/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.codec.decoder.mqtt5.Mqtt5MessageDecoderUtil;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt5DisconnectDecoder
implements MqttMessageDecoder {
    private static final int FLAGS = 0;

    @Inject
    Mqtt5DisconnectDecoder() {
    }

    @Override
    @NotNull
    public MqttDisconnect decode(int flags, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        MqttMessageDecoderUtil.checkFixedHeaderFlags(0, flags);
        Mqtt5DisconnectReasonCode reasonCode = MqttDisconnect.DEFAULT_REASON_CODE;
        long sessionExpiryInterval = -1L;
        MqttUtf8StringImpl serverReference = null;
        MqttUtf8StringImpl reasonString = null;
        ImmutableList.Builder<MqttUserPropertyImpl> userPropertiesBuilder = null;
        if (in.isReadable()) {
            reasonCode = Mqtt5DisconnectReasonCode.fromCode(in.readUnsignedByte());
            if (reasonCode == null) {
                throw Mqtt5MessageDecoderUtil.wrongReasonCode();
            }
            if (in.isReadable()) {
                Mqtt5MessageDecoderUtil.checkPropertyLengthNoPayload(in);
                block6: while (in.isReadable()) {
                    int propertyIdentifier = Mqtt5MessageDecoderUtil.decodePropertyIdentifier(in);
                    switch (propertyIdentifier) {
                        case 17: {
                            sessionExpiryInterval = Mqtt5MessageDecoderUtil.decodeSessionExpiryInterval(sessionExpiryInterval, in);
                            continue block6;
                        }
                        case 28: {
                            serverReference = Mqtt5MessageDecoderUtil.decodeServerReference(serverReference, in);
                            continue block6;
                        }
                        case 31: {
                            reasonString = Mqtt5MessageDecoderUtil.decodeReasonString(reasonString, in);
                            continue block6;
                        }
                        case 38: {
                            userPropertiesBuilder = Mqtt5MessageDecoderUtil.decodeUserProperty(userPropertiesBuilder, in);
                            continue block6;
                        }
                    }
                    throw Mqtt5MessageDecoderUtil.wrongProperty(propertyIdentifier);
                }
            }
        }
        MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.build(userPropertiesBuilder);
        return new MqttDisconnect(reasonCode, sessionExpiryInterval, serverReference, reasonString, userProperties);
    }
}

