/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;

public class LogLog {
    public static final String DEBUG_KEY = "log4j.debug";
    public static final String CONFIG_DEBUG_KEY = "log4j.configDebug";
    protected static boolean debugEnabled = false;
    private static boolean quietMode = false;
    private static final String PREFIX = "log4j: ";
    private static final String ERR_PREFIX = "log4j:ERROR ";
    private static final String WARN_PREFIX = "log4j:WARN ";
    private static final PaxLogger log = FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(LogLog.class), "log4j");

    public static void setInternalDebugging(boolean enabled) {
        debugEnabled = enabled;
    }

    public static void debug(String msg) {
        if (debugEnabled && !quietMode) {
            log.debug(msg);
        }
    }

    public static void debug(String msg, Throwable t) {
        if (debugEnabled && !quietMode) {
            log.debug(msg, (Object)t);
        }
    }

    public static void error(String msg) {
        if (quietMode) {
            return;
        }
        log.error(msg);
    }

    public static void error(String msg, Throwable t) {
        if (quietMode) {
            return;
        }
        log.error(msg, (Object)t);
    }

    public static void setQuietMode(boolean quietMode) {
        LogLog.quietMode = quietMode;
    }

    public static void warn(String msg) {
        if (quietMode) {
            return;
        }
        log.warn(msg);
    }

    public static void warn(String msg, Throwable t) {
        if (quietMode) {
            return;
        }
        log.warn(msg, (Object)t);
    }
}

