/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml.acs;

import com.google.common.base.Predicates;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.guacamole.auth.saml.acs.AssertedIdentity;
import org.apache.guacamole.auth.saml.acs.AuthenticationSession;
import org.apache.guacamole.auth.saml.acs.IdentifierGenerator;

@Singleton
public class AuthenticationSessionManager {
    @Inject
    private IdentifierGenerator idGenerator;
    private final ConcurrentMap<String, AuthenticationSession> sessions = new ConcurrentHashMap<String, AuthenticationSession>();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public AuthenticationSessionManager() {
        this.executor.scheduleAtFixedRate(() -> this.sessions.values().removeIf(Predicates.not(AuthenticationSession::isValid)), 1L, 1L, TimeUnit.MINUTES);
    }

    public AuthenticationSession resume(String identifier) {
        AuthenticationSession session;
        if (identifier != null && (session = (AuthenticationSession)this.sessions.remove(identifier)) != null && session.isValid()) {
            return session;
        }
        return null;
    }

    public AssertedIdentity getIdentity(String identifier) {
        AuthenticationSession session = this.resume(identifier);
        if (session != null) {
            return session.getIdentity();
        }
        return null;
    }

    public String defer(AuthenticationSession session) {
        String identifier = this.idGenerator.generateIdentifier();
        this.sessions.put(identifier, session);
        return identifier;
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }
}

