/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ProtocolRestrictor;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;

public class DirectResourceResolver
implements ResourceResolver {
    private final Configuration config;

    public DirectResourceResolver(Configuration config) {
        this.config = config;
    }

    @Override
    public Source resolve(ResourceRequest request) throws XPathException {
        Source ss;
        InputStream stream;
        String relativeURI;
        if (request.uriIsNamespace) {
            return null;
        }
        ProtocolRestrictor restrictor = this.config.getProtocolRestrictor();
        if (!"all".equals(restrictor.toString())) {
            try {
                URI u = new URI(request.uri);
                if (!restrictor.test(u)) {
                    throw new XPathException("URIs using protocol " + u.getScheme() + " are not permitted");
                }
            }
            catch (URISyntaxException err) {
                throw new XPathException("Unknown URI scheme requested " + request.uri);
            }
        }
        if ((relativeURI = request.relativeUri) == null) {
            relativeURI = request.uri;
        }
        String id = null;
        int hash = relativeURI.indexOf(35);
        if (hash >= 0) {
            request = request.copy();
            request.relativeUri = relativeURI.substring(0, hash);
            id = relativeURI.substring(hash + 1);
        }
        if ("http://www.w3.org/1999/XSL/Transform".equals(request.nature)) {
            try {
                if (request.uri.startsWith("classpath:")) {
                    String s = request.uri.substring(10);
                    if (s.startsWith("/")) {
                        s = s.substring(1);
                    }
                    stream = this.config.getDynamicLoader().getResourceAsStream(s);
                } else {
                    stream = ResourceLoader.urlStream(new URL(request.uri));
                }
            }
            catch (IOException e) {
                stream = null;
            }
            InputSource is = new InputSource(request.uri);
            is.setByteStream(stream);
            ss = new SAXSource(this.config.getStyleParser(), is);
            if (stream != null) {
                ss = AugmentedSource.makeAugmentedSource(ss);
                ((AugmentedSource)ss).setPleaseCloseAfterUse(true);
            }
        } else if ("https://www.iana.org/assignments/media-types/application/xml".equals(request.nature) || "http://www.w3.org/2001/XMLSchema".equals(request.nature)) {
            try {
                stream = ResourceLoader.urlStream(new URL(request.uri));
            }
            catch (IOException e) {
                stream = null;
            }
            ss = new StreamSource(stream, request.uri);
            if (stream != null) {
                ss = AugmentedSource.makeAugmentedSource(ss);
                ((AugmentedSource)ss).setPleaseCloseAfterUse(true);
            }
        } else {
            ss = new StreamSource(request.uri);
        }
        if (id != null) {
            String idFinal = id;
            FilterFactory factory = next -> new IDFilter(next, idFinal);
            ss = AugmentedSource.makeAugmentedSource(ss);
            ((AugmentedSource)ss).addFilter(factory);
        }
        return ss;
    }
}

