/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.reporting;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.Severity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class CheckMessage
implements Comparable<CheckMessage> {
    private static final int MAX_LOCATIONS = 25;
    @JsonProperty
    private final String ID;
    @JsonProperty
    private final Severity severity;
    @JsonProperty
    private String message;
    @JsonProperty
    private int additionalLocations = 0;
    @JsonProperty
    private final List<EPUBLocation> locations = new ArrayList<EPUBLocation>();
    @JsonProperty
    private final String suggestion;

    private CheckMessage(Message message, EPUBLocation location, Object ... args) {
        this.ID = message.getID().toString();
        this.message = message.getMessage(args);
        this.locations.add(location);
        this.severity = message.getSeverity();
        this.suggestion = "".equals(message.getSuggestion()) ? null : message.getSuggestion();
    }

    public static CheckMessage addCheckMessage(List<CheckMessage> checkMessages, Message message, EPUBLocation location, Object ... args) {
        CheckMessage result = CheckMessage.findCheckMessage(checkMessages, message.getID().toString(), message.getMessage(args));
        if (result == null) {
            result = new CheckMessage(message, location, args);
            checkMessages.add(result);
        } else {
            result.addLocation(location);
        }
        return result;
    }

    void addLocation(EPUBLocation location) {
        if (this.findLocation(location) == null) {
            if (this.locations.size() == 25) {
                ++this.additionalLocations;
            } else if (this.locations.size() < 25) {
                this.locations.add(location);
            } else {
                ++this.additionalLocations;
                EPUBLocation ePUBLocation = this.locations.remove(this.locations.size() - 1);
            }
        }
    }

    private static CheckMessage findCheckMessage(List<CheckMessage> checkMessages, String id, String text) {
        for (CheckMessage message : checkMessages) {
            if (!message.ID.equals(id) || !message.message.equals(text)) continue;
            return message;
        }
        return null;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    private EPUBLocation findLocation(EPUBLocation location) {
        for (EPUBLocation l : this.locations) {
            if (!l.equals(location)) continue;
            return l;
        }
        return null;
    }

    public String toString() {
        EPUBLocation location = this.locations.get(this.locations.size() - 1);
        String lineSeparator = System.getProperty("line.separator");
        String text = "ID: " + this.ID + lineSeparator + "SEVERITY: " + (this.severity != null ? this.severity : "-UNDEFINED-") + lineSeparator + lineSeparator + "ERRONEOUS FILE NAME: " + location.getPath() + lineSeparator;
        if (location.getLine() > 0 && location.getColumn() > 0) {
            text = text + "LINE NUMBER: " + location.getLine() + lineSeparator;
        }
        text = text + "COLUMN NUMBER: " + location.getColumn() + lineSeparator;
        text = text + "DESCRIPTION (long): " + this.message + lineSeparator;
        text = text + "==========================================================================================================================" + lineSeparator;
        return text;
    }

    int safeCompare(String a, String b) {
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a == null) {
            return 0;
        }
        return a.compareTo(b);
    }

    @Override
    public int compareTo(CheckMessage o) {
        int comp = this.safeCompare(this.ID, o.ID);
        if (comp != 0) {
            return comp;
        }
        comp = this.severity.toInt() - o.severity.toInt();
        if (comp != 0) {
            return comp < 0 ? -1 : 1;
        }
        comp = this.safeCompare(this.message, o.message);
        if (comp != 0) {
            return comp;
        }
        comp = this.safeCompare(this.suggestion, o.suggestion);
        if (comp != 0) {
            return comp;
        }
        comp = this.additionalLocations - o.additionalLocations;
        if (comp != 0) {
            return comp < 0 ? -1 : 1;
        }
        comp = this.locations.size() - o.locations.size();
        if (comp != 0) {
            return comp < 0 ? -1 : 1;
        }
        return 0;
    }

    public void sortLocations() {
        Collections.sort(this.locations);
    }

    public String getID() {
        return this.ID;
    }

    public String getMessage() {
        return this.message;
    }

    public int getAdditionalLocations() {
        return this.additionalLocations;
    }

    public List<EPUBLocation> getLocations() {
        return this.locations;
    }

    public String getSuggestion() {
        return this.suggestion;
    }
}

