/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.codelinks.highlight;

import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.codelinks.CodeLink;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.codelinks.highlight.URLTextRange;
import com.almworks.tracklink.util.Utils;
import com.almworks.util.Log;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.javadoc.PsiDocToken;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeParser {
    private final IssueLinkModel myModel;

    public CodeParser(IssueLinkModel model) {
        this.myModel = model;
    }

    @Nullable
    private URLTextRange getURLTextRange(@NotNull Editor editor, @Nullable PsiFile psiFile, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/codelinks/highlight/CodeParser.getURLTextRange must not be null");
        }
        if (psiFile == null) {
            return null;
        }
        Document document = editor.getDocument();
        int length = document.getTextLength();
        if (length > 0 && offset < length) {
            CharSequence text = document.getCharsSequence();
            int startLineOffset = Utils.getStartLineOffset(editor, offset);
            int endLineOffset = Utils.getEndLineOffset(editor, offset);
            CharSequence textLine = text.subSequence(startLineOffset, endLineOffset);
            List<CodeLinkType> referenceTypes = this.myModel.getReferenceTypes();
            for (CodeLinkType codeLinkType : referenceTypes) {
                Pattern searchPattern = codeLinkType.getPattern();
                if (searchPattern == null) continue;
                Matcher matcher = searchPattern.matcher(textLine);
                while (matcher.find()) {
                    int startOffset = startLineOffset + matcher.start();
                    int endOffset = startLineOffset + matcher.end();
                    if (startOffset > offset || endOffset < offset) continue;
                    String group = matcher.group();
                    String url = searchPattern.matcher(group).replaceAll(codeLinkType.getReplacePattern());
                    return new URLTextRange(startOffset, endOffset, new CodeLink(group, url), codeLinkType, CodeParser.isComment(psiFile, offset));
                }
            }
        }
        return null;
    }

    @Nullable
    public URLTextRange getURLTextRange(DataContext context) {
        Editor editor = (Editor)DataKeys.EDITOR.getData(context);
        PsiFile psiFile = (PsiFile)DataKeys.PSI_FILE.getData(context);
        if (editor == null || editor.isDisposed()) {
            return null;
        }
        return this.getURLTextRange(editor, psiFile, editor.getCaretModel().getOffset());
    }

    @Nullable
    public URLTextRange getURLTextRange(Editor editor, PsiFile file, Point location) {
        if (editor == null) {
            return null;
        }
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(location);
        int offset = editor.logicalPositionToOffset(logicalPosition);
        return this.getURLTextRange(editor, file, offset);
    }

    public static boolean isComment(PsiFile psiFile, int offset) {
        if (psiFile == null) {
            return false;
        }
        PsiElement element = psiFile.findElementAt(offset);
        return element instanceof PsiComment || element instanceof PsiDocToken;
    }

    public List<URLTextRange> getURLTextRanges(Editor editor, int startOffset, int endOffset) {
        CharSequence wholeText;
        assert (endOffset >= startOffset) : "startOffset: " + startOffset + "; endOffset: " + endOffset;
        if (editor.isDisposed() || endOffset <= startOffset) {
            return Collections.emptyList();
        }
        startOffset = Utils.ensureInBounds(editor, startOffset);
        endOffset = Utils.ensureInBounds(editor, endOffset);
        try {
            wholeText = editor.getDocument().getCharsSequence().subSequence(startOffset, endOffset);
        }
        catch (IndexOutOfBoundsException e) {
            Log.error(e);
            return Collections.emptyList();
        }
        List<URLTextRange> ranges = this.getRanges(wholeText);
        for (URLTextRange urlTextRange : ranges) {
            urlTextRange.shift(startOffset);
        }
        return ranges;
    }

    public List<URLTextRange> getRanges(CharSequence wholeText) {
        ArrayList<URLTextRange> ranges = new ArrayList<URLTextRange>();
        List<CodeLinkType> codeLinkTypes = this.myModel.getReferenceTypes();
        for (CodeLinkType codeLinkType : codeLinkTypes) {
            Pattern searchPattern = codeLinkType.getPattern();
            if (searchPattern == null) continue;
            Matcher matcher = searchPattern.matcher(wholeText);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                String group = matcher.group();
                String url = searchPattern.matcher(group).replaceAll(codeLinkType.getReplacePattern());
                URLTextRange textRange = new URLTextRange(start, end, new CodeLink(group, url), codeLinkType, false);
                ranges.add(textRange);
            }
        }
        return ranges;
    }
}

