/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;

public class WindowsTextFieldCaret
extends DefaultCaret
implements UIResource {
    private boolean m_selectAll = true;

    public void focusGained(FocusEvent e) {
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if (this.getComponent().isEnabled() && this.m_selectAll && UIManager.getBoolean("TextField.patchSelectOnFocus")) {
            super.setDot(0);
            super.moveDot(this.getComponent().getDocument().getLength());
        }
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (!e.isTemporary()) {
            this.m_selectAll = true;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) || e.isPopupTrigger()) {
            this.m_selectAll = false;
        }
        super.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.isPopupTrigger()) {
            this.m_selectAll = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }
}

