/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing.autospell;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.DocumentWordTokenizer;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.swing.autospell.AutoSpellConstants;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;

public class AutoSpellCheckHandler
extends MouseAdapter
implements DocumentListener,
AutoSpellConstants {
    private SpellChecker sCheck = null;
    private Configuration config = Configuration.getConfiguration();
    private ResourceBundle messages = null;
    private DocumentEvent myLastDocChange;
    private int myLastWordStart;
    private int myCurrWordStart;
    private int myCurrWordEnd;
    private boolean myCurrWordHasCaret = false;
    private Timer myTimer;
    private int myCurStart;
    private int myCurEnd;
    private StyledDocument myCurDocument;
    private List correctList = new ArrayList(512);
    private List missList = new ArrayList(512);

    public AutoSpellCheckHandler(SpellChecker spellChecker) {
        this.sCheck = spellChecker;
    }

    public AutoSpellCheckHandler(SpellChecker spellChecker, ResourceBundle resourceBundle) {
        this(spellChecker);
        this.messages = resourceBundle;
    }

    public void addJEditorPane(final JEditorPane jEditorPane) {
        StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
        this.myTimer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jEditorPane.isDisplayable()) {
                    AutoSpellCheckHandler.this.markupSpellingAtOnce(AutoSpellCheckHandler.this.myCurDocument, AutoSpellCheckHandler.this.myCurStart, AutoSpellCheckHandler.this.myCurEnd);
                }
            }
        });
        this.myTimer.setInitialDelay(500);
        this.myTimer.setRepeats(false);
        styledDocument.addDocumentListener(this);
        jEditorPane.addMouseListener(this);
        this.markupSpelling(styledDocument, 0, styledDocument.getLength() - 1);
    }

    private void logException(Exception exception) {
    }

    static int findWordEnd(String string, int n) {
        int n2 = n;
        int n3 = string.length();
        while (n2 < n3) {
            char c;
            if (Character.isLetterOrDigit(c = string.charAt(n2++))) continue;
            --n2;
            break;
        }
        return n2;
    }

    static int findWordStart(String string, int n) {
        char c;
        int n2 = n;
        while (n2 > 0 && Character.isLetterOrDigit(c = string.charAt(--n2))) {
        }
        return n2;
    }

    public void removeJEditorPane(JEditorPane jEditorPane) {
        Document document = jEditorPane.getDocument();
        jEditorPane.removeMouseListener(this);
        document.removeDocumentListener(this);
        this.myCurDocument = null;
        this.myTimer.stop();
    }

    private void markupSpelling(StyledDocument styledDocument, int n, int n2) {
        this.myCurDocument = styledDocument;
        this.myCurStart = n;
        this.myCurEnd = n2;
        this.myTimer.restart();
    }

    private void markupSpellingAtOnce(StyledDocument styledDocument, int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        Segment segment = new Segment();
        this.correctList.clear();
        this.missList.clear();
        int n5 = 0;
        int n6 = 0;
        boolean bl = true;
        DocumentWordTokenizer documentWordTokenizer = new DocumentWordTokenizer(styledDocument);
        if (n > 0) {
            documentWordTokenizer.posStartFullWordFrom(n);
        }
        while (documentWordTokenizer.hasMoreWords() && documentWordTokenizer.getCurrentWordPosition() <= n2) {
            String string = documentWordTokenizer.nextWord();
            n3 = documentWordTokenizer.getCurrentWordPosition();
            if (n4 != -1) {
                this.markAsCorrect(styledDocument, n4, n3);
            }
            if ((n4 = documentWordTokenizer.getCurrentWordEnd()) > styledDocument.getLength()) {
                n4 = styledDocument.getLength() - 1;
            }
            if (n3 >= n4) continue;
            if (this.sCheck.isIgnoredSpecial(string) || this.sCheck.isCorrect(string) || this.sCheck.isIgnored(string) || string.length() < 2) {
                this.correctList.add(new Pair(n3, n4));
                ++n5;
                continue;
            }
            this.missList.add(new Pair(n3, n4));
            ++n6;
        }
        if (n5 < 1 || n6 > n5) {
            bl = false;
        }
        if (n4 < n2 && n4 != -1) {
            this.correctList.add(new Pair(n4, n2));
            n5 += n2 - n4;
        }
        if (bl) {
            Pair pair;
            int n7;
            for (n7 = 0; n7 < this.missList.size(); ++n7) {
                pair = (Pair)this.missList.get(n7);
                this.markAsMisspelled(styledDocument, pair.first, pair.second);
            }
            for (n7 = 0; n7 < this.correctList.size(); ++n7) {
                pair = (Pair)this.correctList.get(n7);
                this.markAsCorrect(styledDocument, pair.first, pair.second);
            }
        } else {
            this.markAsCorrect(styledDocument, n, n2);
        }
    }

    private void markAsMisspelled(StyledDocument styledDocument, int n, int n2) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute("misspelled", wordMisspelledTrue);
        styledDocument.setCharacterAttributes(n, n2 - n, simpleAttributeSet, false);
    }

    private void markAsCorrect(StyledDocument styledDocument, int n, int n2) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(styledDocument.getCharacterElement((n + n2) / 2).getAttributes());
        simpleAttributeSet.removeAttribute("misspelled");
        if (n2 >= n) {
            styledDocument.setCharacterAttributes(n, n2 - n, simpleAttributeSet, true);
        }
    }

    private void handleDocumentChange(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() instanceof StyledDocument) {
            int n;
            int n2;
            StyledDocument styledDocument = (StyledDocument)documentEvent.getDocument();
            Element element = styledDocument.getCharacterElement(documentEvent.getOffset());
            Element element2 = element.getParentElement();
            if (element2 != null) {
                int n3 = documentEvent.getOffset() + documentEvent.getLength();
                int n4 = documentEvent.getOffset();
                if (n4 < element2.getStartOffset() || n3 > element2.getEndOffset() && element2.getParentElement() != null) {
                    Element element3 = element2.getParentElement();
                    for (int i = 0; i < element3.getElementCount(); ++i) {
                        Element element4 = element3.getElement(i);
                        this.markupSpellingAtOnce(styledDocument, element4.getStartOffset(), element4.getEndOffset());
                    }
                    return;
                }
                n2 = element2.getStartOffset();
                n = element2.getEndOffset();
            } else {
                n2 = element.getStartOffset();
                n = element.getEndOffset();
            }
            this.markupSpelling(styledDocument, n2, n);
        }
    }

    private void showSuggestionPopup(JEditorPane jEditorPane, Point point) {
        StyledDocument styledDocument;
        AttributeSet attributeSet;
        int n = jEditorPane.viewToModel(point);
        if (n >= 0 && (attributeSet = (styledDocument = (StyledDocument)jEditorPane.getDocument()).getCharacterElement(n).getAttributes()).containsAttribute("misspelled", wordMisspelledTrue)) {
            JMenuItem jMenuItem;
            DocumentWordTokenizer documentWordTokenizer = new DocumentWordTokenizer(styledDocument);
            documentWordTokenizer.posStartFullWordFrom(n);
            String string = documentWordTokenizer.nextWord();
            List list = this.sCheck.getSuggestions(string, this.config.getInteger("SPELL_THRESHOLD"));
            JPopupMenu jPopupMenu = new JPopupMenu();
            ReplaceListener replaceListener = new ReplaceListener(documentWordTokenizer);
            for (int i = 0; i < list.size(); ++i) {
                Word word = (Word)list.get(i);
                jMenuItem = new JMenuItem(word.getWord());
                jMenuItem.setActionCommand(word.getWord());
                jMenuItem.addActionListener(replaceListener);
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem();
            if (this.messages != null) {
                jMenuItem.setText(this.messages.getString("IGNOREALL"));
            } else {
                jMenuItem.setText("Ignore All");
            }
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(new IgnoreAllListener(styledDocument));
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem();
            if (this.messages != null) {
                jMenuItem.setText(this.messages.getString("ADD"));
            } else {
                jMenuItem.setText("Add word to wordlist");
            }
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(new AddToDictListener(styledDocument));
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(jEditorPane, point.x, point.y);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void docChanged(DocumentEvent documentEvent) {
        SpellCheckChange spellCheckChange = new SpellCheckChange(documentEvent);
        SwingUtilities.invokeLater(spellCheckChange);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JEditorPane jEditorPane;
        if (!(mouseEvent.getComponent() instanceof JEditorPane)) {
            return;
        }
        if (mouseEvent.isPopupTrigger() && (jEditorPane = (JEditorPane)mouseEvent.getComponent()).isEditable()) {
            this.showSuggestionPopup(jEditorPane, new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent);
        mouseEvent.consume();
    }

    private class MarkUpSpellingAll
    implements Runnable {
        private StyledDocument doc;

        public MarkUpSpellingAll(StyledDocument styledDocument) {
            this.doc = styledDocument;
        }

        public void run() {
            AutoSpellCheckHandler.this.markupSpelling(this.doc, 0, this.doc.getLength());
        }
    }

    private class IgnoreAllListener
    implements ActionListener {
        private StyledDocument doc;

        public IgnoreAllListener(StyledDocument styledDocument) {
            this.doc = styledDocument;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AutoSpellCheckHandler.this.sCheck.ignoreAll(actionEvent.getActionCommand());
            MarkUpSpellingAll markUpSpellingAll = new MarkUpSpellingAll(this.doc);
            SwingUtilities.invokeLater(markUpSpellingAll);
        }
    }

    private class AddToDictListener
    implements ActionListener {
        private StyledDocument doc;

        public AddToDictListener(StyledDocument styledDocument) {
            this.doc = styledDocument;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AutoSpellCheckHandler.this.sCheck.addToDictionary(actionEvent.getActionCommand());
            MarkUpSpellingAll markUpSpellingAll = new MarkUpSpellingAll(this.doc);
            SwingUtilities.invokeLater(markUpSpellingAll);
        }
    }

    private class ReplaceListener
    implements ActionListener {
        DocumentWordTokenizer tok;

        public ReplaceListener(DocumentWordTokenizer documentWordTokenizer) {
            this.tok = documentWordTokenizer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.tok.replaceWord(actionEvent.getActionCommand());
        }
    }

    private class SpellCheckChange
    implements Runnable {
        private DocumentEvent evt;

        public SpellCheckChange(DocumentEvent documentEvent) {
            this.evt = documentEvent;
        }

        public void run() {
            AutoSpellCheckHandler.this.handleDocumentChange(this.evt);
        }
    }

    private static class Pair {
        public Integer first;
        public Integer second;

        private Pair(Integer n, Integer n2) {
            this.first = n;
            this.second = n2;
        }
    }
}

