/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.io.PrintStream;
import javolution.JavolutionError;
import javolution.PerfContext;
import javolution.PerfStream;
import javolution.PerfText;
import javolution.PerfUtil;
import javolution.PerfXML;
import javolution.lang.Reflection;
import javolution.text.Text;
import javolution.text.TextBuilder;

public class Javolution {
    public static final String VERSION = "4.0.2 (J2SE 1.5+) November 1 2006";
    private static PrintStream Out = System.out;
    public static volatile Text txt = new TextBuilder("-7deDED1234567890").toText();
    private static long _time;
    private static final Reflection.Method NANO_TIME_METHOD;

    protected Javolution() {
    }

    public static void main(String[] stringArray) throws Exception {
        Javolution.println("Javolution - Java(TM) Solution for Real-Time and Embedded Systems");
        Javolution.println("Version 4.0.2 (J2SE 1.5+) November 1 2006 (http://javolution.org)");
        Javolution.println("");
        if (stringArray.length > 0) {
            if (stringArray[0].equals("version")) {
                return;
            }
            if (stringArray[0].equals("test")) {
                Javolution.testing();
                return;
            }
            if (stringArray[0].equals("perf")) {
                Javolution.benchmark();
                return;
            }
        }
        Javolution.println("Usage: java -jar javolution.jar [arg]");
        Javolution.println("where arg is one of:");
        Javolution.println("    version (to show version information only)");
        Javolution.println("    test    (to perform self-tests)");
        Javolution.println("    perf    (to run benchmark)");
    }

    private static void testing() throws Exception {
        Javolution.print("Testing...");
        Javolution.println("");
        Javolution.println("Success");
    }

    private static void benchmark() throws Exception {
        Javolution.println("Benchmark...");
        Javolution.println("");
        Thread.currentThread().setPriority(10);
        new PerfStream().run();
        new PerfXML().run();
        new PerfText().run();
        new PerfContext().run();
        new PerfUtil().run();
        Javolution.println("");
        Javolution.println("More performance analysis in future versions...");
    }

    public static void println(Object object) {
        if (Out == null) {
            return;
        }
        Out.println(object);
    }

    public static void print(Object object) {
        if (Out == null) {
            return;
        }
        Out.print(object);
    }

    public static void startTime() {
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            throw new JavolutionError(interruptedException);
        }
        _time = Javolution.nanoTime();
    }

    public static void setOutputStream(PrintStream printStream) {
        Out = printStream;
    }

    public static String endTime(int n) {
        long l;
        String string;
        long l2 = Javolution.nanoTime() - _time;
        long l3 = l2 * 1000L / (long)n;
        if (l3 > 1000000000000L) {
            string = " s";
            l = 1000000000000L;
        } else if (l3 > 1000000000L) {
            string = " ms";
            l = 1000000000L;
        } else if (l3 > 1000000L) {
            string = " us";
            l = 1000000L;
        } else {
            string = " ns";
            l = 1000L;
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(l3 / l);
        int n2 = 4 - textBuilder.length();
        textBuilder.append(".");
        int n3 = 0;
        int n4 = 10;
        while (n3 < n2) {
            textBuilder.append(l3 * (long)n4 / l % 10L);
            ++n3;
            n4 *= 10;
        }
        return textBuilder.append(string).toString();
    }

    private static long nanoTime() {
        if (NANO_TIME_METHOD != null) {
            Long l = (Long)NANO_TIME_METHOD.invoke(null);
            return l;
        }
        return System.currentTimeMillis() * 1000000L;
    }

    public static Class j2meGetClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                try {
                    clazz = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    // empty catch block
                }
            }
        }
        if (clazz == null) {
            throw new JavolutionError("Class " + string + " not found");
        }
        return clazz;
    }

    public static CharSequence j2meToCharSeq(Object object) {
        return object instanceof CharSequence ? (CharSequence)object : (object == null ? null : Text.valueOf((String)object));
    }

    static {
        NANO_TIME_METHOD = Reflection.getMethod("java.lang.System.nanoTime()");
    }
}

