/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class NilVector
extends AbstractString {
    private int capacity;

    public NilVector(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public char[] chars() {
        if (this.capacity != 0) {
            this.accessError();
        }
        return new char[0];
    }

    @Override
    public char[] getStringChars() {
        if (this.capacity != 0) {
            this.accessError();
        }
        return new char[0];
    }

    @Override
    public String getStringValue() {
        if (this.capacity != 0) {
            this.accessError();
        }
        return "";
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.NIL_VECTOR, Fixnum.getInstance(this.capacity));
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.NIL_VECTOR;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.NIL_VECTOR) {
            return Lisp.T;
        }
        if (type == Symbol.SIMPLE_STRING) {
            return Lisp.T;
        }
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.NIL_VECTOR) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_STRING) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject SIMPLE_STRING_P() {
        return Lisp.T;
    }

    @Override
    public boolean equal(LispObject obj) {
        if (obj instanceof NilVector) {
            if (this.capacity != ((NilVector)obj).capacity) {
                return false;
            }
            if (this.capacity != 0) {
                this.accessError();
                return false;
            }
            return true;
        }
        if (obj instanceof AbstractString) {
            if (this.capacity != obj.length()) {
                return false;
            }
            if (this.capacity != 0) {
                this.accessError();
                return false;
            }
            return true;
        }
        return false;
    }

    public String getValue() {
        if (this.capacity == 0) {
            return "";
        }
        this.accessError();
        return null;
    }

    @Override
    public int length() {
        return this.capacity;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public LispObject getElementType() {
        return Lisp.NIL;
    }

    @Override
    public LispObject CHAR(int index) {
        return this.accessError();
    }

    @Override
    public LispObject SCHAR(int index) {
        return this.accessError();
    }

    @Override
    public LispObject AREF(int index) {
        return this.accessError();
    }

    @Override
    public void aset(int index, LispObject newValue) {
        this.storeError(newValue);
    }

    @Override
    public char charAt(int index) {
        this.accessError();
        return '\u0000';
    }

    @Override
    public void setCharAt(int index, char c) {
        this.storeError(LispCharacter.getInstance(c));
    }

    @Override
    public LispObject subseq(int start, int end) {
        if (this.capacity == 0 && start == 0 && end == 0) {
            return this;
        }
        return this.accessError();
    }

    @Override
    public void fill(LispObject obj) {
        this.storeError(obj);
    }

    @Override
    public void fill(char c) {
        this.storeError(LispCharacter.getInstance(c));
    }

    @Override
    public void shrink(int n) {
    }

    @Override
    public LispObject reverse() {
        return this.accessError();
    }

    public LispObject accessError() {
        return Lisp.error(new TypeError("Attempt to access an array of element type NIL."));
    }

    private void storeError(LispObject obj) {
        Lisp.error(new TypeError(String.valueOf(obj) + " is not of type NIL."));
    }

    @Override
    public int sxhash() {
        return 0;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        this.accessError();
        return null;
    }

    @Override
    public AbstractVector adjustArray(int size, AbstractArray displacedTo, int displacement) {
        this.accessError();
        return null;
    }
}

