/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.scm.providers.gitlib.settings.Settings;
import org.apache.maven.scm.providers.gitlib.settings.io.xpp3.GitXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class GitUtil {
    protected static final String GIT_SETTINGS_FILENAME = "git-settings.xml";
    public static final File DEFAULT_SETTINGS_DIRECTORY;
    private static File settingsDirectory;

    private GitUtil() {
    }

    public static Settings getSettings() {
        File scmUserDir = settingsDirectory;
        File settingsFile = new File(scmUserDir, GIT_SETTINGS_FILENAME);
        if (settingsFile.exists()) {
            GitXpp3Reader reader = new GitXpp3Reader();
            try {
                return reader.read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.err.println(message);
            }
        }
        return new Settings();
    }

    public static void setSettingsDirectory(File directory) {
        settingsDirectory = directory;
    }

    static {
        settingsDirectory = DEFAULT_SETTINGS_DIRECTORY = new File(System.getProperty("user.home"), ".scm");
    }
}

