/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.codec.Codec;
import org.sonatype.spice.zapper.hash.Hash;
import org.sonatype.spice.zapper.internal.AbstractPayload;
import org.sonatype.spice.zapper.internal.Arrays;
import org.sonatype.spice.zapper.internal.Payload;
import org.sonatype.spice.zapper.internal.TransferIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePayload
extends AbstractPayload
implements Payload {
    private final byte[] message;

    public MessagePayload(TransferIdentifier transferIdentifier, Path path, byte[] message, Hash hash, List<Codec> codecs) {
        super(transferIdentifier, path, hash, codecs);
        this.message = Arrays.copyOf(message, message.length);
    }

    @Override
    public long getLength() {
        return this.message.length;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.message);
    }

    public byte[] getMessage() {
        return this.message;
    }
}

