/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy.strategy;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.sonatype.nexus.staging.client.Profile;
import com.sonatype.nexus.staging.client.ProfileMatchingParameters;
import com.sonatype.nexus.staging.client.StagingRuleFailures;
import com.sonatype.nexus.staging.client.StagingRuleFailuresException;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.nexus.client.core.exception.NexusClientErrorResponseException;
import org.sonatype.nexus.maven.staging.ErrorDumper;
import org.sonatype.nexus.maven.staging.StagingAction;
import org.sonatype.nexus.maven.staging.deploy.StagingRepository;
import org.sonatype.nexus.maven.staging.deploy.strategy.AbstractDeployStrategy;
import org.sonatype.nexus.maven.staging.remote.Parameters;
import org.sonatype.nexus.maven.staging.remote.RemoteNexus;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public abstract class AbstractStagingDeployStrategy
extends AbstractDeployStrategy {
    @Requirement
    private SecDispatcher secDispatcher;
    public static final String STAGING_REPOSITORY_PROPERTY_FILE_NAME_SUFFIX = ".properties";
    public static final String STAGING_REPOSITORY_ID = "stagingRepository.id";
    public static final String STAGING_REPOSITORY_PROFILE_ID = "stagingRepository.profileId";
    public static final String STAGING_REPOSITORY_URL = "stagingRepository.url";
    public static final String STAGING_REPOSITORY_MANAGED = "stagingRepository.managed";

    protected RemoteNexus createRemoteNexus(MavenSession mavenSession, Parameters parameters) {
        parameters.validateRemoting();
        parameters.validateStaging();
        return new RemoteNexus(mavenSession, this.secDispatcher, this.getLogger().isDebugEnabled(), parameters);
    }

    protected String selectStagingProfile(Parameters parameters, RemoteNexus remoteNexus, Artifact artifact) throws MojoExecutionException {
        try {
            Profile stagingProfile;
            StagingWorkflowV2Service stagingService = remoteNexus.getStagingWorkflowV2Service();
            if (Strings.isNullOrEmpty((String)parameters.getStagingProfileId())) {
                ProfileMatchingParameters params = new ProfileMatchingParameters(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                stagingProfile = stagingService.matchProfile(params);
                this.getLogger().info(" * Using staging profile ID \"" + stagingProfile.id() + "\" (matched by Nexus).");
            } else {
                stagingProfile = stagingService.selectProfile(parameters.getStagingProfileId());
                this.getLogger().info(" * Using staging profile ID \"" + stagingProfile.id() + "\" (configured by user).");
            }
            return stagingProfile.id();
        }
        catch (NexusClientErrorResponseException e) {
            ErrorDumper.dumpErrors(this.getLogger(), e);
            throw new MojoExecutionException("Could not perform action: Nexus ErrorResponse received!", (Exception)((Object)e));
        }
    }

    protected StagingRepository beforeUpload(Parameters parameters, RemoteNexus remoteNexus, Profile stagingProfile) throws MojoExecutionException {
        try {
            StagingWorkflowV2Service stagingService = remoteNexus.getStagingWorkflowV2Service();
            if (Strings.isNullOrEmpty((String)parameters.getStagingRepositoryId())) {
                String createdStagingRepositoryId = stagingService.startStaging(stagingProfile, parameters.getActionDescription(StagingAction.START), parameters.getTags());
                if (parameters.getTags() != null && !parameters.getTags().isEmpty()) {
                    this.getLogger().info(" * Created staging repository with ID \"" + createdStagingRepositoryId + "\", applied tags: " + parameters.getTags());
                } else {
                    this.getLogger().info(" * Created staging repository with ID \"" + createdStagingRepositoryId + "\".");
                }
                String url = stagingService.startedRepositoryBaseUrl(stagingProfile, createdStagingRepositoryId);
                return new StagingRepository(stagingProfile, createdStagingRepositoryId, url, true);
            }
            this.getLogger().info(" * Using non-managed staging repository with ID \"" + parameters.getStagingRepositoryId() + "\" (we are NOT managing it).");
            String url = stagingService.startedRepositoryBaseUrl(stagingProfile, parameters.getStagingRepositoryId());
            return new StagingRepository(stagingProfile, parameters.getStagingRepositoryId(), url, false);
        }
        catch (NexusClientErrorResponseException e) {
            ErrorDumper.dumpErrors(this.getLogger(), e);
            throw new MojoExecutionException("Could not perform action: Nexus ErrorResponse received!", (Exception)((Object)e));
        }
    }

    protected void afterUpload(Parameters parameters, RemoteNexus remoteNexus, StagingRepository stagingRepository) throws MojoExecutionException, StagingRuleFailuresException {
        block11: {
            String stagingRepositoryUrl = this.concat(remoteNexus.getConnectionInfo().getBaseUrl().toString(), "/content/repositories", stagingRepository.getRepositoryId());
            Properties stagingProperties = new Properties();
            stagingProperties.put(STAGING_REPOSITORY_ID, stagingRepository.getRepositoryId());
            stagingProperties.put(STAGING_REPOSITORY_PROFILE_ID, stagingRepository.getProfile().id());
            stagingProperties.put(STAGING_REPOSITORY_URL, stagingRepositoryUrl);
            stagingProperties.put(STAGING_REPOSITORY_MANAGED, String.valueOf(stagingRepository.isManaged()));
            File stagingPropertiesFile = new File(parameters.getStagingDirectoryRoot(), stagingRepository.getProfile().id() + STAGING_REPOSITORY_PROPERTY_FILE_NAME_SUFFIX);
            if (!stagingPropertiesFile.getParentFile().isDirectory()) {
                stagingPropertiesFile.getParentFile().mkdirs();
            }
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(stagingPropertiesFile);
                stagingProperties.store(fout, "Generated by " + parameters.getPluginGav());
                fout.flush();
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Error saving staging repository properties to file " + stagingPropertiesFile, (Exception)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(fout);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)fout);
            if (stagingRepository.isManaged()) {
                StagingWorkflowV2Service stagingService = remoteNexus.getStagingWorkflowV2Service();
                try {
                    if (!parameters.isSkipStagingRepositoryClose()) {
                        try {
                            this.getLogger().info(" * Closing staging repository with ID \"" + stagingRepository.getRepositoryId() + "\".");
                            stagingService.finishStaging(stagingRepository.getProfile(), stagingRepository.getRepositoryId(), parameters.getActionDescription(StagingAction.FINISH));
                            break block11;
                        }
                        catch (StagingRuleFailuresException e) {
                            this.getLogger().error("Rule failure while trying to close staging repository with ID \"" + stagingRepository.getRepositoryId() + "\".");
                            ErrorDumper.dumpErrors(this.getLogger(), e);
                            throw e;
                        }
                    }
                    this.getLogger().info(" * Not closing staging repository with ID \"" + stagingRepository.getRepositoryId() + "\".");
                }
                catch (NexusClientErrorResponseException e) {
                    this.getLogger().error("Error while trying to close staging repository with ID \"" + stagingRepository.getRepositoryId() + "\".");
                    ErrorDumper.dumpErrors(this.getLogger(), e);
                    throw new MojoExecutionException("Could not perform action against repository \"" + stagingRepository.getRepositoryId() + "\": Nexus ErrorResponse received!", (Exception)((Object)e));
                }
            }
        }
    }

    protected void afterUploadFailure(Parameters parameters, RemoteNexus remoteNexus, List<StagingRepository> stagingRepositories, Throwable problem) throws MojoExecutionException {
        boolean keep;
        String msg;
        if (problem instanceof StagingRuleFailuresException) {
            StagingRuleFailuresException srfe = (StagingRuleFailuresException)((Object)problem);
            ArrayList<String> failedRepositories = new ArrayList<String>();
            for (StagingRuleFailures failures : srfe.getFailures()) {
                failedRepositories.add(failures.getRepositoryId());
            }
            msg = "Rule failure during close of staging repositories: " + failedRepositories;
            keep = parameters.isKeepStagingRepositoryOnCloseRuleFailure();
        } else if (problem instanceof IOException) {
            msg = "IO failure during deploy";
            keep = parameters.isKeepStagingRepositoryOnFailure();
        } else if (problem instanceof InvalidRepositoryException) {
            msg = "Internal error: " + problem.getMessage();
            keep = parameters.isKeepStagingRepositoryOnFailure();
        } else {
            return;
        }
        this.getLogger().error("Cleaning up local stage directory after a " + msg);
        File stageRoot = parameters.getStagingDirectoryRoot();
        File[] localStageRepositories = stageRoot.listFiles();
        if (localStageRepositories != null) {
            for (File file : localStageRepositories) {
                if (!file.isFile() || !file.getName().endsWith(STAGING_REPOSITORY_PROPERTY_FILE_NAME_SUFFIX)) continue;
                this.getLogger().error(" * Deleting context " + file.getName());
                file.delete();
            }
        }
        this.getLogger().error("Cleaning up remote stage repositories after a " + msg);
        StagingWorkflowV2Service stagingService = remoteNexus.getStagingWorkflowV2Service();
        for (StagingRepository stagingRepository : stagingRepositories) {
            if (!stagingRepository.isManaged()) continue;
            if (!keep) {
                this.getLogger().error(" * Dropping failed staging repository with ID \"" + stagingRepository.getRepositoryId() + "\" (" + msg + ").");
                stagingService.dropStagingRepositories(parameters.getActionDescription(StagingAction.DROP) + " (" + msg + ").", stagingRepository.getRepositoryId());
                continue;
            }
            this.getLogger().error(" * Not dropping failed staging repository with ID \"" + stagingRepository.getRepositoryId() + "\" (" + msg + ").");
        }
    }

    protected String concat(String ... paths) {
        StringBuilder result = new StringBuilder();
        for (String path : paths) {
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (result.length() > 0 && !path.startsWith("/")) {
                result.append("/");
            }
            result.append(path);
        }
        return result.toString();
    }

    @Override
    protected ArtifactRepository getArtifactRepositoryForDirectory(File stagingDirectory) throws MojoExecutionException {
        if (stagingDirectory != null) {
            if (!(!stagingDirectory.exists() || stagingDirectory.canWrite() && stagingDirectory.isDirectory())) {
                throw new MojoExecutionException("Staging failed: staging directory points to an existing file but is not a directory or is not writable!");
            }
            if (!stagingDirectory.exists()) {
                stagingDirectory.mkdirs();
            }
            try {
                String id = "nexus";
                String url = stagingDirectory.getCanonicalFile().toURI().toURL().toExternalForm();
                return this.createDeploymentArtifactRepository("nexus", url);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Staging failed: staging directory path cannot be converted to canonical one!", (Exception)e);
            }
        }
        throw new MojoExecutionException("Staging failed: staging directory is null!");
    }
}

