/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy.strategy;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.nexus.maven.staging.deploy.DeployableArtifact;
import org.sonatype.nexus.maven.staging.deploy.strategy.AbstractDeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployPerModuleRequest;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.FinalizeDeployRequest;

@Component(role=DeployStrategy.class, hint="deferred")
public class DeferredDeployStrategy
extends AbstractDeployStrategy {
    @Override
    public void deployPerModule(DeployPerModuleRequest request) throws ArtifactInstallationException, ArtifactDeploymentException, MojoExecutionException {
        this.log.info("Performing deferred deploys (gathering into \"{}\")...", (Object)request.getParameters().getDeferredDirectoryRoot().getAbsolutePath());
        if (!request.getDeployableArtifacts().isEmpty()) {
            File stagingDirectory = request.getParameters().getDeferredDirectoryRoot();
            ArtifactRepository stagingRepository = this.getArtifactRepositoryForDirectory(stagingDirectory);
            ArtifactRepository deploymentRepository = this.getDeploymentRepository(request.getMavenSession());
            for (DeployableArtifact deployableArtifact : request.getDeployableArtifacts()) {
                this.install(deployableArtifact.getFile(), deployableArtifact.getArtifact(), stagingRepository, stagingDirectory, deploymentRepository);
            }
        } else {
            this.log.info("Nothing to locally stage?");
        }
    }

    @Override
    public void finalizeDeploy(FinalizeDeployRequest request) throws ArtifactDeploymentException, MojoExecutionException {
        this.log.info("Deploying remotely...");
        File stagingDirectory = request.getParameters().getDeferredDirectoryRoot();
        if (!stagingDirectory.isDirectory()) {
            this.log.warn("Nothing to deploy, directory \"{}\" does not exists!", (Object)stagingDirectory.getAbsolutePath());
            return;
        }
        this.log.info("Bulk deploying locally gathered artifacts from directory: ");
        try {
            this.log.info(" * Bulk deploying locally gathered snapshot artifacts");
            this.deployUp(request.getMavenSession(), stagingDirectory, null);
            this.log.info(" * Bulk deploy of locally gathered snapshot artifacts finished.");
        }
        catch (IOException e) {
            this.log.error("Upload of locally deferred directory finished with a failure.");
            throw new ArtifactDeploymentException("Remote deploy failed: " + e.getMessage(), (Throwable)e);
        }
        this.log.info("Remote deploy finished with success.");
    }
}

