/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jxmpp.jid.Jid;

public class Subscription
extends NodeExtension {
    protected Jid jid;
    protected String id;
    protected State state;
    protected boolean configRequired = false;

    public Subscription(Jid subscriptionJid) {
        this(subscriptionJid, null, null, null);
    }

    public Subscription(Jid subscriptionJid, String nodeId) {
        this(subscriptionJid, nodeId, null, null);
    }

    public Subscription(Jid subscriptionJid, State state) {
        this(subscriptionJid, null, null, state);
    }

    public Subscription(Jid jid, String nodeId, String subscriptionId, State state) {
        super(PubSubElementType.SUBSCRIPTION, nodeId);
        this.jid = jid;
        this.id = subscriptionId;
        this.state = state;
    }

    public Subscription(Jid jid, String nodeId, String subscriptionId, State state, boolean configRequired) {
        super(PubSubElementType.SUBSCRIPTION, nodeId);
        this.jid = jid;
        this.id = subscriptionId;
        this.state = state;
        this.configRequired = configRequired;
    }

    public Jid getJid() {
        return this.jid;
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public boolean isConfigRequired() {
        return this.configRequired;
    }

    @Override
    protected void addXml(XmlStringBuilder xml) {
        xml.attribute("jid", (CharSequence)this.jid);
        xml.optAttribute("subid", this.id);
        xml.optAttribute("subscription", (Enum)this.state);
        xml.closeEmptyElement();
    }

    public static enum State {
        subscribed,
        unconfigured,
        pending,
        none;

    }
}

