/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.ant.tasks;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.ant.tasks.support.SpecificScopesArtifactFilter;
import org.apache.maven.ant.tasks.support.TypesArtifactFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.antrun.taskconfig.DependencyFilesetsConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class DependencyFilesetsTask
extends Task {
    private String mavenProjectId = "maven.project";
    private DependencyFilesetsConfiguration configuration = new DependencyFilesetsConfiguration();

    public void execute() {
        if (this.getProject().getReference(this.mavenProjectId) == null) {
            throw new BuildException("Maven project reference not found: " + this.mavenProjectId);
        }
        MavenProject mavenProject = (MavenProject)this.getProject().getReference("maven.project");
        Set<Artifact> depArtifacts = this.filterArtifacts(mavenProject.getArtifacts());
        FileSet dependenciesFileSet = new FileSet();
        dependenciesFileSet.setProject(this.getProject());
        ArtifactRepository localRepository = (ArtifactRepository)this.getProject().getReference("maven.local.repository");
        dependenciesFileSet.setDir(new File(localRepository.getBasedir()));
        if (depArtifacts.isEmpty()) {
            dependenciesFileSet.createInclude().setName(".");
            dependenciesFileSet.createExclude().setName("**");
        }
        for (Artifact artifact : depArtifacts) {
            String relativeArtifactPath = localRepository.pathOf(artifact);
            dependenciesFileSet.createInclude().setName(relativeArtifactPath);
            String fileSetName = this.getPrefix() + artifact.getDependencyConflictId();
            FileSet singleArtifactFileSet = new FileSet();
            singleArtifactFileSet.setProject(this.getProject());
            singleArtifactFileSet.setFile(artifact.getFile());
            this.getProject().addReference(fileSetName, (Object)singleArtifactFileSet);
        }
        this.getProject().addReference(this.getPrefix() + this.getProjectDependenciesId(), (Object)dependenciesFileSet);
    }

    public String getMavenProjectId() {
        return this.mavenProjectId;
    }

    public void setMavenProjectId(String mavenProjectId) {
        this.mavenProjectId = mavenProjectId;
    }

    public String getPrefix() {
        String prefix = this.configuration.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.configuration.setPrefix(prefix);
    }

    public String getTypes() {
        return this.configuration.getTypes();
    }

    public void setTypes(String types) {
        this.configuration.setTypes(types);
    }

    public String getScopes() {
        return this.configuration.getScopes();
    }

    public void setScopes(String scopes) {
        this.configuration.setScopes(scopes);
    }

    public String getProjectDependenciesId() {
        return this.configuration.getProjectDependenciesId();
    }

    public void setProjectDependenciesId(String projectDependenciesId) {
        this.configuration.setProjectDependenciesId(projectDependenciesId);
    }

    public Set<Artifact> filterArtifacts(Set<Artifact> artifacts) {
        String types;
        String scopes = this.getScopes();
        if (scopes == null) {
            scopes = "";
        }
        if ((types = this.getTypes()) == null) {
            types = "";
        }
        if ("".equals(scopes) && "".equals(types)) {
            return artifacts;
        }
        AndArtifactFilter filter = new AndArtifactFilter();
        if (!"".equals(scopes)) {
            filter.add((ArtifactFilter)new SpecificScopesArtifactFilter(this.getScopes()));
        }
        if (!"".equals(types)) {
            filter.add((ArtifactFilter)new TypesArtifactFilter(this.getTypes()));
        }
        LinkedHashSet<Artifact> artifactsResult = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            artifactsResult.add(artifact);
        }
        return artifactsResult;
    }
}

