/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class AccessibleMethod {
    private final Method method;

    public AccessibleMethod(Class clazz, String string, Class ... classArray) throws NoSuchMethodException {
        try {
            this.method = AccessController.doPrivileged(new AccessMethodAction(clazz, string, classArray));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (NoSuchMethodException)privilegedActionException.getCause();
        }
    }

    public Object invoke(Object object, Object ... objectArray) throws IllegalArgumentException, InvocationTargetException {
        try {
            return this.method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)"accessible method inaccessible");
        }
    }

    public Object invokeNoChecked(Object object, Object ... objectArray) {
        try {
            return this.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new RuntimeException(invocationTargetException.getCause());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessMethodAction
    implements PrivilegedExceptionAction<Method> {
        private final Class<?> klass;
        private final String methodName;
        private final Class[] paramTypes;

        public AccessMethodAction(Class clazz, String string, Class ... classArray) {
            this.klass = clazz;
            this.methodName = string;
            this.paramTypes = classArray;
        }

        @Override
        public Method run() throws NoSuchMethodException {
            Method method = this.klass.getDeclaredMethod(this.methodName, this.paramTypes);
            method.setAccessible(true);
            return method;
        }
    }
}

