/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import javax.swing.colorchooser.ColorModel;
import javax.swing.colorchooser.ColorModelHSL;

final class ColorModelCMYK
extends ColorModel {
    ColorModelCMYK() {
        super("cmyk", "Cyan", "Magenta", "Yellow", "Black", "Alpha");
    }

    void setColor(int n, float[] fArray) {
        super.setColor(n, fArray);
        fArray[4] = fArray[3];
        ColorModelCMYK.RGBtoCMYK(fArray, fArray);
    }

    int getColor(float[] fArray) {
        ColorModelCMYK.CMYKtoRGB(fArray, fArray);
        fArray[3] = fArray[4];
        return super.getColor(fArray);
    }

    private static float[] CMYKtoRGB(float[] fArray, float[] fArray2) {
        if (fArray2 == null) {
            fArray2 = new float[]{1.0f + fArray[0] * fArray[3] - fArray[3] - fArray[0], 1.0f + fArray[1] * fArray[3] - fArray[3] - fArray[1], 1.0f + fArray[2] * fArray[3] - fArray[3] - fArray[2]};
        }
        return fArray2;
    }

    private static float[] RGBtoCMYK(float[] fArray, float[] fArray2) {
        float f;
        if (fArray2 == null) {
            fArray2 = new float[4];
        }
        if ((f = ColorModelHSL.max(fArray[0], fArray[1], fArray[2])) > 0.0f) {
            fArray2[0] = 1.0f - fArray[0] / f;
            fArray2[1] = 1.0f - fArray[1] / f;
            fArray2[2] = 1.0f - fArray[2] / f;
        } else {
            fArray2[0] = 0.0f;
            fArray2[1] = 0.0f;
            fArray2[2] = 0.0f;
        }
        fArray2[3] = 1.0f - f;
        return fArray2;
    }
}

