/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream;

import com.sun.org.apache.xerces.internal.impl.PropertyManager;
import com.sun.xml.internal.stream.writers.XMLDOMWriterImpl;
import com.sun.xml.internal.stream.writers.XMLEventWriterImpl;
import com.sun.xml.internal.stream.writers.XMLStreamWriterImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;

public class XMLOutputFactoryImpl
extends XMLOutputFactory {
    private PropertyManager fPropertyManager = new PropertyManager(2);
    private XMLStreamWriterImpl fStreamWriter = null;
    boolean fReuseInstance = false;
    private static final boolean DEBUG = false;
    private boolean fPropertyChanged;

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLEventWriter(outputStream, null);
    }

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String string) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(outputStream, string));
    }

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        if (result instanceof StAXResult && ((StAXResult)result).getXMLEventWriter() != null) {
            return ((StAXResult)result).getXMLEventWriter();
        }
        return new XMLEventWriterImpl(this.createXMLStreamWriter(result));
    }

    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(writer));
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        if (result instanceof StreamResult) {
            return this.createXMLStreamWriter((StreamResult)result, null);
        }
        if (result instanceof DOMResult) {
            return new XMLDOMWriterImpl((DOMResult)result);
        }
        if (result instanceof StAXResult) {
            if (((StAXResult)result).getXMLStreamWriter() != null) {
                return ((StAXResult)result).getXMLStreamWriter();
            }
            throw new UnsupportedOperationException("Result of type " + result + " is not supported");
        }
        return this.createXMLStreamWriter(new StreamResult(result.getSystemId()));
    }

    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return this.createXMLStreamWriter(this.toStreamResult(null, writer, null), null);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLStreamWriter(outputStream, null);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string) throws XMLStreamException {
        return this.createXMLStreamWriter(this.toStreamResult(outputStream, null, null), string);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Property not supported");
        }
        if (this.fPropertyManager.containsProperty(string)) {
            return this.fPropertyManager.getProperty(string);
        }
        throw new IllegalArgumentException("Property not supported");
    }

    public boolean isPropertySupported(String string) {
        if (string == null) {
            return false;
        }
        return this.fPropertyManager.containsProperty(string);
    }

    public void setProperty(String string, Object object) throws IllegalArgumentException {
        if (string == null || object == null || !this.fPropertyManager.containsProperty(string)) {
            throw new IllegalArgumentException("Property " + string + "is not supported");
        }
        if (string == "reuse-instance" || string.equals("reuse-instance")) {
            this.fReuseInstance = (Boolean)object;
            if (this.fReuseInstance) {
                throw new IllegalArgumentException("Property " + string + " is not supported: XMLStreamWriters are not Thread safe");
            }
        } else {
            this.fPropertyChanged = true;
        }
        this.fPropertyManager.setProperty(string, object);
    }

    StreamResult toStreamResult(OutputStream outputStream, Writer writer, String string) {
        StreamResult streamResult = new StreamResult();
        streamResult.setOutputStream(outputStream);
        streamResult.setWriter(writer);
        streamResult.setSystemId(string);
        return streamResult;
    }

    XMLStreamWriter createXMLStreamWriter(StreamResult streamResult, String string) throws XMLStreamException {
        try {
            if (this.fReuseInstance && this.fStreamWriter != null && this.fStreamWriter.canReuse() && !this.fPropertyChanged) {
                this.fStreamWriter.reset();
                this.fStreamWriter.setOutput(streamResult, string);
                return this.fStreamWriter;
            }
            this.fStreamWriter = new XMLStreamWriterImpl(streamResult, string, new PropertyManager(this.fPropertyManager));
            return this.fStreamWriter;
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }
}

