/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerOrderFocusTraversalPolicy
extends FocusTraversalPolicy
implements Serializable {
    private static final Logger log = Logger.getLogger("java.awt.ContainerOrderFocusTraversalPolicy");
    private final int FORWARD_TRAVERSAL = 0;
    private final int BACKWARD_TRAVERSAL = 1;
    private static final long serialVersionUID = 486933713763926351L;
    private boolean implicitDownCycleTraversal = true;
    private transient Container cachedRoot;
    private transient List cachedCycle;

    private List<Component> getFocusTraversalCycle(Container container) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.enumerateCycle(container, arrayList);
        return arrayList;
    }

    private int getComponentIndex(List<Component> list, Component component) {
        return list.indexOf(component);
    }

    private void enumerateCycle(Container container, List list) {
        if (!container.isVisible() || !container.isDisplayable()) {
            return;
        }
        list.add(container);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Container container2;
            Component component = componentArray[i];
            if (component instanceof Container && !(container2 = (Container)component).isFocusCycleRoot() && !container2.isFocusTraversalPolicyProvider()) {
                this.enumerateCycle(container2, list);
                continue;
            }
            list.add(component);
        }
    }

    private Container getTopmostProvider(Container container, Component component) {
        Container container2;
        Container container3 = null;
        for (container2 = component.getParent(); container2 != container && container2 != null; container2 = container2.getParent()) {
            if (!container2.isFocusTraversalPolicyProvider()) continue;
            container3 = container2;
        }
        if (container2 == null) {
            return null;
        }
        return container3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Component getComponentDownCycle(Component component, int n) {
        Component component2 = null;
        if (!(component instanceof Container)) return component2;
        Container container = (Container)component;
        if (container.isFocusCycleRoot()) {
            if (!this.getImplicitDownCycleTraversal()) return null;
            component2 = container.getFocusTraversalPolicy().getDefaultComponent(container);
            if (component2 == null || !log.isLoggable(Level.FINE)) return component2;
            log.fine("### Transfered focus down-cycle to " + component2 + " in the focus cycle root " + container);
            return component2;
        } else {
            if (!container.isFocusTraversalPolicyProvider()) return component2;
            Component component3 = component2 = n == 0 ? container.getFocusTraversalPolicy().getDefaultComponent(container) : container.getFocusTraversalPolicy().getLastComponent(container);
            if (component2 == null || !log.isLoggable(Level.FINE)) return component2;
            log.fine("### Transfered focus to " + component2 + " in the FTP provider " + container);
        }
        return component2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponentAfter(Container container, Component component) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("### Searching in " + container + " for component after " + component);
        }
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (container.isFocusCycleRoot() && !component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Object object2;
            if (!container.isVisible() || !container.isDisplayable()) {
                return null;
            }
            Component component2 = this.getComponentDownCycle(component, 0);
            if (component2 != null) {
                return component2;
            }
            Container container2 = this.getTopmostProvider(container, component);
            if (container2 != null) {
                Component component3;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("### Asking FTP " + container2 + " for component after " + component);
                }
                if ((component3 = ((FocusTraversalPolicy)(object2 = container2.getFocusTraversalPolicy())).getComponentAfter(container2, component)) != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("### FTP returned " + component3);
                    }
                    return component3;
                }
                component = container2;
            }
            object2 = this.getFocusTraversalCycle(container);
            if (log.isLoggable(Level.FINE)) {
                log.fine("### Cycle is " + object2 + ", component is " + component);
            }
            if ((n = this.getComponentIndex((List<Component>)object2, component)) < 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("### Didn't find component " + component + " in a cycle " + container);
                }
                return this.getFirstComponent(container);
            }
            ++n;
            while (n < object2.size()) {
                component2 = (Component)object2.get(n);
                if (this.accept(component2)) {
                    return component2;
                }
                if ((component2 = this.getComponentDownCycle(component2, 0)) != null) {
                    return component2;
                }
                ++n;
            }
            if (container.isFocusCycleRoot()) {
                this.cachedRoot = container;
                this.cachedCycle = object2;
                component2 = this.getFirstComponent(container);
                this.cachedRoot = null;
                this.cachedCycle = null;
                return component2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponentBefore(Container container, Component component) {
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (container.isFocusCycleRoot() && !component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Object object2;
            if (!container.isVisible() || !container.isDisplayable()) {
                return null;
            }
            Container container2 = this.getTopmostProvider(container, component);
            if (container2 != null) {
                Component component2;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("### Asking FTP " + container2 + " for component after " + component);
                }
                if ((component2 = ((FocusTraversalPolicy)(object2 = container2.getFocusTraversalPolicy())).getComponentBefore(container2, component)) != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("### FTP returned " + component2);
                    }
                    return component2;
                }
                component = container2;
                if (this.accept(component)) {
                    return component;
                }
            }
            object2 = this.getFocusTraversalCycle(container);
            if (log.isLoggable(Level.FINE)) {
                log.fine("### Cycle is " + object2 + ", component is " + component);
            }
            if ((n = this.getComponentIndex((List<Component>)object2, component)) < 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("### Didn't find component " + component + " in a cycle " + container);
                }
                return this.getLastComponent(container);
            }
            Component component3 = null;
            Component component4 = null;
            --n;
            while (n >= 0) {
                component3 = (Component)object2.get(n);
                if (component3 != container && (component4 = this.getComponentDownCycle(component3, 1)) != null) {
                    return component4;
                }
                if (this.accept(component3)) {
                    return component3;
                }
                --n;
            }
            if (container.isFocusCycleRoot()) {
                this.cachedRoot = container;
                this.cachedCycle = object2;
                component3 = this.getLastComponent(container);
                this.cachedRoot = null;
                this.cachedCycle = null;
                return component3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getFirstComponent(Container container) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("### Getting first component in " + container);
        }
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            if (!container.isVisible() || !container.isDisplayable()) {
                return null;
            }
            List<Component> list = this.cachedRoot == container ? this.cachedCycle : this.getFocusTraversalCycle(container);
            if (list.size() == 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("### Cycle is empty");
                }
                return null;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("### Cycle is " + list);
            }
            for (int i = 0; i < list.size(); ++i) {
                Container container2;
                Component component = list.get(i);
                if (this.accept(component)) {
                    return component;
                }
                if (!(component instanceof Container) || component == container || !(container2 = (Container)component).isFocusTraversalPolicyProvider()) continue;
                return container2.getFocusTraversalPolicy().getDefaultComponent(container2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getLastComponent(Container container) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("### Getting last component in " + container);
        }
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            if (!container.isVisible() || !container.isDisplayable()) {
                return null;
            }
            List<Component> list = this.cachedRoot == container ? this.cachedCycle : this.getFocusTraversalCycle(container);
            if (list.size() == 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("### Cycle is empty");
                }
                return null;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("### Cycle is " + list);
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                Container container2;
                Component component = list.get(i);
                if (this.accept(component)) {
                    return component;
                }
                if (!(component instanceof Container) || component == container || !(container2 = (Container)component).isFocusTraversalPolicyProvider()) continue;
                return container2.getFocusTraversalPolicy().getLastComponent(container2);
            }
        }
        return null;
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    public void setImplicitDownCycleTraversal(boolean bl) {
        this.implicitDownCycleTraversal = bl;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected boolean accept(Component component) {
        if (!component.canBeFocusOwner()) {
            return false;
        }
        if (!(component instanceof Window)) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!container.isEnabled() && !container.isLightweight()) {
                    return false;
                }
                if (container instanceof Window) break;
            }
        }
        return true;
    }
}

