/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.dtdparser;

import java.io.InputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class MessageCatalog {
    private String bundleName;
    private Hashtable cache = new Hashtable(5);

    protected MessageCatalog(Class clazz) {
        this(clazz, "Messages");
    }

    private MessageCatalog(Class clazz, String string) {
        this.bundleName = clazz.getName();
        int n = this.bundleName.lastIndexOf(46);
        this.bundleName = n == -1 ? "" : this.bundleName.substring(0, n) + ".";
        this.bundleName = this.bundleName + "resources." + string;
    }

    public String getMessage(Locale locale, String string) {
        ResourceBundle resourceBundle;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, locale);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, Locale.ENGLISH);
        }
        return resourceBundle.getString(string);
    }

    public String getMessage(Locale locale, String string, Object[] objectArray) {
        ResourceBundle resourceBundle;
        if (objectArray == null) {
            return this.getMessage(locale, string);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof String || objectArray[i] instanceof Number || objectArray[i] instanceof Date) continue;
            objectArray[i] = objectArray[i] == null ? "(null)" : objectArray[i].toString();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, locale);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, Locale.ENGLISH);
        }
        MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(string));
        messageFormat.setLocale(locale);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = messageFormat.format(objectArray, stringBuffer, new FieldPosition(0));
        return stringBuffer.toString();
    }

    public Locale chooseLocale(String[] stringArray) {
        if ((stringArray = this.canonicalize(stringArray)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.isLocaleSupported(stringArray[i])) continue;
                return this.getLocale(stringArray[i]);
            }
        }
        return null;
    }

    private String[] canonicalize(String[] stringArray) {
        boolean bl = false;
        int n = 0;
        if (stringArray == null) {
            return stringArray;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n2 = string.length();
            if (n2 != 2 && n2 != 5) {
                if (!bl) {
                    stringArray = (String[])stringArray.clone();
                    bl = true;
                }
                stringArray[i] = null;
                ++n;
                continue;
            }
            if (n2 == 2) {
                if ((string = string.toLowerCase()) == stringArray[i]) continue;
                if (!bl) {
                    stringArray = (String[])stringArray.clone();
                    bl = true;
                }
                stringArray[i] = string;
                continue;
            }
            char[] cArray = new char[]{Character.toLowerCase(string.charAt(0)), Character.toLowerCase(string.charAt(1)), '_', Character.toUpperCase(string.charAt(3)), Character.toUpperCase(string.charAt(4))};
            if (!bl) {
                stringArray = (String[])stringArray.clone();
                bl = true;
            }
            stringArray[i] = new String(cArray);
        }
        if (n != 0) {
            String[] stringArray2 = new String[stringArray.length - n];
            n = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                while (stringArray[i + n] == null) {
                    ++n;
                }
                stringArray2[i] = stringArray[i + n];
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    private Locale getLocale(String string) {
        String string2;
        String string3;
        int n = string.indexOf(95);
        if (n == -1) {
            if (string.equals("de")) {
                return Locale.GERMAN;
            }
            if (string.equals("en")) {
                return Locale.ENGLISH;
            }
            if (string.equals("fr")) {
                return Locale.FRENCH;
            }
            if (string.equals("it")) {
                return Locale.ITALIAN;
            }
            if (string.equals("ja")) {
                return Locale.JAPANESE;
            }
            if (string.equals("ko")) {
                return Locale.KOREAN;
            }
            if (string.equals("zh")) {
                return Locale.CHINESE;
            }
            string3 = string;
            string2 = "";
        } else {
            if (string.equals("zh_CN")) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            if (string.equals("zh_TW")) {
                return Locale.TRADITIONAL_CHINESE;
            }
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        return new Locale(string3, string2);
    }

    public boolean isLocaleSupported(String string) {
        Boolean bl = (Boolean)this.cache.get(string);
        if (bl != null) {
            return bl;
        }
        ClassLoader classLoader = null;
        while (true) {
            String string2 = this.bundleName + "_" + string;
            try {
                Class.forName(string2);
                this.cache.put(string, Boolean.TRUE);
                return true;
            }
            catch (Exception exception) {
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                string2 = string2.replace('.', '/');
                string2 = string2 + ".properties";
                InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
                if (inputStream != null) {
                    this.cache.put(string, Boolean.TRUE);
                    return true;
                }
                int n = string.indexOf(95);
                if (n > 0) {
                    string = string.substring(0, n);
                    continue;
                }
                this.cache.put(string, Boolean.FALSE);
                return false;
            }
            break;
        }
    }
}

