/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.framework;

import com.sun.tools.internal.ws.wsdl.framework.AbstractDocument;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.tools.internal.ws.wsdl.framework.ParseException;
import com.sun.tools.internal.ws.wsdl.framework.ParserListener;
import com.sun.tools.internal.ws.wsdl.framework.WSDLLocation;
import com.sun.xml.internal.ws.util.NamespaceSupport;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ParserContext {
    private static final String PREFIX_XMLNS = "xmlns";
    private boolean _followImports;
    private AbstractDocument _document;
    private NamespaceSupport _nsSupport;
    private ArrayList _listeners;
    private WSDLLocation _wsdlLocation;

    public ParserContext(AbstractDocument abstractDocument, ArrayList arrayList) {
        this._document = abstractDocument;
        this._listeners = arrayList;
        this._nsSupport = new NamespaceSupport();
        this._wsdlLocation = new WSDLLocation();
    }

    public AbstractDocument getDocument() {
        return this._document;
    }

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean bl) {
        this._followImports = bl;
    }

    public void push() {
        this._nsSupport.pushContext();
    }

    public void pop() {
        this._nsSupport.popContext();
    }

    public String getNamespaceURI(String string) {
        return this._nsSupport.getURI(string);
    }

    public Iterator getPrefixes() {
        return this._nsSupport.getPrefixes();
    }

    public String getDefaultNamespaceURI() {
        return this.getNamespaceURI("");
    }

    public void registerNamespaces(Element element) {
        Iterator iterator = XmlUtil.getAllAttributes((Element)element);
        while (iterator.hasNext()) {
            Attr attr = (Attr)iterator.next();
            if (attr.getName().equals(PREFIX_XMLNS)) {
                this._nsSupport.declarePrefix("", attr.getValue());
                continue;
            }
            String string = XmlUtil.getPrefix((String)attr.getName());
            if (string == null || !string.equals(PREFIX_XMLNS)) continue;
            String string2 = XmlUtil.getLocalPart((String)attr.getName());
            String string3 = attr.getValue();
            this._nsSupport.declarePrefix(string2, string3);
        }
    }

    public QName translateQualifiedName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = XmlUtil.getPrefix((String)string);
        String string3 = null;
        if (string2 == null) {
            string3 = this.getDefaultNamespaceURI();
        } else {
            string3 = this.getNamespaceURI(string2);
            if (string3 == null) {
                throw new ParseException("parsing.unknownNamespacePrefix", string2);
            }
        }
        return new QName(string3, XmlUtil.getLocalPart((String)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireIgnoringExtension(QName qName, QName qName2) {
        List list = null;
        ParserContext parserContext = this;
        synchronized (parserContext) {
            if (this._listeners != null) {
                list = (List)this._listeners.clone();
            }
        }
        if (list != null) {
            for (ParserListener parserListener : list) {
                parserListener.ignoringExtension(qName, qName2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDoneParsingEntity(QName qName, Entity entity) {
        List list = null;
        ParserContext parserContext = this;
        synchronized (parserContext) {
            if (this._listeners != null) {
                list = (List)this._listeners.clone();
            }
        }
        if (list != null) {
            for (ParserListener parserListener : list) {
                parserListener.doneParsingEntity(qName, entity);
            }
        }
    }

    public void pushWSDLLocation() {
        this._wsdlLocation.push();
    }

    public void popWSDLLocation() {
        this._wsdlLocation.pop();
    }

    public void setWSDLLocation(String string) {
        this._wsdlLocation.setLocation(string);
    }

    public String getWSDLLocation() {
        return this._wsdlLocation.getLocation();
    }
}

