/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes
implements Iterable<Attribute> {
    public final Attribute[] attrs;
    public final Map<String, Attribute> map;

    Attributes(ClassReader classReader) throws IOException {
        this.map = new HashMap<String, Attribute>();
        int n = classReader.readUnsignedShort();
        this.attrs = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            Attribute attribute;
            this.attrs[i] = attribute = Attribute.read(classReader);
            try {
                this.map.put(attribute.getName(classReader.getConstantPool()), attribute);
                continue;
            }
            catch (ConstantPoolException constantPoolException) {
                // empty catch block
            }
        }
    }

    public Attributes(ConstantPool constantPool, Attribute[] attributeArray) {
        this.attrs = attributeArray;
        this.map = new HashMap<String, Attribute>();
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = attributeArray[i];
            try {
                this.map.put(attribute.getName(constantPool), attribute);
                continue;
            }
            catch (ConstantPoolException constantPoolException) {
                // empty catch block
            }
        }
    }

    @Override
    public Iterator<Attribute> iterator() {
        return Arrays.asList(this.attrs).iterator();
    }

    public Attribute get(int n) {
        return this.attrs[n];
    }

    public Attribute get(String string) {
        return this.map.get(string);
    }

    public int getIndex(ConstantPool constantPool, String string) {
        for (int i = 0; i < this.attrs.length; ++i) {
            Attribute attribute = this.attrs[i];
            try {
                if (attribute == null || !attribute.getName(constantPool).equals(string)) continue;
                return i;
            }
            catch (ConstantPoolException constantPoolException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int size() {
        return this.attrs.length;
    }
}

