#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <err.h>
#include <stdio.h>
#include "spi_io.h"
#include "hexdump.c"

int
main(int argc, char **argv)
{
	int fd;
	int error;

	uint8_t tx[4] = { 0x9f, 0, 0, 0 };
	uint8_t rx[32];

	struct spivect sv[2];
	struct spixfer sx;

	sv[0].tx = tx;
	sv[0].rx = NULL;
	sv[0].len = 1;

	sv[1].tx = NULL;
	sv[1].rx = rx;
	sv[1].len = 3;

	sx.nvec = 2;
	sx.vec = sv;

	printf("%p %zu\n", tx, sizeof(tx));
	printf("%p %zu\n", sv, sizeof(sv));
	printf("%p %zu\n", &sx, sizeof(sx));
	fflush(stdout);

	fd = open("/root/spigen0", O_RDWR);
	if (fd < 0)
		return EXIT_FAILURE;

	error = ioctl(fd, SPI_IOCTL_XFER, &sx);
	if (error == -1)
		err(EXIT_FAILURE, "ioctl\n");

	fflush(stdout);
	hexdump(rx, 3);

	return EXIT_SUCCESS;
}
