.\" $XConsortium: XmacII.man,v 1.13 94/04/18 18:05:17 rws Exp $
.\" Copyright (c) 1989  X Consortium
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.TH XMACII 1 "Release 6" "X Version 11"
.SH NAME
XmacII \- Macintosh II server for X Version 11
.SH SYNOPSIS
.B XmacII
[ option ] ...
.SH DESCRIPTION
.I XmacII
is the server for Version 11 of the X window system on Macintosh II hardware running A/UX.
It will normally be started by the shell script
.IR X11.
.fi
.SH CONFIGURATIONS
.I XmacII
operates under A/UX Release 2.0 and later.
Color and multiple screens are supported.
.SH OPTIONS
.PP
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXmacII\fP accepts the following command line switches:
.TP 8
.B \-screen \fInumber\fP \-depth \fInumber\fP
arranges that the given screen will operate at the given depth.
Screens are numbered from 0 and correspond to the relative position
of video cards in the Macintosh II slots.
Supported depths are 1 (monochrome at 1 bit per pixel), 
8 (color at 8 bits per pixel, indexing a colormap with 256 entries), and
24 (color at 24 bits per pixel). The server starts up, by default, in the
deepest depth available for any particular screen. This option must be used to
modify that behavior.
.TP 8
.B \-optionmouse
requires holding the option key down while pressing the arrow keys to get
middle and right mouse buttons. Allows the arrow keys to retain their normal
function
.TP 8
.B \-noosm
don't open /dev/osm
.SH "BUTTON MAPPINGS"
Many X clients assume the mouse has three buttons. The A/UX X server simulates
the middle and right mouse buttons with keystrokes -- the left-arrow key
generates middle button events, and the right-arrow key generates right button
events -- the real mouse button generates left button events. The 
open-apple or cloverleaf key is the "Meta" modifier, Meta can also be obtained
by pressing the up-arrow key. The down-arrow key duplicates the Control key.
Meta, Control, and Shift are often used in combination with other keystrokes
or mouse clicks. For example, the terminal emulator xterm pops up menus in
response to control-left and control-middle. The original function of the
arrow keys may be obtained by holding down the Option key while pressing
one of the arrow keys.
.SH "SECURITY"
.I X
uses an access control list for deciding whether or not to accept a
connection from a given client.  This list
initially consists of the machine on which the server is running, and any
hosts listed in the file
\fI/etc/X0.hosts\fP
This file should contain one line
per host name, with no white space.  
.PP
The user can manipulate a dynamic form of this list in the server
using the \fIxhost(1)\fP program from
the same machine as the server.
.PP
Unlike some window systems, \fIX\fP does not have any notion of 
window operation permissions or
place any restrictions on what a client can do; if
a program can connect to a display, it has full run of the screen.  There
is support for using 
authentication services on connection startup beyond the simple host name
check, but it is not used in the standard distribution.
.SH "FONTS"
Fonts are stored in individual files in the directory(ies) named by
the font search path.  These files may be created by the \fIfc\fP utility.
The name of the file must correspond to the name of the font in lowercase
with the suffix ".pcf" appended.
Font files may be stored in \fIcompress\fP(1) format, in which case an
additional suffix (usually ".Z", defined when the server is built) must
be appended to the usual filename.
.SH "FILES"
.TP 30
<XRoot>/bin/X11
<XRoot>/bin/X11R6
Bourne shell scripts which start the server and initial 
.I xterm 
client.  <XRoot> refers to the root of the X11 install tree.
.TP 30
$HOME/.x11start 
Bourne shell script executed by initial 
.I xterm 
client which starts a slew of other clients. 
Reference copy in <XRoot>/lib/X11/.x11start
.TP 30
<XRoot>/bin/XmacII 
the server binary
.TP 30
<XRoot>/bin/Xrepair 
ensures console viability after server exits
.TP 30
<XRoot>/bin/* 
client binaries
.TP 30
<XRoot>lib/X11/fonts/*
.TP 30
<XRoot>/lib/X11/rgb.{dir,pag,txt} 
color names to RGB mapping
.TP 30
/etc/X0.hosts
Initial access control list
.TP 30
/tmp/.X11-unix/X0
Unix domain socket
.TP 30
/usr/adm/X0msgs
Error log file
.TP 30
$HOME/.twmrc 
customization for the
.I twm
window manager. Reference copy in <XRoot>/lib/X11/Sample.twmrc
.TP 30
<XRoot>/lib/X11/XErrorDB 
client error message database
.TP 30
<XRoot>/lib/X11/app-defaults 
client specific resource specifications
.TP 30
<XRoot>/lib/X11/examples/Xaw/* 
source code examples of applications built on the
.I X
Toolkit
.TP 30
<XRoot>/lib/terminfo/x/xterm* 
.I terminfo
database entries descibing the terminal emulation capabilities of the
.I xterm
client. Reference copies in <XRoot>/lib/X11/xterm*.tic
.TP 30
<XRoot>/include/X11/bitmaps/*icon 
bitmap representations of icons used by the
.I twm
window manager
.SH "SEE ALSO"
xinit(1), X(1)
.SH BUGS
In the unlikely event the server crashes,  
it may leave the keyboard in a non-useful state.
The X11 script executes the
.I Xrepair
command in an attempt to repair the damage.
