/*	$NetBSD: dce_11_2_enum.h,v 1.2 2021/12/18 23:45:10 riastradh Exp $	*/

/*
 * DCE_11_2 Register documentation
 *
 * Copyright (C) 2016  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef DCE_11_2_ENUM_H
#define DCE_11_2_ENUM_H

typedef enum CRTC_CONTROL_CRTC_START_POINT_CNTL {
	CRTC_CONTROL_CRTC_START_POINT_CNTL_NORMAL        = 0x0,
	CRTC_CONTROL_CRTC_START_POINT_CNTL_DP            = 0x1,
} CRTC_CONTROL_CRTC_START_POINT_CNTL;
typedef enum CRTC_CONTROL_CRTC_FIELD_NUMBER_CNTL {
	CRTC_CONTROL_CRTC_FIELD_NUMBER_CNTL_NORMAL       = 0x0,
	CRTC_CONTROL_CRTC_FIELD_NUMBER_CNTL_DP           = 0x1,
} CRTC_CONTROL_CRTC_FIELD_NUMBER_CNTL;
typedef enum CRTC_CONTROL_CRTC_DISABLE_POINT_CNTL {
	CRTC_CONTROL_CRTC_DISABLE_POINT_CNTL_DISABLE     = 0x0,
	CRTC_CONTROL_CRTC_DISABLE_POINT_CNTL_DISABLE_CURRENT= 0x1,
	CRTC_CONTROL_CRTC_DISABLE_POINT_CNTL_RESERVED    = 0x2,
	CRTC_CONTROL_CRTC_DISABLE_POINT_CNTL_DISABLE_FIRST= 0x3,
} CRTC_CONTROL_CRTC_DISABLE_POINT_CNTL;
typedef enum CRTC_CONTROL_CRTC_FIELD_NUMBER_POLARITY {
	CRTC_CONTROL_CRTC_FIELD_NUMBER_POLARITY_FALSE    = 0x0,
	CRTC_CONTROL_CRTC_FIELD_NUMBER_POLARITY_TRUE     = 0x1,
} CRTC_CONTROL_CRTC_FIELD_NUMBER_POLARITY;
typedef enum CRTC_CONTROL_CRTC_DISP_READ_REQUEST_DISABLE {
	CRTC_CONTROL_CRTC_DISP_READ_REQUEST_DISABLE_FALSE= 0x0,
	CRTC_CONTROL_CRTC_DISP_READ_REQUEST_DISABLE_TRUE = 0x1,
} CRTC_CONTROL_CRTC_DISP_READ_REQUEST_DISABLE;
typedef enum CRTC_CONTROL_CRTC_SOF_PULL_EN {
	CRTC_CONTROL_CRTC_SOF_PULL_EN_FALSE              = 0x0,
	CRTC_CONTROL_CRTC_SOF_PULL_EN_TRUE               = 0x1,
} CRTC_CONTROL_CRTC_SOF_PULL_EN;
typedef enum CRTC_H_SYNC_B_CNTL_CRTC_H_SYNC_B_POL {
	CRTC_H_SYNC_B_CNTL_CRTC_H_SYNC_B_POL_FALSE       = 0x0,
	CRTC_H_SYNC_B_CNTL_CRTC_H_SYNC_B_POL_TRUE        = 0x1,
} CRTC_H_SYNC_B_CNTL_CRTC_H_SYNC_B_POL;
typedef enum CRTC_V_TOTAL_CONTROL_CRTC_V_TOTAL_MAX_SEL {
	CRTC_V_TOTAL_CONTROL_CRTC_V_TOTAL_MAX_SEL_FALSE  = 0x0,
	CRTC_V_TOTAL_CONTROL_CRTC_V_TOTAL_MAX_SEL_TRUE   = 0x1,
} CRTC_V_TOTAL_CONTROL_CRTC_V_TOTAL_MAX_SEL;
typedef enum CRTC_V_TOTAL_CONTROL_CRTC_V_TOTAL_MIN_SEL {
	CRTC_V_TOTAL_CONTROL_CRTC_V_TOTAL_MIN_SEL_FALSE  = 0x0,
	CRTC_V_TOTAL_CONTROL_CRTC_V_TOTAL_MIN_SEL_TRUE   = 0x1,
} CRTC_V_TOTAL_CONTROL_CRTC_V_TOTAL_MIN_SEL;
typedef enum CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_EN {
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_EN_FALSE= 0x0,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_EN_TRUE= 0x1,
} CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_EN;
typedef enum CRTC_V_TOTAL_CONTROL_CRTC_FORCE_LOCK_TO_MASTER_VSYNC {
	CRTC_V_TOTAL_CONTROL_CRTC_FORCE_LOCK_TO_MASTER_VSYNC_DISABLE= 0x0,
	CRTC_V_TOTAL_CONTROL_CRTC_FORCE_LOCK_TO_MASTER_VSYNC_ENABLE= 0x1,
} CRTC_V_TOTAL_CONTROL_CRTC_FORCE_LOCK_TO_MASTER_VSYNC;
typedef enum CRTC_V_TOTAL_CONTROL_CRTC_FORCE_LOCK_ON_EVENT {
	CRTC_V_TOTAL_CONTROL_CRTC_FORCE_LOCK_ON_EVENT_DISABLE= 0x0,
	CRTC_V_TOTAL_CONTROL_CRTC_FORCE_LOCK_ON_EVENT_ENABLE= 0x1,
} CRTC_V_TOTAL_CONTROL_CRTC_FORCE_LOCK_ON_EVENT;
typedef enum CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK {
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_FRAME_START= 0x0,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_CRTC_TRIG_A= 0x1,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_CRTC_TRIG_B= 0x2,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_CURSOR_CHANGE= 0x3,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_OTHER_CLIENT= 0x4,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_MC_DC_REGION0= 0x5,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_MC_DC_REGION1= 0x6,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_MC_DC_REGION2= 0x7,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_MC_DC_REGION3= 0x8,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_GRAPHIC_UPDATE_PENDING= 0x9,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_RESERVED2= 0xa,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_INVALID= 0xb,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_DOUBLE_BUFFER= 0xc,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_D1CRTC_VERT_COUNT_NOM= 0xd,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_D1CRTC_VERT_COUNT= 0xe,
	CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK_RESERVED= 0xf,
} CRTC_V_TOTAL_CONTROL_CRTC_SET_V_TOTAL_MIN_MASK;
typedef enum CRTC_V_TOTAL_INT_STATUS_CRTC_SET_V_TOTAL_MIN_EVENT_OCCURED_ACK {
	CRTC_V_TOTAL_INT_STATUS_CRTC_SET_V_TOTAL_MIN_EVENT_OCCURED_ACK_FALSE= 0x0,
	CRTC_V_TOTAL_INT_STATUS_CRTC_SET_V_TOTAL_MIN_EVENT_OCCURED_ACK_TRUE= 0x1,
} CRTC_V_TOTAL_INT_STATUS_CRTC_SET_V_TOTAL_MIN_EVENT_OCCURED_ACK;
typedef enum CRTC_VSYNC_NOM_INT_STATUS_CRTC_VSYNC_NOM_INT_CLEAR {
	CRTC_VSYNC_NOM_INT_STATUS_CRTC_VSYNC_NOM_INT_CLEAR_FALSE= 0x0,
	CRTC_VSYNC_NOM_INT_STATUS_CRTC_VSYNC_NOM_INT_CLEAR_TRUE= 0x1,
} CRTC_VSYNC_NOM_INT_STATUS_CRTC_VSYNC_NOM_INT_CLEAR;
typedef enum CRTC_V_SYNC_B_CNTL_CRTC_V_SYNC_B_POL {
	CRTC_V_SYNC_B_CNTL_CRTC_V_SYNC_B_POL_FALSE       = 0x0,
	CRTC_V_SYNC_B_CNTL_CRTC_V_SYNC_B_POL_TRUE        = 0x1,
} CRTC_V_SYNC_B_CNTL_CRTC_V_SYNC_B_POL;
typedef enum CRTC_DTMTEST_CNTL_CRTC_DTMTEST_CRTC_EN {
	CRTC_DTMTEST_CNTL_CRTC_DTMTEST_CRTC_EN_FALSE     = 0x0,
	CRTC_DTMTEST_CNTL_CRTC_DTMTEST_CRTC_EN_TRUE      = 0x1,
} CRTC_DTMTEST_CNTL_CRTC_DTMTEST_CRTC_EN;
typedef enum CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT {
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_VSYNCA_OTHER= 0x1,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_HSYNCA_OTHER= 0x2,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_GENERICF= 0x5,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_GENERICE= 0x6,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_VSYNCA  = 0x7,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_HSYNCA  = 0x8,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_VSYNCB  = 0x9,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_HSYNCB  = 0xa,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_HPD1    = 0xb,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_HPD2    = 0xc,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_GENERICD= 0xd,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_GENERICC= 0xe,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_IGSL0   = 0x10,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_IGSL1   = 0x11,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_IGSL2   = 0x12,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_IBLON   = 0x13,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_GENERICA= 0x14,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_GENERICB= 0x15,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_IGSL_ALLOW= 0x16,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT_MANUAL_FLOW= 0x17,
} CRTC_TRIGA_CNTL_CRTC_TRIGA_SOURCE_SELECT;
typedef enum CRTC_TRIGA_CNTL_CRTC_TRIGA_POLARITY_SELECT {
	CRTC_TRIGA_CNTL_CRTC_TRIGA_POLARITY_SELECT_INTERLACE= 0x1,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_POLARITY_SELECT_GENERICA= 0x2,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_POLARITY_SELECT_GENERICB= 0x3,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_POLARITY_SELECT_HSYNCA= 0x4,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_POLARITY_SELECT_HSYNCB= 0x5,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_POLARITY_SELECT_VIDEO = 0x6,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_POLARITY_SELECT_GENERICC= 0x7,
} CRTC_TRIGA_CNTL_CRTC_TRIGA_POLARITY_SELECT;
typedef enum CRTC_TRIGA_CNTL_CRTC_TRIGA_RESYNC_BYPASS_EN {
	CRTC_TRIGA_CNTL_CRTC_TRIGA_RESYNC_BYPASS_EN_FALSE= 0x0,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_RESYNC_BYPASS_EN_TRUE = 0x1,
} CRTC_TRIGA_CNTL_CRTC_TRIGA_RESYNC_BYPASS_EN;
typedef enum CRTC_TRIGA_CNTL_CRTC_TRIGA_CLEAR {
	CRTC_TRIGA_CNTL_CRTC_TRIGA_CLEAR_FALSE           = 0x0,
	CRTC_TRIGA_CNTL_CRTC_TRIGA_CLEAR_TRUE            = 0x1,
} CRTC_TRIGA_CNTL_CRTC_TRIGA_CLEAR;
typedef enum CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT {
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_VSYNCA_OTHER= 0x1,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_HSYNCA_OTHER= 0x2,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_GENERICF= 0x5,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_GENERICE= 0x6,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_VSYNCA  = 0x7,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_HSYNCA  = 0x8,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_VSYNCB  = 0x9,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_HSYNCB  = 0xa,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_HPD1    = 0xb,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_HPD2    = 0xc,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_GENERICD= 0xd,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_GENERICC= 0xe,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_IGSL0   = 0x10,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_IGSL1   = 0x11,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_IGSL2   = 0x12,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_IBLON   = 0x13,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_GENERICA= 0x14,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_GENERICB= 0x15,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_IGSL_ALLOW= 0x16,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT_MANUAL_FLOW= 0x17,
} CRTC_TRIGB_CNTL_CRTC_TRIGB_SOURCE_SELECT;
typedef enum CRTC_TRIGB_CNTL_CRTC_TRIGB_POLARITY_SELECT {
	CRTC_TRIGB_CNTL_CRTC_TRIGB_POLARITY_SELECT_INTERLACE= 0x1,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_POLARITY_SELECT_GENERICA= 0x2,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_POLARITY_SELECT_GENERICB= 0x3,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_POLARITY_SELECT_HSYNCA= 0x4,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_POLARITY_SELECT_HSYNCB= 0x5,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_POLARITY_SELECT_VIDEO = 0x6,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_POLARITY_SELECT_GENERICC= 0x7,
} CRTC_TRIGB_CNTL_CRTC_TRIGB_POLARITY_SELECT;
typedef enum CRTC_TRIGB_CNTL_CRTC_TRIGB_RESYNC_BYPASS_EN {
	CRTC_TRIGB_CNTL_CRTC_TRIGB_RESYNC_BYPASS_EN_FALSE= 0x0,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_RESYNC_BYPASS_EN_TRUE = 0x1,
} CRTC_TRIGB_CNTL_CRTC_TRIGB_RESYNC_BYPASS_EN;
typedef enum CRTC_TRIGB_CNTL_CRTC_TRIGB_CLEAR {
	CRTC_TRIGB_CNTL_CRTC_TRIGB_CLEAR_FALSE           = 0x0,
	CRTC_TRIGB_CNTL_CRTC_TRIGB_CLEAR_TRUE            = 0x1,
} CRTC_TRIGB_CNTL_CRTC_TRIGB_CLEAR;
typedef enum CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_MODE {
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_MODE_DISABLE= 0x0,
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_MODE_HCOUNT= 0x1,
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_MODE_HCOUNT_VCOUNT= 0x2,
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_MODE_RESERVED= 0x3,
} CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_MODE;
typedef enum CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_CHECK {
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_CHECK_FALSE= 0x0,
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_CHECK_TRUE= 0x1,
} CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_CHECK;
typedef enum CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_TRIG_SEL {
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_TRIG_SEL_FALSE= 0x0,
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_TRIG_SEL_TRUE= 0x1,
} CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_TRIG_SEL;
typedef enum CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_CLEAR {
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_CLEAR_FALSE= 0x0,
	CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_CLEAR_TRUE= 0x1,
} CRTC_FORCE_COUNT_NOW_CNTL_CRTC_FORCE_COUNT_NOW_CLEAR;
typedef enum CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT {
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_LOGIC0= 0x0,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_GENERICF= 0x1,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_GENERICE= 0x2,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_HPD1= 0x3,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_HPD2= 0x4,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_DDC1DATA= 0x5,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_DDC1CLK= 0x6,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_DDC2DATA= 0x7,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_DDC2CLK= 0x8,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_DVOCLK= 0x9,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_MANUAL= 0xa,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_LOGIC1= 0xb,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_GENERICB= 0xc,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_GENERICA= 0xd,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_GENERICD= 0xe,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT_GENERICC= 0xf,
} CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_SOURCE_SELECT;
typedef enum CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_POLARITY {
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_POLARITY_FALSE= 0x0,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_POLARITY_TRUE= 0x1,
} CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_POLARITY;
typedef enum CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_GRANULARITY {
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_GRANULARITY_FALSE= 0x0,
	CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_GRANULARITY_TRUE= 0x1,
} CRTC_FLOW_CONTROL_CRTC_FLOW_CONTROL_GRANULARITY;
typedef enum CRTC_STEREO_FORCE_NEXT_EYE_CRTC_STEREO_FORCE_NEXT_EYE {
	CRTC_STEREO_FORCE_NEXT_EYE_CRTC_STEREO_FORCE_NEXT_EYE_NO= 0x0,
	CRTC_STEREO_FORCE_NEXT_EYE_CRTC_STEREO_FORCE_NEXT_EYE_RIGHT= 0x1,
	CRTC_STEREO_FORCE_NEXT_EYE_CRTC_STEREO_FORCE_NEXT_EYE_LEFT= 0x2,
	CRTC_STEREO_FORCE_NEXT_EYE_CRTC_STEREO_FORCE_NEXT_EYE_RESERVED= 0x3,
} CRTC_STEREO_FORCE_NEXT_EYE_CRTC_STEREO_FORCE_NEXT_EYE;
typedef enum CRTC_CONTROL_CRTC_MASTER_EN {
	CRTC_CONTROL_CRTC_MASTER_EN_FALSE                = 0x0,
	CRTC_CONTROL_CRTC_MASTER_EN_TRUE                 = 0x1,
} CRTC_CONTROL_CRTC_MASTER_EN;
typedef enum CRTC_BLANK_CONTROL_CRTC_BLANK_DATA_EN {
	CRTC_BLANK_CONTROL_CRTC_BLANK_DATA_EN_FALSE      = 0x0,
	CRTC_BLANK_CONTROL_CRTC_BLANK_DATA_EN_TRUE       = 0x1,
} CRTC_BLANK_CONTROL_CRTC_BLANK_DATA_EN;
typedef enum CRTC_BLANK_CONTROL_CRTC_BLANK_DE_MODE {
	CRTC_BLANK_CONTROL_CRTC_BLANK_DE_MODE_FALSE      = 0x0,
	CRTC_BLANK_CONTROL_CRTC_BLANK_DE_MODE_TRUE       = 0x1,
} CRTC_BLANK_CONTROL_CRTC_BLANK_DE_MODE;
typedef enum CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_ENABLE {
	CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_ENABLE_FALSE= 0x0,
	CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_ENABLE_TRUE= 0x1,
} CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_ENABLE;
typedef enum CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_FORCE_NEXT_FIELD {
	CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_FORCE_NEXT_FIELD_NOT= 0x0,
	CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_FORCE_NEXT_FIELD_ODD= 0x1,
	CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_FORCE_NEXT_FIELD_EVEN= 0x2,
	CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_FORCE_NEXT_FIELD_NOT2= 0x3,
} CRTC_INTERLACE_CONTROL_CRTC_INTERLACE_FORCE_NEXT_FIELD;
typedef enum CRTC_FIELD_INDICATION_CONTROL_CRTC_FIELD_INDICATION_OUTPUT_POLARITY {
	CRTC_FIELD_INDICATION_CONTROL_CRTC_FIELD_INDICATION_OUTPUT_POLARITY_FALSE= 0x0,
	CRTC_FIELD_INDICATION_CONTROL_CRTC_FIELD_INDICATION_OUTPUT_POLARITY_TRUE= 0x1,
} CRTC_FIELD_INDICATION_CONTROL_CRTC_FIELD_INDICATION_OUTPUT_POLARITY;
typedef enum CRTC_FIELD_INDICATION_CONTROL_CRTC_FIELD_ALIGNMENT {
	CRTC_FIELD_INDICATION_CONTROL_CRTC_FIELD_ALIGNMENT_FALSE= 0x0,
	CRTC_FIELD_INDICATION_CONTROL_CRTC_FIELD_ALIGNMENT_TRUE= 0x1,
} CRTC_FIELD_INDICATION_CONTROL_CRTC_FIELD_ALIGNMENT;
typedef enum CRTC_COUNT_CONTROL_CRTC_HORZ_COUNT_BY2_EN {
	CRTC_COUNT_CONTROL_CRTC_HORZ_COUNT_BY2_EN_FALSE  = 0x0,
	CRTC_COUNT_CONTROL_CRTC_HORZ_COUNT_BY2_EN_TRUE   = 0x1,
} CRTC_COUNT_CONTROL_CRTC_HORZ_COUNT_BY2_EN;
typedef enum CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE {
	CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_FALSE= 0x0,
	CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_TRUE= 0x1,
} CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE;
typedef enum CRTC_VERT_SYNC_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_CLEAR {
	CRTC_VERT_SYNC_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_CLEAR_FALSE= 0x0,
	CRTC_VERT_SYNC_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_CLEAR_TRUE= 0x1,
} CRTC_VERT_SYNC_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_CLEAR;
typedef enum CRTC_VERT_SYNC_CONTROL_CRTC_AUTO_FORCE_VSYNC_MODE {
	CRTC_VERT_SYNC_CONTROL_CRTC_AUTO_FORCE_VSYNC_MODE_DISABLE= 0x0,
	CRTC_VERT_SYNC_CONTROL_CRTC_AUTO_FORCE_VSYNC_MODE_TRIGGERA= 0x1,
	CRTC_VERT_SYNC_CONTROL_CRTC_AUTO_FORCE_VSYNC_MODE_TRIGGERB= 0x2,
	CRTC_VERT_SYNC_CONTROL_CRTC_AUTO_FORCE_VSYNC_MODE_RESERVED= 0x3,
} CRTC_VERT_SYNC_CONTROL_CRTC_AUTO_FORCE_VSYNC_MODE;
typedef enum CRTC_STEREO_CONTROL_CRTC_STEREO_SYNC_OUTPUT_POLARITY {
	CRTC_STEREO_CONTROL_CRTC_STEREO_SYNC_OUTPUT_POLARITY_FALSE= 0x0,
	CRTC_STEREO_CONTROL_CRTC_STEREO_SYNC_OUTPUT_POLARITY_TRUE= 0x1,
} CRTC_STEREO_CONTROL_CRTC_STEREO_SYNC_OUTPUT_POLARITY;
typedef enum CRTC_STEREO_CONTROL_CRTC_STEREO_SYNC_SELECT_POLARITY {
	CRTC_STEREO_CONTROL_CRTC_STEREO_SYNC_SELECT_POLARITY_FALSE= 0x0,
	CRTC_STEREO_CONTROL_CRTC_STEREO_SYNC_SELECT_POLARITY_TRUE= 0x1,
} CRTC_STEREO_CONTROL_CRTC_STEREO_SYNC_SELECT_POLARITY;
typedef enum CRTC_STEREO_CONTROL_CRTC_STEREO_EYE_FLAG_POLARITY {
	CRTC_STEREO_CONTROL_CRTC_STEREO_EYE_FLAG_POLARITY_FALSE= 0x0,
	CRTC_STEREO_CONTROL_CRTC_STEREO_EYE_FLAG_POLARITY_TRUE= 0x1,
} CRTC_STEREO_CONTROL_CRTC_STEREO_EYE_FLAG_POLARITY;
typedef enum CRTC_STEREO_CONTROL_CRTC_STEREO_EN {
	CRTC_STEREO_CONTROL_CRTC_STEREO_EN_FALSE         = 0x0,
	CRTC_STEREO_CONTROL_CRTC_STEREO_EN_TRUE          = 0x1,
} CRTC_STEREO_CONTROL_CRTC_STEREO_EN;
typedef enum CRTC_SNAPSHOT_STATUS_CRTC_SNAPSHOT_CLEAR {
	CRTC_SNAPSHOT_STATUS_CRTC_SNAPSHOT_CLEAR_FALSE   = 0x0,
	CRTC_SNAPSHOT_STATUS_CRTC_SNAPSHOT_CLEAR_TRUE    = 0x1,
} CRTC_SNAPSHOT_STATUS_CRTC_SNAPSHOT_CLEAR;
typedef enum CRTC_SNAPSHOT_CONTROL_CRTC_AUTO_SNAPSHOT_TRIG_SEL {
	CRTC_SNAPSHOT_CONTROL_CRTC_AUTO_SNAPSHOT_TRIG_SEL_DISABLE= 0x0,
	CRTC_SNAPSHOT_CONTROL_CRTC_AUTO_SNAPSHOT_TRIG_SEL_TRIGGERA= 0x1,
	CRTC_SNAPSHOT_CONTROL_CRTC_AUTO_SNAPSHOT_TRIG_SEL_TRIGGERB= 0x2,
	CRTC_SNAPSHOT_CONTROL_CRTC_AUTO_SNAPSHOT_TRIG_SEL_RESERVED= 0x3,
} CRTC_SNAPSHOT_CONTROL_CRTC_AUTO_SNAPSHOT_TRIG_SEL;
typedef enum CRTC_START_LINE_CONTROL_CRTC_PROGRESSIVE_START_LINE_EARLY {
	CRTC_START_LINE_CONTROL_CRTC_PROGRESSIVE_START_LINE_EARLY_FALSE= 0x0,
	CRTC_START_LINE_CONTROL_CRTC_PROGRESSIVE_START_LINE_EARLY_TRUE= 0x1,
} CRTC_START_LINE_CONTROL_CRTC_PROGRESSIVE_START_LINE_EARLY;
typedef enum CRTC_START_LINE_CONTROL_CRTC_INTERLACE_START_LINE_EARLY {
	CRTC_START_LINE_CONTROL_CRTC_INTERLACE_START_LINE_EARLY_FALSE= 0x0,
	CRTC_START_LINE_CONTROL_CRTC_INTERLACE_START_LINE_EARLY_TRUE= 0x1,
} CRTC_START_LINE_CONTROL_CRTC_INTERLACE_START_LINE_EARLY;
typedef enum CRTC_START_LINE_CONTROL_CRTC_LEGACY_REQUESTOR_EN {
	CRTC_START_LINE_CONTROL_CRTC_LEGACY_REQUESTOR_EN_FALSE= 0x0,
	CRTC_START_LINE_CONTROL_CRTC_LEGACY_REQUESTOR_EN_TRUE= 0x1,
} CRTC_START_LINE_CONTROL_CRTC_LEGACY_REQUESTOR_EN;
typedef enum CRTC_START_LINE_CONTROL_CRTC_PREFETCH_EN {
	CRTC_START_LINE_CONTROL_CRTC_PREFETCH_EN_FALSE   = 0x0,
	CRTC_START_LINE_CONTROL_CRTC_PREFETCH_EN_TRUE    = 0x1,
} CRTC_START_LINE_CONTROL_CRTC_PREFETCH_EN;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_SNAPSHOT_INT_MSK {
	CRTC_INTERRUPT_CONTROL_CRTC_SNAPSHOT_INT_MSK_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_SNAPSHOT_INT_MSK_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_SNAPSHOT_INT_MSK;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_SNAPSHOT_INT_TYPE {
	CRTC_INTERRUPT_CONTROL_CRTC_SNAPSHOT_INT_TYPE_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_SNAPSHOT_INT_TYPE_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_SNAPSHOT_INT_TYPE;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_V_UPDATE_INT_MSK {
	CRTC_INTERRUPT_CONTROL_CRTC_V_UPDATE_INT_MSK_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_V_UPDATE_INT_MSK_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_V_UPDATE_INT_MSK;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_V_UPDATE_INT_TYPE {
	CRTC_INTERRUPT_CONTROL_CRTC_V_UPDATE_INT_TYPE_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_V_UPDATE_INT_TYPE_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_V_UPDATE_INT_TYPE;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_FORCE_COUNT_NOW_INT_MSK {
	CRTC_INTERRUPT_CONTROL_CRTC_FORCE_COUNT_NOW_INT_MSK_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_FORCE_COUNT_NOW_INT_MSK_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_FORCE_COUNT_NOW_INT_MSK;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_FORCE_COUNT_NOW_INT_TYPE {
	CRTC_INTERRUPT_CONTROL_CRTC_FORCE_COUNT_NOW_INT_TYPE_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_FORCE_COUNT_NOW_INT_TYPE_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_FORCE_COUNT_NOW_INT_TYPE;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_INT_MSK {
	CRTC_INTERRUPT_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_INT_MSK_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_INT_MSK_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_INT_MSK;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_INT_TYPE {
	CRTC_INTERRUPT_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_INT_TYPE_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_INT_TYPE_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_FORCE_VSYNC_NEXT_LINE_INT_TYPE;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_TRIGA_INT_MSK {
	CRTC_INTERRUPT_CONTROL_CRTC_TRIGA_INT_MSK_FALSE  = 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_TRIGA_INT_MSK_TRUE   = 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_TRIGA_INT_MSK;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_TRIGA_INT_TYPE {
	CRTC_INTERRUPT_CONTROL_CRTC_TRIGA_INT_TYPE_FALSE = 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_TRIGA_INT_TYPE_TRUE  = 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_TRIGA_INT_TYPE;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_TRIGB_INT_MSK {
	CRTC_INTERRUPT_CONTROL_CRTC_TRIGB_INT_MSK_FALSE  = 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_TRIGB_INT_MSK_TRUE   = 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_TRIGB_INT_MSK;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_TRIGB_INT_TYPE {
	CRTC_INTERRUPT_CONTROL_CRTC_TRIGB_INT_TYPE_FALSE = 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_TRIGB_INT_TYPE_TRUE  = 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_TRIGB_INT_TYPE;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_VSYNC_NOM_INT_MSK {
	CRTC_INTERRUPT_CONTROL_CRTC_VSYNC_NOM_INT_MSK_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_VSYNC_NOM_INT_MSK_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_VSYNC_NOM_INT_MSK;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_VSYNC_NOM_INT_TYPE {
	CRTC_INTERRUPT_CONTROL_CRTC_VSYNC_NOM_INT_TYPE_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_VSYNC_NOM_INT_TYPE_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_VSYNC_NOM_INT_TYPE;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_GSL_VSYNC_GAP_INT_MSK {
	CRTC_INTERRUPT_CONTROL_CRTC_GSL_VSYNC_GAP_INT_MSK_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_GSL_VSYNC_GAP_INT_MSK_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_GSL_VSYNC_GAP_INT_MSK;
typedef enum CRTC_INTERRUPT_CONTROL_CRTC_GSL_VSYNC_GAP_INT_TYPE {
	CRTC_INTERRUPT_CONTROL_CRTC_GSL_VSYNC_GAP_INT_TYPE_FALSE= 0x0,
	CRTC_INTERRUPT_CONTROL_CRTC_GSL_VSYNC_GAP_INT_TYPE_TRUE= 0x1,
} CRTC_INTERRUPT_CONTROL_CRTC_GSL_VSYNC_GAP_INT_TYPE;
typedef enum CRTC_UPDATE_LOCK_CRTC_UPDATE_LOCK {
	CRTC_UPDATE_LOCK_CRTC_UPDATE_LOCK_FALSE          = 0x0,
	CRTC_UPDATE_LOCK_CRTC_UPDATE_LOCK_TRUE           = 0x1,
} CRTC_UPDATE_LOCK_CRTC_UPDATE_LOCK;
typedef enum CRTC_DOUBLE_BUFFER_CONTROL_CRTC_UPDATE_INSTANTLY {
	CRTC_DOUBLE_BUFFER_CONTROL_CRTC_UPDATE_INSTANTLY_FALSE= 0x0,
	CRTC_DOUBLE_BUFFER_CONTROL_CRTC_UPDATE_INSTANTLY_TRUE= 0x1,
} CRTC_DOUBLE_BUFFER_CONTROL_CRTC_UPDATE_INSTANTLY;
typedef enum CRTC_DOUBLE_BUFFER_CONTROL_CRTC_BLANK_DATA_DOUBLE_BUFFER_EN {
	CRTC_DOUBLE_BUFFER_CONTROL_CRTC_BLANK_DATA_DOUBLE_BUFFER_EN_FALSE= 0x0,
	CRTC_DOUBLE_BUFFER_CONTROL_CRTC_BLANK_DATA_DOUBLE_BUFFER_EN_TRUE= 0x1,
} CRTC_DOUBLE_BUFFER_CONTROL_CRTC_BLANK_DATA_DOUBLE_BUFFER_EN;
typedef enum CRTC_VGA_PARAMETER_CAPTURE_MODE_CRTC_VGA_PARAMETER_CAPTURE_MODE {
	CRTC_VGA_PARAMETER_CAPTURE_MODE_CRTC_VGA_PARAMETER_CAPTURE_MODE_FALSE= 0x0,
	CRTC_VGA_PARAMETER_CAPTURE_MODE_CRTC_VGA_PARAMETER_CAPTURE_MODE_TRUE= 0x1,
} CRTC_VGA_PARAMETER_CAPTURE_MODE_CRTC_VGA_PARAMETER_CAPTURE_MODE;
typedef enum CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_EN {
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_EN_FALSE= 0x0,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_EN_TRUE= 0x1,
} CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_EN;
typedef enum CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE {
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE_RGB= 0x0,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE_YCBCR601= 0x1,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE_YCBCR709= 0x2,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE_VBARS= 0x3,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE_HBARS= 0x4,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE_SRRGB= 0x5,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE_DRRGB= 0x6,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE_XRBIAS= 0x7,
} CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_MODE;
typedef enum CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_DYNAMIC_RANGE {
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_DYNAMIC_RANGE_FALSE= 0x0,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_DYNAMIC_RANGE_TRUE= 0x1,
} CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_DYNAMIC_RANGE;
typedef enum CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_COLOR_FORMAT {
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_COLOR_FORMAT_6BPC= 0x0,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_COLOR_FORMAT_8BPC= 0x1,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_COLOR_FORMAT_10BPC= 0x2,
	CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_COLOR_FORMAT_RESERVED= 0x3,
} CRTC_TEST_PATTERN_CONTROL_CRTC_TEST_PATTERN_COLOR_FORMAT;
typedef enum MASTER_UPDATE_LOCK_MASTER_UPDATE_LOCK {
	MASTER_UPDATE_LOCK_MASTER_UPDATE_LOCK_FALSE      = 0x0,
	MASTER_UPDATE_LOCK_MASTER_UPDATE_LOCK_TRUE       = 0x1,
} MASTER_UPDATE_LOCK_MASTER_UPDATE_LOCK;
typedef enum MASTER_UPDATE_LOCK_GSL_CONTROL_MASTER_UPDATE_LOCK {
	MASTER_UPDATE_LOCK_GSL_CONTROL_MASTER_UPDATE_LOCK_FALSE= 0x0,
	MASTER_UPDATE_LOCK_GSL_CONTROL_MASTER_UPDATE_LOCK_TRUE= 0x1,
} MASTER_UPDATE_LOCK_GSL_CONTROL_MASTER_UPDATE_LOCK;
typedef enum MASTER_UPDATE_LOCK_UNDERFLOW_UPDATE_LOCK {
	MASTER_UPDATE_LOCK_UNDERFLOW_UPDATE_LOCK_FALSE   = 0x0,
	MASTER_UPDATE_LOCK_UNDERFLOW_UPDATE_LOCK_TRUE    = 0x1,
} MASTER_UPDATE_LOCK_UNDERFLOW_UPDATE_LOCK;
typedef enum MASTER_UPDATE_MODE_MASTER_UPDATE_MODE {
	MASTER_UPDATE_MODE_MASTER_UPDATE_MODE_BETWEEN    = 0x0,
	MASTER_UPDATE_MODE_MASTER_UPDATE_MODE_HSYNCA     = 0x1,
	MASTER_UPDATE_MODE_MASTER_UPDATE_MODE_VSYNCA     = 0x2,
	MASTER_UPDATE_MODE_MASTER_UPDATE_MODE_BEFORE     = 0x3,
} MASTER_UPDATE_MODE_MASTER_UPDATE_MODE;
typedef enum MASTER_UPDATE_MODE_MASTER_UPDATE_INTERLACED_MODE {
	MASTER_UPDATE_MODE_MASTER_UPDATE_INTERLACED_MODE_BOTH= 0x0,
	MASTER_UPDATE_MODE_MASTER_UPDATE_INTERLACED_MODE_EVEN= 0x1,
	MASTER_UPDATE_MODE_MASTER_UPDATE_INTERLACED_MODE_ODD= 0x2,
	MASTER_UPDATE_MODE_MASTER_UPDATE_INTERLACED_MODE_RESERVED= 0x3,
} MASTER_UPDATE_MODE_MASTER_UPDATE_INTERLACED_MODE;
typedef enum CRTC_MVP_INBAND_CNTL_INSERT_CRTC_MVP_INBAND_OUT_MODE {
	CRTC_MVP_INBAND_CNTL_INSERT_CRTC_MVP_INBAND_OUT_MODE_DISABLE= 0x0,
	CRTC_MVP_INBAND_CNTL_INSERT_CRTC_MVP_INBAND_OUT_MODE_DEBUG= 0x1,
	CRTC_MVP_INBAND_CNTL_INSERT_CRTC_MVP_INBAND_OUT_MODE_NORMAL= 0x2,
} CRTC_MVP_INBAND_CNTL_INSERT_CRTC_MVP_INBAND_OUT_MODE;
typedef enum CRTC_MVP_STATUS_CRTC_FLIP_NOW_CLEAR {
	CRTC_MVP_STATUS_CRTC_FLIP_NOW_CLEAR_FALSE        = 0x0,
	CRTC_MVP_STATUS_CRTC_FLIP_NOW_CLEAR_TRUE         = 0x1,
} CRTC_MVP_STATUS_CRTC_FLIP_NOW_CLEAR;
typedef enum CRTC_MVP_STATUS_CRTC_AFR_HSYNC_SWITCH_DONE_CLEAR {
	CRTC_MVP_STATUS_CRTC_AFR_HSYNC_SWITCH_DONE_CLEAR_FALSE= 0x0,
	CRTC_MVP_STATUS_CRTC_AFR_HSYNC_SWITCH_DONE_CLEAR_TRUE= 0x1,
} CRTC_MVP_STATUS_CRTC_AFR_HSYNC_SWITCH_DONE_CLEAR;
typedef enum CRTC_V_UPDATE_INT_STATUS_CRTC_V_UPDATE_INT_CLEAR {
	CRTC_V_UPDATE_INT_STATUS_CRTC_V_UPDATE_INT_CLEAR_FALSE= 0x0,
	CRTC_V_UPDATE_INT_STATUS_CRTC_V_UPDATE_INT_CLEAR_TRUE= 0x1,
} CRTC_V_UPDATE_INT_STATUS_CRTC_V_UPDATE_INT_CLEAR;
typedef enum CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_OUTPUT_POLARITY {
	CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_OUTPUT_POLARITY_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_OUTPUT_POLARITY_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_OUTPUT_POLARITY;
typedef enum CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_INT_ENABLE {
	CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_INT_ENABLE_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_INT_ENABLE_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_INT_ENABLE;
typedef enum CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_CLEAR {
	CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_CLEAR_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_CLEAR_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_CLEAR;
typedef enum CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_INT_TYPE {
	CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_INT_TYPE_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_INT_TYPE_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT0_CONTROL_CRTC_VERTICAL_INTERRUPT0_INT_TYPE;
typedef enum CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_CLEAR {
	CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_CLEAR_CLEAR_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_CLEAR_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_CLEAR;
typedef enum CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_INT_ENABLE {
	CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_INT_ENABLE_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_INT_ENABLE_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_INT_ENABLE;
typedef enum CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_INT_TYPE {
	CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_INT_TYPE_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_INT_TYPE_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT1_CONTROL_CRTC_VERTICAL_INTERRUPT1_INT_TYPE;
typedef enum CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_CLEAR {
	CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_CLEAR_CLEAR_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_CLEAR_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_CLEAR;
typedef enum CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_INT_ENABLE {
	CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_INT_ENABLE_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_INT_ENABLE_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_INT_ENABLE;
typedef enum CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_INT_TYPE {
	CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_INT_TYPE_FALSE= 0x0,
	CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_INT_TYPE_TRUE= 0x1,
} CRTC_VERTICAL_INTERRUPT2_CONTROL_CRTC_VERTICAL_INTERRUPT2_INT_TYPE;
typedef enum CRTC_CRC_CNTL_CRTC_CRC_EN {
	CRTC_CRC_CNTL_CRTC_CRC_EN_FALSE                  = 0x0,
	CRTC_CRC_CNTL_CRTC_CRC_EN_TRUE                   = 0x1,
} CRTC_CRC_CNTL_CRTC_CRC_EN;
typedef enum CRTC_CRC_CNTL_CRTC_CRC_CONT_EN {
	CRTC_CRC_CNTL_CRTC_CRC_CONT_EN_FALSE             = 0x0,
	CRTC_CRC_CNTL_CRTC_CRC_CONT_EN_TRUE              = 0x1,
} CRTC_CRC_CNTL_CRTC_CRC_CONT_EN;
typedef enum CRTC_CRC_CNTL_CRTC_CRC_STEREO_MODE {
	CRTC_CRC_CNTL_CRTC_CRC_STEREO_MODE_LEFT          = 0x0,
	CRTC_CRC_CNTL_CRTC_CRC_STEREO_MODE_RIGHT         = 0x1,
	CRTC_CRC_CNTL_CRTC_CRC_STEREO_MODE_BOTH_EYES     = 0x2,
	CRTC_CRC_CNTL_CRTC_CRC_STEREO_MODE_BOTH_FIELDS   = 0x3,
} CRTC_CRC_CNTL_CRTC_CRC_STEREO_MODE;
typedef enum CRTC_CRC_CNTL_CRTC_CRC_INTERLACE_MODE {
	CRTC_CRC_CNTL_CRTC_CRC_INTERLACE_MODE_TOP        = 0x0,
	CRTC_CRC_CNTL_CRTC_CRC_INTERLACE_MODE_BOTTOM     = 0x1,
	CRTC_CRC_CNTL_CRTC_CRC_INTERLACE_MODE_BOTH_BOTTOM= 0x2,
	CRTC_CRC_CNTL_CRTC_CRC_INTERLACE_MODE_BOTH_FIELD = 0x3,
} CRTC_CRC_CNTL_CRTC_CRC_INTERLACE_MODE;
typedef enum CRTC_CRC_CNTL_CRTC_CRC_USE_NEW_AND_REPEATED_PIXELS {
	CRTC_CRC_CNTL_CRTC_CRC_USE_NEW_AND_REPEATED_PIXELS_FALSE= 0x0,
	CRTC_CRC_CNTL_CRTC_CRC_USE_NEW_AND_REPEATED_PIXELS_TRUE= 0x1,
} CRTC_CRC_CNTL_CRTC_CRC_USE_NEW_AND_REPEATED_PIXELS;
typedef enum CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT {
	CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT_UAB          = 0x0,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT_UA_B         = 0x1,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT_U_AB         = 0x2,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT_U_A_B        = 0x3,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT_IAB          = 0x4,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT_IA_B         = 0x5,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT_I_AB         = 0x6,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT_I_A_B        = 0x7,
} CRTC_CRC_CNTL_CRTC_CRTC_CRC0_SELECT;
typedef enum CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT {
	CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT_UAB          = 0x0,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT_UA_B         = 0x1,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT_U_AB         = 0x2,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT_U_A_B        = 0x3,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT_IAB          = 0x4,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT_IA_B         = 0x5,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT_I_AB         = 0x6,
	CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT_I_A_B        = 0x7,
} CRTC_CRC_CNTL_CRTC_CRTC_CRC1_SELECT;
typedef enum CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_ENABLE {
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_ENABLE_DISABLE= 0x0,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_ENABLE_ONESHOT= 0x1,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_ENABLE_CONTINUOUS= 0x2,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_ENABLE_RESERVED= 0x3,
} CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_ENABLE;
typedef enum CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_HCOUNT_MODE_ENABLE {
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_HCOUNT_MODE_ENABLE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_HCOUNT_MODE_ENABLE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_HCOUNT_MODE_ENABLE;
typedef enum CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_ENABLE {
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_ENABLE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_ENABLE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_ENABLE;
typedef enum CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_WINDOW {
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_WINDOW_1pixel= 0x0,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_WINDOW_2pixel= 0x1,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_WINDOW_3pixel= 0x2,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_WINDOW_4pixel= 0x3,
} CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_JITTER_FILTERING_WINDOW;
typedef enum CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_WINDOW_ENABLE {
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_WINDOW_ENABLE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_WINDOW_ENABLE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_WINDOW_ENABLE;
typedef enum CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_WINDOW_UPDATE {
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_WINDOW_UPDATE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_WINDOW_UPDATE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_WINDOW_UPDATE;
typedef enum CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_VSYNC_POLARITY {
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_VSYNC_POLARITY_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_VSYNC_POLARITY_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_VSYNC_POLARITY;
typedef enum CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_HSYNC_POLARITY {
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_HSYNC_POLARITY_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_HSYNC_POLARITY_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_HSYNC_POLARITY;
typedef enum CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_INTERLACE_MODE {
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_INTERLACE_MODE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_INTERLACE_MODE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_CONTROL_CRTC_EXT_TIMING_SYNC_INTERLACE_MODE;
typedef enum CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_INT_ENABLE {
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_INT_ENABLE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_INT_ENABLE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_INT_ENABLE;
typedef enum CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_CLEAR {
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_CLEAR_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_CLEAR_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_CLEAR;
typedef enum CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_INT_TYPE {
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_INT_TYPE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_INT_TYPE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_INT_TYPE;
typedef enum CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT {
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT_1FRAME= 0x0,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT_2FRAME= 0x1,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT_4FRAME= 0x2,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT_8FRAME= 0x3,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT_16FRAME= 0x4,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT_32FRAME= 0x5,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT_64FRAME= 0x6,
	CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT_128FRAME= 0x7,
} CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_LOSS_FRAME_COUNT;
typedef enum CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_INT_ENABLE {
	CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_INT_ENABLE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_INT_ENABLE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_INT_ENABLE;
typedef enum CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_CLEAR {
	CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_CLEAR_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_CLEAR_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_CLEAR;
typedef enum CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_INT_TYPE {
	CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_INT_TYPE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_INT_TYPE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_INT_TYPE;
typedef enum CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_INT_ENABLE {
	CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_INT_ENABLE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_INT_ENABLE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_INT_ENABLE;
typedef enum CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_CLEAR {
	CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_CLEAR_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_CLEAR_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_CLEAR;
typedef enum CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_INT_TYPE {
	CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_INT_TYPE_FALSE= 0x0,
	CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_INT_TYPE_TRUE= 0x1,
} CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_CRTC_EXT_TIMING_SYNC_SIGNAL_INT_TYPE;
typedef enum CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_ENABLE {
	CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_ENABLE_FALSE= 0x0,
	CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_ENABLE_TRUE= 0x1,
} CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_ENABLE;
typedef enum CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_CLEAR {
	CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_CLEAR_FALSE= 0x0,
	CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_CLEAR_TRUE= 0x1,
} CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_CLEAR;
typedef enum CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_TYPE {
	CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_TYPE_FALSE= 0x0,
	CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_TYPE_TRUE= 0x1,
} CRTC_STATIC_SCREEN_CONTROL_CRTC_CPU_SS_INT_TYPE;
typedef enum CRTC_STATIC_SCREEN_CONTROL_CRTC_STATIC_SCREEN_OVERRIDE {
	CRTC_STATIC_SCREEN_CONTROL_CRTC_STATIC_SCREEN_OVERRIDE_FALSE= 0x0,
	CRTC_STATIC_SCREEN_CONTROL_CRTC_STATIC_SCREEN_OVERRIDE_TRUE= 0x1,
} CRTC_STATIC_SCREEN_CONTROL_CRTC_STATIC_SCREEN_OVERRIDE;
typedef enum CRTC_STATIC_SCREEN_CONTROL_CRTC_STATIC_SCREEN_OVERRIDE_VALUE {
	CRTC_STATIC_SCREEN_CONTROL_CRTC_STATIC_SCREEN_OVERRIDE_VALUE_OFF= 0x0,
	CRTC_STATIC_SCREEN_CONTROL_CRTC_STATIC_SCREEN_OVERRIDE_VALUE_ON= 0x1,
} CRTC_STATIC_SCREEN_CONTROL_CRTC_STATIC_SCREEN_OVERRIDE_VALUE;
typedef enum CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_EN {
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_EN_FALSE= 0x0,
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_EN_TRUE= 0x1,
} CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_EN;
typedef enum CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_EN_DB {
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_EN_DB_FALSE= 0x0,
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_EN_DB_TRUE= 0x1,
} CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_EN_DB;
typedef enum CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_V_UPDATE_MODE {
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_V_UPDATE_MODE_BLOCK_BOTH= 0x0,
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_V_UPDATE_MODE_BLOCK_INTERLACE= 0x1,
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_V_UPDATE_MODE_BLOCK_PROGRASSIVE= 0x2,
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_V_UPDATE_MODE_RESERVED= 0x3,
} CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_V_UPDATE_MODE;
typedef enum CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_STEREO_SEL_OVR {
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_STEREO_SEL_OVR_FALSE= 0x0,
	CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_STEREO_SEL_OVR_TRUE= 0x1,
} CRTC_3D_STRUCTURE_CONTROL_CRTC_3D_STRUCTURE_STEREO_SEL_OVR;
typedef enum CRTC_V_SYNC_A_POL {
	CRTC_V_SYNC_A_POL_HIGH                           = 0x0,
	CRTC_V_SYNC_A_POL_LOW                            = 0x1,
} CRTC_V_SYNC_A_POL;
typedef enum CRTC_H_SYNC_A_POL {
	CRTC_H_SYNC_A_POL_HIGH                           = 0x0,
	CRTC_H_SYNC_A_POL_LOW                            = 0x1,
} CRTC_H_SYNC_A_POL;
typedef enum CRTC_HORZ_REPETITION_COUNT {
	CRTC_HORZ_REPETITION_COUNT_0                     = 0x0,
	CRTC_HORZ_REPETITION_COUNT_1                     = 0x1,
	CRTC_HORZ_REPETITION_COUNT_2                     = 0x2,
	CRTC_HORZ_REPETITION_COUNT_3                     = 0x3,
	CRTC_HORZ_REPETITION_COUNT_4                     = 0x4,
	CRTC_HORZ_REPETITION_COUNT_5                     = 0x5,
	CRTC_HORZ_REPETITION_COUNT_6                     = 0x6,
	CRTC_HORZ_REPETITION_COUNT_7                     = 0x7,
	CRTC_HORZ_REPETITION_COUNT_8                     = 0x8,
	CRTC_HORZ_REPETITION_COUNT_9                     = 0x9,
	CRTC_HORZ_REPETITION_COUNT_10                    = 0xa,
	CRTC_HORZ_REPETITION_COUNT_11                    = 0xb,
	CRTC_HORZ_REPETITION_COUNT_12                    = 0xc,
	CRTC_HORZ_REPETITION_COUNT_13                    = 0xd,
	CRTC_HORZ_REPETITION_COUNT_14                    = 0xe,
	CRTC_HORZ_REPETITION_COUNT_15                    = 0xf,
} CRTC_HORZ_REPETITION_COUNT;
typedef enum PERFCOUNTER_CVALUE_SEL {
	PERFCOUNTER_CVALUE_SEL_47_0                      = 0x0,
	PERFCOUNTER_CVALUE_SEL_15_0                      = 0x1,
	PERFCOUNTER_CVALUE_SEL_31_16                     = 0x2,
	PERFCOUNTER_CVALUE_SEL_47_32                     = 0x3,
	PERFCOUNTER_CVALUE_SEL_11_0                      = 0x4,
	PERFCOUNTER_CVALUE_SEL_23_12                     = 0x5,
	PERFCOUNTER_CVALUE_SEL_35_24                     = 0x6,
	PERFCOUNTER_CVALUE_SEL_47_36                     = 0x7,
} PERFCOUNTER_CVALUE_SEL;
typedef enum PERFCOUNTER_INC_MODE {
	PERFCOUNTER_INC_MODE_MULTI_BIT                   = 0x0,
	PERFCOUNTER_INC_MODE_BOTH_EDGE                   = 0x1,
	PERFCOUNTER_INC_MODE_LSB                         = 0x2,
	PERFCOUNTER_INC_MODE_POS_EDGE                    = 0x3,
} PERFCOUNTER_INC_MODE;
typedef enum PERFCOUNTER_HW_CNTL_SEL {
	PERFCOUNTER_HW_CNTL_SEL_RUNEN                    = 0x0,
	PERFCOUNTER_HW_CNTL_SEL_CNTOFF                   = 0x1,
} PERFCOUNTER_HW_CNTL_SEL;
typedef enum PERFCOUNTER_RUNEN_MODE {
	PERFCOUNTER_RUNEN_MODE_LEVEL                     = 0x0,
	PERFCOUNTER_RUNEN_MODE_EDGE                      = 0x1,
} PERFCOUNTER_RUNEN_MODE;
typedef enum PERFCOUNTER_CNTOFF_START_DIS {
	PERFCOUNTER_CNTOFF_START_ENABLE                  = 0x0,
	PERFCOUNTER_CNTOFF_START_DISABLE                 = 0x1,
} PERFCOUNTER_CNTOFF_START_DIS;
typedef enum PERFCOUNTER_RESTART_EN {
	PERFCOUNTER_RESTART_DISABLE                      = 0x0,
	PERFCOUNTER_RESTART_ENABLE                       = 0x1,
} PERFCOUNTER_RESTART_EN;
typedef enum PERFCOUNTER_INT_EN {
	PERFCOUNTER_INT_DISABLE                          = 0x0,
	PERFCOUNTER_INT_ENABLE                           = 0x1,
} PERFCOUNTER_INT_EN;
typedef enum PERFCOUNTER_OFF_MASK {
	PERFCOUNTER_OFF_MASK_DISABLE                     = 0x0,
	PERFCOUNTER_OFF_MASK_ENABLE                      = 0x1,
} PERFCOUNTER_OFF_MASK;
typedef enum PERFCOUNTER_ACTIVE {
	PERFCOUNTER_IS_IDLE                              = 0x0,
	PERFCOUNTER_IS_ACTIVE                            = 0x1,
} PERFCOUNTER_ACTIVE;
typedef enum PERFCOUNTER_INT_TYPE {
	PERFCOUNTER_INT_TYPE_LEVEL                       = 0x0,
	PERFCOUNTER_INT_TYPE_PULSE                       = 0x1,
} PERFCOUNTER_INT_TYPE;
typedef enum PERFCOUNTER_COUNTED_VALUE_TYPE {
	PERFCOUNTER_COUNTED_VALUE_TYPE_ACC               = 0x0,
	PERFCOUNTER_COUNTED_VALUE_TYPE_MAX               = 0x1,
} PERFCOUNTER_COUNTED_VALUE_TYPE;
typedef enum PERFCOUNTER_CNTL_SEL {
	PERFCOUNTER_CNTL_SEL_0                           = 0x0,
	PERFCOUNTER_CNTL_SEL_1                           = 0x1,
	PERFCOUNTER_CNTL_SEL_2                           = 0x2,
	PERFCOUNTER_CNTL_SEL_3                           = 0x3,
	PERFCOUNTER_CNTL_SEL_4                           = 0x4,
	PERFCOUNTER_CNTL_SEL_5                           = 0x5,
	PERFCOUNTER_CNTL_SEL_6                           = 0x6,
	PERFCOUNTER_CNTL_SEL_7                           = 0x7,
} PERFCOUNTER_CNTL_SEL;
typedef enum PERFCOUNTER_CNT0_STATE {
	PERFCOUNTER_CNT0_STATE_RESET                     = 0x0,
	PERFCOUNTER_CNT0_STATE_START                     = 0x1,
	PERFCOUNTER_CNT0_STATE_FREEZE                    = 0x2,
	PERFCOUNTER_CNT0_STATE_HW                        = 0x3,
} PERFCOUNTER_CNT0_STATE;
typedef enum PERFCOUNTER_STATE_SEL0 {
	PERFCOUNTER_STATE_SEL0_GLOBAL                    = 0x0,
	PERFCOUNTER_STATE_SEL0_LOCAL                     = 0x1,
} PERFCOUNTER_STATE_SEL0;
typedef enum PERFCOUNTER_CNT1_STATE {
	PERFCOUNTER_CNT1_STATE_RESET                     = 0x0,
	PERFCOUNTER_CNT1_STATE_START                     = 0x1,
	PERFCOUNTER_CNT1_STATE_FREEZE                    = 0x2,
	PERFCOUNTER_CNT1_STATE_HW                        = 0x3,
} PERFCOUNTER_CNT1_STATE;
typedef enum PERFCOUNTER_STATE_SEL1 {
	PERFCOUNTER_STATE_SEL1_GLOBAL                    = 0x0,
	PERFCOUNTER_STATE_SEL1_LOCAL                     = 0x1,
} PERFCOUNTER_STATE_SEL1;
typedef enum PERFCOUNTER_CNT2_STATE {
	PERFCOUNTER_CNT2_STATE_RESET                     = 0x0,
	PERFCOUNTER_CNT2_STATE_START                     = 0x1,
	PERFCOUNTER_CNT2_STATE_FREEZE                    = 0x2,
	PERFCOUNTER_CNT2_STATE_HW                        = 0x3,
} PERFCOUNTER_CNT2_STATE;
typedef enum PERFCOUNTER_STATE_SEL2 {
	PERFCOUNTER_STATE_SEL2_GLOBAL                    = 0x0,
	PERFCOUNTER_STATE_SEL2_LOCAL                     = 0x1,
} PERFCOUNTER_STATE_SEL2;
typedef enum PERFCOUNTER_CNT3_STATE {
	PERFCOUNTER_CNT3_STATE_RESET                     = 0x0,
	PERFCOUNTER_CNT3_STATE_START                     = 0x1,
	PERFCOUNTER_CNT3_STATE_FREEZE                    = 0x2,
	PERFCOUNTER_CNT3_STATE_HW                        = 0x3,
} PERFCOUNTER_CNT3_STATE;
typedef enum PERFCOUNTER_STATE_SEL3 {
	PERFCOUNTER_STATE_SEL3_GLOBAL                    = 0x0,
	PERFCOUNTER_STATE_SEL3_LOCAL                     = 0x1,
} PERFCOUNTER_STATE_SEL3;
typedef enum PERFCOUNTER_CNT4_STATE {
	PERFCOUNTER_CNT4_STATE_RESET                     = 0x0,
	PERFCOUNTER_CNT4_STATE_START                     = 0x1,
	PERFCOUNTER_CNT4_STATE_FREEZE                    = 0x2,
	PERFCOUNTER_CNT4_STATE_HW                        = 0x3,
} PERFCOUNTER_CNT4_STATE;
typedef enum PERFCOUNTER_STATE_SEL4 {
	PERFCOUNTER_STATE_SEL4_GLOBAL                    = 0x0,
	PERFCOUNTER_STATE_SEL4_LOCAL                     = 0x1,
} PERFCOUNTER_STATE_SEL4;
typedef enum PERFCOUNTER_CNT5_STATE {
	PERFCOUNTER_CNT5_STATE_RESET                     = 0x0,
	PERFCOUNTER_CNT5_STATE_START                     = 0x1,
	PERFCOUNTER_CNT5_STATE_FREEZE                    = 0x2,
	PERFCOUNTER_CNT5_STATE_HW                        = 0x3,
} PERFCOUNTER_CNT5_STATE;
typedef enum PERFCOUNTER_STATE_SEL5 {
	PERFCOUNTER_STATE_SEL5_GLOBAL                    = 0x0,
	PERFCOUNTER_STATE_SEL5_LOCAL                     = 0x1,
} PERFCOUNTER_STATE_SEL5;
typedef enum PERFCOUNTER_CNT6_STATE {
	PERFCOUNTER_CNT6_STATE_RESET                     = 0x0,
	PERFCOUNTER_CNT6_STATE_START                     = 0x1,
	PERFCOUNTER_CNT6_STATE_FREEZE                    = 0x2,
	PERFCOUNTER_CNT6_STATE_HW                        = 0x3,
} PERFCOUNTER_CNT6_STATE;
typedef enum PERFCOUNTER_STATE_SEL6 {
	PERFCOUNTER_STATE_SEL6_GLOBAL                    = 0x0,
	PERFCOUNTER_STATE_SEL6_LOCAL                     = 0x1,
} PERFCOUNTER_STATE_SEL6;
typedef enum PERFCOUNTER_CNT7_STATE {
	PERFCOUNTER_CNT7_STATE_RESET                     = 0x0,
	PERFCOUNTER_CNT7_STATE_START                     = 0x1,
	PERFCOUNTER_CNT7_STATE_FREEZE                    = 0x2,
	PERFCOUNTER_CNT7_STATE_HW                        = 0x3,
} PERFCOUNTER_CNT7_STATE;
typedef enum PERFCOUNTER_STATE_SEL7 {
	PERFCOUNTER_STATE_SEL7_GLOBAL                    = 0x0,
	PERFCOUNTER_STATE_SEL7_LOCAL                     = 0x1,
} PERFCOUNTER_STATE_SEL7;
typedef enum PERFMON_STATE {
	PERFMON_STATE_RESET                              = 0x0,
	PERFMON_STATE_START                              = 0x1,
	PERFMON_STATE_FREEZE                             = 0x2,
	PERFMON_STATE_HW                                 = 0x3,
} PERFMON_STATE;
typedef enum PERFMON_CNTOFF_AND_OR {
	PERFMON_CNTOFF_OR                                = 0x0,
	PERFMON_CNTOFF_AND                               = 0x1,
} PERFMON_CNTOFF_AND_OR;
typedef enum PERFMON_CNTOFF_INT_EN {
	PERFMON_CNTOFF_INT_DISABLE                       = 0x0,
	PERFMON_CNTOFF_INT_ENABLE                        = 0x1,
} PERFMON_CNTOFF_INT_EN;
typedef enum PERFMON_CNTOFF_INT_TYPE {
	PERFMON_CNTOFF_INT_TYPE_LEVEL                    = 0x0,
	PERFMON_CNTOFF_INT_TYPE_PULSE                    = 0x1,
} PERFMON_CNTOFF_INT_TYPE;
typedef enum ENABLE {
	DISABLE_THE_FEATURE                              = 0x0,
	ENABLE_THE_FEATURE                               = 0x1,
} ENABLE;
typedef enum ENABLE_CLOCK {
	DISABLE_THE_CLOCK                                = 0x0,
	ENABLE_THE_CLOCK                                 = 0x1,
} ENABLE_CLOCK;
typedef enum FORCE_VBI {
	FORCE_VBI_LOW                                    = 0x0,
	FORCE_VBI_HIGH                                   = 0x1,
} FORCE_VBI;
typedef enum OVERRIDE_CGTT_SCLK {
	OVERRIDE_CGTT_SCLK_NOOP                          = 0x0,
	SET_OVERRIDE_CGTT_SCLK                           = 0x1,
} OVERRIDE_CGTT_SCLK;
typedef enum CLEAR_SMU_INTR {
	SMU_INTR_STATUS_NOOP                             = 0x0,
	SMU_INTR_STATUS_CLEAR                            = 0x1,
} CLEAR_SMU_INTR;
typedef enum STATIC_SCREEN_SMU_INTR {
	STATIC_SCREEN_SMU_INTR_NOOP                      = 0x0,
	SET_STATIC_SCREEN_SMU_INTR                       = 0x1,
} STATIC_SCREEN_SMU_INTR;
typedef enum JITTER_REMOVE_DISABLE {
	ENABLE_JITTER_REMOVAL                            = 0x0,
	DISABLE_JITTER_REMOVAL                           = 0x1,
} JITTER_REMOVE_DISABLE;
typedef enum DISABLE_CLOCK_GATING {
	CLOCK_GATING_ENABLED                             = 0x0,
	CLOCK_GATING_DISABLED                            = 0x1,
} DISABLE_CLOCK_GATING;
typedef enum DISABLE_CLOCK_GATING_IN_DCO {
	CLOCK_GATING_ENABLED_IN_DCO                      = 0x0,
	CLOCK_GATING_DISABLED_IN_DCO                     = 0x1,
} DISABLE_CLOCK_GATING_IN_DCO;
typedef enum DCCG_DEEP_COLOR_CNTL {
	DCCG_DEEP_COLOR_DTO_DISABLE                      = 0x0,
	DCCG_DEEP_COLOR_DTO_5_4_RATIO                    = 0x1,
	DCCG_DEEP_COLOR_DTO_3_2_RATIO                    = 0x2,
	DCCG_DEEP_COLOR_DTO_2_1_RATIO                    = 0x3,
} DCCG_DEEP_COLOR_CNTL;
typedef enum REFCLK_CLOCK_EN {
	REFCLK_CLOCK_EN_PCIE_REFCLK                      = 0x0,
	REFCLK_CLOCK_EN_ALLOW_SRC                        = 0x1,
} REFCLK_CLOCK_EN;
typedef enum REFCLK_SRC_SEL {
	REFCLK_SRC_SEL_XTALIN                            = 0x0,
	REFCLK_SRC_SEL_DISPPLL                           = 0x1,
} REFCLK_SRC_SEL;
typedef enum DPREFCLK_SRC_SEL {
	DPREFCLK_SRC_SEL_CK                              = 0x0,
	DPREFCLK_SRC_SEL_P0PLL                           = 0x1,
	DPREFCLK_SRC_SEL_P1PLL                           = 0x2,
	DPREFCLK_SRC_SEL_P2PLL                           = 0x3,
	DPREFCLK_SRC_SEL_P3PLL                           = 0x4,
} DPREFCLK_SRC_SEL;
typedef enum XTAL_REF_SEL {
	XTAL_REF_SEL_1X                                  = 0x0,
	XTAL_REF_SEL_2X                                  = 0x1,
} XTAL_REF_SEL;
typedef enum XTAL_REF_CLOCK_SOURCE_SEL {
	XTAL_REF_CLOCK_SOURCE_SEL_XTALIN                 = 0x0,
	XTAL_REF_CLOCK_SOURCE_SEL_PPLL                   = 0x1,
} XTAL_REF_CLOCK_SOURCE_SEL;
typedef enum MICROSECOND_TIME_BASE_CLOCK_SOURCE_SEL {
	MICROSECOND_TIME_BASE_CLOCK_IS_XTALIN            = 0x0,
	MICROSECOND_TIME_BASE_CLOCK_IS_PPLL_REFCLK       = 0x1,
} MICROSECOND_TIME_BASE_CLOCK_SOURCE_SEL;
typedef enum ALLOW_SR_ON_TRANS_REQ {
	ALLOW_SR_ON_TRANS_REQ_ENABLE                     = 0x0,
	ALLOW_SR_ON_TRANS_REQ_DISABLE                    = 0x1,
} ALLOW_SR_ON_TRANS_REQ;
typedef enum MILLISECOND_TIME_BASE_CLOCK_SOURCE_SEL {
	MILLISECOND_TIME_BASE_CLOCK_IS_XTALIN            = 0x0,
	MILLISECOND_TIME_BASE_CLOCK_IS_PPLL_REFCLK       = 0x1,
} MILLISECOND_TIME_BASE_CLOCK_SOURCE_SEL;
typedef enum PIPE_PIXEL_RATE_SOURCE {
	PIPE_PIXEL_RATE_SOURCE_P0PLL                     = 0x0,
	PIPE_PIXEL_RATE_SOURCE_P1PLL                     = 0x1,
	PIPE_PIXEL_RATE_SOURCE_P2PLL                     = 0x2,
} PIPE_PIXEL_RATE_SOURCE;
typedef enum PIPE_PHYPLL_PIXEL_RATE_SOURCE {
	PIPE_PHYPLL_PIXEL_RATE_SOURCE_UNIPHYA            = 0x0,
	PIPE_PHYPLL_PIXEL_RATE_SOURCE_UNIPHYB            = 0x1,
	PIPE_PHYPLL_PIXEL_RATE_SOURCE_UNIPHYC            = 0x2,
	PIPE_PHYPLL_PIXEL_RATE_SOURCE_UNIPHYD            = 0x3,
	PIPE_PHYPLL_PIXEL_RATE_SOURCE_UNIPHYE            = 0x4,
	PIPE_PHYPLL_PIXEL_RATE_SOURCE_UNIPHYF            = 0x5,
	PIPE_PHYPLL_PIXEL_RATE_SOURCE_UNIPHYG            = 0x6,
} PIPE_PHYPLL_PIXEL_RATE_SOURCE;
typedef enum PIPE_PIXEL_RATE_PLL_SOURCE {
	PIPE_PIXEL_RATE_PLL_SOURCE_PHYPLL                = 0x0,
	PIPE_PIXEL_RATE_PLL_SOURCE_DISPPLL               = 0x1,
} PIPE_PIXEL_RATE_PLL_SOURCE;
typedef enum DP_DTO_DS_DISABLE {
	DP_DTO_DESPREAD_DISABLE                          = 0x0,
	DP_DTO_DESPREAD_ENABLE                           = 0x1,
} DP_DTO_DS_DISABLE;
typedef enum CRTC_ADD_PIXEL {
	CRTC_ADD_PIXEL_NOOP                              = 0x0,
	CRTC_ADD_PIXEL_FORCE                             = 0x1,
} CRTC_ADD_PIXEL;
typedef enum CRTC_DROP_PIXEL {
	CRTC_DROP_PIXEL_NOOP                             = 0x0,
	CRTC_DROP_PIXEL_FORCE                            = 0x1,
} CRTC_DROP_PIXEL;
typedef enum SYMCLK_FE_FORCE_EN {
	SYMCLK_FE_FORCE_EN_DISABLE                       = 0x0,
	SYMCLK_FE_FORCE_EN_ENABLE                        = 0x1,
} SYMCLK_FE_FORCE_EN;
typedef enum SYMCLK_FE_FORCE_SRC {
	SYMCLK_FE_FORCE_SRC_UNIPHYA                      = 0x0,
	SYMCLK_FE_FORCE_SRC_UNIPHYB                      = 0x1,
	SYMCLK_FE_FORCE_SRC_UNIPHYC                      = 0x2,
	SYMCLK_FE_FORCE_SRC_UNIPHYD                      = 0x3,
	SYMCLK_FE_FORCE_SRC_UNIPHYE                      = 0x4,
	SYMCLK_FE_FORCE_SRC_UNIPHYF                      = 0x5,
	SYMCLK_FE_FORCE_SRC_UNIPHYG                      = 0x6,
} SYMCLK_FE_FORCE_SRC;
typedef enum DPDBG_CLK_FORCE_EN {
	DPDBG_CLK_FORCE_EN_DISABLE                       = 0x0,
	DPDBG_CLK_FORCE_EN_ENABLE                        = 0x1,
} DPDBG_CLK_FORCE_EN;
typedef enum DVOACLK_COARSE_SKEW_CNTL {
	DVOACLK_COARSE_SKEW_CNTL_NO_ADJUSTMENT           = 0x0,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_1_STEP            = 0x1,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_2_STEPS           = 0x2,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_3_STEPS           = 0x3,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_4_STEPS           = 0x4,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_5_STEPS           = 0x5,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_6_STEPS           = 0x6,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_7_STEPS           = 0x7,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_8_STEPS           = 0x8,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_9_STEPS           = 0x9,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_10_STEPS          = 0xa,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_11_STEPS          = 0xb,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_12_STEPS          = 0xc,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_13_STEPS          = 0xd,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_14_STEPS          = 0xe,
	DVOACLK_COARSE_SKEW_CNTL_DELAY_15_STEPS          = 0xf,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_1_STEP            = 0x10,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_2_STEPS           = 0x11,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_3_STEPS           = 0x12,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_4_STEPS           = 0x13,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_5_STEPS           = 0x14,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_6_STEPS           = 0x15,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_7_STEPS           = 0x16,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_8_STEPS           = 0x17,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_9_STEPS           = 0x18,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_10_STEPS          = 0x19,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_11_STEPS          = 0x1a,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_12_STEPS          = 0x1b,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_13_STEPS          = 0x1c,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_14_STEPS          = 0x1d,
	DVOACLK_COARSE_SKEW_CNTL_EARLY_15_STEPS          = 0x1e,
} DVOACLK_COARSE_SKEW_CNTL;
typedef enum DVOACLK_FINE_SKEW_CNTL {
	DVOACLK_FINE_SKEW_CNTL_NO_ADJUSTMENT             = 0x0,
	DVOACLK_FINE_SKEW_CNTL_DELAY_1_STEP              = 0x1,
	DVOACLK_FINE_SKEW_CNTL_DELAY_2_STEPS             = 0x2,
	DVOACLK_FINE_SKEW_CNTL_DELAY_3_STEPS             = 0x3,
	DVOACLK_FINE_SKEW_CNTL_EARLY_1_STEP              = 0x4,
	DVOACLK_FINE_SKEW_CNTL_EARLY_2_STEPS             = 0x5,
	DVOACLK_FINE_SKEW_CNTL_EARLY_3_STEPS             = 0x6,
	DVOACLK_FINE_SKEW_CNTL_EARLY_4_STEPS             = 0x7,
} DVOACLK_FINE_SKEW_CNTL;
typedef enum DVOACLKD_IN_PHASE {
	DVOACLKD_IN_OPPOSITE_PHASE_WITH_PCLK_DVO         = 0x0,
	DVOACLKD_IN_PHASE_WITH_PCLK_DVO                  = 0x1,
} DVOACLKD_IN_PHASE;
typedef enum DVOACLKC_IN_PHASE {
	DVOACLKC_IN_OPPOSITE_PHASE_WITH_PCLK_DVO         = 0x0,
	DVOACLKC_IN_PHASE_WITH_PCLK_DVO                  = 0x1,
} DVOACLKC_IN_PHASE;
typedef enum DVOACLKC_MVP_IN_PHASE {
	DVOACLKC_MVP_IN_OPPOSITE_PHASE_WITH_PCLK_DVO     = 0x0,
	DVOACLKC_MVP_IN_PHASE_WITH_PCLK_DVO              = 0x1,
} DVOACLKC_MVP_IN_PHASE;
typedef enum DVOACLKC_MVP_SKEW_PHASE_OVERRIDE {
	DVOACLKC_MVP_SKEW_PHASE_OVERRIDE_DISABLE         = 0x0,
	DVOACLKC_MVP_SKEW_PHASE_OVERRIDE_ENABLE          = 0x1,
} DVOACLKC_MVP_SKEW_PHASE_OVERRIDE;
typedef enum MVP_CLK_SRC_SEL {
	MVP_CLK_SRC_SEL_RSRV                             = 0x0,
	MVP_CLK_SRC_SEL_IO_1                             = 0x1,
	MVP_CLK_SRC_SEL_IO_2                             = 0x2,
	MVP_CLK_SRC_SEL_REFCLK                           = 0x3,
} MVP_CLK_SRC_SEL;
typedef enum DCCG_AUDIO_DTO0_SOURCE_SEL {
	DCCG_AUDIO_DTO0_SOURCE_SEL_CRTC0                 = 0x0,
	DCCG_AUDIO_DTO0_SOURCE_SEL_CRTC1                 = 0x1,
	DCCG_AUDIO_DTO0_SOURCE_SEL_CRTC2                 = 0x2,
	DCCG_AUDIO_DTO0_SOURCE_SEL_CRTC3                 = 0x3,
	DCCG_AUDIO_DTO0_SOURCE_SEL_CRTC4                 = 0x4,
	DCCG_AUDIO_DTO0_SOURCE_SEL_CRTC5                 = 0x5,
	DCCG_AUDIO_DTO0_SOURCE_SEL_RESERVED              = 0x6,
} DCCG_AUDIO_DTO0_SOURCE_SEL;
typedef enum DCCG_AUDIO_DTO_SEL {
	DCCG_AUDIO_DTO_SEL_AUDIO_DTO0                    = 0x0,
	DCCG_AUDIO_DTO_SEL_AUDIO_DTO1                    = 0x1,
	DCCG_AUDIO_DTO_SEL_NO_AUDIO_DTO                  = 0x2,
} DCCG_AUDIO_DTO_SEL;
typedef enum DCCG_AUDIO_DTO2_SOURCE_SEL {
	DCCG_AUDIO_DTO2_SOURCE_SEL_AMCLK0                = 0x0,
	DCCG_AUDIO_DTO2_SOURCE_SEL_AMCLK1                = 0x1,
} DCCG_AUDIO_DTO2_SOURCE_SEL;
typedef enum DCCG_AUDIO_DTO_USE_512FBR_DTO {
	DCCG_AUDIO_DTO_USE_128FBR_FOR_DP                 = 0x0,
	DCCG_AUDIO_DTO_USE_512FBR_FOR_DP                 = 0x1,
} DCCG_AUDIO_DTO_USE_512FBR_DTO;
typedef enum DCCG_DBG_EN {
	DCCG_DBG_EN_DISABLE                              = 0x0,
	DCCG_DBG_EN_ENABLE                               = 0x1,
} DCCG_DBG_EN;
typedef enum DCCG_DBG_BLOCK_SEL {
	DCCG_DBG_BLOCK_SEL_DCCG                          = 0x0,
	DCCG_DBG_BLOCK_SEL_PMON                          = 0x1,
	DCCG_DBG_BLOCK_SEL_PMON2                         = 0x2,
} DCCG_DBG_BLOCK_SEL;
typedef enum DCCG_DBG_CLOCK_SEL {
	DCCG_DBG_CLOCK_SEL_DISPCLK                       = 0x0,
	DCCG_DBG_CLOCK_SEL_SCLK                          = 0x1,
	DCCG_DBG_CLOCK_SEL_MVPCLK                        = 0x2,
	DCCG_DBG_CLOCK_SEL_DVOCLK                        = 0x3,
	DCCG_DBG_CLOCK_SEL_DACCLK                        = 0x4,
	DCCG_DBG_CLOCK_SEL_REFCLK                        = 0x5,
	DCCG_DBG_CLOCK_SEL_SYMCLKA                       = 0x6,
	DCCG_DBG_CLOCK_SEL_SYMCLKB                       = 0x7,
	DCCG_DBG_CLOCK_SEL_SYMCLKC                       = 0x8,
	DCCG_DBG_CLOCK_SEL_SYMCLKD                       = 0x9,
	DCCG_DBG_CLOCK_SEL_SYMCLKE                       = 0xa,
	DCCG_DBG_CLOCK_SEL_SYMCLKG                       = 0xb,
	DCCG_DBG_CLOCK_SEL_SYMCLKF                       = 0xc,
	DCCG_DBG_CLOCK_SEL_RSRV                          = 0xd,
	DCCG_DBG_CLOCK_SEL_AOMCLK0                       = 0xe,
	DCCG_DBG_CLOCK_SEL_AOMCLK1                       = 0xf,
	DCCG_DBG_CLOCK_SEL_AOMCLK2                       = 0x10,
	DCCG_DBG_CLOCK_SEL_DPREFCLK                      = 0x11,
	DCCG_DBG_CLOCK_SEL_UNB_DB_CLK                    = 0x12,
	DCCG_DBG_CLOCK_SEL_DSICLK                        = 0x13,
	DCCG_DBG_CLOCK_SEL_BYTECLK                       = 0x14,
	DCCG_DBG_CLOCK_SEL_ESCCLK                        = 0x15,
	DCCG_DBG_CLOCK_SEL_SYMCLKLPA                     = 0x16,
	DCCG_DBG_CLOCK_SEL_SYMCLKLPB                     = 0x17,
} DCCG_DBG_CLOCK_SEL;
typedef enum DCCG_DBG_OUT_BLOCK_SEL {
	DCCG_DBG_OUT_BLOCK_SEL_DCCG                      = 0x0,
	DCCG_DBG_OUT_BLOCK_SEL_DCO                       = 0x1,
	DCCG_DBG_OUT_BLOCK_SEL_DCIO                      = 0x2,
	DCCG_DBG_OUT_BLOCK_SEL_DSI                       = 0x3,
} DCCG_DBG_OUT_BLOCK_SEL;
typedef enum DISPCLK_FREQ_RAMP_DONE {
	DISPCLK_FREQ_RAMP_IN_PROGRESS                    = 0x0,
	DISPCLK_FREQ_RAMP_COMPLETED                      = 0x1,
} DISPCLK_FREQ_RAMP_DONE;
typedef enum DCCG_FIFO_ERRDET_RESET {
	DCCG_FIFO_ERRDET_RESET_NOOP                      = 0x0,
	DCCG_FIFO_ERRDET_RESET_FORCE                     = 0x1,
} DCCG_FIFO_ERRDET_RESET;
typedef enum DCCG_FIFO_ERRDET_STATE {
	DCCG_FIFO_ERRDET_STATE_DETECTION                 = 0x0,
	DCCG_FIFO_ERRDET_STATE_CALIBRATION               = 0x1,
} DCCG_FIFO_ERRDET_STATE;
typedef enum DCCG_FIFO_ERRDET_OVR_EN {
	DCCG_FIFO_ERRDET_OVR_DISABLE                     = 0x0,
	DCCG_FIFO_ERRDET_OVR_ENABLE                      = 0x1,
} DCCG_FIFO_ERRDET_OVR_EN;
typedef enum DISPCLK_CHG_FWD_CORR_DISABLE {
	DISPCLK_CHG_FWD_CORR_ENABLE_AT_BEGINNING         = 0x0,
	DISPCLK_CHG_FWD_CORR_DISABLE_AT_BEGINNING        = 0x1,
} DISPCLK_CHG_FWD_CORR_DISABLE;
typedef enum DC_MEM_GLOBAL_PWR_REQ_DIS {
	DC_MEM_GLOBAL_PWR_REQ_ENABLE                     = 0x0,
	DC_MEM_GLOBAL_PWR_REQ_DISABLE                    = 0x1,
} DC_MEM_GLOBAL_PWR_REQ_DIS;
typedef enum DCCG_PERF_RUN {
	DCCG_PERF_RUN_NOOP                               = 0x0,
	DCCG_PERF_RUN_START                              = 0x1,
} DCCG_PERF_RUN;
typedef enum DCCG_PERF_MODE_VSYNC {
	DCCG_PERF_MODE_VSYNC_NOOP                        = 0x0,
	DCCG_PERF_MODE_VSYNC_START                       = 0x1,
} DCCG_PERF_MODE_VSYNC;
typedef enum DCCG_PERF_MODE_HSYNC {
	DCCG_PERF_MODE_HSYNC_NOOP                        = 0x0,
	DCCG_PERF_MODE_HSYNC_START                       = 0x1,
} DCCG_PERF_MODE_HSYNC;
typedef enum DCCG_PERF_CRTC_SELECT {
	DCCG_PERF_SEL_CRTC0                              = 0x0,
	DCCG_PERF_SEL_CRTC1                              = 0x1,
	DCCG_PERF_SEL_CRTC2                              = 0x2,
	DCCG_PERF_SEL_CRTC3                              = 0x3,
	DCCG_PERF_SEL_CRTC4                              = 0x4,
	DCCG_PERF_SEL_CRTC5                              = 0x5,
} DCCG_PERF_CRTC_SELECT;
typedef enum CLOCK_BRANCH_SOFT_RESET {
	CLOCK_BRANCH_SOFT_RESET_NOOP                     = 0x0,
	CLOCK_BRANCH_SOFT_RESET_FORCE                    = 0x1,
} CLOCK_BRANCH_SOFT_RESET;
typedef enum PLL_CFG_IF_SOFT_RESET {
	PLL_CFG_IF_SOFT_RESET_NOOP                       = 0x0,
	PLL_CFG_IF_SOFT_RESET_FORCE                      = 0x1,
} PLL_CFG_IF_SOFT_RESET;
typedef enum DVO_ENABLE_RST {
	DVO_ENABLE_RST_DISABLE                           = 0x0,
	DVO_ENABLE_RST_ENABLE                            = 0x1,
} DVO_ENABLE_RST;
typedef enum LptNumBanks {
	LPT_NUM_BANKS_2BANK                              = 0x0,
	LPT_NUM_BANKS_4BANK                              = 0x1,
	LPT_NUM_BANKS_8BANK                              = 0x2,
	LPT_NUM_BANKS_16BANK                             = 0x3,
	LPT_NUM_BANKS_32BANK                             = 0x4,
} LptNumBanks;
typedef enum DCIO_DC_GENERICA_SEL {
	DCIO_GENERICA_SEL_DACA_STEREOSYNC                = 0x0,
	DCIO_GENERICA_SEL_STEREOSYNC                     = 0x1,
	DCIO_GENERICA_SEL_DACA_PIXCLK                    = 0x2,
	DCIO_GENERICA_SEL_DACB_PIXCLK                    = 0x3,
	DCIO_GENERICA_SEL_DVOA_CTL3                      = 0x4,
	DCIO_GENERICA_SEL_P1_PLLCLK                      = 0x5,
	DCIO_GENERICA_SEL_P2_PLLCLK                      = 0x6,
	DCIO_GENERICA_SEL_DVOA_STEREOSYNC                = 0x7,
	DCIO_GENERICA_SEL_DACA_FIELD_NUMBER              = 0x8,
	DCIO_GENERICA_SEL_DACB_FIELD_NUMBER              = 0x9,
	DCIO_GENERICA_SEL_GENERICA_DCCG                  = 0xa,
	DCIO_GENERICA_SEL_SYNCEN                         = 0xb,
	DCIO_GENERICA_SEL_GENERICA_SCG                   = 0xc,
	DCIO_GENERICA_SEL_RESERVED_VALUE13               = 0xd,
	DCIO_GENERICA_SEL_RESERVED_VALUE14               = 0xe,
	DCIO_GENERICA_SEL_RESERVED_VALUE15               = 0xf,
	DCIO_GENERICA_SEL_GENERICA_DPRX                  = 0x10,
	DCIO_GENERICA_SEL_GENERICB_DPRX                  = 0x11,
} DCIO_DC_GENERICA_SEL;
typedef enum DCIO_DC_GENERIC_UNIPHY_REFDIV_CLK_SEL {
	DCIO_UNIPHYA_TEST_REFDIV_CLK                     = 0x0,
	DCIO_UNIPHYB_TEST_REFDIV_CLK                     = 0x1,
	DCIO_UNIPHYC_TEST_REFDIV_CLK                     = 0x2,
	DCIO_UNIPHYD_TEST_REFDIV_CLK                     = 0x3,
	DCIO_UNIPHYE_TEST_REFDIV_CLK                     = 0x4,
	DCIO_UNIPHYF_TEST_REFDIV_CLK                     = 0x5,
	DCIO_UNIPHYG_TEST_REFDIV_CLK                     = 0x6,
	DCIO_UNIPHYLPA_TEST_REFDIV_CLK                   = 0x7,
	DCIO_UNIPHYLPB_TEST_REFDIV_CLK                   = 0x8,
} DCIO_DC_GENERIC_UNIPHY_REFDIV_CLK_SEL;
typedef enum DCIO_DC_GENERIC_UNIPHY_FBDIV_CLK_SEL {
	DCIO_UNIPHYA_FBDIV_CLK                           = 0x0,
	DCIO_UNIPHYB_FBDIV_CLK                           = 0x1,
	DCIO_UNIPHYC_FBDIV_CLK                           = 0x2,
	DCIO_UNIPHYD_FBDIV_CLK                           = 0x3,
	DCIO_UNIPHYE_FBDIV_CLK                           = 0x4,
	DCIO_UNIPHYF_FBDIV_CLK                           = 0x5,
	DCIO_UNIPHYG_FBDIV_CLK                           = 0x6,
	DCIO_UNIPHYLPA_FBDIV_CLK                         = 0x7,
	DCIO_UNIPHYLPB_FBDIV_CLK                         = 0x8,
} DCIO_DC_GENERIC_UNIPHY_FBDIV_CLK_SEL;
typedef enum DCIO_DC_GENERIC_UNIPHY_FBDIV_SSC_CLK_SEL {
	DCIO_UNIPHYA_FBDIV_SSC_CLK                       = 0x0,
	DCIO_UNIPHYB_FBDIV_SSC_CLK                       = 0x1,
	DCIO_UNIPHYC_FBDIV_SSC_CLK                       = 0x2,
	DCIO_UNIPHYD_FBDIV_SSC_CLK                       = 0x3,
	DCIO_UNIPHYE_FBDIV_SSC_CLK                       = 0x4,
	DCIO_UNIPHYF_FBDIV_SSC_CLK                       = 0x5,
	DCIO_UNIPHYG_FBDIV_SSC_CLK                       = 0x6,
	DCIO_UNIPHYLPA_FBDIV_SSC_CLK                     = 0x7,
	DCIO_UNIPHYLPB_FBDIV_SSC_CLK                     = 0x8,
} DCIO_DC_GENERIC_UNIPHY_FBDIV_SSC_CLK_SEL;
typedef enum DCIO_DC_GENERIC_UNIPHY_FBDIV_CLK_DIV2_SEL {
	DCIO_UNIPHYA_TEST_FBDIV_CLK_DIV2                 = 0x0,
	DCIO_UNIPHYB_TEST_FBDIV_CLK_DIV2                 = 0x1,
	DCIO_UNIPHYC_TEST_FBDIV_CLK_DIV2                 = 0x2,
	DCIO_UNIPHYD_TEST_FBDIV_CLK_DIV2                 = 0x3,
	DCIO_UNIPHYE_TEST_FBDIV_CLK_DIV2                 = 0x4,
	DCIO_UNIPHYF_TEST_FBDIV_CLK_DIV2                 = 0x5,
	DCIO_UNIPHYG_TEST_FBDIV_CLK_DIV2                 = 0x6,
	DCIO_UNIPHYLPA_TEST_FBDIV_CLK_DIV2               = 0x7,
	DCIO_UNIPHYLPB_TEST_FBDIV_CLK_DIV2               = 0x8,
} DCIO_DC_GENERIC_UNIPHY_FBDIV_CLK_DIV2_SEL;
typedef enum DCIO_DC_GENERICB_SEL {
	DCIO_GENERICB_SEL_DACA_STEREOSYNC                = 0x0,
	DCIO_GENERICB_SEL_STEREOSYNC                     = 0x1,
	DCIO_GENERICB_SEL_DACA_PIXCLK                    = 0x2,
	DCIO_GENERICB_SEL_DACB_PIXCLK                    = 0x3,
	DCIO_GENERICB_SEL_DVOA_CTL3                      = 0x4,
	DCIO_GENERICB_SEL_P1_PLLCLK                      = 0x5,
	DCIO_GENERICB_SEL_P2_PLLCLK                      = 0x6,
	DCIO_GENERICB_SEL_DVOA_STEREOSYNC                = 0x7,
	DCIO_GENERICB_SEL_DACA_FIELD_NUMBER              = 0x8,
	DCIO_GENERICB_SEL_DACB_FIELD_NUMBER              = 0x9,
	DCIO_GENERICB_SEL_GENERICB_DCCG                  = 0xa,
	DCIO_GENERICB_SEL_SYNCEN                         = 0xb,
	DCIO_GENERICB_SEL_GENERICA_SCG                   = 0xc,
	DCIO_GENERICB_SEL_RESERVED_VALUE13               = 0xd,
	DCIO_GENERICB_SEL_RESERVED_VALUE14               = 0xe,
	DCIO_GENERICB_SEL_RESERVED_VALUE15               = 0xf,
} DCIO_DC_GENERICB_SEL;
typedef enum DCIO_DC_PAD_EXTERN_SIG_SEL {
	DCIO_DC_PAD_EXTERN_SIG_SEL_MVP                   = 0x0,
	DCIO_DC_PAD_EXTERN_SIG_SEL_VSYNCA                = 0x1,
	DCIO_DC_PAD_EXTERN_SIG_SEL_GENLK_CLK             = 0x2,
	DCIO_DC_PAD_EXTERN_SIG_SEL_GENLK_VSYNC           = 0x3,
	DCIO_DC_PAD_EXTERN_SIG_SEL_GENERICA              = 0x4,
	DCIO_DC_PAD_EXTERN_SIG_SEL_GENERICB              = 0x5,
	DCIO_DC_PAD_EXTERN_SIG_SEL_GENERICC              = 0x6,
	DCIO_DC_PAD_EXTERN_SIG_SEL_HPD1                  = 0x7,
	DCIO_DC_PAD_EXTERN_SIG_SEL_HPD2                  = 0x8,
	DCIO_DC_PAD_EXTERN_SIG_SEL_DDC1CLK               = 0x9,
	DCIO_DC_PAD_EXTERN_SIG_SEL_DDC1DATA              = 0xa,
	DCIO_DC_PAD_EXTERN_SIG_SEL_DDC2CLK               = 0xb,
	DCIO_DC_PAD_EXTERN_SIG_SEL_DDC2DATA              = 0xc,
	DCIO_DC_PAD_EXTERN_SIG_SEL_VHAD1                 = 0xd,
	DCIO_DC_PAD_EXTERN_SIG_SEL_VHAD0                 = 0xe,
	DCIO_DC_PAD_EXTERN_SIG_SEL_VPHCTL                = 0xf,
} DCIO_DC_PAD_EXTERN_SIG_SEL;
typedef enum DCIO_DC_PAD_EXTERN_SIG_MVP_PIXEL_SRC_STATUS {
	DCIO_MVP_PIXEL_SRC_STATUS_HSYNCA                 = 0x0,
	DCIO_MVP_PIXEL_SRC_STATUS_HSYNCA_DUPLICATE       = 0x1,
	DCIO_MVP_PIXEL_SRC_STATUS_CRTC                   = 0x2,
	DCIO_MVP_PIXEL_SRC_STATUS_LB                     = 0x3,
} DCIO_DC_PAD_EXTERN_SIG_MVP_PIXEL_SRC_STATUS;
typedef enum DCIO_DC_REF_CLK_CNTL_HSYNCA_OUTPUT_SEL {
	DCIO_HSYNCA_OUTPUT_SEL_DISABLE                   = 0x0,
	DCIO_HSYNCA_OUTPUT_SEL_PPLL1                     = 0x1,
	DCIO_HSYNCA_OUTPUT_SEL_PPLL2                     = 0x2,
	DCIO_HSYNCA_OUTPUT_SEL_RESERVED                  = 0x3,
} DCIO_DC_REF_CLK_CNTL_HSYNCA_OUTPUT_SEL;
typedef enum DCIO_DC_REF_CLK_CNTL_GENLK_CLK_OUTPUT_SEL {
	DCIO_GENLK_CLK_OUTPUT_SEL_DISABLE                = 0x0,
	DCIO_GENLK_CLK_OUTPUT_SEL_PPLL1                  = 0x1,
	DCIO_GENLK_CLK_OUTPUT_SEL_PPLL2                  = 0x2,
	DCIO_GENLK_CLK_OUTPUT_SEL_RESERVED_VALUE3        = 0x3,
} DCIO_DC_REF_CLK_CNTL_GENLK_CLK_OUTPUT_SEL;
typedef enum DCIO_DC_GPIO_VIP_DEBUG {
	DCIO_DC_GPIO_VIP_DEBUG_NORMAL                    = 0x0,
	DCIO_DC_GPIO_VIP_DEBUG_CG_BIG                    = 0x1,
} DCIO_DC_GPIO_VIP_DEBUG;
typedef enum DCIO_DC_GPIO_MACRO_DEBUG {
	DCIO_DC_GPIO_MACRO_DEBUG_NORMAL                  = 0x0,
	DCIO_DC_GPIO_MACRO_DEBUG_CHIP_BIF                = 0x1,
	DCIO_DC_GPIO_MACRO_DEBUG_RESERVED_VALUE2         = 0x2,
	DCIO_DC_GPIO_MACRO_DEBUG_RESERVED_VALUE3         = 0x3,
} DCIO_DC_GPIO_MACRO_DEBUG;
typedef enum DCIO_DC_GPIO_CHIP_DEBUG_OUT_PIN_SEL {
	DCIO_DC_GPIO_CHIP_DEBUG_OUT_PIN_SEL_NORMAL       = 0x0,
	DCIO_DC_GPIO_CHIP_DEBUG_OUT_PIN_SEL_SWAP         = 0x1,
} DCIO_DC_GPIO_CHIP_DEBUG_OUT_PIN_SEL;
typedef enum DCIO_DC_GPIO_DEBUG_BUS_FLOP_EN {
	DCIO_DC_GPIO_DEBUG_BUS_FLOP_EN_BYPASS            = 0x0,
	DCIO_DC_GPIO_DEBUG_BUS_FLOP_EN_ENABLE            = 0x1,
} DCIO_DC_GPIO_DEBUG_BUS_FLOP_EN;
typedef enum DCIO_DC_GPIO_DEBUG_DPRX_LOOPBACK_ENABLE {
	DCIO_DPRX_LOOPBACK_ENABLE_NORMAL                 = 0x0,
	DCIO_DPRX_LOOPBACK_ENABLE_LOOP                   = 0x1,
} DCIO_DC_GPIO_DEBUG_DPRX_LOOPBACK_ENABLE;
typedef enum DCIO_UNIPHY_LINK_CNTL_MINIMUM_PIXVLD_LOW_DURATION {
	DCIO_UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_3_CLOCKS = 0x0,
	DCIO_UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_7_CLOCKS = 0x1,
	DCIO_UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_11_CLOCKS= 0x2,
	DCIO_UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_15_CLOCKS= 0x3,
	DCIO_UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_19_CLOCKS= 0x4,
	DCIO_UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_23_CLOCKS= 0x5,
	DCIO_UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_27_CLOCKS= 0x6,
	DCIO_UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_31_CLOCKS= 0x7,
} DCIO_UNIPHY_LINK_CNTL_MINIMUM_PIXVLD_LOW_DURATION;
typedef enum DCIO_UNIPHY_LINK_CNTL_CHANNEL_INVERT {
	DCIO_UNIPHY_CHANNEL_NO_INVERSION                 = 0x0,
	DCIO_UNIPHY_CHANNEL_INVERTED                     = 0x1,
} DCIO_UNIPHY_LINK_CNTL_CHANNEL_INVERT;
typedef enum DCIO_UNIPHY_LINK_CNTL_ENABLE_HPD_MASK {
	DCIO_UNIPHY_LINK_ENABLE_HPD_MASK_DISALLOW        = 0x0,
	DCIO_UNIPHY_LINK_ENABLE_HPD_MASK_ALLOW           = 0x1,
	DCIO_UNIPHY_LINK_ENABLE_HPD_MASK_ALLOW_DEBOUNCED = 0x2,
	DCIO_UNIPHY_LINK_ENABLE_HPD_MASK_ALLOW_TOGGLE_FILTERED= 0x3,
} DCIO_UNIPHY_LINK_CNTL_ENABLE_HPD_MASK;
typedef enum DCIO_UNIPHY_CHANNEL_XBAR_SOURCE {
	DCIO_UNIPHY_CHANNEL_XBAR_SOURCE_CH0              = 0x0,
	DCIO_UNIPHY_CHANNEL_XBAR_SOURCE_CH1              = 0x1,
	DCIO_UNIPHY_CHANNEL_XBAR_SOURCE_CH2              = 0x2,
	DCIO_UNIPHY_CHANNEL_XBAR_SOURCE_CH3              = 0x3,
} DCIO_UNIPHY_CHANNEL_XBAR_SOURCE;
typedef enum DCIO_DC_DVODATA_CONFIG_VIP_MUX_EN {
	DCIO_VIP_MUX_EN_DVO                              = 0x0,
	DCIO_VIP_MUX_EN_VIP                              = 0x1,
} DCIO_DC_DVODATA_CONFIG_VIP_MUX_EN;
typedef enum DCIO_DC_DVODATA_CONFIG_VIP_ALTER_MAPPING_EN {
	DCIO_VIP_ALTER_MAPPING_EN_DEFAULT                = 0x0,
	DCIO_VIP_ALTER_MAPPING_EN_ALTERNATIVE            = 0x1,
} DCIO_DC_DVODATA_CONFIG_VIP_ALTER_MAPPING_EN;
typedef enum DCIO_DC_DVODATA_CONFIG_DVO_ALTER_MAPPING_EN {
	DCIO_DVO_ALTER_MAPPING_EN_DEFAULT                = 0x0,
	DCIO_DVO_ALTER_MAPPING_EN_ALTERNATIVE            = 0x1,
} DCIO_DC_DVODATA_CONFIG_DVO_ALTER_MAPPING_EN;
typedef enum DCIO_LVTMA_PWRSEQ_CNTL_DISABLE_SYNCEN_CONTROL_OF_TX_EN {
	DCIO_LVTMA_PWRSEQ_DISABLE_SYNCEN_CONTROL_OF_TX_ENABLE= 0x0,
	DCIO_LVTMA_PWRSEQ_DISABLE_SYNCEN_CONTROL_OF_TX_DISABLE= 0x1,
} DCIO_LVTMA_PWRSEQ_CNTL_DISABLE_SYNCEN_CONTROL_OF_TX_EN;
typedef enum DCIO_LVTMA_PWRSEQ_CNTL_TARGET_STATE {
	DCIO_LVTMA_PWRSEQ_TARGET_STATE_LCD_OFF           = 0x0,
	DCIO_LVTMA_PWRSEQ_TARGET_STATE_LCD_ON            = 0x1,
} DCIO_LVTMA_PWRSEQ_CNTL_TARGET_STATE;
typedef enum DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_SYNCEN_POL {
	DCIO_LVTMA_SYNCEN_POL_NON_INVERT                 = 0x0,
	DCIO_LVTMA_SYNCEN_POL_INVERT                     = 0x1,
} DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_SYNCEN_POL;
typedef enum DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_DIGON {
	DCIO_LVTMA_DIGON_OFF                             = 0x0,
	DCIO_LVTMA_DIGON_ON                              = 0x1,
} DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_DIGON;
typedef enum DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_DIGON_POL {
	DCIO_LVTMA_DIGON_POL_NON_INVERT                  = 0x0,
	DCIO_LVTMA_DIGON_POL_INVERT                      = 0x1,
} DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_DIGON_POL;
typedef enum DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_BLON {
	DCIO_LVTMA_BLON_OFF                              = 0x0,
	DCIO_LVTMA_BLON_ON                               = 0x1,
} DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_BLON;
typedef enum DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_BLON_POL {
	DCIO_LVTMA_BLON_POL_NON_INVERT                   = 0x0,
	DCIO_LVTMA_BLON_POL_INVERT                       = 0x1,
} DCIO_LVTMA_PWRSEQ_CNTL_LVTMA_BLON_POL;
typedef enum DCIO_LVTMA_PWRSEQ_DELAY2_LVTMA_VARY_BL_OVERRIDE_EN {
	DCIO_LVTMA_VARY_BL_OVERRIDE_EN_BLON              = 0x0,
	DCIO_LVTMA_VARY_BL_OVERRIDE_EN_SEPARATE          = 0x1,
} DCIO_LVTMA_PWRSEQ_DELAY2_LVTMA_VARY_BL_OVERRIDE_EN;
typedef enum DCIO_BL_PWM_CNTL_BL_PWM_FRACTIONAL_EN {
	DCIO_BL_PWM_FRACTIONAL_DISABLE                   = 0x0,
	DCIO_BL_PWM_FRACTIONAL_ENABLE                    = 0x1,
} DCIO_BL_PWM_CNTL_BL_PWM_FRACTIONAL_EN;
typedef enum DCIO_BL_PWM_CNTL_BL_PWM_EN {
	DCIO_BL_PWM_DISABLE                              = 0x0,
	DCIO_BL_PWM_ENABLE                               = 0x1,
} DCIO_BL_PWM_CNTL_BL_PWM_EN;
typedef enum DCIO_BL_PWM_CNTL2_DBG_BL_PWM_INPUT_REFCLK_SELECT {
	DCIO_DBG_BL_PWM_INPUT_REFCLK_SELECT_NORMAL       = 0x0,
	DCIO_DBG_BL_PWM_INPUT_REFCLK_SELECT_DEBUG1       = 0x1,
	DCIO_DBG_BL_PWM_INPUT_REFCLK_SELECT_DEBUG2       = 0x2,
	DCIO_DBG_BL_PWM_INPUT_REFCLK_SELECT_DEBUG3       = 0x3,
} DCIO_BL_PWM_CNTL2_DBG_BL_PWM_INPUT_REFCLK_SELECT;
typedef enum DCIO_BL_PWM_CNTL2_BL_PWM_OVERRIDE_BL_OUT_ENABLE {
	DCIO_BL_PWM_OVERRIDE_BL_OUT_DISABLE              = 0x0,
	DCIO_BL_PWM_OVERRIDE_BL_OUT_ENABLE               = 0x1,
} DCIO_BL_PWM_CNTL2_BL_PWM_OVERRIDE_BL_OUT_ENABLE;
typedef enum DCIO_BL_PWM_CNTL2_BL_PWM_OVERRIDE_LVTMA_PWRSEQ_EN {
	DCIO_BL_PWM_OVERRIDE_LVTMA_PWRSEQ_EN_NORMAL      = 0x0,
	DCIO_BL_PWM_OVERRIDE_LVTMA_PWRSEQ_EN_PWM         = 0x1,
} DCIO_BL_PWM_CNTL2_BL_PWM_OVERRIDE_LVTMA_PWRSEQ_EN;
typedef enum DCIO_BL_PWM_GRP1_REG_LOCK {
	DCIO_BL_PWM_GRP1_REG_LOCK_DISABLE                = 0x0,
	DCIO_BL_PWM_GRP1_REG_LOCK_ENABLE                 = 0x1,
} DCIO_BL_PWM_GRP1_REG_LOCK;
typedef enum DCIO_BL_PWM_GRP1_UPDATE_AT_FRAME_START {
	DCIO_BL_PWM_GRP1_UPDATE_AT_FRAME_START_DISABLE   = 0x0,
	DCIO_BL_PWM_GRP1_UPDATE_AT_FRAME_START_ENABLE    = 0x1,
} DCIO_BL_PWM_GRP1_UPDATE_AT_FRAME_START;
typedef enum DCIO_BL_PWM_GRP1_FRAME_START_DISP_SEL {
	DCIO_BL_PWM_GRP1_FRAME_START_DISP_SEL_CONTROLLER1= 0x0,
	DCIO_BL_PWM_GRP1_FRAME_START_DISP_SEL_CONTROLLER2= 0x1,
	DCIO_BL_PWM_GRP1_FRAME_START_DISP_SEL_CONTROLLER3= 0x2,
	DCIO_BL_PWM_GRP1_FRAME_START_DISP_SEL_CONTROLLER4= 0x3,
	DCIO_BL_PWM_GRP1_FRAME_START_DISP_SEL_CONTROLLER5= 0x4,
	DCIO_BL_PWM_GRP1_FRAME_START_DISP_SEL_CONTROLLER6= 0x5,
} DCIO_BL_PWM_GRP1_FRAME_START_DISP_SEL;
typedef enum DCIO_BL_PWM_GRP1_READBACK_DB_REG_VALUE_EN {
	DCIO_BL_PWM_GRP1_READBACK_DB_REG_VALUE_EN_BL_PWM = 0x0,
	DCIO_BL_PWM_GRP1_READBACK_DB_REG_VALUE_EN_BL1_PWM= 0x1,
} DCIO_BL_PWM_GRP1_READBACK_DB_REG_VALUE_EN;
typedef enum DCIO_BL_PWM_GRP1_IGNORE_MASTER_LOCK_EN {
	DCIO_BL_PWM_GRP1_IGNORE_MASTER_LOCK_ENABLE       = 0x0,
	DCIO_BL_PWM_GRP1_IGNORE_MASTER_LOCK_DISABLE      = 0x1,
} DCIO_BL_PWM_GRP1_IGNORE_MASTER_LOCK_EN;
typedef enum DCIO_GSL_SEL {
	DCIO_GSL_SEL_GROUP_0                             = 0x0,
	DCIO_GSL_SEL_GROUP_1                             = 0x1,
	DCIO_GSL_SEL_GROUP_2                             = 0x2,
} DCIO_GSL_SEL;
typedef enum DCIO_GENLK_CLK_GSL_MASK {
	DCIO_GENLK_CLK_GSL_MASK_NO                       = 0x0,
	DCIO_GENLK_CLK_GSL_MASK_TIMING                   = 0x1,
	DCIO_GENLK_CLK_GSL_MASK_STEREO                   = 0x2,
} DCIO_GENLK_CLK_GSL_MASK;
typedef enum DCIO_GENLK_VSYNC_GSL_MASK {
	DCIO_GENLK_VSYNC_GSL_MASK_NO                     = 0x0,
	DCIO_GENLK_VSYNC_GSL_MASK_TIMING                 = 0x1,
	DCIO_GENLK_VSYNC_GSL_MASK_STEREO                 = 0x2,
} DCIO_GENLK_VSYNC_GSL_MASK;
typedef enum DCIO_SWAPLOCK_A_GSL_MASK {
	DCIO_SWAPLOCK_A_GSL_MASK_NO                      = 0x0,
	DCIO_SWAPLOCK_A_GSL_MASK_TIMING                  = 0x1,
	DCIO_SWAPLOCK_A_GSL_MASK_STEREO                  = 0x2,
} DCIO_SWAPLOCK_A_GSL_MASK;
typedef enum DCIO_SWAPLOCK_B_GSL_MASK {
	DCIO_SWAPLOCK_B_GSL_MASK_NO                      = 0x0,
	DCIO_SWAPLOCK_B_GSL_MASK_TIMING                  = 0x1,
	DCIO_SWAPLOCK_B_GSL_MASK_STEREO                  = 0x2,
} DCIO_SWAPLOCK_B_GSL_MASK;
typedef enum DCIO_GSL_VSYNC_SEL {
	DCIO_GSL_VSYNC_SEL_PIPE0                         = 0x0,
	DCIO_GSL_VSYNC_SEL_PIPE1                         = 0x1,
	DCIO_GSL_VSYNC_SEL_PIPE2                         = 0x2,
	DCIO_GSL_VSYNC_SEL_PIPE3                         = 0x3,
	DCIO_GSL_VSYNC_SEL_PIPE4                         = 0x4,
	DCIO_GSL_VSYNC_SEL_PIPE5                         = 0x5,
} DCIO_GSL_VSYNC_SEL;
typedef enum DCIO_GSL0_TIMING_SYNC_SEL {
	DCIO_GSL0_TIMING_SYNC_SEL_PIPE                   = 0x0,
	DCIO_GSL0_TIMING_SYNC_SEL_GENCLK_VSYNC           = 0x1,
	DCIO_GSL0_TIMING_SYNC_SEL_GENCLK_CLK             = 0x2,
	DCIO_GSL0_TIMING_SYNC_SEL_SWAPLOCK_A             = 0x3,
	DCIO_GSL0_TIMING_SYNC_SEL_SWAPLOCK_B             = 0x4,
} DCIO_GSL0_TIMING_SYNC_SEL;
typedef enum DCIO_GSL0_GLOBAL_UNLOCK_SEL {
	DCIO_GSL0_GLOBAL_UNLOCK_SEL_INVERSION            = 0x0,
	DCIO_GSL0_GLOBAL_UNLOCK_SEL_GENCLK_VSYNC         = 0x1,
	DCIO_GSL0_GLOBAL_UNLOCK_SEL_GENLK_CLK            = 0x2,
	DCIO_GSL0_GLOBAL_UNLOCK_SEL_SWAPLOCK_A           = 0x3,
	DCIO_GSL0_GLOBAL_UNLOCK_SEL_SWAPLOCK_B           = 0x4,
} DCIO_GSL0_GLOBAL_UNLOCK_SEL;
typedef enum DCIO_GSL1_TIMING_SYNC_SEL {
	DCIO_GSL1_TIMING_SYNC_SEL_PIPE                   = 0x0,
	DCIO_GSL1_TIMING_SYNC_SEL_GENCLK_VSYNC           = 0x1,
	DCIO_GSL1_TIMING_SYNC_SEL_GENCLK_CLK             = 0x2,
	DCIO_GSL1_TIMING_SYNC_SEL_SWAPLOCK_A             = 0x3,
	DCIO_GSL1_TIMING_SYNC_SEL_SWAPLOCK_B             = 0x4,
} DCIO_GSL1_TIMING_SYNC_SEL;
typedef enum DCIO_GSL1_GLOBAL_UNLOCK_SEL {
	DCIO_GSL1_GLOBAL_UNLOCK_SEL_INVERSION            = 0x0,
	DCIO_GSL1_GLOBAL_UNLOCK_SEL_GENCLK_VSYNC         = 0x1,
	DCIO_GSL1_GLOBAL_UNLOCK_SEL_GENLK_CLK            = 0x2,
	DCIO_GSL1_GLOBAL_UNLOCK_SEL_SWAPLOCK_A           = 0x3,
	DCIO_GSL1_GLOBAL_UNLOCK_SEL_SWAPLOCK_B           = 0x4,
} DCIO_GSL1_GLOBAL_UNLOCK_SEL;
typedef enum DCIO_GSL2_TIMING_SYNC_SEL {
	DCIO_GSL2_TIMING_SYNC_SEL_PIPE                   = 0x0,
	DCIO_GSL2_TIMING_SYNC_SEL_GENCLK_VSYNC           = 0x1,
	DCIO_GSL2_TIMING_SYNC_SEL_GENCLK_CLK             = 0x2,
	DCIO_GSL2_TIMING_SYNC_SEL_SWAPLOCK_A             = 0x3,
	DCIO_GSL2_TIMING_SYNC_SEL_SWAPLOCK_B             = 0x4,
} DCIO_GSL2_TIMING_SYNC_SEL;
typedef enum DCIO_GSL2_GLOBAL_UNLOCK_SEL {
	DCIO_GSL2_GLOBAL_UNLOCK_SEL_INVERSION            = 0x0,
	DCIO_GSL2_GLOBAL_UNLOCK_SEL_GENCLK_VSYNC         = 0x1,
	DCIO_GSL2_GLOBAL_UNLOCK_SEL_GENLK_CLK            = 0x2,
	DCIO_GSL2_GLOBAL_UNLOCK_SEL_SWAPLOCK_A           = 0x3,
	DCIO_GSL2_GLOBAL_UNLOCK_SEL_SWAPLOCK_B           = 0x4,
} DCIO_GSL2_GLOBAL_UNLOCK_SEL;
typedef enum DCIO_DC_GPU_TIMER_START_POSITION {
	DCIO_GPU_TIMER_START_0_END_27                    = 0x0,
	DCIO_GPU_TIMER_START_1_END_28                    = 0x1,
	DCIO_GPU_TIMER_START_2_END_29                    = 0x2,
	DCIO_GPU_TIMER_START_3_END_30                    = 0x3,
	DCIO_GPU_TIMER_START_4_END_31                    = 0x4,
	DCIO_GPU_TIMER_START_6_END_33                    = 0x5,
	DCIO_GPU_TIMER_START_8_END_35                    = 0x6,
	DCIO_GPU_TIMER_START_10_END_37                   = 0x7,
} DCIO_DC_GPU_TIMER_START_POSITION;
typedef enum DCIO_CLOCK_CNTL_DCIO_TEST_CLK_SEL {
	DCIO_TEST_CLK_SEL_DISPCLK                        = 0x0,
	DCIO_TEST_CLK_SEL_GATED_DISPCLK                  = 0x1,
	DCIO_TEST_CLK_SEL_SCLK                           = 0x2,
} DCIO_CLOCK_CNTL_DCIO_TEST_CLK_SEL;
typedef enum DCIO_CLOCK_CNTL_DISPCLK_R_DCIO_GATE_DIS {
	DCIO_DISPCLK_R_DCIO_GATE_DISABLE                 = 0x0,
	DCIO_DISPCLK_R_DCIO_GATE_ENABLE                  = 0x1,
} DCIO_CLOCK_CNTL_DISPCLK_R_DCIO_GATE_DIS;
typedef enum DCIO_DCO_DCFE_EXT_VSYNC_MUX {
	DCIO_EXT_VSYNC_MUX_SWAPLOCKB                     = 0x0,
	DCIO_EXT_VSYNC_MUX_CRTC0                         = 0x1,
	DCIO_EXT_VSYNC_MUX_CRTC1                         = 0x2,
	DCIO_EXT_VSYNC_MUX_CRTC2                         = 0x3,
	DCIO_EXT_VSYNC_MUX_CRTC3                         = 0x4,
	DCIO_EXT_VSYNC_MUX_CRTC4                         = 0x5,
	DCIO_EXT_VSYNC_MUX_CRTC5                         = 0x6,
	DCIO_EXT_VSYNC_MUX_GENERICB                      = 0x7,
} DCIO_DCO_DCFE_EXT_VSYNC_MUX;
typedef enum DCIO_DCO_EXT_VSYNC_MASK {
	DCIO_EXT_VSYNC_MASK_NONE                         = 0x0,
	DCIO_EXT_VSYNC_MASK_PIPE0                        = 0x1,
	DCIO_EXT_VSYNC_MASK_PIPE1                        = 0x2,
	DCIO_EXT_VSYNC_MASK_PIPE2                        = 0x3,
	DCIO_EXT_VSYNC_MASK_PIPE3                        = 0x4,
	DCIO_EXT_VSYNC_MASK_PIPE4                        = 0x5,
	DCIO_EXT_VSYNC_MASK_PIPE5                        = 0x6,
	DCIO_EXT_VSYNC_MASK_NONE_DUPLICATE               = 0x7,
} DCIO_DCO_EXT_VSYNC_MASK;
typedef enum DCIO_DBG_OUT_PIN_SEL {
	DCIO_DBG_OUT_PIN_SEL_LOW_12BIT                   = 0x0,
	DCIO_DBG_OUT_PIN_SEL_HIGH_12BIT                  = 0x1,
} DCIO_DBG_OUT_PIN_SEL;
typedef enum DCIO_DBG_OUT_12BIT_SEL {
	DCIO_DBG_OUT_12BIT_SEL_LOW_12BIT                 = 0x0,
	DCIO_DBG_OUT_12BIT_SEL_MID_12BIT                 = 0x1,
	DCIO_DBG_OUT_12BIT_SEL_HIGH_12BIT                = 0x2,
	DCIO_DBG_OUT_12BIT_SEL_OVERRIDE                  = 0x3,
} DCIO_DBG_OUT_12BIT_SEL;
typedef enum DCIO_DSYNC_SOFT_RESET {
	DCIO_DSYNC_SOFT_RESET_DEASSERT                   = 0x0,
	DCIO_DSYNC_SOFT_RESET_ASSERT                     = 0x1,
} DCIO_DSYNC_SOFT_RESET;
typedef enum DCIO_DACA_SOFT_RESET {
	DCIO_DACA_SOFT_RESET_DEASSERT                    = 0x0,
	DCIO_DACA_SOFT_RESET_ASSERT                      = 0x1,
} DCIO_DACA_SOFT_RESET;
typedef enum DCIO_DCRXPHY_SOFT_RESET {
	DCIO_DCRXPHY_SOFT_RESET_DEASSERT                 = 0x0,
	DCIO_DCRXPHY_SOFT_RESET_ASSERT                   = 0x1,
} DCIO_DCRXPHY_SOFT_RESET;
typedef enum DCIO_DPHY_LANE_SEL {
	DCIO_DPHY_LANE_SEL_LANE0                         = 0x0,
	DCIO_DPHY_LANE_SEL_LANE1                         = 0x1,
	DCIO_DPHY_LANE_SEL_LANE2                         = 0x2,
	DCIO_DPHY_LANE_SEL_LANE3                         = 0x3,
} DCIO_DPHY_LANE_SEL;
typedef enum DCIO_DPCS_INTERRUPT_TYPE {
	DCIO_DPCS_INTERRUPT_TYPE_LEVEL_BASED             = 0x0,
	DCIO_DPCS_INTERRUPT_TYPE_PULSE_BASED             = 0x1,
} DCIO_DPCS_INTERRUPT_TYPE;
typedef enum DCIO_DPCS_INTERRUPT_MASK {
	DCIO_DPCS_INTERRUPT_DISABLE                      = 0x0,
	DCIO_DPCS_INTERRUPT_ENABLE                       = 0x1,
} DCIO_DPCS_INTERRUPT_MASK;
typedef enum DCIO_DC_GPU_TIMER_READ_SELECT {
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D1_V_UPDATE     = 0x0,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D1_V_UPDATE     = 0x1,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D2_V_UPDATE     = 0x2,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D2_V_UPDATE     = 0x3,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D3_V_UPDATE     = 0x4,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D3_V_UPDATE     = 0x5,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D4_V_UPDATE     = 0x6,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D4_V_UPDATE     = 0x7,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D5_V_UPDATE     = 0x8,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D5_V_UPDATE     = 0x9,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D6_V_UPDATE     = 0xa,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D6_V_UPDATE     = 0xb,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D1_P_FLIP       = 0xc,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D1_P_FLIP       = 0xd,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D2_P_FLIP       = 0xe,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D2_P_FLIP       = 0xf,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D3_P_FLIP       = 0x10,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D3_P_FLIP       = 0x11,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D4_P_FLIP       = 0x12,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D4_P_FLIP       = 0x13,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D5_P_FLIP       = 0x14,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D5_P_FLIP       = 0x15,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D6_P_FLIP       = 0x16,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D6_P_FLIP       = 0x17,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D1_VSYNC_NOM    = 0x18,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D1_VSYNC_NOM    = 0x19,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D2_VSYNC_NOM    = 0x1a,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D2_VSYNC_NOM    = 0x1b,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D3_VSYNC_NOM    = 0x1c,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D3_VSYNC_NOM    = 0x1d,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D4_VSYNC_NOM    = 0x1e,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D4_VSYNC_NOM    = 0x1f,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D5_VSYNC_NOM    = 0x20,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D5_VSYNC_NOM    = 0x21,
	DCIO_GPU_TIMER_READ_SELECT_LOWER_D6_VSYNC_NOM    = 0x22,
	DCIO_GPU_TIMER_READ_SELECT_UPPER_D6_VSYNC_NOM    = 0x23,
} DCIO_DC_GPU_TIMER_READ_SELECT;
typedef enum DCIO_IMPCAL_STEP_DELAY {
	DCIO_IMPCAL_STEP_DELAY_1us                       = 0x0,
	DCIO_IMPCAL_STEP_DELAY_2us                       = 0x1,
	DCIO_IMPCAL_STEP_DELAY_3us                       = 0x2,
	DCIO_IMPCAL_STEP_DELAY_4us                       = 0x3,
	DCIO_IMPCAL_STEP_DELAY_5us                       = 0x4,
	DCIO_IMPCAL_STEP_DELAY_6us                       = 0x5,
	DCIO_IMPCAL_STEP_DELAY_7us                       = 0x6,
	DCIO_IMPCAL_STEP_DELAY_8us                       = 0x7,
	DCIO_IMPCAL_STEP_DELAY_9us                       = 0x8,
	DCIO_IMPCAL_STEP_DELAY_10us                      = 0x9,
	DCIO_IMPCAL_STEP_DELAY_11us                      = 0xa,
	DCIO_IMPCAL_STEP_DELAY_12us                      = 0xb,
	DCIO_IMPCAL_STEP_DELAY_13us                      = 0xc,
	DCIO_IMPCAL_STEP_DELAY_14us                      = 0xd,
	DCIO_IMPCAL_STEP_DELAY_15us                      = 0xe,
	DCIO_IMPCAL_STEP_DELAY_16us                      = 0xf,
} DCIO_IMPCAL_STEP_DELAY;
typedef enum DCIO_UNIPHY_IMPCAL_SEL {
	DCIO_UNIPHY_IMPCAL_SEL_TEMPERATURE               = 0x0,
	DCIO_UNIPHY_IMPCAL_SEL_BINARY                    = 0x1,
} DCIO_UNIPHY_IMPCAL_SEL;
typedef enum DCIO_DBG_CLOCK_SEL {
	DCIO_DBG_CLOCK_SEL_DISPCLK                       = 0x0,
	DCIO_DBG_CLOCK_SEL_SYMCLKA                       = 0x1,
	DCIO_DBG_CLOCK_SEL_SYMCLKB                       = 0x2,
	DCIO_DBG_CLOCK_SEL_SYMCLKC                       = 0x3,
	DCIO_DBG_CLOCK_SEL_SYMCLKD                       = 0x4,
	DCIO_DBG_CLOCK_SEL_SYMCLKE                       = 0x5,
	DCIO_DBG_CLOCK_SEL_SYMCLKF                       = 0x6,
	DCIO_DBG_CLOCK_SEL_REFCLK                        = 0xb,
} DCIO_DBG_CLOCK_SEL;
typedef enum DCIOCHIP_HPD_SEL {
	DCIOCHIP_HPD_SEL_ASYNC                           = 0x0,
	DCIOCHIP_HPD_SEL_CLOCKED                         = 0x1,
} DCIOCHIP_HPD_SEL;
typedef enum DCIOCHIP_PAD_MODE {
	DCIOCHIP_PAD_MODE_DDC                            = 0x0,
	DCIOCHIP_PAD_MODE_DP                             = 0x1,
} DCIOCHIP_PAD_MODE;
typedef enum DCIOCHIP_AUXSLAVE_PAD_MODE {
	DCIOCHIP_AUXSLAVE_PAD_MODE_I2C                   = 0x0,
	DCIOCHIP_AUXSLAVE_PAD_MODE_AUX                   = 0x1,
} DCIOCHIP_AUXSLAVE_PAD_MODE;
typedef enum DCIOCHIP_INVERT {
	DCIOCHIP_POL_NON_INVERT                          = 0x0,
	DCIOCHIP_POL_INVERT                              = 0x1,
} DCIOCHIP_INVERT;
typedef enum DCIOCHIP_PD_EN {
	DCIOCHIP_PD_EN_NOTALLOW                          = 0x0,
	DCIOCHIP_PD_EN_ALLOW                             = 0x1,
} DCIOCHIP_PD_EN;
typedef enum DCIOCHIP_GPIO_MASK_EN {
	DCIOCHIP_GPIO_MASK_EN_HARDWARE                   = 0x0,
	DCIOCHIP_GPIO_MASK_EN_SOFTWARE                   = 0x1,
} DCIOCHIP_GPIO_MASK_EN;
typedef enum DCIOCHIP_MASK {
	DCIOCHIP_MASK_DISABLE                            = 0x0,
	DCIOCHIP_MASK_ENABLE                             = 0x1,
} DCIOCHIP_MASK;
typedef enum DCIOCHIP_GPIO_I2C_MASK {
	DCIOCHIP_GPIO_I2C_MASK_DISABLE                   = 0x0,
	DCIOCHIP_GPIO_I2C_MASK_ENABLE                    = 0x1,
} DCIOCHIP_GPIO_I2C_MASK;
typedef enum DCIOCHIP_GPIO_I2C_DRIVE {
	DCIOCHIP_GPIO_I2C_DRIVE_LOW                      = 0x0,
	DCIOCHIP_GPIO_I2C_DRIVE_HIGH                     = 0x1,
} DCIOCHIP_GPIO_I2C_DRIVE;
typedef enum DCIOCHIP_GPIO_I2C_EN {
	DCIOCHIP_GPIO_I2C_DISABLE                        = 0x0,
	DCIOCHIP_GPIO_I2C_ENABLE                         = 0x1,
} DCIOCHIP_GPIO_I2C_EN;
typedef enum DCIOCHIP_MASK_4BIT {
	DCIOCHIP_MASK_4BIT_DISABLE                       = 0x0,
	DCIOCHIP_MASK_4BIT_ENABLE                        = 0xf,
} DCIOCHIP_MASK_4BIT;
typedef enum DCIOCHIP_ENABLE_4BIT {
	DCIOCHIP_4BIT_DISABLE                            = 0x0,
	DCIOCHIP_4BIT_ENABLE                             = 0xf,
} DCIOCHIP_ENABLE_4BIT;
typedef enum DCIOCHIP_MASK_5BIT {
	DCIOCHIP_MASIK_5BIT_DISABLE                      = 0x0,
	DCIOCHIP_MASIK_5BIT_ENABLE                       = 0x1f,
} DCIOCHIP_MASK_5BIT;
typedef enum DCIOCHIP_ENABLE_5BIT {
	DCIOCHIP_5BIT_DISABLE                            = 0x0,
	DCIOCHIP_5BIT_ENABLE                             = 0x1f,
} DCIOCHIP_ENABLE_5BIT;
typedef enum DCIOCHIP_MASK_2BIT {
	DCIOCHIP_MASK_2BIT_DISABLE                       = 0x0,
	DCIOCHIP_MASK_2BIT_ENABLE                        = 0x3,
} DCIOCHIP_MASK_2BIT;
typedef enum DCIOCHIP_ENABLE_2BIT {
	DCIOCHIP_2BIT_DISABLE                            = 0x0,
	DCIOCHIP_2BIT_ENABLE                             = 0x3,
} DCIOCHIP_ENABLE_2BIT;
typedef enum DCIOCHIP_REF_27_SRC_SEL {
	DCIOCHIP_REF_27_SRC_SEL_XTAL_DIVIDER             = 0x0,
	DCIOCHIP_REF_27_SRC_SEL_DISP_CLKIN2_DIVIDER      = 0x1,
	DCIOCHIP_REF_27_SRC_SEL_XTAL_BYPASS              = 0x2,
	DCIOCHIP_REF_27_SRC_SEL_DISP_CLKIN2_BYPASS       = 0x3,
} DCIOCHIP_REF_27_SRC_SEL;
typedef enum DCIOCHIP_DVO_VREFPON {
	DCIOCHIP_DVO_VREFPON_DISABLE                     = 0x0,
	DCIOCHIP_DVO_VREFPON_ENABLE                      = 0x1,
} DCIOCHIP_DVO_VREFPON;
typedef enum DCIOCHIP_DVO_VREFSEL {
	DCIOCHIP_DVO_VREFSEL_ONCHIP                      = 0x0,
	DCIOCHIP_DVO_VREFSEL_EXTERNAL                    = 0x1,
} DCIOCHIP_DVO_VREFSEL;
typedef enum DCIOCHIP_SPDIF1_IMODE {
	DCIOCHIP_SPDIF1_IMODE_OE_A                       = 0x0,
	DCIOCHIP_SPDIF1_IMODE_TSTE_TSTO                  = 0x1,
} DCIOCHIP_SPDIF1_IMODE;
typedef enum DCIOCHIP_AUX_FALLSLEWSEL {
	DCIOCHIP_AUX_FALLSLEWSEL_LOW                     = 0x0,
	DCIOCHIP_AUX_FALLSLEWSEL_HIGH0                   = 0x1,
	DCIOCHIP_AUX_FALLSLEWSEL_HIGH1                   = 0x2,
	DCIOCHIP_AUX_FALLSLEWSEL_ULTRAHIGH               = 0x3,
} DCIOCHIP_AUX_FALLSLEWSEL;
typedef enum DCIOCHIP_AUX_SPIKESEL {
	DCIOCHIP_AUX_SPIKESEL_50NS                       = 0x0,
	DCIOCHIP_AUX_SPIKESEL_10NS                       = 0x1,
} DCIOCHIP_AUX_SPIKESEL;
typedef enum DCIOCHIP_AUX_CSEL0P9 {
	DCIOCHIP_AUX_CSEL_DEC1P0                         = 0x0,
	DCIOCHIP_AUX_CSEL_DEC0P9                         = 0x1,
} DCIOCHIP_AUX_CSEL0P9;
typedef enum DCIOCHIP_AUX_CSEL1P1 {
	DCIOCHIP_AUX_CSEL_INC1P0                         = 0x0,
	DCIOCHIP_AUX_CSEL_INC1P1                         = 0x1,
} DCIOCHIP_AUX_CSEL1P1;
typedef enum DCIOCHIP_AUX_RSEL0P9 {
	DCIOCHIP_AUX_RSEL_DEC1P0                         = 0x0,
	DCIOCHIP_AUX_RSEL_DEC0P9                         = 0x1,
} DCIOCHIP_AUX_RSEL0P9;
typedef enum DCIOCHIP_AUX_RSEL1P1 {
	DCIOCHIP_AUX_RSEL_INC1P0                         = 0x0,
	DCIOCHIP_AUX_RSEL_INC1P1                         = 0x1,
} DCIOCHIP_AUX_RSEL1P1;
typedef enum DCP_GRPH_ENABLE {
	DCP_GRPH_ENABLE_FALSE                            = 0x0,
	DCP_GRPH_ENABLE_TRUE                             = 0x1,
} DCP_GRPH_ENABLE;
typedef enum DCP_GRPH_KEYER_ALPHA_SEL {
	DCP_GRPH_KEYER_ALPHA_SEL_FALSE                   = 0x0,
	DCP_GRPH_KEYER_ALPHA_SEL_TRUE                    = 0x1,
} DCP_GRPH_KEYER_ALPHA_SEL;
typedef enum DCP_GRPH_DEPTH {
	DCP_GRPH_DEPTH_8BPP                              = 0x0,
	DCP_GRPH_DEPTH_16BPP                             = 0x1,
	DCP_GRPH_DEPTH_32BPP                             = 0x2,
	DCP_GRPH_DEPTH_64BPP                             = 0x3,
} DCP_GRPH_DEPTH;
typedef enum DCP_GRPH_NUM_BANKS {
	DCP_GRPH_NUM_BANKS_2BANK                         = 0x0,
	DCP_GRPH_NUM_BANKS_4BANK                         = 0x1,
	DCP_GRPH_NUM_BANKS_8BANK                         = 0x2,
	DCP_GRPH_NUM_BANKS_16BANK                        = 0x3,
} DCP_GRPH_NUM_BANKS;
typedef enum DCP_GRPH_BANK_WIDTH {
	DCP_GRPH_BANK_WIDTH_1                            = 0x0,
	DCP_GRPH_BANK_WIDTH_2                            = 0x1,
	DCP_GRPH_BANK_WIDTH_4                            = 0x2,
	DCP_GRPH_BANK_WIDTH_8                            = 0x3,
} DCP_GRPH_BANK_WIDTH;
typedef enum DCP_GRPH_FORMAT {
	DCP_GRPH_FORMAT_8BPP                             = 0x0,
	DCP_GRPH_FORMAT_16BPP                            = 0x1,
	DCP_GRPH_FORMAT_32BPP                            = 0x2,
	DCP_GRPH_FORMAT_64BPP                            = 0x3,
} DCP_GRPH_FORMAT;
typedef enum DCP_GRPH_BANK_HEIGHT {
	DCP_GRPH_BANK_HEIGHT_1                           = 0x0,
	DCP_GRPH_BANK_HEIGHT_2                           = 0x1,
	DCP_GRPH_BANK_HEIGHT_4                           = 0x2,
	DCP_GRPH_BANK_HEIGHT_8                           = 0x3,
} DCP_GRPH_BANK_HEIGHT;
typedef enum DCP_GRPH_TILE_SPLIT {
	DCP_GRPH_TILE_SPLIT_64B                          = 0x0,
	DCP_GRPH_TILE_SPLIT_128B                         = 0x1,
	DCP_GRPH_TILE_SPLIT_256B                         = 0x2,
	DCP_GRPH_TILE_SPLIT_512B                         = 0x3,
	DCP_GRPH_TILE_SPLIT_1B                           = 0x4,
	DCP_GRPH_TILE_SPLIT_2B                           = 0x5,
	DCP_GRPH_TILE_SPLIT_4B                           = 0x6,
} DCP_GRPH_TILE_SPLIT;
typedef enum DCP_GRPH_ADDRESS_TRANSLATION_ENABLE {
	DCP_GRPH_ADDRESS_TRANSLATION_ENABLE_FALSE        = 0x0,
	DCP_GRPH_ADDRESS_TRANSLATION_ENABLE_TRUE         = 0x1,
} DCP_GRPH_ADDRESS_TRANSLATION_ENABLE;
typedef enum DCP_GRPH_PRIVILEGED_ACCESS_ENABLE {
	DCP_GRPH_PRIVILEGED_ACCESS_ENABLE_FALSE          = 0x0,
	DCP_GRPH_PRIVILEGED_ACCESS_ENABLE_TRUE           = 0x1,
} DCP_GRPH_PRIVILEGED_ACCESS_ENABLE;
typedef enum DCP_GRPH_MACRO_TILE_ASPECT {
	DCP_GRPH_MACRO_TILE_ASPECT_1                     = 0x0,
	DCP_GRPH_MACRO_TILE_ASPECT_2                     = 0x1,
	DCP_GRPH_MACRO_TILE_ASPECT_4                     = 0x2,
	DCP_GRPH_MACRO_TILE_ASPECT_8                     = 0x3,
} DCP_GRPH_MACRO_TILE_ASPECT;
typedef enum DCP_GRPH_ARRAY_MODE {
	DCP_GRPH_ARRAY_MODE_0                            = 0x0,
	DCP_GRPH_ARRAY_MODE_1                            = 0x1,
	DCP_GRPH_ARRAY_MODE_2                            = 0x2,
	DCP_GRPH_ARRAY_MODE_3                            = 0x3,
	DCP_GRPH_ARRAY_MODE_4                            = 0x4,
	DCP_GRPH_ARRAY_MODE_7                            = 0x7,
	DCP_GRPH_ARRAY_MODE_12                           = 0xc,
	DCP_GRPH_ARRAY_MODE_13                           = 0xd,
} DCP_GRPH_ARRAY_MODE;
typedef enum DCP_GRPH_MICRO_TILE_MODE {
	DCP_GRPH_MICRO_TILE_MODE_0                       = 0x0,
	DCP_GRPH_MICRO_TILE_MODE_1                       = 0x1,
	DCP_GRPH_MICRO_TILE_MODE_2                       = 0x2,
	DCP_GRPH_MICRO_TILE_MODE_3                       = 0x3,
} DCP_GRPH_MICRO_TILE_MODE;
typedef enum DCP_GRPH_COLOR_EXPANSION_MODE {
	DCP_GRPH_COLOR_EXPANSION_MODE_DEXP               = 0x0,
	DCP_GRPH_COLOR_EXPANSION_MODE_ZEXP               = 0x1,
} DCP_GRPH_COLOR_EXPANSION_MODE;
typedef enum DCP_GRPH_LUT_10BIT_BYPASS_EN {
	DCP_GRPH_LUT_10BIT_BYPASS_EN_FALSE               = 0x0,
	DCP_GRPH_LUT_10BIT_BYPASS_EN_TRUE                = 0x1,
} DCP_GRPH_LUT_10BIT_BYPASS_EN;
typedef enum DCP_GRPH_LUT_10BIT_BYPASS_DBL_BUF_EN {
	DCP_GRPH_LUT_10BIT_BYPASS_DBL_BUF_EN_FALSE       = 0x0,
	DCP_GRPH_LUT_10BIT_BYPASS_DBL_BUF_EN_TRUE        = 0x1,
} DCP_GRPH_LUT_10BIT_BYPASS_DBL_BUF_EN;
typedef enum DCP_GRPH_ENDIAN_SWAP {
	DCP_GRPH_ENDIAN_SWAP_NONE                        = 0x0,
	DCP_GRPH_ENDIAN_SWAP_8IN16                       = 0x1,
	DCP_GRPH_ENDIAN_SWAP_8IN32                       = 0x2,
	DCP_GRPH_ENDIAN_SWAP_8IN64                       = 0x3,
} DCP_GRPH_ENDIAN_SWAP;
typedef enum DCP_GRPH_RED_CROSSBAR {
	DCP_GRPH_RED_CROSSBAR_FROM_R                     = 0x0,
	DCP_GRPH_RED_CROSSBAR_FROM_G                     = 0x1,
	DCP_GRPH_RED_CROSSBAR_FROM_B                     = 0x2,
	DCP_GRPH_RED_CROSSBAR_FROM_A                     = 0x3,
} DCP_GRPH_RED_CROSSBAR;
typedef enum DCP_GRPH_GREEN_CROSSBAR {
	DCP_GRPH_GREEN_CROSSBAR_FROM_G                   = 0x0,
	DCP_GRPH_GREEN_CROSSBAR_FROM_B                   = 0x1,
	DCP_GRPH_GREEN_CROSSBAR_FROM_A                   = 0x2,
	DCP_GRPH_GREEN_CROSSBAR_FROM_R                   = 0x3,
} DCP_GRPH_GREEN_CROSSBAR;
typedef enum DCP_GRPH_BLUE_CROSSBAR {
	DCP_GRPH_BLUE_CROSSBAR_FROM_B                    = 0x0,
	DCP_GRPH_BLUE_CROSSBAR_FROM_A                    = 0x1,
	DCP_GRPH_BLUE_CROSSBAR_FROM_R                    = 0x2,
	DCP_GRPH_BLUE_CROSSBAR_FROM_G                    = 0x3,
} DCP_GRPH_BLUE_CROSSBAR;
typedef enum DCP_GRPH_ALPHA_CROSSBAR {
	DCP_GRPH_ALPHA_CROSSBAR_FROM_A                   = 0x0,
	DCP_GRPH_ALPHA_CROSSBAR_FROM_R                   = 0x1,
	DCP_GRPH_ALPHA_CROSSBAR_FROM_G                   = 0x2,
	DCP_GRPH_ALPHA_CROSSBAR_FROM_B                   = 0x3,
} DCP_GRPH_ALPHA_CROSSBAR;
typedef enum DCP_GRPH_PRIMARY_DFQ_ENABLE {
	DCP_GRPH_PRIMARY_DFQ_ENABLE_FALSE                = 0x0,
	DCP_GRPH_PRIMARY_DFQ_ENABLE_TRUE                 = 0x1,
} DCP_GRPH_PRIMARY_DFQ_ENABLE;
typedef enum DCP_GRPH_SECONDARY_DFQ_ENABLE {
	DCP_GRPH_SECONDARY_DFQ_ENABLE_FALSE              = 0x0,
	DCP_GRPH_SECONDARY_DFQ_ENABLE_TRUE               = 0x1,
} DCP_GRPH_SECONDARY_DFQ_ENABLE;
typedef enum DCP_GRPH_INPUT_GAMMA_MODE {
	DCP_GRPH_INPUT_GAMMA_MODE_LUT                    = 0x0,
	DCP_GRPH_INPUT_GAMMA_MODE_BYPASS                 = 0x1,
} DCP_GRPH_INPUT_GAMMA_MODE;
typedef enum DCP_GRPH_MODE_UPDATE_PENDING {
	DCP_GRPH_MODE_UPDATE_PENDING_FALSE               = 0x0,
	DCP_GRPH_MODE_UPDATE_PENDING_TRUE                = 0x1,
} DCP_GRPH_MODE_UPDATE_PENDING;
typedef enum DCP_GRPH_MODE_UPDATE_TAKEN {
	DCP_GRPH_MODE_UPDATE_TAKEN_FALSE                 = 0x0,
	DCP_GRPH_MODE_UPDATE_TAKEN_TRUE                  = 0x1,
} DCP_GRPH_MODE_UPDATE_TAKEN;
typedef enum DCP_GRPH_SURFACE_UPDATE_PENDING {
	DCP_GRPH_SURFACE_UPDATE_PENDING_FALSE            = 0x0,
	DCP_GRPH_SURFACE_UPDATE_PENDING_TRUE             = 0x1,
} DCP_GRPH_SURFACE_UPDATE_PENDING;
typedef enum DCP_GRPH_SURFACE_UPDATE_TAKEN {
	DCP_GRPH_SURFACE_UPDATE_TAKEN_FALSE              = 0x0,
	DCP_GRPH_SURFACE_UPDATE_TAKEN_TRUE               = 0x1,
} DCP_GRPH_SURFACE_UPDATE_TAKEN;
typedef enum DCP_GRPH_SURFACE_XDMA_PENDING_ENABLE {
	DCP_GRPH_SURFACE_XDMA_PENDING_ENABLE_FALSE       = 0x0,
	DCP_GRPH_SURFACE_XDMA_PENDING_ENABLE_TRUE        = 0x1,
} DCP_GRPH_SURFACE_XDMA_PENDING_ENABLE;
typedef enum DCP_GRPH_UPDATE_LOCK {
	DCP_GRPH_UPDATE_LOCK_FALSE                       = 0x0,
	DCP_GRPH_UPDATE_LOCK_TRUE                        = 0x1,
} DCP_GRPH_UPDATE_LOCK;
typedef enum DCP_GRPH_SURFACE_IGNORE_UPDATE_LOCK {
	DCP_GRPH_SURFACE_IGNORE_UPDATE_LOCK_FALSE        = 0x0,
	DCP_GRPH_SURFACE_IGNORE_UPDATE_LOCK_TRUE         = 0x1,
} DCP_GRPH_SURFACE_IGNORE_UPDATE_LOCK;
typedef enum DCP_GRPH_MODE_DISABLE_MULTIPLE_UPDATE {
	DCP_GRPH_MODE_DISABLE_MULTIPLE_UPDATE_FALSE      = 0x0,
	DCP_GRPH_MODE_DISABLE_MULTIPLE_UPDATE_TRUE       = 0x1,
} DCP_GRPH_MODE_DISABLE_MULTIPLE_UPDATE;
typedef enum DCP_GRPH_SURFACE_DISABLE_MULTIPLE_UPDATE {
	DCP_GRPH_SURFACE_DISABLE_MULTIPLE_UPDATE_FALSE   = 0x0,
	DCP_GRPH_SURFACE_DISABLE_MULTIPLE_UPDATE_TRUE    = 0x1,
} DCP_GRPH_SURFACE_DISABLE_MULTIPLE_UPDATE;
typedef enum DCP_GRPH_SURFACE_UPDATE_H_RETRACE_EN {
	DCP_GRPH_SURFACE_UPDATE_H_RETRACE_EN_FALSE       = 0x0,
	DCP_GRPH_SURFACE_UPDATE_H_RETRACE_EN_TRUE        = 0x1,
} DCP_GRPH_SURFACE_UPDATE_H_RETRACE_EN;
typedef enum DCP_GRPH_XDMA_SUPER_AA_EN {
	DCP_GRPH_XDMA_SUPER_AA_EN_FALSE                  = 0x0,
	DCP_GRPH_XDMA_SUPER_AA_EN_TRUE                   = 0x1,
} DCP_GRPH_XDMA_SUPER_AA_EN;
typedef enum DCP_GRPH_DFQ_RESET {
	DCP_GRPH_DFQ_RESET_FALSE                         = 0x0,
	DCP_GRPH_DFQ_RESET_TRUE                          = 0x1,
} DCP_GRPH_DFQ_RESET;
typedef enum DCP_GRPH_DFQ_SIZE {
	DCP_GRPH_DFQ_SIZE_DEEP1                          = 0x0,
	DCP_GRPH_DFQ_SIZE_DEEP2                          = 0x1,
	DCP_GRPH_DFQ_SIZE_DEEP3                          = 0x2,
	DCP_GRPH_DFQ_SIZE_DEEP4                          = 0x3,
	DCP_GRPH_DFQ_SIZE_DEEP5                          = 0x4,
	DCP_GRPH_DFQ_SIZE_DEEP6                          = 0x5,
	DCP_GRPH_DFQ_SIZE_DEEP7                          = 0x6,
	DCP_GRPH_DFQ_SIZE_DEEP8                          = 0x7,
} DCP_GRPH_DFQ_SIZE;
typedef enum DCP_GRPH_DFQ_MIN_FREE_ENTRIES {
	DCP_GRPH_DFQ_MIN_FREE_ENTRIES_1                  = 0x0,
	DCP_GRPH_DFQ_MIN_FREE_ENTRIES_2                  = 0x1,
	DCP_GRPH_DFQ_MIN_FREE_ENTRIES_3                  = 0x2,
	DCP_GRPH_DFQ_MIN_FREE_ENTRIES_4                  = 0x3,
	DCP_GRPH_DFQ_MIN_FREE_ENTRIES_5                  = 0x4,
	DCP_GRPH_DFQ_MIN_FREE_ENTRIES_6                  = 0x5,
	DCP_GRPH_DFQ_MIN_FREE_ENTRIES_7                  = 0x6,
	DCP_GRPH_DFQ_MIN_FREE_ENTRIES_8                  = 0x7,
} DCP_GRPH_DFQ_MIN_FREE_ENTRIES;
typedef enum DCP_GRPH_DFQ_RESET_ACK {
	DCP_GRPH_DFQ_RESET_ACK_FALSE                     = 0x0,
	DCP_GRPH_DFQ_RESET_ACK_TRUE                      = 0x1,
} DCP_GRPH_DFQ_RESET_ACK;
typedef enum DCP_GRPH_PFLIP_INT_CLEAR {
	DCP_GRPH_PFLIP_INT_CLEAR_FALSE                   = 0x0,
	DCP_GRPH_PFLIP_INT_CLEAR_TRUE                    = 0x1,
} DCP_GRPH_PFLIP_INT_CLEAR;
typedef enum DCP_GRPH_PFLIP_INT_MASK {
	DCP_GRPH_PFLIP_INT_MASK_FALSE                    = 0x0,
	DCP_GRPH_PFLIP_INT_MASK_TRUE                     = 0x1,
} DCP_GRPH_PFLIP_INT_MASK;
typedef enum DCP_GRPH_PFLIP_INT_TYPE {
	DCP_GRPH_PFLIP_INT_TYPE_LEGACY_LEVEL             = 0x0,
	DCP_GRPH_PFLIP_INT_TYPE_PULSE                    = 0x1,
} DCP_GRPH_PFLIP_INT_TYPE;
typedef enum DCP_GRPH_PRESCALE_SELECT {
	DCP_GRPH_PRESCALE_SELECT_FIXED                   = 0x0,
	DCP_GRPH_PRESCALE_SELECT_FLOATING                = 0x1,
} DCP_GRPH_PRESCALE_SELECT;
typedef enum DCP_GRPH_PRESCALE_R_SIGN {
	DCP_GRPH_PRESCALE_R_SIGN_UNSIGNED                = 0x0,
	DCP_GRPH_PRESCALE_R_SIGN_SIGNED                  = 0x1,
} DCP_GRPH_PRESCALE_R_SIGN;
typedef enum DCP_GRPH_PRESCALE_G_SIGN {
	DCP_GRPH_PRESCALE_G_SIGN_UNSIGNED                = 0x0,
	DCP_GRPH_PRESCALE_G_SIGN_SIGNED                  = 0x1,
} DCP_GRPH_PRESCALE_G_SIGN;
typedef enum DCP_GRPH_PRESCALE_B_SIGN {
	DCP_GRPH_PRESCALE_B_SIGN_UNSIGNED                = 0x0,
	DCP_GRPH_PRESCALE_B_SIGN_SIGNED                  = 0x1,
} DCP_GRPH_PRESCALE_B_SIGN;
typedef enum DCP_GRPH_PRESCALE_BYPASS {
	DCP_GRPH_PRESCALE_BYPASS_FALSE                   = 0x0,
	DCP_GRPH_PRESCALE_BYPASS_TRUE                    = 0x1,
} DCP_GRPH_PRESCALE_BYPASS;
typedef enum DCP_INPUT_CSC_GRPH_MODE {
	DCP_INPUT_CSC_GRPH_MODE_BYPASS                   = 0x0,
	DCP_INPUT_CSC_GRPH_MODE_INPUT_CSC_COEF           = 0x1,
	DCP_INPUT_CSC_GRPH_MODE_SHARED_COEF              = 0x2,
	DCP_INPUT_CSC_GRPH_MODE_RESERVED                 = 0x3,
} DCP_INPUT_CSC_GRPH_MODE;
typedef enum DCP_OUTPUT_CSC_GRPH_MODE {
	DCP_OUTPUT_CSC_GRPH_MODE_BYPASS                  = 0x0,
	DCP_OUTPUT_CSC_GRPH_MODE_RGB                     = 0x1,
	DCP_OUTPUT_CSC_GRPH_MODE_YCBCR601                = 0x2,
	DCP_OUTPUT_CSC_GRPH_MODE_YCBCR709                = 0x3,
	DCP_OUTPUT_CSC_GRPH_MODE_OUTPUT_CSC_COEF         = 0x4,
	DCP_OUTPUT_CSC_GRPH_MODE_SHARED_COEF             = 0x5,
	DCP_OUTPUT_CSC_GRPH_MODE_RESERVED0               = 0x6,
	DCP_OUTPUT_CSC_GRPH_MODE_RESERVED1               = 0x7,
} DCP_OUTPUT_CSC_GRPH_MODE;
typedef enum DCP_DENORM_MODE {
	DCP_DENORM_MODE_UNITY                            = 0x0,
	DCP_DENORM_MODE_6BIT                             = 0x1,
	DCP_DENORM_MODE_8BIT                             = 0x2,
	DCP_DENORM_MODE_10BIT                            = 0x3,
	DCP_DENORM_MODE_11BIT                            = 0x4,
	DCP_DENORM_MODE_12BIT                            = 0x5,
	DCP_DENORM_MODE_RESERVED0                        = 0x6,
	DCP_DENORM_MODE_RESERVED1                        = 0x7,
} DCP_DENORM_MODE;
typedef enum DCP_DENORM_14BIT_OUT {
	DCP_DENORM_14BIT_OUT_FALSE                       = 0x0,
	DCP_DENORM_14BIT_OUT_TRUE                        = 0x1,
} DCP_DENORM_14BIT_OUT;
typedef enum DCP_OUT_ROUND_TRUNC_MODE {
	DCP_OUT_ROUND_TRUNC_MODE_TRUNCATE_12             = 0x0,
	DCP_OUT_ROUND_TRUNC_MODE_TRUNCATE_11             = 0x1,
	DCP_OUT_ROUND_TRUNC_MODE_TRUNCATE_10             = 0x2,
	DCP_OUT_ROUND_TRUNC_MODE_TRUNCATE_9              = 0x3,
	DCP_OUT_ROUND_TRUNC_MODE_TRUNCATE_8              = 0x4,
	DCP_OUT_ROUND_TRUNC_MODE_TRUNCATE_RESERVED       = 0x5,
	DCP_OUT_ROUND_TRUNC_MODE_TRUNCATE_14             = 0x6,
	DCP_OUT_ROUND_TRUNC_MODE_TRUNCATE_13             = 0x7,
	DCP_OUT_ROUND_TRUNC_MODE_ROUND_12                = 0x8,
	DCP_OUT_ROUND_TRUNC_MODE_ROUND_11                = 0x9,
	DCP_OUT_ROUND_TRUNC_MODE_ROUND_10                = 0xa,
	DCP_OUT_ROUND_TRUNC_MODE_ROUND_9                 = 0xb,
	DCP_OUT_ROUND_TRUNC_MODE_ROUND_8                 = 0xc,
	DCP_OUT_ROUND_TRUNC_MODE_ROUND_RESERVED          = 0xd,
	DCP_OUT_ROUND_TRUNC_MODE_ROUND_14                = 0xe,
	DCP_OUT_ROUND_TRUNC_MODE_ROUND_13                = 0xf,
} DCP_OUT_ROUND_TRUNC_MODE;
typedef enum DCP_KEY_MODE {
	DCP_KEY_MODE_ALPHA0                              = 0x0,
	DCP_KEY_MODE_ALPHA1                              = 0x1,
	DCP_KEY_MODE_IN_RANGE_ALPHA1                     = 0x2,
	DCP_KEY_MODE_IN_RANGE_ALPHA0                     = 0x3,
} DCP_KEY_MODE;
typedef enum DCP_GRPH_DEGAMMA_MODE {
	DCP_GRPH_DEGAMMA_MODE_BYPASS                     = 0x0,
	DCP_GRPH_DEGAMMA_MODE_ROMA                       = 0x1,
	DCP_GRPH_DEGAMMA_MODE_ROMB                       = 0x2,
	DCP_GRPH_DEGAMMA_MODE_RESERVED                   = 0x3,
} DCP_GRPH_DEGAMMA_MODE;
typedef enum DCP_CURSOR2_DEGAMMA_MODE {
	DCP_CURSOR2_DEGAMMA_MODE_BYPASS                  = 0x0,
	DCP_CURSOR2_DEGAMMA_MODE_ROMA                    = 0x1,
	DCP_CURSOR2_DEGAMMA_MODE_ROMB                    = 0x2,
	DCP_CURSOR2_DEGAMMA_MODE_RESERVED                = 0x3,
} DCP_CURSOR2_DEGAMMA_MODE;
typedef enum DCP_CURSOR_DEGAMMA_MODE {
	DCP_CURSOR_DEGAMMA_MODE_BYPASS                   = 0x0,
	DCP_CURSOR_DEGAMMA_MODE_ROMA                     = 0x1,
	DCP_CURSOR_DEGAMMA_MODE_ROMB                     = 0x2,
	DCP_CURSOR_DEGAMMA_MODE_RESERVED                 = 0x3,
} DCP_CURSOR_DEGAMMA_MODE;
typedef enum DCP_GRPH_GAMUT_REMAP_MODE {
	DCP_GRPH_GAMUT_REMAP_MODE_BYPASS                 = 0x0,
	DCP_GRPH_GAMUT_REMAP_MODE_ROMA                   = 0x1,
	DCP_GRPH_GAMUT_REMAP_MODE_ROMB                   = 0x2,
	DCP_GRPH_GAMUT_REMAP_MODE_RESERVED               = 0x3,
} DCP_GRPH_GAMUT_REMAP_MODE;
typedef enum DCP_SPATIAL_DITHER_EN {
	DCP_SPATIAL_DITHER_EN_FALSE                      = 0x0,
	DCP_SPATIAL_DITHER_EN_TRUE                       = 0x1,
} DCP_SPATIAL_DITHER_EN;
typedef enum DCP_SPATIAL_DITHER_MODE {
	DCP_SPATIAL_DITHER_MODE_BYPASS                   = 0x0,
	DCP_SPATIAL_DITHER_MODE_ROMA                     = 0x1,
	DCP_SPATIAL_DITHER_MODE_ROMB                     = 0x2,
	DCP_SPATIAL_DITHER_MODE_RESERVED                 = 0x3,
} DCP_SPATIAL_DITHER_MODE;
typedef enum DCP_SPATIAL_DITHER_DEPTH {
	DCP_SPATIAL_DITHER_DEPTH_30BPP                   = 0x0,
	DCP_SPATIAL_DITHER_DEPTH_24BPP                   = 0x1,
	DCP_SPATIAL_DITHER_DEPTH_36BPP                   = 0x2,
	DCP_SPATIAL_DITHER_DEPTH_UNDEFINED               = 0x3,
} DCP_SPATIAL_DITHER_DEPTH;
typedef enum DCP_FRAME_RANDOM_ENABLE {
	DCP_FRAME_RANDOM_ENABLE_FALSE                    = 0x0,
	DCP_FRAME_RANDOM_ENABLE_TRUE                     = 0x1,
} DCP_FRAME_RANDOM_ENABLE;
typedef enum DCP_RGB_RANDOM_ENABLE {
	DCP_RGB_RANDOM_ENABLE_FALSE                      = 0x0,
	DCP_RGB_RANDOM_ENABLE_TRUE                       = 0x1,
} DCP_RGB_RANDOM_ENABLE;
typedef enum DCP_HIGHPASS_RANDOM_ENABLE {
	DCP_HIGHPASS_RANDOM_ENABLE_FALSE                 = 0x0,
	DCP_HIGHPASS_RANDOM_ENABLE_TRUE                  = 0x1,
} DCP_HIGHPASS_RANDOM_ENABLE;
typedef enum DCP_CURSOR_EN {
	DCP_CURSOR_EN_FALSE                              = 0x0,
	DCP_CURSOR_EN_TRUE                               = 0x1,
} DCP_CURSOR_EN;
typedef enum DCP_CUR_INV_TRANS_CLAMP {
	DCP_CUR_INV_TRANS_CLAMP_FALSE                    = 0x0,
	DCP_CUR_INV_TRANS_CLAMP_TRUE                     = 0x1,
} DCP_CUR_INV_TRANS_CLAMP;
typedef enum DCP_CURSOR_MODE {
	DCP_CURSOR_MODE_MONO_2BPP                        = 0x0,
	DCP_CURSOR_MODE_24BPP_1BIT                       = 0x1,
	DCP_CURSOR_MODE_24BPP_8BIT_PREMULTI              = 0x2,
	DCP_CURSOR_MODE_24BPP_8BIT_UNPREMULTI            = 0x3,
} DCP_CURSOR_MODE;
typedef enum DCP_CURSOR_2X_MAGNIFY {
	DCP_CURSOR_2X_MAGNIFY_FALSE                      = 0x0,
	DCP_CURSOR_2X_MAGNIFY_TRUE                       = 0x1,
} DCP_CURSOR_2X_MAGNIFY;
typedef enum DCP_CURSOR_FORCE_MC_ON {
	DCP_CURSOR_FORCE_MC_ON_FALSE                     = 0x0,
	DCP_CURSOR_FORCE_MC_ON_TRUE                      = 0x1,
} DCP_CURSOR_FORCE_MC_ON;
typedef enum DCP_CURSOR_URGENT_CONTROL {
	DCP_CURSOR_URGENT_CONTROL_MODE_0                 = 0x0,
	DCP_CURSOR_URGENT_CONTROL_MODE_1                 = 0x1,
	DCP_CURSOR_URGENT_CONTROL_MODE_2                 = 0x2,
	DCP_CURSOR_URGENT_CONTROL_MODE_3                 = 0x3,
	DCP_CURSOR_URGENT_CONTROL_MODE_4                 = 0x4,
} DCP_CURSOR_URGENT_CONTROL;
typedef enum DCP_CURSOR_UPDATE_PENDING {
	DCP_CURSOR_UPDATE_PENDING_FALSE                  = 0x0,
	DCP_CURSOR_UPDATE_PENDING_TRUE                   = 0x1,
} DCP_CURSOR_UPDATE_PENDING;
typedef enum DCP_CURSOR_UPDATE_TAKEN {
	DCP_CURSOR_UPDATE_TAKEN_FALSE                    = 0x0,
	DCP_CURSOR_UPDATE_TAKEN_TRUE                     = 0x1,
} DCP_CURSOR_UPDATE_TAKEN;
typedef enum DCP_CURSOR_UPDATE_LOCK {
	DCP_CURSOR_UPDATE_LOCK_FALSE                     = 0x0,
	DCP_CURSOR_UPDATE_LOCK_TRUE                      = 0x1,
} DCP_CURSOR_UPDATE_LOCK;
typedef enum DCP_CURSOR_DISABLE_MULTIPLE_UPDATE {
	DCP_CURSOR_DISABLE_MULTIPLE_UPDATE_FALSE         = 0x0,
	DCP_CURSOR_DISABLE_MULTIPLE_UPDATE_TRUE          = 0x1,
} DCP_CURSOR_DISABLE_MULTIPLE_UPDATE;
typedef enum DCP_CURSOR_UPDATE_STEREO_MODE {
	DCP_CURSOR_UPDATE_STEREO_MODE_BOTH               = 0x0,
	DCP_CURSOR_UPDATE_STEREO_MODE_SECONDARY_ONLY     = 0x1,
	DCP_CURSOR_UPDATE_STEREO_MODE_UNDEFINED          = 0x2,
	DCP_CURSOR_UPDATE_STEREO_MODE_PRIMARY_ONLY       = 0x3,
} DCP_CURSOR_UPDATE_STEREO_MODE;
typedef enum DCP_CURSOR2_EN {
	DCP_CURSOR2_EN_FALSE                             = 0x0,
	DCP_CURSOR2_EN_TRUE                              = 0x1,
} DCP_CURSOR2_EN;
typedef enum DCP_CUR2_INV_TRANS_CLAMP {
	DCP_CUR2_INV_TRANS_CLAMP_FALSE                   = 0x0,
	DCP_CUR2_INV_TRANS_CLAMP_TRUE                    = 0x1,
} DCP_CUR2_INV_TRANS_CLAMP;
typedef enum DCP_CURSOR2_MODE {
	DCP_CURSOR2_MODE_MONO_2BPP                       = 0x0,
	DCP_CURSOR2_MODE_24BPP_1BIT                      = 0x1,
	DCP_CURSOR2_MODE_24BPP_8BIT_PREMULTI             = 0x2,
	DCP_CURSOR2_MODE_24BPP_8BIT_UNPREMULTI           = 0x3,
} DCP_CURSOR2_MODE;
typedef enum DCP_CURSOR2_2X_MAGNIFY {
	DCP_CURSOR2_2X_MAGNIFY_FALSE                     = 0x0,
	DCP_CURSOR2_2X_MAGNIFY_TRUE                      = 0x1,
} DCP_CURSOR2_2X_MAGNIFY;
typedef enum DCP_CURSOR2_FORCE_MC_ON {
	DCP_CURSOR2_FORCE_MC_ON_FALSE                    = 0x0,
	DCP_CURSOR2_FORCE_MC_ON_TRUE                     = 0x1,
} DCP_CURSOR2_FORCE_MC_ON;
typedef enum DCP_CURSOR2_URGENT_CONTROL {
	DCP_CURSOR2_URGENT_CONTROL_MODE_0                = 0x0,
	DCP_CURSOR2_URGENT_CONTROL_MODE_1                = 0x1,
	DCP_CURSOR2_URGENT_CONTROL_MODE_2                = 0x2,
	DCP_CURSOR2_URGENT_CONTROL_MODE_3                = 0x3,
	DCP_CURSOR2_URGENT_CONTROL_MODE_4                = 0x4,
} DCP_CURSOR2_URGENT_CONTROL;
typedef enum DCP_CURSOR2_UPDATE_PENDING {
	DCP_CURSOR2_UPDATE_PENDING_FALSE                 = 0x0,
	DCP_CURSOR2_UPDATE_PENDING_TRUE                  = 0x1,
} DCP_CURSOR2_UPDATE_PENDING;
typedef enum DCP_CURSOR2_UPDATE_TAKEN {
	DCP_CURSOR2_UPDATE_TAKEN_FALSE                   = 0x0,
	DCP_CURSOR2_UPDATE_TAKEN_TRUE                    = 0x1,
} DCP_CURSOR2_UPDATE_TAKEN;
typedef enum DCP_CURSOR2_UPDATE_LOCK {
	DCP_CURSOR2_UPDATE_LOCK_FALSE                    = 0x0,
	DCP_CURSOR2_UPDATE_LOCK_TRUE                     = 0x1,
} DCP_CURSOR2_UPDATE_LOCK;
typedef enum DCP_CURSOR2_DISABLE_MULTIPLE_UPDATE {
	DCP_CURSOR2_DISABLE_MULTIPLE_UPDATE_FALSE        = 0x0,
	DCP_CURSOR2_DISABLE_MULTIPLE_UPDATE_TRUE         = 0x1,
} DCP_CURSOR2_DISABLE_MULTIPLE_UPDATE;
typedef enum DCP_CURSOR2_UPDATE_STEREO_MODE {
	DCP_CURSOR2_UPDATE_STEREO_MODE_BOTH              = 0x0,
	DCP_CURSOR2_UPDATE_STEREO_MODE_SECONDARY_ONLY    = 0x1,
	DCP_CURSOR2_UPDATE_STEREO_MODE_UNDEFINED         = 0x2,
	DCP_CURSOR2_UPDATE_STEREO_MODE_PRIMARY_ONLY      = 0x3,
} DCP_CURSOR2_UPDATE_STEREO_MODE;
typedef enum DCP_CUR_REQUEST_FILTER_DIS {
	DCP_CUR_REQUEST_FILTER_DIS_FALSE                 = 0x0,
	DCP_CUR_REQUEST_FILTER_DIS_TRUE                  = 0x1,
} DCP_CUR_REQUEST_FILTER_DIS;
typedef enum DCP_CURSOR_STEREO_EN {
	DCP_CURSOR_STEREO_EN_FALSE                       = 0x0,
	DCP_CURSOR_STEREO_EN_TRUE                        = 0x1,
} DCP_CURSOR_STEREO_EN;
typedef enum DCP_CURSOR_STEREO_OFFSET_YNX {
	DCP_CURSOR_STEREO_OFFSET_YNX_X_POSITION          = 0x0,
	DCP_CURSOR_STEREO_OFFSET_YNX_Y_POSITION          = 0x1,
} DCP_CURSOR_STEREO_OFFSET_YNX;
typedef enum DCP_CURSOR2_STEREO_EN {
	DCP_CURSOR2_STEREO_EN_FALSE                      = 0x0,
	DCP_CURSOR2_STEREO_EN_TRUE                       = 0x1,
} DCP_CURSOR2_STEREO_EN;
typedef enum DCP_CURSOR2_STEREO_OFFSET_YNX {
	DCP_CURSOR2_STEREO_OFFSET_YNX_X_POSITION         = 0x0,
	DCP_CURSOR2_STEREO_OFFSET_YNX_Y_POSITION         = 0x1,
} DCP_CURSOR2_STEREO_OFFSET_YNX;
typedef enum DCP_DC_LUT_RW_MODE {
	DCP_DC_LUT_RW_MODE_256_ENTRY                     = 0x0,
	DCP_DC_LUT_RW_MODE_PWL                           = 0x1,
} DCP_DC_LUT_RW_MODE;
typedef enum DCP_DC_LUT_VGA_ACCESS_ENABLE {
	DCP_DC_LUT_VGA_ACCESS_ENABLE_FALSE               = 0x0,
	DCP_DC_LUT_VGA_ACCESS_ENABLE_TRUE                = 0x1,
} DCP_DC_LUT_VGA_ACCESS_ENABLE;
typedef enum DCP_DC_LUT_AUTOFILL {
	DCP_DC_LUT_AUTOFILL_FALSE                        = 0x0,
	DCP_DC_LUT_AUTOFILL_TRUE                         = 0x1,
} DCP_DC_LUT_AUTOFILL;
typedef enum DCP_DC_LUT_AUTOFILL_DONE {
	DCP_DC_LUT_AUTOFILL_DONE_FALSE                   = 0x0,
	DCP_DC_LUT_AUTOFILL_DONE_TRUE                    = 0x1,
} DCP_DC_LUT_AUTOFILL_DONE;
typedef enum DCP_DC_LUT_INC_B {
	DCP_DC_LUT_INC_B_NA                              = 0x0,
	DCP_DC_LUT_INC_B_2                               = 0x1,
	DCP_DC_LUT_INC_B_4                               = 0x2,
	DCP_DC_LUT_INC_B_8                               = 0x3,
	DCP_DC_LUT_INC_B_16                              = 0x4,
	DCP_DC_LUT_INC_B_32                              = 0x5,
	DCP_DC_LUT_INC_B_64                              = 0x6,
	DCP_DC_LUT_INC_B_128                             = 0x7,
	DCP_DC_LUT_INC_B_256                             = 0x8,
	DCP_DC_LUT_INC_B_512                             = 0x9,
} DCP_DC_LUT_INC_B;
typedef enum DCP_DC_LUT_DATA_B_SIGNED_EN {
	DCP_DC_LUT_DATA_B_SIGNED_EN_FALSE                = 0x0,
	DCP_DC_LUT_DATA_B_SIGNED_EN_TRUE                 = 0x1,
} DCP_DC_LUT_DATA_B_SIGNED_EN;
typedef enum DCP_DC_LUT_DATA_B_FLOAT_POINT_EN {
	DCP_DC_LUT_DATA_B_FLOAT_POINT_EN_FALSE           = 0x0,
	DCP_DC_LUT_DATA_B_FLOAT_POINT_EN_TRUE            = 0x1,
} DCP_DC_LUT_DATA_B_FLOAT_POINT_EN;
typedef enum DCP_DC_LUT_DATA_B_FORMAT {
	DCP_DC_LUT_DATA_B_FORMAT_U0P10                   = 0x0,
	DCP_DC_LUT_DATA_B_FORMAT_S1P10                   = 0x1,
	DCP_DC_LUT_DATA_B_FORMAT_U1P11                   = 0x2,
	DCP_DC_LUT_DATA_B_FORMAT_U0P12                   = 0x3,
} DCP_DC_LUT_DATA_B_FORMAT;
typedef enum DCP_DC_LUT_INC_G {
	DCP_DC_LUT_INC_G_NA                              = 0x0,
	DCP_DC_LUT_INC_G_2                               = 0x1,
	DCP_DC_LUT_INC_G_4                               = 0x2,
	DCP_DC_LUT_INC_G_8                               = 0x3,
	DCP_DC_LUT_INC_G_16                              = 0x4,
	DCP_DC_LUT_INC_G_32                              = 0x5,
	DCP_DC_LUT_INC_G_64                              = 0x6,
	DCP_DC_LUT_INC_G_128                             = 0x7,
	DCP_DC_LUT_INC_G_256                             = 0x8,
	DCP_DC_LUT_INC_G_512                             = 0x9,
} DCP_DC_LUT_INC_G;
typedef enum DCP_DC_LUT_DATA_G_SIGNED_EN {
	DCP_DC_LUT_DATA_G_SIGNED_EN_FALSE                = 0x0,
	DCP_DC_LUT_DATA_G_SIGNED_EN_TRUE                 = 0x1,
} DCP_DC_LUT_DATA_G_SIGNED_EN;
typedef enum DCP_DC_LUT_DATA_G_FLOAT_POINT_EN {
	DCP_DC_LUT_DATA_G_FLOAT_POINT_EN_FALSE           = 0x0,
	DCP_DC_LUT_DATA_G_FLOAT_POINT_EN_TRUE            = 0x1,
} DCP_DC_LUT_DATA_G_FLOAT_POINT_EN;
typedef enum DCP_DC_LUT_DATA_G_FORMAT {
	DCP_DC_LUT_DATA_G_FORMAT_U0P10                   = 0x0,
	DCP_DC_LUT_DATA_G_FORMAT_S1P10                   = 0x1,
	DCP_DC_LUT_DATA_G_FORMAT_U1P11                   = 0x2,
	DCP_DC_LUT_DATA_G_FORMAT_U0P12                   = 0x3,
} DCP_DC_LUT_DATA_G_FORMAT;
typedef enum DCP_DC_LUT_INC_R {
	DCP_DC_LUT_INC_R_NA                              = 0x0,
	DCP_DC_LUT_INC_R_2                               = 0x1,
	DCP_DC_LUT_INC_R_4                               = 0x2,
	DCP_DC_LUT_INC_R_8                               = 0x3,
	DCP_DC_LUT_INC_R_16                              = 0x4,
	DCP_DC_LUT_INC_R_32                              = 0x5,
	DCP_DC_LUT_INC_R_64                              = 0x6,
	DCP_DC_LUT_INC_R_128                             = 0x7,
	DCP_DC_LUT_INC_R_256                             = 0x8,
	DCP_DC_LUT_INC_R_512                             = 0x9,
} DCP_DC_LUT_INC_R;
typedef enum DCP_DC_LUT_DATA_R_SIGNED_EN {
	DCP_DC_LUT_DATA_R_SIGNED_EN_FALSE                = 0x0,
	DCP_DC_LUT_DATA_R_SIGNED_EN_TRUE                 = 0x1,
} DCP_DC_LUT_DATA_R_SIGNED_EN;
typedef enum DCP_DC_LUT_DATA_R_FLOAT_POINT_EN {
	DCP_DC_LUT_DATA_R_FLOAT_POINT_EN_FALSE           = 0x0,
	DCP_DC_LUT_DATA_R_FLOAT_POINT_EN_TRUE            = 0x1,
} DCP_DC_LUT_DATA_R_FLOAT_POINT_EN;
typedef enum DCP_DC_LUT_DATA_R_FORMAT {
	DCP_DC_LUT_DATA_R_FORMAT_U0P10                   = 0x0,
	DCP_DC_LUT_DATA_R_FORMAT_S1P10                   = 0x1,
	DCP_DC_LUT_DATA_R_FORMAT_U1P11                   = 0x2,
	DCP_DC_LUT_DATA_R_FORMAT_U0P12                   = 0x3,
} DCP_DC_LUT_DATA_R_FORMAT;
typedef enum DCP_CRC_ENABLE {
	DCP_CRC_ENABLE_FALSE                             = 0x0,
	DCP_CRC_ENABLE_TRUE                              = 0x1,
} DCP_CRC_ENABLE;
typedef enum DCP_CRC_SOURCE_SEL {
	DCP_CRC_SOURCE_SEL_OUTPUT_PIX                    = 0x0,
	DCP_CRC_SOURCE_SEL_INPUT_L32                     = 0x1,
	DCP_CRC_SOURCE_SEL_INPUT_H32                     = 0x2,
	DCP_CRC_SOURCE_SEL_OUTPUT_CNTL                   = 0x4,
} DCP_CRC_SOURCE_SEL;
typedef enum DCP_CRC_LINE_SEL {
	DCP_CRC_LINE_SEL_RESERVED                        = 0x0,
	DCP_CRC_LINE_SEL_EVEN                            = 0x1,
	DCP_CRC_LINE_SEL_ODD                             = 0x2,
	DCP_CRC_LINE_SEL_BOTH                            = 0x3,
} DCP_CRC_LINE_SEL;
typedef enum DCP_GRPH_FLIP_RATE {
	DCP_GRPH_FLIP_RATE_1FRAME                        = 0x0,
	DCP_GRPH_FLIP_RATE_2FRAME                        = 0x1,
	DCP_GRPH_FLIP_RATE_3FRAME                        = 0x2,
	DCP_GRPH_FLIP_RATE_4FRAME                        = 0x3,
	DCP_GRPH_FLIP_RATE_5FRAME                        = 0x4,
	DCP_GRPH_FLIP_RATE_6FRAME                        = 0x5,
	DCP_GRPH_FLIP_RATE_7FRAME                        = 0x6,
	DCP_GRPH_FLIP_RATE_8FRAME                        = 0x7,
} DCP_GRPH_FLIP_RATE;
typedef enum DCP_GRPH_FLIP_RATE_ENABLE {
	DCP_GRPH_FLIP_RATE_ENABLE_FALSE                  = 0x0,
	DCP_GRPH_FLIP_RATE_ENABLE_TRUE                   = 0x1,
} DCP_GRPH_FLIP_RATE_ENABLE;
typedef enum DCP_GSL0_EN {
	DCP_GSL0_EN_FALSE                                = 0x0,
	DCP_GSL0_EN_TRUE                                 = 0x1,
} DCP_GSL0_EN;
typedef enum DCP_GSL1_EN {
	DCP_GSL1_EN_FALSE                                = 0x0,
	DCP_GSL1_EN_TRUE                                 = 0x1,
} DCP_GSL1_EN;
typedef enum DCP_GSL2_EN {
	DCP_GSL2_EN_FALSE                                = 0x0,
	DCP_GSL2_EN_TRUE                                 = 0x1,
} DCP_GSL2_EN;
typedef enum DCP_GSL_MASTER_EN {
	DCP_GSL_MASTER_EN_FALSE                          = 0x0,
	DCP_GSL_MASTER_EN_TRUE                           = 0x1,
} DCP_GSL_MASTER_EN;
typedef enum DCP_GSL_XDMA_GROUP {
	DCP_GSL_XDMA_GROUP_VSYNC                         = 0x0,
	DCP_GSL_XDMA_GROUP_HSYNC0                        = 0x1,
	DCP_GSL_XDMA_GROUP_HSYNC1                        = 0x2,
	DCP_GSL_XDMA_GROUP_HSYNC2                        = 0x3,
} DCP_GSL_XDMA_GROUP;
typedef enum DCP_GSL_XDMA_GROUP_UNDERFLOW_EN {
	DCP_GSL_XDMA_GROUP_UNDERFLOW_EN_FALSE            = 0x0,
	DCP_GSL_XDMA_GROUP_UNDERFLOW_EN_TRUE             = 0x1,
} DCP_GSL_XDMA_GROUP_UNDERFLOW_EN;
typedef enum DCP_GSL_SYNC_SOURCE {
	DCP_GSL_SYNC_SOURCE_FLIP                         = 0x0,
	DCP_GSL_SYNC_SOURCE_PHASE0                       = 0x1,
	DCP_GSL_SYNC_SOURCE_RESET                        = 0x2,
	DCP_GSL_SYNC_SOURCE_PHASE1                       = 0x3,
} DCP_GSL_SYNC_SOURCE;
typedef enum DCP_GSL_DELAY_SURFACE_UPDATE_PENDING {
	DCP_GSL_DELAY_SURFACE_UPDATE_PENDING_FALSE       = 0x0,
	DCP_GSL_DELAY_SURFACE_UPDATE_PENDING_TRUE        = 0x1,
} DCP_GSL_DELAY_SURFACE_UPDATE_PENDING;
typedef enum DCP_TEST_DEBUG_WRITE_EN {
	DCP_TEST_DEBUG_WRITE_EN_FALSE                    = 0x0,
	DCP_TEST_DEBUG_WRITE_EN_TRUE                     = 0x1,
} DCP_TEST_DEBUG_WRITE_EN;
typedef enum DCP_GRPH_STEREOSYNC_FLIP_EN {
	DCP_GRPH_STEREOSYNC_FLIP_EN_FALSE                = 0x0,
	DCP_GRPH_STEREOSYNC_FLIP_EN_TRUE                 = 0x1,
} DCP_GRPH_STEREOSYNC_FLIP_EN;
typedef enum DCP_GRPH_STEREOSYNC_FLIP_MODE {
	DCP_GRPH_STEREOSYNC_FLIP_MODE_FLIP               = 0x0,
	DCP_GRPH_STEREOSYNC_FLIP_MODE_PHASE0             = 0x1,
	DCP_GRPH_STEREOSYNC_FLIP_MODE_RESET              = 0x2,
	DCP_GRPH_STEREOSYNC_FLIP_MODE_PHASE1             = 0x3,
} DCP_GRPH_STEREOSYNC_FLIP_MODE;
typedef enum DCP_GRPH_STEREOSYNC_SELECT_DISABLE {
	DCP_GRPH_STEREOSYNC_SELECT_DISABLE_FALSE         = 0x0,
	DCP_GRPH_STEREOSYNC_SELECT_DISABLE_TRUE          = 0x1,
} DCP_GRPH_STEREOSYNC_SELECT_DISABLE;
typedef enum DCP_GRPH_ROTATION_ANGLE {
	DCP_GRPH_ROTATION_ANGLE_0                        = 0x0,
	DCP_GRPH_ROTATION_ANGLE_90                       = 0x1,
	DCP_GRPH_ROTATION_ANGLE_180                      = 0x2,
	DCP_GRPH_ROTATION_ANGLE_270                      = 0x3,
} DCP_GRPH_ROTATION_ANGLE;
typedef enum DCP_GRPH_XDMA_CACHE_UNDERFLOW_CNT_EN {
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_CNT_EN_FALSE       = 0x0,
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_CNT_EN_TRUE        = 0x1,
} DCP_GRPH_XDMA_CACHE_UNDERFLOW_CNT_EN;
typedef enum DCP_GRPH_XDMA_CACHE_UNDERFLOW_CNT_MODE {
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_CNT_MODE_RELY_NUM  = 0x0,
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_CNT_MODE_RELY_ENABLE= 0x1,
} DCP_GRPH_XDMA_CACHE_UNDERFLOW_CNT_MODE;
typedef enum DCP_GRPH_REGAMMA_MODE {
	DCP_GRPH_REGAMMA_MODE_BYPASS                     = 0x0,
	DCP_GRPH_REGAMMA_MODE_SRGB                       = 0x1,
	DCP_GRPH_REGAMMA_MODE_XVYCC                      = 0x2,
	DCP_GRPH_REGAMMA_MODE_PROGA                      = 0x3,
	DCP_GRPH_REGAMMA_MODE_PROGB                      = 0x4,
} DCP_GRPH_REGAMMA_MODE;
typedef enum DCP_ALPHA_ROUND_TRUNC_MODE {
	DCP_ALPHA_ROUND_TRUNC_MODE_ROUND                 = 0x0,
	DCP_ALPHA_ROUND_TRUNC_MODE_TRUNC                 = 0x1,
} DCP_ALPHA_ROUND_TRUNC_MODE;
typedef enum DCP_CURSOR_ALPHA_BLND_ENA {
	DCP_CURSOR_ALPHA_BLND_ENA_FALSE                  = 0x0,
	DCP_CURSOR_ALPHA_BLND_ENA_TRUE                   = 0x1,
} DCP_CURSOR_ALPHA_BLND_ENA;
typedef enum DCP_GRPH_XDMA_CACHE_UNDERFLOW_FRAME_MASK {
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_FRAME_MASK_FALSE   = 0x0,
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_FRAME_MASK_TRUE    = 0x1,
} DCP_GRPH_XDMA_CACHE_UNDERFLOW_FRAME_MASK;
typedef enum DCP_GRPH_XDMA_CACHE_UNDERFLOW_FRAME_ACK {
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_FRAME_ACK_FALSE    = 0x0,
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_FRAME_ACK_TRUE     = 0x1,
} DCP_GRPH_XDMA_CACHE_UNDERFLOW_FRAME_ACK;
typedef enum DCP_GRPH_XDMA_CACHE_UNDERFLOW_INT_MASK {
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_INT_MASK_FALSE     = 0x0,
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_INT_MASK_TRUE      = 0x1,
} DCP_GRPH_XDMA_CACHE_UNDERFLOW_INT_MASK;
typedef enum DCP_GRPH_XDMA_CACHE_UNDERFLOW_INT_ACK {
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_INT_ACK_FALSE      = 0x0,
	DCP_GRPH_XDMA_CACHE_UNDERFLOW_INT_ACK_TRUE       = 0x1,
} DCP_GRPH_XDMA_CACHE_UNDERFLOW_INT_ACK;
typedef enum DCP_GRPH_SURFACE_COUNTER_EN {
	DCP_GRPH_SURFACE_COUNTER_EN_DISABLE              = 0x0,
	DCP_GRPH_SURFACE_COUNTER_EN_ENABLE               = 0x1,
} DCP_GRPH_SURFACE_COUNTER_EN;
typedef enum DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT {
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_0          = 0x0,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_1          = 0x1,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_2          = 0x2,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_3          = 0x3,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_4          = 0x4,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_5          = 0x5,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_6          = 0x6,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_7          = 0x7,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_8          = 0x8,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_9          = 0x9,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_10         = 0xa,
	DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT_11         = 0xb,
} DCP_GRPH_SURFACE_COUNTER_EVENT_SELECT;
typedef enum DCP_GRPH_SURFACE_COUNTER_ERR_WRAP_OCCURED {
	DCP_GRPH_SURFACE_COUNTER_ERR_WRAP_OCCURED_NO     = 0x0,
	DCP_GRPH_SURFACE_COUNTER_ERR_WRAP_OCCURED_YES    = 0x1,
} DCP_GRPH_SURFACE_COUNTER_ERR_WRAP_OCCURED;
typedef enum HDMI_KEEPOUT_MODE {
	HDMI_KEEPOUT_0_650PIX_AFTER_VSYNC                = 0x0,
	HDMI_KEEPOUT_509_650PIX_AFTER_VSYNC              = 0x1,
} HDMI_KEEPOUT_MODE;
typedef enum HDMI_CLOCK_CHANNEL_RATE {
	HDMI_CLOCK_CHANNEL_FREQ_EQUAL_TO_CHAR_RATE       = 0x0,
	HDMI_CLOCK_CHANNEL_FREQ_QUARTER_TO_CHAR_RATE     = 0x1,
} HDMI_CLOCK_CHANNEL_RATE;
typedef enum HDMI_NO_EXTRA_NULL_PACKET_FILLED {
	HDMI_EXTRA_NULL_PACKET_FILLED_ENABLE             = 0x0,
	HDMI_EXTRA_NULL_PACKET_FILLED_DISABLE            = 0x1,
} HDMI_NO_EXTRA_NULL_PACKET_FILLED;
typedef enum HDMI_PACKET_GEN_VERSION {
	HDMI_PACKET_GEN_VERSION_OLD                      = 0x0,
	HDMI_PACKET_GEN_VERSION_NEW                      = 0x1,
} HDMI_PACKET_GEN_VERSION;
typedef enum HDMI_ERROR_ACK {
	HDMI_ERROR_ACK_INT                               = 0x0,
	HDMI_ERROR_NOT_ACK                               = 0x1,
} HDMI_ERROR_ACK;
typedef enum HDMI_ERROR_MASK {
	HDMI_ERROR_MASK_INT                              = 0x0,
	HDMI_ERROR_NOT_MASK                              = 0x1,
} HDMI_ERROR_MASK;
typedef enum HDMI_DEEP_COLOR_DEPTH {
	HDMI_DEEP_COLOR_DEPTH_24BPP                      = 0x0,
	HDMI_DEEP_COLOR_DEPTH_30BPP                      = 0x1,
	HDMI_DEEP_COLOR_DEPTH_36BPP                      = 0x2,
	HDMI_DEEP_COLOR_DEPTH_RESERVED                   = 0x3,
} HDMI_DEEP_COLOR_DEPTH;
typedef enum HDMI_AUDIO_DELAY_EN {
	HDMI_AUDIO_DELAY_DISABLE                         = 0x0,
	HDMI_AUDIO_DELAY_58CLK                           = 0x1,
	HDMI_AUDIO_DELAY_56CLK                           = 0x2,
	HDMI_AUDIO_DELAY_RESERVED                        = 0x3,
} HDMI_AUDIO_DELAY_EN;
typedef enum HDMI_AUDIO_SEND_MAX_PACKETS {
	HDMI_NOT_SEND_MAX_AUDIO_PACKETS                  = 0x0,
	HDMI_SEND_MAX_AUDIO_PACKETS                      = 0x1,
} HDMI_AUDIO_SEND_MAX_PACKETS;
typedef enum HDMI_ACR_SEND {
	HDMI_ACR_NOT_SEND                                = 0x0,
	HDMI_ACR_PKT_SEND                                = 0x1,
} HDMI_ACR_SEND;
typedef enum HDMI_ACR_CONT {
	HDMI_ACR_CONT_DISABLE                            = 0x0,
	HDMI_ACR_CONT_ENABLE                             = 0x1,
} HDMI_ACR_CONT;
typedef enum HDMI_ACR_SELECT {
	HDMI_ACR_SELECT_HW                               = 0x0,
	HDMI_ACR_SELECT_32K                              = 0x1,
	HDMI_ACR_SELECT_44K                              = 0x2,
	HDMI_ACR_SELECT_48K                              = 0x3,
} HDMI_ACR_SELECT;
typedef enum HDMI_ACR_SOURCE {
	HDMI_ACR_SOURCE_HW                               = 0x0,
	HDMI_ACR_SOURCE_SW                               = 0x1,
} HDMI_ACR_SOURCE;
typedef enum HDMI_ACR_N_MULTIPLE {
	HDMI_ACR_0_MULTIPLE_RESERVED                     = 0x0,
	HDMI_ACR_1_MULTIPLE                              = 0x1,
	HDMI_ACR_2_MULTIPLE                              = 0x2,
	HDMI_ACR_3_MULTIPLE_RESERVED                     = 0x3,
	HDMI_ACR_4_MULTIPLE                              = 0x4,
	HDMI_ACR_5_MULTIPLE_RESERVED                     = 0x5,
	HDMI_ACR_6_MULTIPLE_RESERVED                     = 0x6,
	HDMI_ACR_7_MULTIPLE_RESERVED                     = 0x7,
} HDMI_ACR_N_MULTIPLE;
typedef enum HDMI_ACR_AUDIO_PRIORITY {
	HDMI_ACR_PKT_HIGH_PRIORITY_THAN_AUDIO_SAMPLE     = 0x0,
	HDMI_AUDIO_SAMPLE_HIGH_PRIORITY_THAN_ACR_PKT     = 0x1,
} HDMI_ACR_AUDIO_PRIORITY;
typedef enum HDMI_NULL_SEND {
	HDMI_NULL_NOT_SEND                               = 0x0,
	HDMI_NULL_PKT_SEND                               = 0x1,
} HDMI_NULL_SEND;
typedef enum HDMI_GC_SEND {
	HDMI_GC_NOT_SEND                                 = 0x0,
	HDMI_GC_PKT_SEND                                 = 0x1,
} HDMI_GC_SEND;
typedef enum HDMI_GC_CONT {
	HDMI_GC_CONT_DISABLE                             = 0x0,
	HDMI_GC_CONT_ENABLE                              = 0x1,
} HDMI_GC_CONT;
typedef enum HDMI_ISRC_SEND {
	HDMI_ISRC_NOT_SEND                               = 0x0,
	HDMI_ISRC_PKT_SEND                               = 0x1,
} HDMI_ISRC_SEND;
typedef enum HDMI_ISRC_CONT {
	HDMI_ISRC_CONT_DISABLE                           = 0x0,
	HDMI_ISRC_CONT_ENABLE                            = 0x1,
} HDMI_ISRC_CONT;
typedef enum HDMI_AVI_INFO_SEND {
	HDMI_AVI_INFO_NOT_SEND                           = 0x0,
	HDMI_AVI_INFO_PKT_SEND                           = 0x1,
} HDMI_AVI_INFO_SEND;
typedef enum HDMI_AVI_INFO_CONT {
	HDMI_AVI_INFO_CONT_DISABLE                       = 0x0,
	HDMI_AVI_INFO_CONT_ENABLE                        = 0x1,
} HDMI_AVI_INFO_CONT;
typedef enum HDMI_AUDIO_INFO_SEND {
	HDMI_AUDIO_INFO_NOT_SEND                         = 0x0,
	HDMI_AUDIO_INFO_PKT_SEND                         = 0x1,
} HDMI_AUDIO_INFO_SEND;
typedef enum HDMI_AUDIO_INFO_CONT {
	HDMI_AUDIO_INFO_CONT_DISABLE                     = 0x0,
	HDMI_AUDIO_INFO_CONT_ENABLE                      = 0x1,
} HDMI_AUDIO_INFO_CONT;
typedef enum HDMI_MPEG_INFO_SEND {
	HDMI_MPEG_INFO_NOT_SEND                          = 0x0,
	HDMI_MPEG_INFO_PKT_SEND                          = 0x1,
} HDMI_MPEG_INFO_SEND;
typedef enum HDMI_MPEG_INFO_CONT {
	HDMI_MPEG_INFO_CONT_DISABLE                      = 0x0,
	HDMI_MPEG_INFO_CONT_ENABLE                       = 0x1,
} HDMI_MPEG_INFO_CONT;
typedef enum HDMI_GENERIC0_SEND {
	HDMI_GENERIC0_NOT_SEND                           = 0x0,
	HDMI_GENERIC0_PKT_SEND                           = 0x1,
} HDMI_GENERIC0_SEND;
typedef enum HDMI_GENERIC0_CONT {
	HDMI_GENERIC0_CONT_DISABLE                       = 0x0,
	HDMI_GENERIC0_CONT_ENABLE                        = 0x1,
} HDMI_GENERIC0_CONT;
typedef enum HDMI_GENERIC1_SEND {
	HDMI_GENERIC1_NOT_SEND                           = 0x0,
	HDMI_GENERIC1_PKT_SEND                           = 0x1,
} HDMI_GENERIC1_SEND;
typedef enum HDMI_GENERIC1_CONT {
	HDMI_GENERIC1_CONT_DISABLE                       = 0x0,
	HDMI_GENERIC1_CONT_ENABLE                        = 0x1,
} HDMI_GENERIC1_CONT;
typedef enum HDMI_GC_AVMUTE_CONT {
	HDMI_GC_AVMUTE_CONT_DISABLE                      = 0x0,
	HDMI_GC_AVMUTE_CONT_ENABLE                       = 0x1,
} HDMI_GC_AVMUTE_CONT;
typedef enum HDMI_PACKING_PHASE_OVERRIDE {
	HDMI_PACKING_PHASE_SET_BY_HW                     = 0x0,
	HDMI_PACKING_PHASE_SET_BY_SW                     = 0x1,
} HDMI_PACKING_PHASE_OVERRIDE;
typedef enum HDMI_GENERIC2_SEND {
	HDMI_GENERIC2_NOT_SEND                           = 0x0,
	HDMI_GENERIC2_PKT_SEND                           = 0x1,
} HDMI_GENERIC2_SEND;
typedef enum HDMI_GENERIC2_CONT {
	HDMI_GENERIC2_CONT_DISABLE                       = 0x0,
	HDMI_GENERIC2_CONT_ENABLE                        = 0x1,
} HDMI_GENERIC2_CONT;
typedef enum HDMI_GENERIC3_SEND {
	HDMI_GENERIC3_NOT_SEND                           = 0x0,
	HDMI_GENERIC3_PKT_SEND                           = 0x1,
} HDMI_GENERIC3_SEND;
typedef enum HDMI_GENERIC3_CONT {
	HDMI_GENERIC3_CONT_DISABLE                       = 0x0,
	HDMI_GENERIC3_CONT_ENABLE                        = 0x1,
} HDMI_GENERIC3_CONT;
typedef enum TMDS_PIXEL_ENCODING {
	TMDS_PIXEL_ENCODING_444_OR_420                   = 0x0,
	TMDS_PIXEL_ENCODING_422                          = 0x1,
} TMDS_PIXEL_ENCODING;
typedef enum TMDS_COLOR_FORMAT {
	TMDS_COLOR_FORMAT__24BPP__TWIN30BPP_MSB__DUAL48BPP= 0x0,
	TMDS_COLOR_FORMAT_TWIN30BPP_LSB                  = 0x1,
	TMDS_COLOR_FORMAT_DUAL30BPP                      = 0x2,
	TMDS_COLOR_FORMAT_RESERVED                       = 0x3,
} TMDS_COLOR_FORMAT;
typedef enum TMDS_STEREOSYNC_CTL_SEL_REG {
	TMDS_STEREOSYNC_CTL0                             = 0x0,
	TMDS_STEREOSYNC_CTL1                             = 0x1,
	TMDS_STEREOSYNC_CTL2                             = 0x2,
	TMDS_STEREOSYNC_CTL3                             = 0x3,
} TMDS_STEREOSYNC_CTL_SEL_REG;
typedef enum TMDS_CTL0_DATA_SEL {
	TMDS_CTL0_DATA_SEL0_RESERVED                     = 0x0,
	TMDS_CTL0_DATA_SEL1_DISPLAY_ENABLE               = 0x1,
	TMDS_CTL0_DATA_SEL2_VSYNC                        = 0x2,
	TMDS_CTL0_DATA_SEL3_RESERVED                     = 0x3,
	TMDS_CTL0_DATA_SEL4_HSYNC                        = 0x4,
	TMDS_CTL0_DATA_SEL5_SEL7_RESERVED                = 0x5,
	TMDS_CTL0_DATA_SEL8_RANDOM_DATA                  = 0x6,
	TMDS_CTL0_DATA_SEL9_SEL15_RANDOM_DATA            = 0x7,
} TMDS_CTL0_DATA_SEL;
typedef enum TMDS_CTL0_DATA_INVERT {
	TMDS_CTL0_DATA_NORMAL                            = 0x0,
	TMDS_CTL0_DATA_INVERT_EN                         = 0x1,
} TMDS_CTL0_DATA_INVERT;
typedef enum TMDS_CTL0_DATA_MODULATION {
	TMDS_CTL0_DATA_MODULATION_DISABLE                = 0x0,
	TMDS_CTL0_DATA_MODULATION_BIT0                   = 0x1,
	TMDS_CTL0_DATA_MODULATION_BIT1                   = 0x2,
	TMDS_CTL0_DATA_MODULATION_BIT2                   = 0x3,
} TMDS_CTL0_DATA_MODULATION;
typedef enum TMDS_CTL0_PATTERN_OUT_EN {
	TMDS_CTL0_PATTERN_OUT_DISABLE                    = 0x0,
	TMDS_CTL0_PATTERN_OUT_ENABLE                     = 0x1,
} TMDS_CTL0_PATTERN_OUT_EN;
typedef enum TMDS_CTL1_DATA_SEL {
	TMDS_CTL1_DATA_SEL0_RESERVED                     = 0x0,
	TMDS_CTL1_DATA_SEL1_DISPLAY_ENABLE               = 0x1,
	TMDS_CTL1_DATA_SEL2_VSYNC                        = 0x2,
	TMDS_CTL1_DATA_SEL3_RESERVED                     = 0x3,
	TMDS_CTL1_DATA_SEL4_HSYNC                        = 0x4,
	TMDS_CTL1_DATA_SEL5_SEL7_RESERVED                = 0x5,
	TMDS_CTL1_DATA_SEL8_BLANK_TIME                   = 0x6,
	TMDS_CTL1_DATA_SEL9_SEL15_RESERVED               = 0x7,
} TMDS_CTL1_DATA_SEL;
typedef enum TMDS_CTL1_DATA_INVERT {
	TMDS_CTL1_DATA_NORMAL                            = 0x0,
	TMDS_CTL1_DATA_INVERT_EN                         = 0x1,
} TMDS_CTL1_DATA_INVERT;
typedef enum TMDS_CTL1_DATA_MODULATION {
	TMDS_CTL1_DATA_MODULATION_DISABLE                = 0x0,
	TMDS_CTL1_DATA_MODULATION_BIT0                   = 0x1,
	TMDS_CTL1_DATA_MODULATION_BIT1                   = 0x2,
	TMDS_CTL1_DATA_MODULATION_BIT2                   = 0x3,
} TMDS_CTL1_DATA_MODULATION;
typedef enum TMDS_CTL1_PATTERN_OUT_EN {
	TMDS_CTL1_PATTERN_OUT_DISABLE                    = 0x0,
	TMDS_CTL1_PATTERN_OUT_ENABLE                     = 0x1,
} TMDS_CTL1_PATTERN_OUT_EN;
typedef enum TMDS_CTL2_DATA_SEL {
	TMDS_CTL2_DATA_SEL0_RESERVED                     = 0x0,
	TMDS_CTL2_DATA_SEL1_DISPLAY_ENABLE               = 0x1,
	TMDS_CTL2_DATA_SEL2_VSYNC                        = 0x2,
	TMDS_CTL2_DATA_SEL3_RESERVED                     = 0x3,
	TMDS_CTL2_DATA_SEL4_HSYNC                        = 0x4,
	TMDS_CTL2_DATA_SEL5_SEL7_RESERVED                = 0x5,
	TMDS_CTL2_DATA_SEL8_BLANK_TIME                   = 0x6,
	TMDS_CTL2_DATA_SEL9_SEL15_RESERVED               = 0x7,
} TMDS_CTL2_DATA_SEL;
typedef enum TMDS_CTL2_DATA_INVERT {
	TMDS_CTL2_DATA_NORMAL                            = 0x0,
	TMDS_CTL2_DATA_INVERT_EN                         = 0x1,
} TMDS_CTL2_DATA_INVERT;
typedef enum TMDS_CTL2_DATA_MODULATION {
	TMDS_CTL2_DATA_MODULATION_DISABLE                = 0x0,
	TMDS_CTL2_DATA_MODULATION_BIT0                   = 0x1,
	TMDS_CTL2_DATA_MODULATION_BIT1                   = 0x2,
	TMDS_CTL2_DATA_MODULATION_BIT2                   = 0x3,
} TMDS_CTL2_DATA_MODULATION;
typedef enum TMDS_CTL2_PATTERN_OUT_EN {
	TMDS_CTL2_PATTERN_OUT_DISABLE                    = 0x0,
	TMDS_CTL2_PATTERN_OUT_ENABLE                     = 0x1,
} TMDS_CTL2_PATTERN_OUT_EN;
typedef enum TMDS_CTL3_DATA_INVERT {
	TMDS_CTL3_DATA_NORMAL                            = 0x0,
	TMDS_CTL3_DATA_INVERT_EN                         = 0x1,
} TMDS_CTL3_DATA_INVERT;
typedef enum TMDS_CTL3_DATA_MODULATION {
	TMDS_CTL3_DATA_MODULATION_DISABLE                = 0x0,
	TMDS_CTL3_DATA_MODULATION_BIT0                   = 0x1,
	TMDS_CTL3_DATA_MODULATION_BIT1                   = 0x2,
	TMDS_CTL3_DATA_MODULATION_BIT2                   = 0x3,
} TMDS_CTL3_DATA_MODULATION;
typedef enum TMDS_CTL3_PATTERN_OUT_EN {
	TMDS_CTL3_PATTERN_OUT_DISABLE                    = 0x0,
	TMDS_CTL3_PATTERN_OUT_ENABLE                     = 0x1,
} TMDS_CTL3_PATTERN_OUT_EN;
typedef enum TMDS_CTL3_DATA_SEL {
	TMDS_CTL3_DATA_SEL0_RESERVED                     = 0x0,
	TMDS_CTL3_DATA_SEL1_DISPLAY_ENABLE               = 0x1,
	TMDS_CTL3_DATA_SEL2_VSYNC                        = 0x2,
	TMDS_CTL3_DATA_SEL3_RESERVED                     = 0x3,
	TMDS_CTL3_DATA_SEL4_HSYNC                        = 0x4,
	TMDS_CTL3_DATA_SEL5_SEL7_RESERVED                = 0x5,
	TMDS_CTL3_DATA_SEL8_BLANK_TIME                   = 0x6,
	TMDS_CTL3_DATA_SEL9_SEL15_RESERVED               = 0x7,
} TMDS_CTL3_DATA_SEL;
typedef enum DIG_FE_CNTL_SOURCE_SELECT {
	DIG_FE_SOURCE_FROM_FMT0                          = 0x0,
	DIG_FE_SOURCE_FROM_FMT1                          = 0x1,
	DIG_FE_SOURCE_FROM_FMT2                          = 0x2,
	DIG_FE_SOURCE_FROM_FMT3                          = 0x3,
	DIG_FE_SOURCE_FROM_FMT4                          = 0x4,
	DIG_FE_SOURCE_FROM_FMT5                          = 0x5,
} DIG_FE_CNTL_SOURCE_SELECT;
typedef enum DIG_FE_CNTL_STEREOSYNC_SELECT {
	DIG_FE_STEREOSYNC_FROM_FMT0                      = 0x0,
	DIG_FE_STEREOSYNC_FROM_FMT1                      = 0x1,
	DIG_FE_STEREOSYNC_FROM_FMT2                      = 0x2,
	DIG_FE_STEREOSYNC_FROM_FMT3                      = 0x3,
	DIG_FE_STEREOSYNC_FROM_FMT4                      = 0x4,
	DIG_FE_STEREOSYNC_FROM_FMT5                      = 0x5,
} DIG_FE_CNTL_STEREOSYNC_SELECT;
typedef enum DIG_FIFO_READ_CLOCK_SRC {
	DIG_FIFO_READ_CLOCK_SRC_FROM_DCCG                = 0x0,
	DIG_FIFO_READ_CLOCK_SRC_FROM_DISPLAY_PIPE        = 0x1,
} DIG_FIFO_READ_CLOCK_SRC;
typedef enum DIG_OUTPUT_CRC_CNTL_LINK_SEL {
	DIG_OUTPUT_CRC_ON_LINK0                          = 0x0,
	DIG_OUTPUT_CRC_ON_LINK1                          = 0x1,
} DIG_OUTPUT_CRC_CNTL_LINK_SEL;
typedef enum DIG_OUTPUT_CRC_DATA_SEL {
	DIG_OUTPUT_CRC_FOR_FULLFRAME                     = 0x0,
	DIG_OUTPUT_CRC_FOR_ACTIVEONLY                    = 0x1,
	DIG_OUTPUT_CRC_FOR_VBI                           = 0x2,
	DIG_OUTPUT_CRC_FOR_AUDIO                         = 0x3,
} DIG_OUTPUT_CRC_DATA_SEL;
typedef enum DIG_TEST_PATTERN_TEST_PATTERN_OUT_EN {
	DIG_IN_NORMAL_OPERATION                          = 0x0,
	DIG_IN_DEBUG_MODE                                = 0x1,
} DIG_TEST_PATTERN_TEST_PATTERN_OUT_EN;
typedef enum DIG_TEST_PATTERN_HALF_CLOCK_PATTERN_SEL {
	DIG_10BIT_TEST_PATTERN                           = 0x0,
	DIG_ALTERNATING_TEST_PATTERN                     = 0x1,
} DIG_TEST_PATTERN_HALF_CLOCK_PATTERN_SEL;
typedef enum DIG_TEST_PATTERN_RANDOM_PATTERN_OUT_EN {
	DIG_TEST_PATTERN_NORMAL                          = 0x0,
	DIG_TEST_PATTERN_RANDOM                          = 0x1,
} DIG_TEST_PATTERN_RANDOM_PATTERN_OUT_EN;
typedef enum DIG_TEST_PATTERN_RANDOM_PATTERN_RESET {
	DIG_RANDOM_PATTERN_ENABLED                       = 0x0,
	DIG_RANDOM_PATTERN_RESETED                       = 0x1,
} DIG_TEST_PATTERN_RANDOM_PATTERN_RESET;
typedef enum DIG_TEST_PATTERN_EXTERNAL_RESET_EN {
	DIG_TEST_PATTERN_EXTERNAL_RESET_ENABLE           = 0x0,
	DIG_TEST_PATTERN_EXTERNAL_RESET_BY_EXT_SIG       = 0x1,
} DIG_TEST_PATTERN_EXTERNAL_RESET_EN;
typedef enum DIG_RANDOM_PATTERN_SEED_RAN_PAT {
	DIG_RANDOM_PATTERN_SEED_RAN_PAT_ALL_PIXELS       = 0x0,
	DIG_RANDOM_PATTERN_SEED_RAN_PAT_DE_HIGH          = 0x1,
} DIG_RANDOM_PATTERN_SEED_RAN_PAT;
typedef enum DIG_FIFO_STATUS_USE_OVERWRITE_LEVEL {
	DIG_FIFO_USE_OVERWRITE_LEVEL                     = 0x0,
	DIG_FIFO_USE_CAL_AVERAGE_LEVEL                   = 0x1,
} DIG_FIFO_STATUS_USE_OVERWRITE_LEVEL;
typedef enum DIG_FIFO_ERROR_ACK {
	DIG_FIFO_ERROR_ACK_INT                           = 0x0,
	DIG_FIFO_ERROR_NOT_ACK                           = 0x1,
} DIG_FIFO_ERROR_ACK;
typedef enum DIG_FIFO_STATUS_FORCE_RECAL_AVERAGE {
	DIG_FIFO_NOT_FORCE_RECAL_AVERAGE                 = 0x0,
	DIG_FIFO_FORCE_RECAL_AVERAGE_LEVEL               = 0x1,
} DIG_FIFO_STATUS_FORCE_RECAL_AVERAGE;
typedef enum DIG_FIFO_STATUS_FORCE_RECOMP_MINMAX {
	DIG_FIFO_NOT_FORCE_RECOMP_MINMAX                 = 0x0,
	DIG_FIFO_FORCE_RECOMP_MINMAX                     = 0x1,
} DIG_FIFO_STATUS_FORCE_RECOMP_MINMAX;
typedef enum DIG_DISPCLK_SWITCH_CNTL_SWITCH_POINT {
	DIG_DISPCLK_SWITCH_AT_EARLY_VBLANK               = 0x0,
	DIG_DISPCLK_SWITCH_AT_FIRST_HSYNC                = 0x1,
} DIG_DISPCLK_SWITCH_CNTL_SWITCH_POINT;
typedef enum DIG_DISPCLK_SWITCH_ALLOWED_INT_ACK {
	DIG_DISPCLK_SWITCH_ALLOWED_ACK_INT               = 0x0,
	DIG_DISPCLK_SWITCH_ALLOWED_INT_NOT_ACK           = 0x1,
} DIG_DISPCLK_SWITCH_ALLOWED_INT_ACK;
typedef enum DIG_DISPCLK_SWITCH_ALLOWED_INT_MASK {
	DIG_DISPCLK_SWITCH_ALLOWED_MASK_INT              = 0x0,
	DIG_DISPCLK_SWITCH_ALLOWED_INT_UNMASK            = 0x1,
} DIG_DISPCLK_SWITCH_ALLOWED_INT_MASK;
typedef enum AFMT_INTERRUPT_STATUS_CHG_MASK {
	AFMT_INTERRUPT_DISABLE                           = 0x0,
	AFMT_INTERRUPT_ENABLE                            = 0x1,
} AFMT_INTERRUPT_STATUS_CHG_MASK;
typedef enum HDMI_GC_AVMUTE {
	HDMI_GC_AVMUTE_SET                               = 0x0,
	HDMI_GC_AVMUTE_UNSET                             = 0x1,
} HDMI_GC_AVMUTE;
typedef enum HDMI_DEFAULT_PAHSE {
	HDMI_DEFAULT_PHASE_IS_0                          = 0x0,
	HDMI_DEFAULT_PHASE_IS_1                          = 0x1,
} HDMI_DEFAULT_PAHSE;
typedef enum AFMT_AUDIO_PACKET_CONTROL2_AUDIO_LAYOUT_OVRD {
	AFMT_AUDIO_LAYOUT_DETERMINED_BY_AZ_AUDIO_CHANNEL_STATUS= 0x0,
	AFMT_AUDIO_LAYOUT_OVRD_BY_REGISTER               = 0x1,
} AFMT_AUDIO_PACKET_CONTROL2_AUDIO_LAYOUT_OVRD;
typedef enum AUDIO_LAYOUT_SELECT {
	AUDIO_LAYOUT_0                                   = 0x0,
	AUDIO_LAYOUT_1                                   = 0x1,
} AUDIO_LAYOUT_SELECT;
typedef enum AFMT_AUDIO_CRC_CONTROL_CONT {
	AFMT_AUDIO_CRC_ONESHOT                           = 0x0,
	AFMT_AUDIO_CRC_AUTO_RESTART                      = 0x1,
} AFMT_AUDIO_CRC_CONTROL_CONT;
typedef enum AFMT_AUDIO_CRC_CONTROL_SOURCE {
	AFMT_AUDIO_CRC_SOURCE_FROM_FIFO_INPUT            = 0x0,
	AFMT_AUDIO_CRC_SOURCE_FROM_FIFO_OUTPUT           = 0x1,
} AFMT_AUDIO_CRC_CONTROL_SOURCE;
typedef enum AFMT_AUDIO_CRC_CONTROL_CH_SEL {
	AFMT_AUDIO_CRC_CH0_SIG                           = 0x0,
	AFMT_AUDIO_CRC_CH1_SIG                           = 0x1,
	AFMT_AUDIO_CRC_CH2_SIG                           = 0x2,
	AFMT_AUDIO_CRC_CH3_SIG                           = 0x3,
	AFMT_AUDIO_CRC_CH4_SIG                           = 0x4,
	AFMT_AUDIO_CRC_CH5_SIG                           = 0x5,
	AFMT_AUDIO_CRC_CH6_SIG                           = 0x6,
	AFMT_AUDIO_CRC_CH7_SIG                           = 0x7,
	AFMT_AUDIO_CRC_RESERVED                          = 0x8,
	AFMT_AUDIO_CRC_AUDIO_SAMPLE_COUNT                = 0x9,
} AFMT_AUDIO_CRC_CONTROL_CH_SEL;
typedef enum AFMT_RAMP_CONTROL0_SIGN {
	AFMT_RAMP_SIGNED                                 = 0x0,
	AFMT_RAMP_UNSIGNED                               = 0x1,
} AFMT_RAMP_CONTROL0_SIGN;
typedef enum AFMT_AUDIO_PACKET_CONTROL_AUDIO_SAMPLE_SEND {
	AFMT_AUDIO_PACKET_SENT_DISABLED                  = 0x0,
	AFMT_AUDIO_PACKET_SENT_ENABLED                   = 0x1,
} AFMT_AUDIO_PACKET_CONTROL_AUDIO_SAMPLE_SEND;
typedef enum AFMT_AUDIO_PACKET_CONTROL_RESET_FIFO_WHEN_AUDIO_DIS {
	AFMT_NOT_RESET_AUDIO_FIFO_WHEN_AUDIO_DISABLED_RESERVED= 0x0,
	AFMT_RESET_AUDIO_FIFO_WHEN_AUDIO_DISABLED        = 0x1,
} AFMT_AUDIO_PACKET_CONTROL_RESET_FIFO_WHEN_AUDIO_DIS;
typedef enum AFMT_INFOFRAME_CONTROL0_AUDIO_INFO_SOURCE {
	AFMT_INFOFRAME_SOURCE_FROM_AZALIA_BLOCK          = 0x0,
	AFMT_INFOFRAME_SOURCE_FROM_AFMT_REGISTERS        = 0x1,
} AFMT_INFOFRAME_CONTROL0_AUDIO_INFO_SOURCE;
typedef enum AFMT_AUDIO_SRC_CONTROL_SELECT {
	AFMT_AUDIO_SRC_FROM_AZ_STREAM0                   = 0x0,
	AFMT_AUDIO_SRC_FROM_AZ_STREAM1                   = 0x1,
	AFMT_AUDIO_SRC_FROM_AZ_STREAM2                   = 0x2,
	AFMT_AUDIO_SRC_FROM_AZ_STREAM3                   = 0x3,
	AFMT_AUDIO_SRC_FROM_AZ_STREAM4                   = 0x4,
	AFMT_AUDIO_SRC_FROM_AZ_STREAM5                   = 0x5,
	AFMT_AUDIO_SRC_RESERVED                          = 0x6,
} AFMT_AUDIO_SRC_CONTROL_SELECT;
typedef enum DIG_BE_CNTL_MODE {
	DIG_BE_DP_SST_MODE                               = 0x0,
	DIG_BE_RESERVED1                                 = 0x1,
	DIG_BE_TMDS_DVI_MODE                             = 0x2,
	DIG_BE_TMDS_HDMI_MODE                            = 0x3,
	DIG_BE_SDVO_RESERVED                             = 0x4,
	DIG_BE_DP_MST_MODE                               = 0x5,
	DIG_BE_RESERVED2                                 = 0x6,
	DIG_BE_RESERVED3                                 = 0x7,
} DIG_BE_CNTL_MODE;
typedef enum DIG_BE_CNTL_HPD_SELECT {
	DIG_BE_CNTL_HPD1                                 = 0x0,
	DIG_BE_CNTL_HPD2                                 = 0x1,
	DIG_BE_CNTL_HPD3                                 = 0x2,
	DIG_BE_CNTL_HPD4                                 = 0x3,
	DIG_BE_CNTL_HPD5                                 = 0x4,
	DIG_BE_CNTL_HPD6                                 = 0x5,
} DIG_BE_CNTL_HPD_SELECT;
typedef enum LVTMA_RANDOM_PATTERN_SEED_RAN_PAT {
	LVTMA_RANDOM_PATTERN_SEED_ALL_PIXELS             = 0x0,
	LVTMA_RANDOM_PATTERN_SEED_ONLY_DE_HIGH           = 0x1,
} LVTMA_RANDOM_PATTERN_SEED_RAN_PAT;
typedef enum TMDS_SYNC_PHASE {
	TMDS_NOT_SYNC_PHASE_ON_FRAME_START               = 0x0,
	TMDS_SYNC_PHASE_ON_FRAME_START                   = 0x1,
} TMDS_SYNC_PHASE;
typedef enum TMDS_DATA_SYNCHRONIZATION_DSINTSEL {
	TMDS_DATA_SYNCHRONIZATION_DSINTSEL_PCLK_TMDS     = 0x0,
	TMDS_DATA_SYNCHRONIZATION_DSINTSEL_TMDS_PLL      = 0x1,
} TMDS_DATA_SYNCHRONIZATION_DSINTSEL;
typedef enum TMDS_TRANSMITTER_ENABLE_HPD_MASK {
	TMDS_TRANSMITTER_HPD_MASK_NOT_OVERRIDE           = 0x0,
	TMDS_TRANSMITTER_HPD_MASK_OVERRIDE               = 0x1,
} TMDS_TRANSMITTER_ENABLE_HPD_MASK;
typedef enum TMDS_TRANSMITTER_ENABLE_LNKCEN_HPD_MASK {
	TMDS_TRANSMITTER_LNKCEN_HPD_MASK_NOT_OVERRIDE    = 0x0,
	TMDS_TRANSMITTER_LNKCEN_HPD_MASK_OVERRIDE        = 0x1,
} TMDS_TRANSMITTER_ENABLE_LNKCEN_HPD_MASK;
typedef enum TMDS_TRANSMITTER_ENABLE_LNKDEN_HPD_MASK {
	TMDS_TRANSMITTER_LNKDEN_HPD_MASK_NOT_OVERRIDE    = 0x0,
	TMDS_TRANSMITTER_LNKDEN_HPD_MASK_OVERRIDE        = 0x1,
} TMDS_TRANSMITTER_ENABLE_LNKDEN_HPD_MASK;
typedef enum TMDS_TRANSMITTER_CONTROL_PLL_ENABLE_HPD_MASK {
	TMDS_TRANSMITTER_HPD_NOT_OVERRIDE_PLL_ENABLE     = 0x0,
	TMDS_TRANSMITTER_HPD_OVERRIDE_PLL_ENABLE_ON_DISCON= 0x1,
	TMDS_TRANSMITTER_HPD_OVERRIDE_PLL_ENABLE_ON_CON  = 0x2,
	TMDS_TRANSMITTER_HPD_OVERRIDE_PLL_ENABLE         = 0x3,
} TMDS_TRANSMITTER_CONTROL_PLL_ENABLE_HPD_MASK;
typedef enum TMDS_TRANSMITTER_CONTROL_IDSCKSELA {
	TMDS_TRANSMITTER_IDSCKSELA_USE_IPIXCLK           = 0x0,
	TMDS_TRANSMITTER_IDSCKSELA_USE_IDCLK             = 0x1,
} TMDS_TRANSMITTER_CONTROL_IDSCKSELA;
typedef enum TMDS_TRANSMITTER_CONTROL_IDSCKSELB {
	TMDS_TRANSMITTER_IDSCKSELB_USE_IPIXCLK           = 0x0,
	TMDS_TRANSMITTER_IDSCKSELB_USE_IDCLK             = 0x1,
} TMDS_TRANSMITTER_CONTROL_IDSCKSELB;
typedef enum TMDS_TRANSMITTER_CONTROL_PLL_PWRUP_SEQ_EN {
	TMDS_TRANSMITTER_PLL_PWRUP_SEQ_DISABLE           = 0x0,
	TMDS_TRANSMITTER_PLL_PWRUP_SEQ_ENABLE            = 0x1,
} TMDS_TRANSMITTER_CONTROL_PLL_PWRUP_SEQ_EN;
typedef enum TMDS_TRANSMITTER_CONTROL_PLL_RESET_HPD_MASK {
	TMDS_TRANSMITTER_PLL_NOT_RST_ON_HPD              = 0x0,
	TMDS_TRANSMITTER_PLL_RST_ON_HPD                  = 0x1,
} TMDS_TRANSMITTER_CONTROL_PLL_RESET_HPD_MASK;
typedef enum TMDS_TRANSMITTER_CONTROL_TMCLK_FROM_PADS {
	TMDS_TRANSMITTER_TMCLK_FROM_TMDS_TMCLK           = 0x0,
	TMDS_TRANSMITTER_TMCLK_FROM_PADS                 = 0x1,
} TMDS_TRANSMITTER_CONTROL_TMCLK_FROM_PADS;
typedef enum TMDS_TRANSMITTER_CONTROL_TDCLK_FROM_PADS {
	TMDS_TRANSMITTER_TDCLK_FROM_TMDS_TDCLK           = 0x0,
	TMDS_TRANSMITTER_TDCLK_FROM_PADS                 = 0x1,
} TMDS_TRANSMITTER_CONTROL_TDCLK_FROM_PADS;
typedef enum TMDS_TRANSMITTER_CONTROL_PLLSEL_OVERWRITE_EN {
	TMDS_TRANSMITTER_PLLSEL_BY_HW                    = 0x0,
	TMDS_TRANSMITTER_PLLSEL_OVERWRITE_BY_SW          = 0x1,
} TMDS_TRANSMITTER_CONTROL_PLLSEL_OVERWRITE_EN;
typedef enum TMDS_TRANSMITTER_CONTROL_BYPASS_PLLA {
	TMDS_TRANSMITTER_BYPASS_PLLA_COHERENT            = 0x0,
	TMDS_TRANSMITTER_BYPASS_PLLA_INCOHERENT          = 0x1,
} TMDS_TRANSMITTER_CONTROL_BYPASS_PLLA;
typedef enum TMDS_TRANSMITTER_CONTROL_BYPASS_PLLB {
	TMDS_TRANSMITTER_BYPASS_PLLB_COHERENT            = 0x0,
	TMDS_TRANSMITTER_BYPASS_PLLB_INCOHERENT          = 0x1,
} TMDS_TRANSMITTER_CONTROL_BYPASS_PLLB;
typedef enum TMDS_REG_TEST_OUTPUTA_CNTLA {
	TMDS_REG_TEST_OUTPUTA_CNTLA_OTDATA0              = 0x0,
	TMDS_REG_TEST_OUTPUTA_CNTLA_OTDATA1              = 0x1,
	TMDS_REG_TEST_OUTPUTA_CNTLA_OTDATA2              = 0x2,
	TMDS_REG_TEST_OUTPUTA_CNTLA_NA                   = 0x3,
} TMDS_REG_TEST_OUTPUTA_CNTLA;
typedef enum TMDS_REG_TEST_OUTPUTB_CNTLB {
	TMDS_REG_TEST_OUTPUTB_CNTLB_OTDATB0              = 0x0,
	TMDS_REG_TEST_OUTPUTB_CNTLB_OTDATB1              = 0x1,
	TMDS_REG_TEST_OUTPUTB_CNTLB_OTDATB2              = 0x2,
	TMDS_REG_TEST_OUTPUTB_CNTLB_NA                   = 0x3,
} TMDS_REG_TEST_OUTPUTB_CNTLB;
typedef enum DP_LINK_TRAINING_COMPLETE {
	DP_LINK_TRAINING_NOT_COMPLETE                    = 0x0,
	DP_LINK_TRAINING_ALREADY_COMPLETE                = 0x1,
} DP_LINK_TRAINING_COMPLETE;
typedef enum DP_EMBEDDED_PANEL_MODE {
	DP_EXTERNAL_PANEL                                = 0x0,
	DP_EMBEDDED_PANEL                                = 0x1,
} DP_EMBEDDED_PANEL_MODE;
typedef enum DP_PIXEL_ENCODING {
	DP_PIXEL_ENCODING_RGB444                         = 0x0,
	DP_PIXEL_ENCODING_YCBCR422                       = 0x1,
	DP_PIXEL_ENCODING_YCBCR444                       = 0x2,
	DP_PIXEL_ENCODING_RGB_WIDE_GAMUT                 = 0x3,
	DP_PIXEL_ENCODING_Y_ONLY                         = 0x4,
	DP_PIXEL_ENCODING_YCBCR420                       = 0x5,
	DP_PIXEL_ENCODING_RESERVED                       = 0x6,
} DP_PIXEL_ENCODING;
typedef enum DP_DYN_RANGE {
	DP_DYN_VESA_RANGE                                = 0x0,
	DP_DYN_CEA_RANGE                                 = 0x1,
} DP_DYN_RANGE;
typedef enum DP_YCBCR_RANGE {
	DP_YCBCR_RANGE_BT601_5                           = 0x0,
	DP_YCBCR_RANGE_BT709_5                           = 0x1,
} DP_YCBCR_RANGE;
typedef enum DP_COMPONENT_DEPTH {
	DP_COMPONENT_DEPTH_6BPC                          = 0x0,
	DP_COMPONENT_DEPTH_8BPC                          = 0x1,
	DP_COMPONENT_DEPTH_10BPC                         = 0x2,
	DP_COMPONENT_DEPTH_12BPC                         = 0x3,
	DP_COMPONENT_DEPTH_16BPC                         = 0x4,
	DP_COMPONENT_DEPTH_RESERVED                      = 0x5,
} DP_COMPONENT_DEPTH;
typedef enum DP_MSA_MISC0_OVERRIDE_ENABLE {
	MSA_MISC0_OVERRIDE_DISABLE                       = 0x0,
	MSA_MISC0_OVERRIDE_ENABLE                        = 0x1,
} DP_MSA_MISC0_OVERRIDE_ENABLE;
typedef enum DP_MSA_MISC1_BIT7_OVERRIDE_ENABLE {
	MSA_MISC1_BIT7_OVERRIDE_DISABLE                  = 0x0,
	MSA_MISC1_BIT7_OVERRIDE_ENABLE                   = 0x1,
} DP_MSA_MISC1_BIT7_OVERRIDE_ENABLE;
typedef enum DP_UDI_LANES {
	DP_UDI_1_LANE                                    = 0x0,
	DP_UDI_2_LANES                                   = 0x1,
	DP_UDI_LANES_RESERVED                            = 0x2,
	DP_UDI_4_LANES                                   = 0x3,
} DP_UDI_LANES;
typedef enum DP_VID_STREAM_DIS_DEFER {
	DP_VID_STREAM_DIS_NO_DEFER                       = 0x0,
	DP_VID_STREAM_DIS_DEFER_TO_HBLANK                = 0x1,
	DP_VID_STREAM_DIS_DEFER_TO_VBLANK                = 0x2,
} DP_VID_STREAM_DIS_DEFER;
typedef enum DP_STEER_OVERFLOW_ACK {
	DP_STEER_OVERFLOW_ACK_NO_EFFECT                  = 0x0,
	DP_STEER_OVERFLOW_ACK_CLR_INTERRUPT              = 0x1,
} DP_STEER_OVERFLOW_ACK;
typedef enum DP_STEER_OVERFLOW_MASK {
	DP_STEER_OVERFLOW_MASKED                         = 0x0,
	DP_STEER_OVERFLOW_UNMASK                         = 0x1,
} DP_STEER_OVERFLOW_MASK;
typedef enum DP_TU_OVERFLOW_ACK {
	DP_TU_OVERFLOW_ACK_NO_EFFECT                     = 0x0,
	DP_TU_OVERFLOW_ACK_CLR_INTERRUPT                 = 0x1,
} DP_TU_OVERFLOW_ACK;
typedef enum DP_VID_TIMING_MODE {
	DP_VID_TIMING_MODE_ASYNC                         = 0x0,
	DP_VID_TIMING_MODE_SYNC                          = 0x1,
} DP_VID_TIMING_MODE;
typedef enum DP_VID_M_N_DOUBLE_BUFFER_MODE {
	DP_VID_M_N_DOUBLE_BUFFER_AFTER_VID_M_UPDATE      = 0x0,
	DP_VID_M_N_DOUBLE_BUFFER_AT_FRAME_START          = 0x1,
} DP_VID_M_N_DOUBLE_BUFFER_MODE;
typedef enum DP_VID_M_N_GEN_EN {
	DP_VID_M_N_PROGRAMMED_VIA_REG                    = 0x0,
	DP_VID_M_N_CALC_AUTO                             = 0x1,
} DP_VID_M_N_GEN_EN;
typedef enum DP_VID_M_DOUBLE_VALUE_EN {
	DP_VID_M_INPUT_PIXEL_RATE                        = 0x0,
	DP_VID_M_DOUBLE_INPUT_PIXEL_RATE                 = 0x1,
} DP_VID_M_DOUBLE_VALUE_EN;
typedef enum DP_VID_ENHANCED_FRAME_MODE {
	VID_NORMAL_FRAME_MODE                            = 0x0,
	VID_ENHANCED_MODE                                = 0x1,
} DP_VID_ENHANCED_FRAME_MODE;
typedef enum DP_VID_MSA_TOP_FIELD_MODE {
	DP_TOP_FIELD_ONLY                                = 0x0,
	DP_TOP_PLUS_BOTTOM_FIELD                         = 0x1,
} DP_VID_MSA_TOP_FIELD_MODE;
typedef enum DP_VID_VBID_FIELD_POL {
	DP_VID_VBID_FIELD_POL_NORMAL                     = 0x0,
	DP_VID_VBID_FIELD_POL_INV                        = 0x1,
} DP_VID_VBID_FIELD_POL;
typedef enum DP_VID_STREAM_DISABLE_ACK {
	ID_STREAM_DISABLE_NO_ACK                         = 0x0,
	ID_STREAM_DISABLE_ACKED                          = 0x1,
} DP_VID_STREAM_DISABLE_ACK;
typedef enum DP_VID_STREAM_DISABLE_MASK {
	VID_STREAM_DISABLE_MASKED                        = 0x0,
	VID_STREAM_DISABLE_UNMASK                        = 0x1,
} DP_VID_STREAM_DISABLE_MASK;
typedef enum DPHY_ATEST_SEL_LANE0 {
	DPHY_ATEST_LANE0_PRBS_PATTERN                    = 0x0,
	DPHY_ATEST_LANE0_REG_PATTERN                     = 0x1,
} DPHY_ATEST_SEL_LANE0;
typedef enum DPHY_ATEST_SEL_LANE1 {
	DPHY_ATEST_LANE1_PRBS_PATTERN                    = 0x0,
	DPHY_ATEST_LANE1_REG_PATTERN                     = 0x1,
} DPHY_ATEST_SEL_LANE1;
typedef enum DPHY_ATEST_SEL_LANE2 {
	DPHY_ATEST_LANE2_PRBS_PATTERN                    = 0x0,
	DPHY_ATEST_LANE2_REG_PATTERN                     = 0x1,
} DPHY_ATEST_SEL_LANE2;
typedef enum DPHY_ATEST_SEL_LANE3 {
	DPHY_ATEST_LANE3_PRBS_PATTERN                    = 0x0,
	DPHY_ATEST_LANE3_REG_PATTERN                     = 0x1,
} DPHY_ATEST_SEL_LANE3;
typedef enum DPHY_BYPASS {
	DPHY_8B10B_OUTPUT                                = 0x0,
	DPHY_DBG_OUTPUT                                  = 0x1,
} DPHY_BYPASS;
typedef enum DPHY_SKEW_BYPASS {
	DPHY_WITH_SKEW                                   = 0x0,
	DPHY_NO_SKEW                                     = 0x1,
} DPHY_SKEW_BYPASS;
typedef enum DPHY_TRAINING_PATTERN_SEL {
	DPHY_TRAINING_PATTERN_1                          = 0x0,
	DPHY_TRAINING_PATTERN_2                          = 0x1,
	DPHY_TRAINING_PATTERN_3                          = 0x2,
	DPHY_TRAINING_PATTERN_4                          = 0x3,
} DPHY_TRAINING_PATTERN_SEL;
typedef enum DPHY_8B10B_RESET {
	DPHY_8B10B_NOT_RESET                             = 0x0,
	DPHY_8B10B_RESETET                               = 0x1,
} DPHY_8B10B_RESET;
typedef enum DP_DPHY_8B10B_EXT_DISP {
	DP_DPHY_8B10B_EXT_DISP_ZERO                      = 0x0,
	DP_DPHY_8B10B_EXT_DISP_ONE                       = 0x1,
} DP_DPHY_8B10B_EXT_DISP;
typedef enum DPHY_8B10B_CUR_DISP {
	DPHY_8B10B_CUR_DISP_ZERO                         = 0x0,
	DPHY_8B10B_CUR_DISP_ONE                          = 0x1,
} DPHY_8B10B_CUR_DISP;
typedef enum DPHY_PRBS_EN {
	DPHY_PRBS_DISABLE                                = 0x0,
	DPHY_PRBS_ENABLE                                 = 0x1,
} DPHY_PRBS_EN;
typedef enum DPHY_PRBS_SEL {
	DPHY_PRBS7_SELECTED                              = 0x0,
	DPHY_PRBS23_SELECTED                             = 0x1,
	DPHY_PRBS11_SELECTED                             = 0x2,
} DPHY_PRBS_SEL;
typedef enum DPHY_LOAD_BS_COUNT_START {
	DPHY_LOAD_BS_COUNT_STARTED                       = 0x0,
	DPHY_LOAD_BS_COUNT_NOT_STARTED                   = 0x1,
} DPHY_LOAD_BS_COUNT_START;
typedef enum DPHY_CRC_EN {
	DPHY_CRC_DISABLED                                = 0x0,
	DPHY_CRC_ENABLED                                 = 0x1,
} DPHY_CRC_EN;
typedef enum DPHY_CRC_CONT_EN {
	DPHY_CRC_ONE_SHOT                                = 0x0,
	DPHY_CRC_CONTINUOUS                              = 0x1,
} DPHY_CRC_CONT_EN;
typedef enum DPHY_CRC_FIELD {
	DPHY_CRC_START_FROM_TOP_FIELD                    = 0x0,
	DPHY_CRC_START_FROM_BOTTOM_FIELD                 = 0x1,
} DPHY_CRC_FIELD;
typedef enum DPHY_CRC_SEL {
	DPHY_CRC_LANE0_SELECTED                          = 0x0,
	DPHY_CRC_LANE1_SELECTED                          = 0x1,
	DPHY_CRC_LANE2_SELECTED                          = 0x2,
	DPHY_CRC_LANE3_SELECTED                          = 0x3,
} DPHY_CRC_SEL;
typedef enum DPHY_RX_FAST_TRAINING_CAPABLE {
	DPHY_FAST_TRAINING_NOT_CAPABLE_0                 = 0x0,
	DPHY_FAST_TRAINING_CAPABLE                       = 0x1,
} DPHY_RX_FAST_TRAINING_CAPABLE;
typedef enum DP_SEC_COLLISION_ACK {
	DP_SEC_COLLISION_ACK_NO_EFFECT                   = 0x0,
	DP_SEC_COLLISION_ACK_CLR_FLAG                    = 0x1,
} DP_SEC_COLLISION_ACK;
typedef enum DP_SEC_AUDIO_MUTE {
	DP_SEC_AUDIO_MUTE_HW_CTRL                        = 0x0,
	DP_SEC_AUDIO_MUTE_SW_CTRL                        = 0x1,
} DP_SEC_AUDIO_MUTE;
typedef enum DP_SEC_TIMESTAMP_MODE {
	DP_SEC_TIMESTAMP_PROGRAMMABLE_MODE               = 0x0,
	DP_SEC_TIMESTAMP_AUTO_CALC_MODE                  = 0x1,
} DP_SEC_TIMESTAMP_MODE;
typedef enum DP_SEC_ASP_PRIORITY {
	DP_SEC_ASP_LOW_PRIORITY                          = 0x0,
	DP_SEC_ASP_HIGH_PRIORITY                         = 0x1,
} DP_SEC_ASP_PRIORITY;
typedef enum DP_SEC_ASP_CHANNEL_COUNT_OVERRIDE {
	DP_SEC_ASP_CHANNEL_COUNT_FROM_AZ                 = 0x0,
	DP_SEC_ASP_CHANNEL_COUNT_OVERRIDE_ENABLED        = 0x1,
} DP_SEC_ASP_CHANNEL_COUNT_OVERRIDE;
typedef enum DP_MSE_SAT_UPDATE_ACT {
	DP_MSE_SAT_UPDATE_NO_ACTION                      = 0x0,
	DP_MSE_SAT_UPDATE_WITH_TRIGGER                   = 0x1,
	DP_MSE_SAT_UPDATE_WITHOUT_TRIGGER                = 0x2,
} DP_MSE_SAT_UPDATE_ACT;
typedef enum DP_MSE_LINK_LINE {
	DP_MSE_LINK_LINE_32_MTP_LONG                     = 0x0,
	DP_MSE_LINK_LINE_64_MTP_LONG                     = 0x1,
	DP_MSE_LINK_LINE_128_MTP_LONG                    = 0x2,
	DP_MSE_LINK_LINE_256_MTP_LONG                    = 0x3,
} DP_MSE_LINK_LINE;
typedef enum DP_MSE_BLANK_CODE {
	DP_MSE_BLANK_CODE_SF_FILLED                      = 0x0,
	DP_MSE_BLANK_CODE_ZERO_FILLED                    = 0x1,
} DP_MSE_BLANK_CODE;
typedef enum DP_MSE_TIMESTAMP_MODE {
	DP_MSE_TIMESTAMP_CALC_BASED_ON_LINK_RATE         = 0x0,
	DP_MSE_TIMESTAMP_CALC_BASED_ON_VC_RATE           = 0x1,
} DP_MSE_TIMESTAMP_MODE;
typedef enum DP_MSE_ZERO_ENCODER {
	DP_MSE_NOT_ZERO_FE_ENCODER                       = 0x0,
	DP_MSE_ZERO_FE_ENCODER                           = 0x1,
} DP_MSE_ZERO_ENCODER;
typedef enum DP_MSE_OUTPUT_DPDBG_DATA {
	DP_MSE_OUTPUT_DPDBG_DATA_DIS                     = 0x0,
	DP_MSE_OUTPUT_DPDBG_DATA_EN                      = 0x1,
} DP_MSE_OUTPUT_DPDBG_DATA;
typedef enum DP_DPHY_HBR2_PATTERN_CONTROL_MODE {
	DP_DPHY_HBR2_PASS_THROUGH                        = 0x0,
	DP_DPHY_HBR2_PATTERN_1                           = 0x1,
	DP_DPHY_HBR2_PATTERN_2_NEG                       = 0x2,
	DP_DPHY_HBR2_PATTERN_3                           = 0x3,
	DP_DPHY_HBR2_PATTERN_2_POS                       = 0x6,
} DP_DPHY_HBR2_PATTERN_CONTROL_MODE;
typedef enum DPHY_CRC_MST_PHASE_ERROR_ACK {
	DPHY_CRC_MST_PHASE_ERROR_NO_ACK                  = 0x0,
	DPHY_CRC_MST_PHASE_ERROR_ACKED                   = 0x1,
} DPHY_CRC_MST_PHASE_ERROR_ACK;
typedef enum DPHY_SW_FAST_TRAINING_START {
	DPHY_SW_FAST_TRAINING_NOT_STARTED                = 0x0,
	DPHY_SW_FAST_TRAINING_STARTED                    = 0x1,
} DPHY_SW_FAST_TRAINING_START;
typedef enum DP_DPHY_FAST_TRAINING_VBLANK_EDGE_DETECT_EN {
	DP_DPHY_FAST_TRAINING_VBLANK_EDGE_DETECT_DISABLED= 0x0,
	DP_DPHY_FAST_TRAINING_VBLANK_EDGE_DETECT_ENABLED = 0x1,
} DP_DPHY_FAST_TRAINING_VBLANK_EDGE_DETECT_EN;
typedef enum DP_DPHY_FAST_TRAINING_COMPLETE_MASK {
	DP_DPHY_FAST_TRAINING_COMPLETE_MASKED            = 0x0,
	DP_DPHY_FAST_TRAINING_COMPLETE_NOT_MASKED        = 0x1,
} DP_DPHY_FAST_TRAINING_COMPLETE_MASK;
typedef enum DP_DPHY_FAST_TRAINING_COMPLETE_ACK {
	DP_DPHY_FAST_TRAINING_COMPLETE_NOT_ACKED         = 0x0,
	DP_DPHY_FAST_TRAINING_COMPLETE_ACKED             = 0x1,
} DP_DPHY_FAST_TRAINING_COMPLETE_ACK;
typedef enum DP_MSA_V_TIMING_OVERRIDE_EN {
	MSA_V_TIMING_OVERRIDE_DISABLED                   = 0x0,
	MSA_V_TIMING_OVERRIDE_ENABLED                    = 0x1,
} DP_MSA_V_TIMING_OVERRIDE_EN;
typedef enum DP_SEC_GSP0_PRIORITY {
	SEC_GSP0_PRIORITY_LOW                            = 0x0,
	SEC_GSP0_PRIORITY_HIGH                           = 0x1,
} DP_SEC_GSP0_PRIORITY;
typedef enum DP_SEC_GSP0_SEND {
	NOT_SENT                                         = 0x0,
	FORCE_SENT                                       = 0x1,
} DP_SEC_GSP0_SEND;
typedef enum DP_AUX_CONTROL_HPD_SEL {
	DP_AUX_CONTROL_HPD1_SELECTED                     = 0x0,
	DP_AUX_CONTROL_HPD2_SELECTED                     = 0x1,
	DP_AUX_CONTROL_HPD3_SELECTED                     = 0x2,
	DP_AUX_CONTROL_HPD4_SELECTED                     = 0x3,
	DP_AUX_CONTROL_HPD5_SELECTED                     = 0x4,
	DP_AUX_CONTROL_HPD6_SELECTED                     = 0x5,
} DP_AUX_CONTROL_HPD_SEL;
typedef enum DP_AUX_CONTROL_TEST_MODE {
	DP_AUX_CONTROL_TEST_MODE_DISABLE                 = 0x0,
	DP_AUX_CONTROL_TEST_MODE_ENABLE                  = 0x1,
} DP_AUX_CONTROL_TEST_MODE;
typedef enum DP_AUX_SW_CONTROL_SW_GO {
	DP_AUX_SW_CONTROL_SW__NOT_GO                     = 0x0,
	DP_AUX_SW_CONTROL_SW__GO                         = 0x1,
} DP_AUX_SW_CONTROL_SW_GO;
typedef enum DP_AUX_SW_CONTROL_LS_READ_TRIG {
	DP_AUX_SW_CONTROL_LS_READ__NOT_TRIG              = 0x0,
	DP_AUX_SW_CONTROL_LS_READ__TRIG                  = 0x1,
} DP_AUX_SW_CONTROL_LS_READ_TRIG;
typedef enum DP_AUX_ARB_CONTROL_ARB_PRIORITY {
	DP_AUX_ARB_CONTROL_ARB_PRIORITY__GTC_LS_SW       = 0x0,
	DP_AUX_ARB_CONTROL_ARB_PRIORITY__LS_GTC_SW       = 0x1,
	DP_AUX_ARB_CONTROL_ARB_PRIORITY__SW_LS_GTC       = 0x2,
	DP_AUX_ARB_CONTROL_ARB_PRIORITY__SW_GTC_LS       = 0x3,
} DP_AUX_ARB_CONTROL_ARB_PRIORITY;
typedef enum DP_AUX_ARB_CONTROL_USE_AUX_REG_REQ {
	DP_AUX_ARB_CONTROL__NOT_USE_AUX_REG_REQ          = 0x0,
	DP_AUX_ARB_CONTROL__USE_AUX_REG_REQ              = 0x1,
} DP_AUX_ARB_CONTROL_USE_AUX_REG_REQ;
typedef enum DP_AUX_ARB_CONTROL_DONE_USING_AUX_REG {
	DP_AUX_ARB_CONTROL__DONE_NOT_USING_AUX_REG       = 0x0,
	DP_AUX_ARB_CONTROL__DONE_USING_AUX_REG           = 0x1,
} DP_AUX_ARB_CONTROL_DONE_USING_AUX_REG;
typedef enum DP_AUX_INT_ACK {
	DP_AUX_INT__NOT_ACK                              = 0x0,
	DP_AUX_INT__ACK                                  = 0x1,
} DP_AUX_INT_ACK;
typedef enum DP_AUX_LS_UPDATE_ACK {
	DP_AUX_INT_LS_UPDATE_NOT_ACK                     = 0x0,
	DP_AUX_INT_LS_UPDATE_ACK                         = 0x1,
} DP_AUX_LS_UPDATE_ACK;
typedef enum DP_AUX_DPHY_TX_REF_CONTROL_TX_REF_SEL {
	DP_AUX_DPHY_TX_REF_CONTROL_TX_REF_SEL__DIVIDED_SYM_CLK= 0x0,
	DP_AUX_DPHY_TX_REF_CONTROL_TX_REF_SEL__FROM_DCCG_MICROSECOND_REF= 0x1,
} DP_AUX_DPHY_TX_REF_CONTROL_TX_REF_SEL;
typedef enum DP_AUX_DPHY_TX_REF_CONTROL_TX_RATE {
	DP_AUX_DPHY_TX_REF_CONTROL_TX_RATE__1MHZ         = 0x0,
	DP_AUX_DPHY_TX_REF_CONTROL_TX_RATE__2MHZ         = 0x1,
	DP_AUX_DPHY_TX_REF_CONTROL_TX_RATE__4MHZ         = 0x2,
	DP_AUX_DPHY_TX_REF_CONTROL_TX_RATE__8MHZ         = 0x3,
} DP_AUX_DPHY_TX_REF_CONTROL_TX_RATE;
typedef enum DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN {
	DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN__0US        = 0x0,
	DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN__8US        = 0x1,
	DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN__16US       = 0x2,
	DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN__24US       = 0x3,
	DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN__32US       = 0x4,
	DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN__40US       = 0x5,
	DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN__48US       = 0x6,
	DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN__56US       = 0x7,
} DP_AUX_DPHY_TX_CONTROL_PRECHARGE_LEN;
typedef enum DP_AUX_DPHY_TX_CONTROL_MODE_DET_CHECK_DELAY {
	DP_AUX_DPHY_TX_CONTROL_MODE_DET_CHECK_DELAY__0   = 0x0,
	DP_AUX_DPHY_TX_CONTROL_MODE_DET_CHECK_DELAY__16US= 0x1,
	DP_AUX_DPHY_TX_CONTROL_MODE_DET_CHECK_DELAY__32US= 0x2,
	DP_AUX_DPHY_TX_CONTROL_MODE_DET_CHECK_DELAY__64US= 0x3,
	DP_AUX_DPHY_TX_CONTROL_MODE_DET_CHECK_DELAY__128US= 0x4,
	DP_AUX_DPHY_TX_CONTROL_MODE_DET_CHECK_DELAY__256US= 0x5,
} DP_AUX_DPHY_TX_CONTROL_MODE_DET_CHECK_DELAY;
typedef enum DP_AUX_DPHY_RX_CONTROL_START_WINDOW {
	DP_AUX_DPHY_RX_CONTROL_START_WINDOW__1TO2_PERIOD = 0x0,
	DP_AUX_DPHY_RX_CONTROL_START_WINDOW__1TO4_PERIOD = 0x1,
	DP_AUX_DPHY_RX_CONTROL_START_WINDOW__1TO8_PERIOD = 0x2,
	DP_AUX_DPHY_RX_CONTROL_START_WINDOW__1TO16_PERIOD= 0x3,
	DP_AUX_DPHY_RX_CONTROL_START_WINDOW__1TO32_PERIOD= 0x4,
	DP_AUX_DPHY_RX_CONTROL_START_WINDOW__1TO64_PERIOD= 0x5,
	DP_AUX_DPHY_RX_CONTROL_START_WINDOW__1TO128_PERIOD= 0x6,
	DP_AUX_DPHY_RX_CONTROL_START_WINDOW__1TO256_PERIOD= 0x7,
} DP_AUX_DPHY_RX_CONTROL_START_WINDOW;
typedef enum DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW {
	DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW__1TO2_PERIOD= 0x0,
	DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW__1TO4_PERIOD= 0x1,
	DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW__1TO8_PERIOD= 0x2,
	DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW__1TO16_PERIOD= 0x3,
	DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW__1TO32_PERIOD= 0x4,
	DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW__1TO64_PERIOD= 0x5,
	DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW__1TO128_PERIOD= 0x6,
	DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW__1TO256_PERIOD= 0x7,
} DP_AUX_DPHY_RX_CONTROL_RECEIVE_WINDOW;
typedef enum DP_AUX_DPHY_RX_CONTROL_HALF_SYM_DETECT_LEN {
	DP_AUX_DPHY_RX_CONTROL_HALF_SYM_DETECT_LEN__6_EDGES= 0x0,
	DP_AUX_DPHY_RX_CONTROL_HALF_SYM_DETECT_LEN__10_EDGES= 0x1,
	DP_AUX_DPHY_RX_CONTROL_HALF_SYM_DETECT_LEN__18_EDGES= 0x2,
	DP_AUX_DPHY_RX_CONTROL_HALF_SYM_DETECT_LEN__RESERVED= 0x3,
} DP_AUX_DPHY_RX_CONTROL_HALF_SYM_DETECT_LEN;
typedef enum DP_AUX_DPHY_RX_CONTROL_ALLOW_BELOW_THRESHOLD_PHASE_DETECT {
	DP_AUX_DPHY_RX_CONTROL__NOT_ALLOW_BELOW_THRESHOLD_PHASE_DETECT= 0x0,
	DP_AUX_DPHY_RX_CONTROL__ALLOW_BELOW_THRESHOLD_PHASE_DETECT= 0x1,
} DP_AUX_DPHY_RX_CONTROL_ALLOW_BELOW_THRESHOLD_PHASE_DETECT;
typedef enum DP_AUX_DPHY_RX_CONTROL_ALLOW_BELOW_THRESHOLD_START {
	DP_AUX_DPHY_RX_CONTROL__NOT_ALLOW_BELOW_THRESHOLD_START= 0x0,
	DP_AUX_DPHY_RX_CONTROL__ALLOW_BELOW_THRESHOLD_START= 0x1,
} DP_AUX_DPHY_RX_CONTROL_ALLOW_BELOW_THRESHOLD_START;
typedef enum DP_AUX_DPHY_RX_CONTROL_ALLOW_BELOW_THRESHOLD_STOP {
	DP_AUX_DPHY_RX_CONTROL__NOT_ALLOW_BELOW_THRESHOLD_STOP= 0x0,
	DP_AUX_DPHY_RX_CONTROL__ALLOW_BELOW_THRESHOLD_STOP= 0x1,
} DP_AUX_DPHY_RX_CONTROL_ALLOW_BELOW_THRESHOLD_STOP;
typedef enum DP_AUX_DPHY_RX_CONTROL_PHASE_DETECT_LEN {
	DP_AUX_DPHY_RX_CONTROL_PHASE_DETECT_LEN__2_HALF_SYMBOLS= 0x0,
	DP_AUX_DPHY_RX_CONTROL_PHASE_DETECT_LEN__4_HALF_SYMBOLS= 0x1,
	DP_AUX_DPHY_RX_CONTROL_PHASE_DETECT_LEN__6_HALF_SYMBOLS= 0x2,
	DP_AUX_DPHY_RX_CONTROL_PHASE_DETECT_LEN__8_HALF_SYMBOLS= 0x3,
} DP_AUX_DPHY_RX_CONTROL_PHASE_DETECT_LEN;
typedef enum DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN {
	DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN_450US         = 0x0,
	DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN_500US         = 0x1,
	DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN_550US         = 0x2,
	DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN_600US         = 0x3,
	DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN_650US         = 0x4,
	DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN_700US         = 0x5,
	DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN_750US         = 0x6,
	DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN_800US         = 0x7,
} DP_AUX_DPHY_RX_CONTROL_TIMEOUT_LEN;
typedef enum DP_AUX_DPHY_RX_DETECTION_THRESHOLD {
	DP_AUX_DPHY_RX_DETECTION_THRESHOLD__1to2         = 0x0,
	DP_AUX_DPHY_RX_DETECTION_THRESHOLD__3to4         = 0x1,
	DP_AUX_DPHY_RX_DETECTION_THRESHOLD__7to8         = 0x2,
	DP_AUX_DPHY_RX_DETECTION_THRESHOLD__15to16       = 0x3,
	DP_AUX_DPHY_RX_DETECTION_THRESHOLD__31to32       = 0x4,
	DP_AUX_DPHY_RX_DETECTION_THRESHOLD__63to64       = 0x5,
	DP_AUX_DPHY_RX_DETECTION_THRESHOLD__127to128     = 0x6,
	DP_AUX_DPHY_RX_DETECTION_THRESHOLD__255to256     = 0x7,
} DP_AUX_DPHY_RX_DETECTION_THRESHOLD;
typedef enum DP_AUX_GTC_SYNC_CONTROL_GTC_SYNC_BLOCK_REQ {
	DP_AUX_GTC_SYNC_CONTROL_GTC_SYNC_ALLOW_REQ_FROM_OTHER_AUX= 0x0,
	DP_AUX_GTC_SYNC_CONTROL_GTC_SYNC_BLOCK_REQ_FROM_OTHER_AUX= 0x1,
} DP_AUX_GTC_SYNC_CONTROL_GTC_SYNC_BLOCK_REQ;
typedef enum DP_AUX_GTC_SYNC_CONTROL_INTERVAL_RESET_WINDOW {
	DP_AUX_GTC_SYNC_CONTROL_INTERVAL_RESET_WINDOW__300US= 0x0,
	DP_AUX_GTC_SYNC_CONTROL_INTERVAL_RESET_WINDOW__400US= 0x1,
	DP_AUX_GTC_SYNC_CONTROL_INTERVAL_RESET_WINDOW__500US= 0x2,
	DP_AUX_GTC_SYNC_CONTROL_INTERVAL_RESET_WINDOW__600US= 0x3,
} DP_AUX_GTC_SYNC_CONTROL_INTERVAL_RESET_WINDOW;
typedef enum DP_AUX_GTC_SYNC_CONTROL_OFFSET_CALC_MAX_ATTEMPT {
	DP_AUX_GTC_SYNC_CONTROL_OFFSET_CALC_MAX_ATTEMPT__4_ATTAMPS= 0x0,
	DP_AUX_GTC_SYNC_CONTROL_OFFSET_CALC_MAX_ATTEMPT__8_ATTAMPS= 0x1,
	DP_AUX_GTC_SYNC_CONTROL_OFFSET_CALC_MAX_ATTEMPT__16_ATTAMPS= 0x2,
	DP_AUX_GTC_SYNC_CONTROL_OFFSET_CALC_MAX_ATTEMPT__RESERVED= 0x3,
} DP_AUX_GTC_SYNC_CONTROL_OFFSET_CALC_MAX_ATTEMPT;
typedef enum DP_AUX_GTC_SYNC_ERROR_CONTROL_LOCK_ACQ_TIMEOUT_LEN {
	DP_AUX_GTC_SYNC_ERROR_CONTROL_LOCK_ACQ_TIMEOUT_LEN__0= 0x0,
	DP_AUX_GTC_SYNC_ERROR_CONTROL_LOCK_ACQ_TIMEOUT_LEN__64= 0x1,
	DP_AUX_GTC_SYNC_ERROR_CONTROL_LOCK_ACQ_TIMEOUT_LEN__128= 0x2,
	DP_AUX_GTC_SYNC_ERROR_CONTROL_LOCK_ACQ_TIMEOUT_LEN__256= 0x3,
} DP_AUX_GTC_SYNC_ERROR_CONTROL_LOCK_ACQ_TIMEOUT_LEN;
typedef enum DP_AUX_ERR_OCCURRED_ACK {
	DP_AUX_ERR_OCCURRED__NOT_ACK                     = 0x0,
	DP_AUX_ERR_OCCURRED__ACK                         = 0x1,
} DP_AUX_ERR_OCCURRED_ACK;
typedef enum DP_AUX_POTENTIAL_ERR_REACHED_ACK {
	DP_AUX_POTENTIAL_ERR_REACHED__NOT_ACK            = 0x0,
	DP_AUX_POTENTIAL_ERR_REACHED__ACK                = 0x1,
} DP_AUX_POTENTIAL_ERR_REACHED_ACK;
typedef enum DP_AUX_DEFINITE_ERR_REACHED_ACK {
	ALPHA_DP_AUX_DEFINITE_ERR_REACHED_NOT_ACK        = 0x0,
	ALPHA_DP_AUX_DEFINITE_ERR_REACHED_ACK            = 0x1,
} DP_AUX_DEFINITE_ERR_REACHED_ACK;
typedef enum DP_AUX_RESET {
	DP_AUX_RESET_DEASSERTED                          = 0x0,
	DP_AUX_RESET_ASSERTED                            = 0x1,
} DP_AUX_RESET;
typedef enum DP_AUX_RESET_DONE {
	DP_AUX_RESET_SEQUENCE_NOT_DONE                   = 0x0,
	DP_AUX_RESET_SEQUENCE_DONE                       = 0x1,
} DP_AUX_RESET_DONE;
typedef enum FBC_IDLE_MASK_MASK_BITS {
	FBC_IDLE_MASK_DISP_REG_UPDATE                    = 0x0,
	FBC_IDLE_MASK_RESERVED1                          = 0x1,
	FBC_IDLE_MASK_FBC_GRPH_COMP_EN                   = 0x2,
	FBC_IDLE_MASK_FBC_MIN_COMPRESSION                = 0x3,
	FBC_IDLE_MASK_FBC_ALPHA_COMP_EN                  = 0x4,
	FBC_IDLE_MASK_FBC_ZERO_ALPHA_CHUNK_SKIP_EN       = 0x5,
	FBC_IDLE_MASK_FBC_FORCE_COPY_TO_COMP_BUF         = 0x6,
	FBC_IDLE_MASK_RESERVED7                          = 0x7,
	FBC_IDLE_MASK_RESERVED8                          = 0x8,
	FBC_IDLE_MASK_RESERVED9                          = 0x9,
	FBC_IDLE_MASK_RESERVED10                         = 0xa,
	FBC_IDLE_MASK_RESERVED11                         = 0xb,
	FBC_IDLE_MASK_RESERVED12                         = 0xc,
	FBC_IDLE_MASK_RESERVED13                         = 0xd,
	FBC_IDLE_MASK_RESERVED14                         = 0xe,
	FBC_IDLE_MASK_RESERVED15                         = 0xf,
	FBC_IDLE_MASK_RESERVED16                         = 0x10,
	FBC_IDLE_MASK_RESERVED17                         = 0x11,
	FBC_IDLE_MASK_RESERVED18                         = 0x12,
	FBC_IDLE_MASK_RESERVED19                         = 0x13,
	FBC_IDLE_MASK_RESERVED20                         = 0x14,
	FBC_IDLE_MASK_RESERVED21                         = 0x15,
	FBC_IDLE_MASK_RESERVED22                         = 0x16,
	FBC_IDLE_MASK_RESERVED23                         = 0x17,
	FBC_IDLE_MASK_MC_HIT_REGION_0                    = 0x18,
	FBC_IDLE_MASK_MC_HIT_REGION_1                    = 0x19,
	FBC_IDLE_MASK_MC_HIT_REGION_2                    = 0x1a,
	FBC_IDLE_MASK_MC_HIT_REGION_3                    = 0x1b,
	FBC_IDLE_MASK_MC_WRITE                           = 0x1c,
	FBC_IDLE_MASK_CG_STATIC_SCREEN                   = 0x1d,
	FBC_IDLE_MASK_RESERVED30                         = 0x1e,
	FBC_IDLE_MASK_RESERVED31                         = 0x1f,
} FBC_IDLE_MASK_MASK_BITS;
typedef enum FMT_CONTROL_PIXEL_ENCODING {
	FMT_CONTROL_PIXEL_ENCODING_RGB444_OR_YCBCR444    = 0x0,
	FMT_CONTROL_PIXEL_ENCODING_YCBCR422              = 0x1,
	FMT_CONTROL_PIXEL_ENCODING_YCBCR420              = 0x2,
	FMT_CONTROL_PIXEL_ENCODING_RESERVED              = 0x3,
} FMT_CONTROL_PIXEL_ENCODING;
typedef enum FMT_CONTROL_SUBSAMPLING_MODE {
	FMT_CONTROL_SUBSAMPLING_MODE_DROP                = 0x0,
	FMT_CONTROL_SUBSAMPLING_MODE_AVERAGE             = 0x1,
	FMT_CONTROL_SUBSAMPLING_MODE_3_TAP               = 0x2,
	FMT_CONTROL_SUBSAMPLING_MODE_RESERVED            = 0x3,
} FMT_CONTROL_SUBSAMPLING_MODE;
typedef enum FMT_CONTROL_SUBSAMPLING_ORDER {
	FMT_CONTROL_SUBSAMPLING_ORDER_CB_BEFORE_CR       = 0x0,
	FMT_CONTROL_SUBSAMPLING_ORDER_CR_BEFORE_CB       = 0x1,
} FMT_CONTROL_SUBSAMPLING_ORDER;
typedef enum FMT_CONTROL_CBCR_BIT_REDUCTION_BYPASS {
	FMT_CONTROL_CBCR_BIT_REDUCTION_BYPASS_DISABLE    = 0x0,
	FMT_CONTROL_CBCR_BIT_REDUCTION_BYPASS_ENABLE     = 0x1,
} FMT_CONTROL_CBCR_BIT_REDUCTION_BYPASS;
typedef enum FMT_BIT_DEPTH_CONTROL_TRUNCATE_MODE {
	FMT_BIT_DEPTH_CONTROL_TRUNCATE_MODE_TRUNCATION   = 0x0,
	FMT_BIT_DEPTH_CONTROL_TRUNCATE_MODE_ROUNDING     = 0x1,
} FMT_BIT_DEPTH_CONTROL_TRUNCATE_MODE;
typedef enum FMT_BIT_DEPTH_CONTROL_TRUNCATE_DEPTH {
	FMT_BIT_DEPTH_CONTROL_TRUNCATE_DEPTH_18BPP       = 0x0,
	FMT_BIT_DEPTH_CONTROL_TRUNCATE_DEPTH_24BPP       = 0x1,
	FMT_BIT_DEPTH_CONTROL_TRUNCATE_DEPTH_30BPP       = 0x2,
} FMT_BIT_DEPTH_CONTROL_TRUNCATE_DEPTH;
typedef enum FMT_BIT_DEPTH_CONTROL_SPATIAL_DITHER_DEPTH {
	FMT_BIT_DEPTH_CONTROL_SPATIAL_DITHER_DEPTH_18BPP = 0x0,
	FMT_BIT_DEPTH_CONTROL_SPATIAL_DITHER_DEPTH_24BPP = 0x1,
	FMT_BIT_DEPTH_CONTROL_SPATIAL_DITHER_DEPTH_30BPP = 0x2,
} FMT_BIT_DEPTH_CONTROL_SPATIAL_DITHER_DEPTH;
typedef enum FMT_BIT_DEPTH_CONTROL_TEMPORAL_DITHER_DEPTH {
	FMT_BIT_DEPTH_CONTROL_TEMPORAL_DITHER_DEPTH_18BPP= 0x0,
	FMT_BIT_DEPTH_CONTROL_TEMPORAL_DITHER_DEPTH_24BPP= 0x1,
	FMT_BIT_DEPTH_CONTROL_TEMPORAL_DITHER_DEPTH_30BPP= 0x2,
} FMT_BIT_DEPTH_CONTROL_TEMPORAL_DITHER_DEPTH;
typedef enum FMT_BIT_DEPTH_CONTROL_TEMPORAL_LEVEL {
	FMT_BIT_DEPTH_CONTROL_TEMPORAL_LEVEL_GREY_LEVEL2 = 0x0,
	FMT_BIT_DEPTH_CONTROL_TEMPORAL_LEVEL_GREY_LEVEL4 = 0x1,
} FMT_BIT_DEPTH_CONTROL_TEMPORAL_LEVEL;
typedef enum FMT_BIT_DEPTH_CONTROL_25FRC_SEL {
	FMT_BIT_DEPTH_CONTROL_25FRC_SEL_Ei               = 0x0,
	FMT_BIT_DEPTH_CONTROL_25FRC_SEL_Fi               = 0x1,
	FMT_BIT_DEPTH_CONTROL_25FRC_SEL_Gi               = 0x2,
	FMT_BIT_DEPTH_CONTROL_25FRC_SEL_RESERVED         = 0x3,
} FMT_BIT_DEPTH_CONTROL_25FRC_SEL;
typedef enum FMT_BIT_DEPTH_CONTROL_50FRC_SEL {
	FMT_BIT_DEPTH_CONTROL_50FRC_SEL_A                = 0x0,
	FMT_BIT_DEPTH_CONTROL_50FRC_SEL_B                = 0x1,
	FMT_BIT_DEPTH_CONTROL_50FRC_SEL_C                = 0x2,
	FMT_BIT_DEPTH_CONTROL_50FRC_SEL_D                = 0x3,
} FMT_BIT_DEPTH_CONTROL_50FRC_SEL;
typedef enum FMT_BIT_DEPTH_CONTROL_75FRC_SEL {
	FMT_BIT_DEPTH_CONTROL_75FRC_SEL_E                = 0x0,
	FMT_BIT_DEPTH_CONTROL_75FRC_SEL_F                = 0x1,
	FMT_BIT_DEPTH_CONTROL_75FRC_SEL_G                = 0x2,
	FMT_BIT_DEPTH_CONTROL_75FRC_SEL_RESERVED         = 0x3,
} FMT_BIT_DEPTH_CONTROL_75FRC_SEL;
typedef enum FMT_TEMPORAL_DITHER_PATTERN_CONTROL_SELECT {
	FMT_TEMPORAL_DITHER_PATTERN_CONTROL_SELECT_LEGACY_HARDCODED_PATTERN= 0x0,
	FMT_TEMPORAL_DITHER_PATTERN_CONTROL_SELECT_PROGRAMMABLE_PATTERN= 0x1,
} FMT_TEMPORAL_DITHER_PATTERN_CONTROL_SELECT;
typedef enum FMT_TEMPORAL_DITHER_PATTERN_CONTROL_RGB1_BGR0 {
	FMT_TEMPORAL_DITHER_PATTERN_CONTROL_RGB1_BGR0_BGR= 0x0,
	FMT_TEMPORAL_DITHER_PATTERN_CONTROL_RGB1_BGR0_RGB= 0x1,
} FMT_TEMPORAL_DITHER_PATTERN_CONTROL_RGB1_BGR0;
typedef enum FMT_CLAMP_CNTL_COLOR_FORMAT {
	FMT_CLAMP_CNTL_COLOR_FORMAT_6BPC                 = 0x0,
	FMT_CLAMP_CNTL_COLOR_FORMAT_8BPC                 = 0x1,
	FMT_CLAMP_CNTL_COLOR_FORMAT_10BPC                = 0x2,
	FMT_CLAMP_CNTL_COLOR_FORMAT_12BPC                = 0x3,
	FMT_CLAMP_CNTL_COLOR_FORMAT_RESERVED1            = 0x4,
	FMT_CLAMP_CNTL_COLOR_FORMAT_RESERVED2            = 0x5,
	FMT_CLAMP_CNTL_COLOR_FORMAT_RESERVED3            = 0x6,
	FMT_CLAMP_CNTL_COLOR_FORMAT_PROGRAMMABLE         = 0x7,
} FMT_CLAMP_CNTL_COLOR_FORMAT;
typedef enum FMT_CRC_CNTL_CONT_EN {
	FMT_CRC_CNTL_CONT_EN_ONE_SHOT                    = 0x0,
	FMT_CRC_CNTL_CONT_EN_CONT                        = 0x1,
} FMT_CRC_CNTL_CONT_EN;
typedef enum FMT_CRC_CNTL_INCLUDE_OVERSCAN {
	FMT_CRC_CNTL_INCLUDE_OVERSCAN_NOT_INCLUDE        = 0x0,
	FMT_CRC_CNTL_INCLUDE_OVERSCAN_INCLUDE            = 0x1,
} FMT_CRC_CNTL_INCLUDE_OVERSCAN;
typedef enum FMT_CRC_CNTL_ONLY_BLANKB {
	FMT_CRC_CNTL_ONLY_BLANKB_ENTIRE_FIELD            = 0x0,
	FMT_CRC_CNTL_ONLY_BLANKB_NON_BLANK               = 0x1,
} FMT_CRC_CNTL_ONLY_BLANKB;
typedef enum FMT_CRC_CNTL_PSR_MODE_ENABLE {
	FMT_CRC_CNTL_PSR_MODE_ENABLE_NORMAL              = 0x0,
	FMT_CRC_CNTL_PSR_MODE_ENABLE_EDP_PSR_CRC         = 0x1,
} FMT_CRC_CNTL_PSR_MODE_ENABLE;
typedef enum FMT_CRC_CNTL_INTERLACE_MODE {
	FMT_CRC_CNTL_INTERLACE_MODE_TOP                  = 0x0,
	FMT_CRC_CNTL_INTERLACE_MODE_BOTTOM               = 0x1,
	FMT_CRC_CNTL_INTERLACE_MODE_BOTH_BOTTOM          = 0x2,
	FMT_CRC_CNTL_INTERLACE_MODE_BOTH_EACH            = 0x3,
} FMT_CRC_CNTL_INTERLACE_MODE;
typedef enum FMT_CRC_CNTL_EVEN_ODD_PIX_ENABLE {
	FMT_CRC_CNTL_EVEN_ODD_PIX_ENABLE_ALL             = 0x0,
	FMT_CRC_CNTL_EVEN_ODD_PIX_ENABLE_ODD_EVEN        = 0x1,
} FMT_CRC_CNTL_EVEN_ODD_PIX_ENABLE;
typedef enum FMT_CRC_CNTL_EVEN_ODD_PIX_SELECT {
	FMT_CRC_CNTL_EVEN_ODD_PIX_SELECT_EVEN            = 0x0,
	FMT_CRC_CNTL_EVEN_ODD_PIX_SELECT_ODD             = 0x1,
} FMT_CRC_CNTL_EVEN_ODD_PIX_SELECT;
typedef enum FMT_DEBUG_CNTL_COLOR_SELECT {
	FMT_DEBUG_CNTL_COLOR_SELECT_BLUE                 = 0x0,
	FMT_DEBUG_CNTL_COLOR_SELECT_GREEN                = 0x1,
	FMT_DEBUG_CNTL_COLOR_SELECT_RED1                 = 0x2,
	FMT_DEBUG_CNTL_COLOR_SELECT_RED2                 = 0x3,
} FMT_DEBUG_CNTL_COLOR_SELECT;
typedef enum FMT_SPATIAL_DITHER_MODE {
	FMT_SPATIAL_DITHER_MODE_0                        = 0x0,
	FMT_SPATIAL_DITHER_MODE_1                        = 0x1,
	FMT_SPATIAL_DITHER_MODE_2                        = 0x2,
	FMT_SPATIAL_DITHER_MODE_3                        = 0x3,
} FMT_SPATIAL_DITHER_MODE;
typedef enum FMT_STEREOSYNC_OVR_POL {
	FMT_STEREOSYNC_OVR_POL_INVERTED                  = 0x0,
	FMT_STEREOSYNC_OVR_POL_NOT_INVERTED              = 0x1,
} FMT_STEREOSYNC_OVR_POL;
typedef enum FMT_DYNAMIC_EXP_MODE {
	FMT_DYNAMIC_EXP_MODE_10to12                      = 0x0,
	FMT_DYNAMIC_EXP_MODE_8to12                       = 0x1,
} FMT_DYNAMIC_EXP_MODE;
typedef enum LB_DATA_FORMAT_PIXEL_DEPTH {
	LB_DATA_FORMAT_PIXEL_DEPTH_30BPP                 = 0x0,
	LB_DATA_FORMAT_PIXEL_DEPTH_24BPP                 = 0x1,
	LB_DATA_FORMAT_PIXEL_DEPTH_18BPP                 = 0x2,
	LB_DATA_FORMAT_PIXEL_DEPTH_36BPP                 = 0x3,
} LB_DATA_FORMAT_PIXEL_DEPTH;
typedef enum LB_DATA_FORMAT_PIXEL_EXPAN_MODE {
	LB_DATA_FORMAT_PIXEL_EXPAN_MODE_ZERO_PIXEL_EXPANSION= 0x0,
	LB_DATA_FORMAT_PIXEL_EXPAN_MODE_DYNAMIC_PIXEL_EXPANSION= 0x1,
} LB_DATA_FORMAT_PIXEL_EXPAN_MODE;
typedef enum LB_DATA_FORMAT_PIXEL_REDUCE_MODE {
	LB_DATA_FORMAT_PIXEL_REDUCE_MODE_TRUNCATION      = 0x0,
	LB_DATA_FORMAT_PIXEL_REDUCE_MODE_ROUNDING        = 0x1,
} LB_DATA_FORMAT_PIXEL_REDUCE_MODE;
typedef enum LB_DATA_FORMAT_DYNAMIC_PIXEL_DEPTH {
	LB_DATA_FORMAT_DYNAMIC_PIXEL_DEPTH_36BPP         = 0x0,
	LB_DATA_FORMAT_DYNAMIC_PIXEL_DEPTH_30BPP         = 0x1,
} LB_DATA_FORMAT_DYNAMIC_PIXEL_DEPTH;
typedef enum LB_DATA_FORMAT_INTERLEAVE_EN {
	LB_DATA_FORMAT_INTERLEAVE_DISABLE                = 0x0,
	LB_DATA_FORMAT_INTERLEAVE_ENABLE                 = 0x1,
} LB_DATA_FORMAT_INTERLEAVE_EN;
typedef enum LB_DATA_FORMAT_PREFILL_EN {
	LB_DATA_FORMAT_PREFILL_DISABLE                   = 0x0,
	LB_DATA_FORMAT_PREFILL_ENABLE                    = 0x1,
} LB_DATA_FORMAT_PREFILL_EN;
typedef enum LB_DATA_FORMAT_REQUEST_MODE {
	LB_DATA_FORMAT_REQUEST_MODE_NORMAL               = 0x0,
	LB_DATA_FORMAT_REQUEST_MODE_START_OF_LINE        = 0x1,
} LB_DATA_FORMAT_REQUEST_MODE;
typedef enum LB_DATA_FORMAT_ALPHA_EN {
	LB_DATA_FORMAT_ALPHA_DISABLE                     = 0x0,
	LB_DATA_FORMAT_ALPHA_ENABLE                      = 0x1,
} LB_DATA_FORMAT_ALPHA_EN;
typedef enum LB_VLINE_START_END_VLINE_INV {
	LB_VLINE_START_END_VLINE_NORMAL                  = 0x0,
	LB_VLINE_START_END_VLINE_INVERSE                 = 0x1,
} LB_VLINE_START_END_VLINE_INV;
typedef enum LB_VLINE2_START_END_VLINE2_INV {
	LB_VLINE2_START_END_VLINE2_NORMAL                = 0x0,
	LB_VLINE2_START_END_VLINE2_INVERSE               = 0x1,
} LB_VLINE2_START_END_VLINE2_INV;
typedef enum LB_INTERRUPT_MASK_VBLANK_INTERRUPT_MASK {
	LB_INTERRUPT_MASK_VBLANK_INTERRUPT_DISABLE       = 0x0,
	LB_INTERRUPT_MASK_VBLANK_INTERRUPT_ENABLE        = 0x1,
} LB_INTERRUPT_MASK_VBLANK_INTERRUPT_MASK;
typedef enum LB_INTERRUPT_MASK_VLINE_INTERRUPT_MASK {
	LB_INTERRUPT_MASK_VLINE_INTERRUPT_DISABLE        = 0x0,
	LB_INTERRUPT_MASK_VLINE_INTERRUPT_ENABLE         = 0x1,
} LB_INTERRUPT_MASK_VLINE_INTERRUPT_MASK;
typedef enum LB_INTERRUPT_MASK_VLINE2_INTERRUPT_MASK {
	LB_INTERRUPT_MASK_VLINE2_INTERRUPT_DISABLE       = 0x0,
	LB_INTERRUPT_MASK_VLINE2_INTERRUPT_ENABLE        = 0x1,
} LB_INTERRUPT_MASK_VLINE2_INTERRUPT_MASK;
typedef enum LB_VLINE_STATUS_VLINE_ACK {
	LB_VLINE_STATUS_VLINE_NORMAL                     = 0x0,
	LB_VLINE_STATUS_VLINE_CLEAR                      = 0x1,
} LB_VLINE_STATUS_VLINE_ACK;
typedef enum LB_VLINE_STATUS_VLINE_INTERRUPT_TYPE {
	LB_VLINE_STATUS_VLINE_INTERRUPT_TYPE_LEVEL_BASED = 0x0,
	LB_VLINE_STATUS_VLINE_INTERRUPT_TYPE_PULSE_BASED = 0x1,
} LB_VLINE_STATUS_VLINE_INTERRUPT_TYPE;
typedef enum LB_VLINE2_STATUS_VLINE2_ACK {
	LB_VLINE2_STATUS_VLINE2_NORMAL                   = 0x0,
	LB_VLINE2_STATUS_VLINE2_CLEAR                    = 0x1,
} LB_VLINE2_STATUS_VLINE2_ACK;
typedef enum LB_VLINE2_STATUS_VLINE2_INTERRUPT_TYPE {
	LB_VLINE2_STATUS_VLINE2_INTERRUPT_TYPE_LEVEL_BASED= 0x0,
	LB_VLINE2_STATUS_VLINE2_INTERRUPT_TYPE_PULSE_BASED= 0x1,
} LB_VLINE2_STATUS_VLINE2_INTERRUPT_TYPE;
typedef enum LB_VBLANK_STATUS_VBLANK_ACK {
	LB_VBLANK_STATUS_VBLANK_NORMAL                   = 0x0,
	LB_VBLANK_STATUS_VBLANK_CLEAR                    = 0x1,
} LB_VBLANK_STATUS_VBLANK_ACK;
typedef enum LB_VBLANK_STATUS_VBLANK_INTERRUPT_TYPE {
	LB_VBLANK_STATUS_VBLANK_INTERRUPT_TYPE_LEVEL_BASED= 0x0,
	LB_VBLANK_STATUS_VBLANK_INTERRUPT_TYPE_PULSE_BASED= 0x1,
} LB_VBLANK_STATUS_VBLANK_INTERRUPT_TYPE;
typedef enum LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL {
	LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL_DISABLE      = 0x0,
	LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL_FROM_VSYNC_VBLANK= 0x1,
	LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL_FROM_POWERDOWN_RESET= 0x2,
	LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL_FROM_VSYNC_VBLANK_POWERDOWN_RESET= 0x3,
} LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL;
typedef enum LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL2 {
	LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL2_USE_VBLANK  = 0x0,
	LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL2_USE_VSYNC   = 0x1,
} LB_SYNC_RESET_SEL_LB_SYNC_RESET_SEL2;
typedef enum LB_SYNC_RESET_SEL_LB_SYNC_DURATION {
	LB_SYNC_RESET_SEL_LB_SYNC_DURATION_16_CLOCKS     = 0x0,
	LB_SYNC_RESET_SEL_LB_SYNC_DURATION_32_CLOCKS     = 0x1,
	LB_SYNC_RESET_SEL_LB_SYNC_DURATION_64_CLOCKS     = 0x2,
	LB_SYNC_RESET_SEL_LB_SYNC_DURATION_128_CLOCKS    = 0x3,
} LB_SYNC_RESET_SEL_LB_SYNC_DURATION;
typedef enum LB_KEYER_COLOR_CTRL_LB_KEYER_COLOR_EN {
	LB_KEYER_COLOR_CTRL_LB_KEYER_COLOR_DISABLE       = 0x0,
	LB_KEYER_COLOR_CTRL_LB_KEYER_COLOR_ENABLE        = 0x1,
} LB_KEYER_COLOR_CTRL_LB_KEYER_COLOR_EN;
typedef enum LB_KEYER_COLOR_CTRL_LB_KEYER_COLOR_REP_EN {
	LB_KEYER_COLOR_CTRL_LB_KEYER_COLOR_REPLACEMENT_DISABLE= 0x0,
	LB_KEYER_COLOR_CTRL_LB_KEYER_COLOR_REPLACEMENT_ENABLE= 0x1,
} LB_KEYER_COLOR_CTRL_LB_KEYER_COLOR_REP_EN;
typedef enum LB_BUFFER_STATUS_LB_BUFFER_EMPTY_ACK {
	LB_BUFFER_STATUS_LB_BUFFER_EMPTY_NORMAL          = 0x0,
	LB_BUFFER_STATUS_LB_BUFFER_EMPTY_RESET           = 0x1,
} LB_BUFFER_STATUS_LB_BUFFER_EMPTY_ACK;
typedef enum LB_BUFFER_STATUS_LB_BUFFER_FULL_ACK {
	LB_BUFFER_STATUS_LB_BUFFER_FULL_NORMAL           = 0x0,
	LB_BUFFER_STATUS_LB_BUFFER_FULL_RESET            = 0x1,
} LB_BUFFER_STATUS_LB_BUFFER_FULL_ACK;
typedef enum LB_MVP_AFR_FLIP_MODE_MVP_AFR_FLIP_MODE {
	LB_MVP_AFR_FLIP_MODE_MVP_AFR_FLIP_MODE_REAL_FLIP = 0x2,
	LB_MVP_AFR_FLIP_MODE_MVP_AFR_FLIP_MODE_DUMMY_FLIP= 0x3,
} LB_MVP_AFR_FLIP_MODE_MVP_AFR_FLIP_MODE;
typedef enum LB_MVP_AFR_FLIP_FIFO_CNTL_MVP_AFR_FLIP_FIFO_RESET {
	LB_MVP_AFR_FLIP_FIFO_CNTL_MVP_AFR_FLIP_FIFO_NORMAL= 0x0,
	LB_MVP_AFR_FLIP_FIFO_CNTL_MVP_AFR_FLIP_FIFO_RESET_ACTIVE= 0x1,
} LB_MVP_AFR_FLIP_FIFO_CNTL_MVP_AFR_FLIP_FIFO_RESET;
typedef enum LB_MVP_AFR_FLIP_FIFO_CNTL_MVP_AFR_FLIP_FIFO_RESET_ACK {
	LB_MVP_AFR_FLIP_FIFO_CNTL_MVP_AFR_FLIP_FIFO_RESET_ACK_NOT_USED0= 0x0,
	LB_MVP_AFR_FLIP_FIFO_CNTL_MVP_AFR_FLIP_FIFO_RESET_ACK_NOT_USED1= 0x1,
} LB_MVP_AFR_FLIP_FIFO_CNTL_MVP_AFR_FLIP_FIFO_RESET_ACK;
typedef enum LB_MVP_FLIP_LINE_NUM_INSERT_MVP_FLIP_LINE_NUM_INSERT_MODE {
	LB_MVP_FLIP_LINE_NUM_INSERT_MVP_FLIP_LINE_NUM_INSERT_MODE_NO_INSERT= 0x0,
	LB_MVP_FLIP_LINE_NUM_INSERT_MVP_FLIP_LINE_NUM_INSERT_MODE_DEBUG= 0x1,
	LB_MVP_FLIP_LINE_NUM_INSERT_MVP_FLIP_LINE_NUM_INSERT_MODE_HSYNC_MODE= 0x2,
} LB_MVP_FLIP_LINE_NUM_INSERT_MVP_FLIP_LINE_NUM_INSERT_MODE;
typedef enum LB_MVP_FLIP_LINE_NUM_INSERT_MVP_FLIP_AUTO_ENABLE {
	LB_MVP_FLIP_LINE_NUM_INSERT_MVP_FLIP_AUTO_DISABLE= 0x0,
	LB_MVP_FLIP_LINE_NUM_INSERT_MVP_FLIP_AUTO_EN     = 0x1,
} LB_MVP_FLIP_LINE_NUM_INSERT_MVP_FLIP_AUTO_ENABLE;
typedef enum LB_DC_MVP_LB_CONTROL_MVP_SWAP_LOCK_IN_MODE {
	ALPHA_LB_DC_MVP_LB_CONTROL_MVP_SWAP_LOCK_IN_MODE_MASTER= 0x1,
	ALPHA_LB_DC_MVP_LB_CONTROL_MVP_SWAP_LOCK_IN_MODE_SLAVE= 0x2,
} LB_DC_MVP_LB_CONTROL_MVP_SWAP_LOCK_IN_MODE;
typedef enum LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_SEL {
	LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_SEL_NOT_USED0= 0x0,
	LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_SEL_NOT_USED1= 0x1,
} LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_SEL;
typedef enum LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_FORCE_ONE {
	LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_NO_FORCE_ONE= 0x0,
	LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_FORCE_TO_ONE= 0x1,
} LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_FORCE_ONE;
typedef enum LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_FORCE_ZERO {
	LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_NO_FORCE_ZERO= 0x0,
	LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_FORCE_TO_ZERO= 0x1,
} LB_DC_MVP_LB_CONTROL_DC_MVP_SWAP_LOCK_OUT_FORCE_ZERO;
typedef enum LB_TEST_DEBUG_INDEX_LB_TEST_DEBUG_WRITE_EN {
	LB_TEST_DEBUG_INDEX_LB_TEST_DEBUG_WRITE_EN_NOT_USED0= 0x0,
	LB_TEST_DEBUG_INDEX_LB_TEST_DEBUG_WRITE_EN_NOT_USED1= 0x1,
} LB_TEST_DEBUG_INDEX_LB_TEST_DEBUG_WRITE_EN;
typedef enum LBV_PIXEL_DEPTH {
	PIXEL_DEPTH_30BPP                                = 0x0,
	PIXEL_DEPTH_24BPP                                = 0x1,
	PIXEL_DEPTH_18BPP                                = 0x2,
	PIXEL_DEPTH_38BPP                                = 0x3,
} LBV_PIXEL_DEPTH;
typedef enum LBV_PIXEL_EXPAN_MODE {
	PIXEL_EXPAN_MODE_ZERO_EXP                        = 0x0,
	PIXEL_EXPAN_MODE_DYN_EXP                         = 0x1,
} LBV_PIXEL_EXPAN_MODE;
typedef enum LBV_INTERLEAVE_EN {
	INTERLEAVE_DIS                                   = 0x0,
	INTERLEAVE_EN                                    = 0x1,
} LBV_INTERLEAVE_EN;
typedef enum LBV_PIXEL_REDUCE_MODE {
	PIXEL_REDUCE_MODE_TRUNCATION                     = 0x0,
	PIXEL_REDUCE_MODE_ROUNDING                       = 0x1,
} LBV_PIXEL_REDUCE_MODE;
typedef enum LBV_DYNAMIC_PIXEL_DEPTH {
	DYNAMIC_PIXEL_DEPTH_36BPP                        = 0x0,
	DYNAMIC_PIXEL_DEPTH_30BPP                        = 0x1,
} LBV_DYNAMIC_PIXEL_DEPTH;
typedef enum LBV_DITHER_EN {
	DITHER_DIS                                       = 0x0,
	DITHER_EN                                        = 0x1,
} LBV_DITHER_EN;
typedef enum LBV_DOWNSCALE_PREFETCH_EN {
	DOWNSCALE_PREFETCH_DIS                           = 0x0,
	DOWNSCALE_PREFETCH_EN                            = 0x1,
} LBV_DOWNSCALE_PREFETCH_EN;
typedef enum LBV_MEMORY_CONFIG {
	MEMORY_CONFIG_0                                  = 0x0,
	MEMORY_CONFIG_1                                  = 0x1,
	MEMORY_CONFIG_2                                  = 0x2,
	MEMORY_CONFIG_3                                  = 0x3,
} LBV_MEMORY_CONFIG;
typedef enum LBV_SYNC_RESET_SEL2 {
	SYNC_RESET_SEL2_VBLANK                           = 0x0,
	SYNC_RESET_SEL2_VSYNC                            = 0x1,
} LBV_SYNC_RESET_SEL2;
typedef enum LBV_SYNC_DURATION {
	SYNC_DURATION_16                                 = 0x0,
	SYNC_DURATION_32                                 = 0x1,
	SYNC_DURATION_64                                 = 0x2,
	SYNC_DURATION_128                                = 0x3,
} LBV_SYNC_DURATION;
typedef enum SCL_C_RAM_TAP_PAIR_IDX {
	SCL_C_RAM_TAP_PAIR_ID0                           = 0x0,
	SCL_C_RAM_TAP_PAIR_ID1                           = 0x1,
	SCL_C_RAM_TAP_PAIR_ID2                           = 0x2,
	SCL_C_RAM_TAP_PAIR_ID3                           = 0x3,
	SCL_C_RAM_TAP_PAIR_ID4                           = 0x4,
} SCL_C_RAM_TAP_PAIR_IDX;
typedef enum SCL_C_RAM_PHASE {
	SCL_C_RAM_PHASE_0                                = 0x0,
	SCL_C_RAM_PHASE_1                                = 0x1,
	SCL_C_RAM_PHASE_2                                = 0x2,
	SCL_C_RAM_PHASE_3                                = 0x3,
	SCL_C_RAM_PHASE_4                                = 0x4,
	SCL_C_RAM_PHASE_5                                = 0x5,
	SCL_C_RAM_PHASE_6                                = 0x6,
	SCL_C_RAM_PHASE_7                                = 0x7,
	SCL_C_RAM_PHASE_8                                = 0x8,
} SCL_C_RAM_PHASE;
typedef enum SCL_C_RAM_FILTER_TYPE {
	SCL_C_RAM_FILTER_TYPE_VERT_LUMA_RGB_LUT          = 0x0,
	SCL_C_RAM_FILTER_TYPE_VERT_CHROMA_LUT            = 0x1,
	SCL_C_RAM_FILTER_TYPE_HORI_LUMA_RGB_LUT          = 0x2,
	SCL_C_RAM_FILTER_TYPE_HORI_CHROMA_LUT            = 0x3,
} SCL_C_RAM_FILTER_TYPE;
typedef enum SCL_MODE_SEL {
	SCL_MODE_RGB_BYPASS                              = 0x0,
	SCL_MODE_RGB_SCALING                             = 0x1,
	SCL_MODE_YCBCR_SCALING                           = 0x2,
	SCL_MODE_YCBCR_BYPASS                            = 0x3,
} SCL_MODE_SEL;
typedef enum SCL_PSCL_EN {
	SCL_PSCL_DISABLE                                 = 0x0,
	SCL_PSCL_ENANBLE                                 = 0x1,
} SCL_PSCL_EN;
typedef enum SCL_V_NUM_OF_TAPS {
	SCL_V_NUM_OF_TAPS_1                              = 0x0,
	SCL_V_NUM_OF_TAPS_2                              = 0x1,
	SCL_V_NUM_OF_TAPS_3                              = 0x2,
	SCL_V_NUM_OF_TAPS_4                              = 0x3,
	SCL_V_NUM_OF_TAPS_5                              = 0x4,
	SCL_V_NUM_OF_TAPS_6                              = 0x5,
} SCL_V_NUM_OF_TAPS;
typedef enum SCL_H_NUM_OF_TAPS {
	SCL_H_NUM_OF_TAPS_1                              = 0x0,
	SCL_H_NUM_OF_TAPS_2                              = 0x1,
	SCL_H_NUM_OF_TAPS_4                              = 0x3,
	SCL_H_NUM_OF_TAPS_6                              = 0x5,
	SCL_H_NUM_OF_TAPS_8                              = 0x7,
	SCL_H_NUM_OF_TAPS_10                             = 0x9,
} SCL_H_NUM_OF_TAPS;
typedef enum SCL_BOUNDARY_MODE {
	SCL_BOUNDARY_MODE_BLACK                          = 0x0,
	SCL_BOUNDARY_MODE_EDGE                           = 0x1,
} SCL_BOUNDARY_MODE;
typedef enum SCL_EARLY_EOL_MOD {
	SCL_EARLY_EOL_MODE_CRTC                          = 0x0,
	SCL_EARLY_EOL_MODE_INTERNAL                      = 0x1,
} SCL_EARLY_EOL_MOD;
typedef enum SCL_BYPASS_MODE {
	SCL_BYPASS_MODE_MC_MR                            = 0x0,
	SCL_BYPASS_MODE_AC_NR                            = 0x1,
	SCL_BYPASS_MODE_AC_AR                            = 0x2,
	SCL_BYPASS_MODE_RESERVED                         = 0x3,
} SCL_BYPASS_MODE;
typedef enum SCL_V_MANUAL_REPLICATE_FACTOR {
	SCL_V_MANUAL_REPLICATE_FACTOR_1                  = 0x0,
	SCL_V_MANUAL_REPLICATE_FACTOR_2                  = 0x1,
	SCL_V_MANUAL_REPLICATE_FACTOR_3                  = 0x2,
	SCL_V_MANUAL_REPLICATE_FACTOR_4                  = 0x3,
	SCL_V_MANUAL_REPLICATE_FACTOR_5                  = 0x4,
	SCL_V_MANUAL_REPLICATE_FACTOR_6                  = 0x5,
	SCL_V_MANUAL_REPLICATE_FACTOR_7                  = 0x6,
	SCL_V_MANUAL_REPLICATE_FACTOR_8                  = 0x7,
	SCL_V_MANUAL_REPLICATE_FACTOR_9                  = 0x8,
	SCL_V_MANUAL_REPLICATE_FACTOR_10                 = 0x9,
	SCL_V_MANUAL_REPLICATE_FACTOR_11                 = 0xa,
	SCL_V_MANUAL_REPLICATE_FACTOR_12                 = 0xb,
	SCL_V_MANUAL_REPLICATE_FACTOR_13                 = 0xc,
	SCL_V_MANUAL_REPLICATE_FACTOR_14                 = 0xd,
	SCL_V_MANUAL_REPLICATE_FACTOR_15                 = 0xe,
	SCL_V_MANUAL_REPLICATE_FACTOR_16                 = 0xf,
} SCL_V_MANUAL_REPLICATE_FACTOR;
typedef enum SCL_H_MANUAL_REPLICATE_FACTOR {
	SCL_H_MANUAL_REPLICATE_FACTOR_1                  = 0x0,
	SCL_H_MANUAL_REPLICATE_FACTOR_2                  = 0x1,
	SCL_H_MANUAL_REPLICATE_FACTOR_3                  = 0x2,
	SCL_H_MANUAL_REPLICATE_FACTOR_4                  = 0x3,
	SCL_H_MANUAL_REPLICATE_FACTOR_5                  = 0x4,
	SCL_H_MANUAL_REPLICATE_FACTOR_6                  = 0x5,
	SCL_H_MANUAL_REPLICATE_FACTOR_7                  = 0x6,
	SCL_H_MANUAL_REPLICATE_FACTOR_8                  = 0x7,
	SCL_H_MANUAL_REPLICATE_FACTOR_9                  = 0x8,
	SCL_H_MANUAL_REPLICATE_FACTOR_10                 = 0x9,
	SCL_H_MANUAL_REPLICATE_FACTOR_11                 = 0xa,
	SCL_H_MANUAL_REPLICATE_FACTOR_12                 = 0xb,
	SCL_H_MANUAL_REPLICATE_FACTOR_13                 = 0xc,
	SCL_H_MANUAL_REPLICATE_FACTOR_14                 = 0xd,
	SCL_H_MANUAL_REPLICATE_FACTOR_15                 = 0xe,
	SCL_H_MANUAL_REPLICATE_FACTOR_16                 = 0xf,
} SCL_H_MANUAL_REPLICATE_FACTOR;
typedef enum SCL_V_CALC_AUTO_RATIO_EN {
	SCL_V_CALC_AUTO_RATIO_DISABLE                    = 0x0,
	SCL_V_CALC_AUTO_RATIO_ENABLE                     = 0x1,
} SCL_V_CALC_AUTO_RATIO_EN;
typedef enum SCL_H_CALC_AUTO_RATIO_EN {
	SCL_H_CALC_AUTO_RATIO_DISABLE                    = 0x0,
	SCL_H_CALC_AUTO_RATIO_ENABLE                     = 0x1,
} SCL_H_CALC_AUTO_RATIO_EN;
typedef enum SCL_H_FILTER_PICK_NEAREST {
	SCL_H_FILTER_PICK_NEAREST_DISABLE                = 0x0,
	SCL_H_FILTER_PICK_NEAREST_ENABLE                 = 0x1,
} SCL_H_FILTER_PICK_NEAREST;
typedef enum SCL_H_2TAP_HARDCODE_COEF_EN {
	SCL_H_2TAP_HARDCODE_COEF_DISABLE                 = 0x0,
	SCL_H_2TAP_HARDCODE_COEF_ENABLE                  = 0x1,
} SCL_H_2TAP_HARDCODE_COEF_EN;
typedef enum SCL_V_FILTER_PICK_NEAREST {
	SCL_V_FILTER_PICK_NEAREST_DISABLE                = 0x0,
	SCL_V_FILTER_PICK_NEAREST_ENABLE                 = 0x1,
} SCL_V_FILTER_PICK_NEAREST;
typedef enum SCL_V_2TAP_HARDCODE_COEF_EN {
	SCL_V_2TAP_HARDCODE_COEF_DISABLE                 = 0x0,
	SCL_V_2TAP_HARDCODE_COEF_ENABLE                  = 0x1,
} SCL_V_2TAP_HARDCODE_COEF_EN;
typedef enum SCL_UPDATE_TAKEN {
	SCL_UPDATE_TAKEN_NO                              = 0x0,
	SCL_UPDATE_TAKEN_YES                             = 0x1,
} SCL_UPDATE_TAKEN;
typedef enum SCL_UPDATE_LOCK {
	SCL_UPDATE_UNLOCKED                              = 0x0,
	SCL_UPDATE_LOCKED                                = 0x1,
} SCL_UPDATE_LOCK;
typedef enum SCL_COEF_UPDATE_COMPLETE {
	SCL_COEF_UPDATE_NOT_COMPLETED                    = 0x0,
	SCL_COEF_UPDATE_COMPLETED                        = 0x1,
} SCL_COEF_UPDATE_COMPLETE;
typedef enum SCL_HF_SHARP_SCALE_FACTOR {
	SCL_HF_SHARP_SCALE_FACTOR_0                      = 0x0,
	SCL_HF_SHARP_SCALE_FACTOR_1                      = 0x1,
	SCL_HF_SHARP_SCALE_FACTOR_2                      = 0x2,
	SCL_HF_SHARP_SCALE_FACTOR_3                      = 0x3,
	SCL_HF_SHARP_SCALE_FACTOR_4                      = 0x4,
	SCL_HF_SHARP_SCALE_FACTOR_5                      = 0x5,
	SCL_HF_SHARP_SCALE_FACTOR_6                      = 0x6,
	SCL_HF_SHARP_SCALE_FACTOR_7                      = 0x7,
} SCL_HF_SHARP_SCALE_FACTOR;
typedef enum SCL_HF_SHARP_EN {
	SCL_HF_SHARP_DISABLE                             = 0x0,
	SCL_HF_SHARP_ENABLE                              = 0x1,
} SCL_HF_SHARP_EN;
typedef enum SCL_VF_SHARP_SCALE_FACTOR {
	SCL_VF_SHARP_SCALE_FACTOR_0                      = 0x0,
	SCL_VF_SHARP_SCALE_FACTOR_1                      = 0x1,
	SCL_VF_SHARP_SCALE_FACTOR_2                      = 0x2,
	SCL_VF_SHARP_SCALE_FACTOR_3                      = 0x3,
	SCL_VF_SHARP_SCALE_FACTOR_4                      = 0x4,
	SCL_VF_SHARP_SCALE_FACTOR_5                      = 0x5,
	SCL_VF_SHARP_SCALE_FACTOR_6                      = 0x6,
	SCL_VF_SHARP_SCALE_FACTOR_7                      = 0x7,
} SCL_VF_SHARP_SCALE_FACTOR;
typedef enum SCL_VF_SHARP_EN {
	SCL_VF_SHARP_DISABLE                             = 0x0,
	SCL_VF_SHARP_ENABLE                              = 0x1,
} SCL_VF_SHARP_EN;
typedef enum SCL_ALU_DISABLE {
	SCL_ALU_ENABLED                                  = 0x0,
	SCL_ALU_DISABLED                                 = 0x1,
} SCL_ALU_DISABLE;
typedef enum SCL_HOST_CONFLICT_MASK {
	SCL_HOST_CONFLICT_DISABLE_INTERRUPT              = 0x0,
	SCL_HOST_CONFLICT_ENABLE_INTERRUPT               = 0x1,
} SCL_HOST_CONFLICT_MASK;
typedef enum SCL_SCL_MODE_CHANGE_MASK {
	SCL_MODE_CHANGE_DISABLE_INTERRUPT                = 0x0,
	SCL_MODE_CHANGE_ENABLE_INTERRUPT                 = 0x1,
} SCL_SCL_MODE_CHANGE_MASK;
typedef enum SCLV_MODE_SEL {
	SCLV_MODE_RGB_BYPASS                             = 0x0,
	SCLV_MODE_RGB_SCALING                            = 0x1,
	SCLV_MODE_YCBCR_SCALING                          = 0x2,
	SCLV_MODE_YCBCR_BYPASS                           = 0x3,
} SCLV_MODE_SEL;
typedef enum SCLV_INTERLACE_SOURCE {
	INTERLACE_SOURCE_PROGRESSIVE                     = 0x0,
	INTERLACE_SOURCE_INTERLEAVE                      = 0x1,
	INTERLACE_SOURCE_STACK                           = 0x2,
} SCLV_INTERLACE_SOURCE;
typedef enum SCLV_UPDATE_LOCK {
	UPDATE_UNLOCKED                                  = 0x0,
	UPDATE_LOCKED                                    = 0x1,
} SCLV_UPDATE_LOCK;
typedef enum SCLV_COEF_UPDATE_COMPLETE {
	COEF_UPDATE_NOT_COMPLETE                         = 0x0,
	COEF_UPDATE_COMPLETE                             = 0x1,
} SCLV_COEF_UPDATE_COMPLETE;
typedef enum COL_MAN_UPDATE_LOCK {
	COL_MAN_UPDATE_UNLOCKED                          = 0x0,
	COL_MAN_UPDATE_LOCKED                            = 0x1,
} COL_MAN_UPDATE_LOCK;
typedef enum COL_MAN_DISABLE_MULTIPLE_UPDATE {
	COL_MAN_MULTIPLE_UPDATE                          = 0x0,
	COL_MAN_MULTIPLE_UPDAT_EDISABLE                  = 0x1,
} COL_MAN_DISABLE_MULTIPLE_UPDATE;
typedef enum COL_MAN_INPUTCSC_MODE {
	INPUTCSC_MODE_BYPASS                             = 0x0,
	INPUTCSC_MODE_A                                  = 0x1,
	INPUTCSC_MODE_B                                  = 0x2,
	INPUTCSC_MODE_UNITY                              = 0x3,
} COL_MAN_INPUTCSC_MODE;
typedef enum COL_MAN_INPUTCSC_TYPE {
	INPUTCSC_TYPE_12_0                               = 0x0,
	INPUTCSC_TYPE_10_2                               = 0x1,
	INPUTCSC_TYPE_8_4                                = 0x2,
} COL_MAN_INPUTCSC_TYPE;
typedef enum COL_MAN_INPUTCSC_CONVERT {
	INPUTCSC_ROUND                                   = 0x0,
	INPUTCSC_TRUNCATE                                = 0x1,
} COL_MAN_INPUTCSC_CONVERT;
typedef enum COL_MAN_PRESCALE_MODE {
	PRESCALE_MODE_BYPASS                             = 0x0,
	PRESCALE_MODE_PROGRAM                            = 0x1,
	PRESCALE_MODE_UNITY                              = 0x2,
} COL_MAN_PRESCALE_MODE;
typedef enum COL_MAN_INPUT_GAMMA_MODE {
	INGAMMA_MODE_BYPASS                              = 0x0,
	INGAMMA_MODE_FIX                                 = 0x1,
	INGAMMA_MODE_FLOAT                               = 0x2,
} COL_MAN_INPUT_GAMMA_MODE;
typedef enum COL_MAN_OUTPUT_CSC_MODE {
	COL_MAN_OUTPUT_CSC_BYPASS                        = 0x0,
	COL_MAN_OUTPUT_CSC_RGB                           = 0x1,
	COL_MAN_OUTPUT_CSC_YCrCb601                      = 0x2,
	COL_MAN_OUTPUT_CSC_YCrCb709                      = 0x3,
	COL_MAN_OUTPUT_CSC_A                             = 0x4,
	COL_MAN_OUTPUT_CSC_B                             = 0x5,
	COL_MAN_OUTPUT_CSC_UNITY                         = 0x6,
} COL_MAN_OUTPUT_CSC_MODE;
typedef enum COL_MAN_DENORM_CLAMP_CONTROL {
	DENORM_CLAMP_MODE_UNITY                          = 0x0,
	DENORM_CLAMP_MODE_8                              = 0x1,
	DENORM_CLAMP_MODE_10                             = 0x2,
	DENORM_CLAMP_MODE_12                             = 0x3,
} COL_MAN_DENORM_CLAMP_CONTROL;
typedef enum COL_MAN_GAMMA_CORR_CONTROL {
	GAMMA_CORR_MODE_BYPASS                           = 0x0,
	GAMMA_CORR_MODE_A                                = 0x1,
	GAMMA_CORR_MODE_B                                = 0x2,
} COL_MAN_GAMMA_CORR_CONTROL;
typedef enum COL_MAN_GLOBAL_PASSTHROUGH_ENABLE {
	CM_GLOBAL_PASSTHROUGH_DISBALE                    = 0x0,
	CM_GLOBAL_PASSTHROUGH_ENABLE                     = 0x1,
} COL_MAN_GLOBAL_PASSTHROUGH_ENABLE;
typedef enum UNP_GRPH_EN {
	UNP_GRPH_DISABLED                                = 0x0,
	UNP_GRPH_ENABLED                                 = 0x1,
} UNP_GRPH_EN;
typedef enum UNP_GRPH_DEPTH {
	UNP_GRPH_8BPP                                    = 0x0,
	UNP_GRPH_16BPP                                   = 0x1,
	UNP_GRPH_32BPP                                   = 0x2,
} UNP_GRPH_DEPTH;
typedef enum UNP_GRPH_NUM_BANKS {
	UNP_GRPH_ADDR_SURF_2_BANK                        = 0x0,
	UNP_GRPH_ADDR_SURF_4_BANK                        = 0x1,
	UNP_GRPH_ADDR_SURF_8_BANK                        = 0x2,
	UNP_GRPH_ADDR_SURF_16_BANK                       = 0x3,
} UNP_GRPH_NUM_BANKS;
typedef enum UNP_GRPH_BANK_WIDTH {
	UNP_GRPH_ADDR_SURF_BANK_WIDTH_1                  = 0x0,
	UNP_GRPH_ADDR_SURF_BANK_WIDTH_2                  = 0x1,
	UNP_GRPH_ADDR_SURF_BANK_WIDTH_4                  = 0x2,
	UNP_GRPH_ADDR_SURF_BANK_WIDTH_8                  = 0x3,
} UNP_GRPH_BANK_WIDTH;
typedef enum UNP_GRPH_BANK_HEIGHT {
	UNP_GRPH_ADDR_SURF_BANK_HEIGHT_1                 = 0x0,
	UNP_GRPH_ADDR_SURF_BANK_HEIGHT_2                 = 0x1,
	UNP_GRPH_ADDR_SURF_BANK_HEIGHT_4                 = 0x2,
	UNP_GRPH_ADDR_SURF_BANK_HEIGHT_8                 = 0x3,
} UNP_GRPH_BANK_HEIGHT;
typedef enum UNP_GRPH_TILE_SPLIT {
	UNP_ADDR_SURF_TILE_SPLIT_64B                     = 0x0,
	UNP_ADDR_SURF_TILE_SPLIT_128B                    = 0x1,
	UNP_ADDR_SURF_TILE_SPLIT_256B                    = 0x2,
	UNP_ADDR_SURF_TILE_SPLIT_512B                    = 0x3,
	UNP_ADDR_SURF_TILE_SPLIT_1KB                     = 0x4,
	UNP_ADDR_SURF_TILE_SPLIT_2KB                     = 0x5,
	UNP_ADDR_SURF_TILE_SPLIT_4KB                     = 0x6,
} UNP_GRPH_TILE_SPLIT;
typedef enum UNP_GRPH_ADDRESS_TRANSLATION_ENABLE {
	UNP_GRPH_ADDRESS_TRANSLATION_ENABLE0             = 0x0,
	UNP_GRPH_ADDRESS_TRANSLATION_ENABLE1             = 0x1,
} UNP_GRPH_ADDRESS_TRANSLATION_ENABLE;
typedef enum UNP_GRPH_PRIVILEGED_ACCESS_ENABLE {
	UNP_GRPH_PRIVILEGED_ACCESS_DIS                   = 0x0,
	UNP_GRPH_PRIVILEGED_ACCESS_EN                    = 0x1,
} UNP_GRPH_PRIVILEGED_ACCESS_ENABLE;
typedef enum UNP_GRPH_MACRO_TILE_ASPECT {
	UNP_ADDR_SURF_MACRO_ASPECT_1                     = 0x0,
	UNP_ADDR_SURF_MACRO_ASPECT_2                     = 0x1,
	UNP_ADDR_SURF_MACRO_ASPECT_4                     = 0x2,
	UNP_ADDR_SURF_MACRO_ASPECT_8                     = 0x3,
} UNP_GRPH_MACRO_TILE_ASPECT;
typedef enum UNP_GRPH_COLOR_EXPANSION_MODE {
	UNP_GRPH_DYNAMIC_EXPANSION                       = 0x0,
	UNP_GRPH_ZERO_EXPANSION                          = 0x1,
} UNP_GRPH_COLOR_EXPANSION_MODE;
typedef enum UNP_VIDEO_FORMAT {
	UNP_VIDEO_FORMAT0                                = 0x0,
	UNP_VIDEO_FORMAT1                                = 0x1,
	UNP_VIDEO_FORMAT_YUV420_YCbCr                    = 0x2,
	UNP_VIDEO_FORMAT_YUV420_YCrCb                    = 0x3,
	UNP_VIDEO_FORMAT_YUV422_YCb                      = 0x4,
	UNP_VIDEO_FORMAT_YUV422_YCr                      = 0x5,
	UNP_VIDEO_FORMAT_YUV422_CbY                      = 0x6,
	UNP_VIDEO_FORMAT_YUV422_CrY                      = 0x7,
} UNP_VIDEO_FORMAT;
typedef enum UNP_GRPH_ENDIAN_SWAP {
	UNP_GRPH_ENDIAN_SWAP_NONE                        = 0x0,
	UNP_GRPH_ENDIAN_SWAP_8IN16                       = 0x1,
	UNP_GRPH_ENDIAN_SWAP_8IN32                       = 0x2,
	UNP_GRPH_ENDIAN_SWAP_8IN43                       = 0x3,
} UNP_GRPH_ENDIAN_SWAP;
typedef enum UNP_GRPH_RED_CROSSBAR {
	UNP_GRPH_RED_CROSSBAR_R_Cr                       = 0x0,
	UNP_GRPH_RED_CROSSBAR_G_Y                        = 0x1,
	UNP_GRPH_RED_CROSSBAR_B_Cb                       = 0x2,
	UNP_GRPH_RED_CROSSBAR_A                          = 0x3,
} UNP_GRPH_RED_CROSSBAR;
typedef enum UNP_GRPH_GREEN_CROSSBAR {
	UNP_UNP_GRPH_GREEN_CROSSBAR_GY_AND_Y             = 0x0,
	UNP_UNP_GRPH_GREEN_CROSSBAR_B_Cb_AND_C           = 0x1,
	UNP_UNP_GRPH_GREEN_CROSSBAR_A                    = 0x2,
	UNP_UNP_GRPH_GREEN_CROSSBAR_R_Cr                 = 0x3,
} UNP_GRPH_GREEN_CROSSBAR;
typedef enum UNP_GRPH_BLUE_CROSSBAR {
	UNP_GRPH_BLUE_CROSSBAR_B_Cb_AND_C                = 0x0,
	UNP_GRPH_BLUE_CROSSBAR_A                         = 0x1,
	UNP_GRPH_BLUE_CROSSBAR_R_Cr                      = 0x2,
	UNP_GRPH_BLUE_CROSSBAR_GY_AND_Y                  = 0x3,
} UNP_GRPH_BLUE_CROSSBAR;
typedef enum UNP_GRPH_MODE_UPDATE_LOCKG {
	UNP_GRPH_UPDATE_LOCK_0                           = 0x0,
	UNP_GRPH_UPDATE_LOCK_1                           = 0x1,
} UNP_GRPH_MODE_UPDATE_LOCKG;
typedef enum UNP_GRPH_SURFACE_IGNORE_UPDATE_LOCK {
	UNP_GRPH_SURFACE_IGNORE_UPDATE_LOCK_0            = 0x0,
	UNP_GRPH_SURFACE_IGNORE_UPDATE_LOCK_1            = 0x1,
} UNP_GRPH_SURFACE_IGNORE_UPDATE_LOCK;
typedef enum UNP_GRPH_MODE_DISABLE_MULTIPLE_UPDATE {
	UNP_GRPH_MODE_DISABLE_MULTIPLE_UPDATE_0          = 0x0,
	UNP_GRPH_MODE_DISABLE_MULTIPLE_UPDATE_1          = 0x1,
} UNP_GRPH_MODE_DISABLE_MULTIPLE_UPDATE;
typedef enum UNP_GRPH_SURFACE_DISABLE_MULTIPLE_UPDATE {
	UNP_GRPH_SURFACE_DISABLE_MULTIPLE_UPDATE_0       = 0x0,
	UNP_GRPH_SURFACE_DISABLE_MULTIPLE_UPDATE_1       = 0x1,
} UNP_GRPH_SURFACE_DISABLE_MULTIPLE_UPDATE;
typedef enum UNP_GRPH_STEREOSYNC_FLIP_EN {
	UNP_GRPH_STEREOSYNC_FLIP_DISABLE                 = 0x0,
	UNP_GRPH_STEREOSYNC_FLIP_ENABLE                  = 0x1,
} UNP_GRPH_STEREOSYNC_FLIP_EN;
typedef enum UNP_GRPH_STEREOSYNC_FLIP_MODE {
	UNP_GRPH_STEREOSYNC_FLIP_MODE_0                  = 0x0,
	UNP_GRPH_STEREOSYNC_FLIP_MODE_1                  = 0x1,
	UNP_GRPH_STEREOSYNC_FLIP_MODE_2                  = 0x2,
	UNP_GRPH_STEREOSYNC_FLIP_MODE_3                  = 0x3,
} UNP_GRPH_STEREOSYNC_FLIP_MODE;
typedef enum UNP_GRPH_STACK_INTERLACE_FLIP_EN {
	UNP_GRPH_STACK_INTERLACE_FLIP_DISABLE            = 0x0,
	UNP_GRPH_STACK_INTERLACE_FLIP_ENABLE             = 0x1,
} UNP_GRPH_STACK_INTERLACE_FLIP_EN;
typedef enum UNP_GRPH_STACK_INTERLACE_FLIP_MODE {
	UNP_GRPH_STACK_INTERLACE_FLIP_MODE_0             = 0x0,
	UNP_GRPH_STACK_INTERLACE_FLIP_MODE_1             = 0x1,
	UNP_GRPH_STACK_INTERLACE_FLIP_MODE_2             = 0x2,
	UNP_GRPH_STACK_INTERLACE_FLIP_MODE_3             = 0x3,
} UNP_GRPH_STACK_INTERLACE_FLIP_MODE;
typedef enum UNP_GRPH_STEREOSYNC_SELECT_DISABLE {
	UNP_GRPH_STEREOSYNC_SELECT_EN                    = 0x0,
	UNP_GRPH_STEREOSYNC_SELECT_DIS                   = 0x1,
} UNP_GRPH_STEREOSYNC_SELECT_DISABLE;
typedef enum UNP_CRC_SOURCE_SEL {
	UNP_CRC_SOURCE_SEL_NP_TO_LBV                     = 0x0,
	UNP_CRC_SOURCE_SEL_LOWER32                       = 0x1,
	UNP_CRC_SOURCE_SEL_RESERVED                      = 0x2,
	UNP_CRC_SOURCE_SEL_LOWER16                       = 0x3,
	UNP_CRC_SOURCE_SEL_UNP_TO_LBV                    = 0x4,
} UNP_CRC_SOURCE_SEL;
typedef enum UNP_CRC_LINE_SEL {
	UNP_CRC_LINE_SEL_RESERVED                        = 0x0,
	UNP_CRC_LINE_SEL_EVEN_ONLY                       = 0x1,
	UNP_CRC_LINE_SEL_ODD_ONLY                        = 0x2,
	UNP_CRC_LINE_SEL_ODD_EVEN                        = 0x3,
} UNP_CRC_LINE_SEL;
typedef enum UNP_ROTATION_ANGLE {
	UNP_ROTATION_ANGLE_0                             = 0x0,
	UNP_ROTATION_ANGLE_90                            = 0x1,
	UNP_ROTATION_ANGLE_180                           = 0x2,
	UNP_ROTATION_ANGLE_270                           = 0x3,
	UNP_ROTATION_ANGLE_0m                            = 0x4,
	UNP_ROTATION_ANGLE_90m                           = 0x5,
	UNP_ROTATION_ANGLE_180m                          = 0x6,
	UNP_ROTATION_ANGLE_270m                          = 0x7,
} UNP_ROTATION_ANGLE;
typedef enum UNP_PIXEL_DROP {
	UNP_PIXEL_NO_DROP                                = 0x0,
	UNP_PIXEL_DROPPING                               = 0x1,
} UNP_PIXEL_DROP;
typedef enum UNP_BUFFER_MODE {
	UNP_BUFFER_MODE_LUMA                             = 0x0,
	UNP_BUFFER_MODE_LUMA_CHROMA                      = 0x1,
} UNP_BUFFER_MODE;
typedef enum WATERMARK_MASK_CONTROL {
	WM_MASK_CONTROL_SET_A                            = 0x0,
	WM_MASK_CONTROL_SET_B                            = 0x1,
	WM_MASK_CONTROL_SET_C                            = 0x2,
	WM_MASK_CONTROL_SET_D                            = 0x3,
	WM_MASK_CONTROL_RESERVED1                        = 0x4,
	WM_MASK_CONTROL_RESERVED2                        = 0x5,
	WM_MASK_CONTROL_RESERVED3                        = 0x6,
	WM_MASK_CONTROL_ACTIVE_SET                       = 0x7,
} WATERMARK_MASK_CONTROL;
typedef enum AZALIA_F2_CODEC_FUNCTION_CONTROL_RESET_CODEC_RESET {
	AZALIA_F2_CODEC_FUNCTION_CONTROL_RESET_CODEC_NOT_RESET= 0x0,
	AZALIA_F2_CODEC_FUNCTION_CONTROL_RESET_CODEC_DO_RESET= 0x1,
} AZALIA_F2_CODEC_FUNCTION_CONTROL_RESET_CODEC_RESET;
typedef enum CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY {
	CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY_ALL= 0x0,
	CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY_6= 0x1,
	CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY_5= 0x2,
	CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY_4= 0x3,
	CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY_3= 0x4,
	CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY_2= 0x5,
	CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY_1= 0x6,
	CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY_0= 0x7,
} CC_RCU_DC_AUDIO_PORT_CONNECTIVITY_PORT_CONNECTIVITY;
typedef enum CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY {
	CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY_ALL= 0x0,
	CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY_6= 0x1,
	CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY_5= 0x2,
	CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY_4= 0x3,
	CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY_3= 0x4,
	CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY_2= 0x5,
	CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY_1= 0x6,
	CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY_0= 0x7,
} CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_INPUT_PORT_CONNECTIVITY;
typedef enum GENERIC_AZ_CONTROLLER_REGISTER_ENABLE_CONTROL {
	GENERIC_AZ_CONTROLLER_REGISTER_DISABLE           = 0x0,
	GENERIC_AZ_CONTROLLER_REGISTER_ENABLE            = 0x1,
} GENERIC_AZ_CONTROLLER_REGISTER_ENABLE_CONTROL;
typedef enum GENERIC_AZ_CONTROLLER_REGISTER_ENABLE_CONTROL_RESERVED {
	GENERIC_AZ_CONTROLLER_REGISTER_DISABLE_RESERVED  = 0x0,
	GENERIC_AZ_CONTROLLER_REGISTER_ENABLE_RESERVED   = 0x1,
} GENERIC_AZ_CONTROLLER_REGISTER_ENABLE_CONTROL_RESERVED;
typedef enum GENERIC_AZ_CONTROLLER_REGISTER_STATUS {
	GENERIC_AZ_CONTROLLER_REGISTER_STATUS_NOT_SET    = 0x0,
	GENERIC_AZ_CONTROLLER_REGISTER_STATUS_SET        = 0x1,
} GENERIC_AZ_CONTROLLER_REGISTER_STATUS;
typedef enum GENERIC_AZ_CONTROLLER_REGISTER_STATUS_RESERVED {
	GENERIC_AZ_CONTROLLER_REGISTER_STATUS_NOT_SET_RESERVED= 0x0,
	GENERIC_AZ_CONTROLLER_REGISTER_STATUS_SET_RESERVED= 0x1,
} GENERIC_AZ_CONTROLLER_REGISTER_STATUS_RESERVED;
typedef enum AZ_GLOBAL_CAPABILITIES {
	AZ_GLOBAL_CAPABILITIES_SIXTY_FOUR_BIT_ADDRESS_NOT_SUPPORTED= 0x0,
	AZ_GLOBAL_CAPABILITIES_SIXTY_FOUR_BIT_ADDRESS_SUPPORTED= 0x1,
} AZ_GLOBAL_CAPABILITIES;
typedef enum GLOBAL_CONTROL_ACCEPT_UNSOLICITED_RESPONSE {
	ACCEPT_UNSOLICITED_RESPONSE_NOT_ENABLE           = 0x0,
	ACCEPT_UNSOLICITED_RESPONSE_ENABLE               = 0x1,
} GLOBAL_CONTROL_ACCEPT_UNSOLICITED_RESPONSE;
typedef enum GLOBAL_CONTROL_FLUSH_CONTROL {
	FLUSH_CONTROL_FLUSH_NOT_STARTED                  = 0x0,
	FLUSH_CONTROL_FLUSH_STARTED                      = 0x1,
} GLOBAL_CONTROL_FLUSH_CONTROL;
typedef enum GLOBAL_CONTROL_CONTROLLER_RESET {
	CONTROLLER_RESET_AZ_CONTROLLER_IN_RESET          = 0x0,
	CONTROLLER_RESET_AZ_CONTROLLER_NOT_IN_RESET      = 0x1,
} GLOBAL_CONTROL_CONTROLLER_RESET;
typedef enum AZ_STATE_CHANGE_STATUS {
	AZ_STATE_CHANGE_STATUS_CODEC_NOT_PRESENT         = 0x0,
	AZ_STATE_CHANGE_STATUS_CODEC_PRESENT             = 0x1,
} AZ_STATE_CHANGE_STATUS;
typedef enum GLOBAL_STATUS_FLUSH_STATUS {
	GLOBAL_STATUS_FLUSH_STATUS_FLUSH_NOT_ENDED       = 0x0,
	GLOBAL_STATUS_FLUSH_STATUS_FLUSH_ENDED           = 0x1,
} GLOBAL_STATUS_FLUSH_STATUS;
typedef enum STREAM_0_SYNCHRONIZATION {
	STREAM_0_SYNCHRONIZATION_STEAM_NOT_STOPPED       = 0x0,
	STREAM_0_SYNCHRONIZATION_STEAM_STOPPED           = 0x1,
} STREAM_0_SYNCHRONIZATION;
typedef enum STREAM_1_SYNCHRONIZATION {
	STREAM_1_SYNCHRONIZATION_STEAM_NOT_STOPPED       = 0x0,
	STREAM_1_SYNCHRONIZATION_STEAM_STOPPED           = 0x1,
} STREAM_1_SYNCHRONIZATION;
typedef enum STREAM_2_SYNCHRONIZATION {
	STREAM_2_SYNCHRONIZATION_STEAM_NOT_STOPPED       = 0x0,
	STREAM_2_SYNCHRONIZATION_STEAM_STOPPED           = 0x1,
} STREAM_2_SYNCHRONIZATION;
typedef enum STREAM_3_SYNCHRONIZATION {
	STREAM_3_SYNCHRONIZATION_STEAM_NOT_STOPPED       = 0x0,
	STREAM_3_SYNCHRONIZATION_STEAM_STOPPED           = 0x1,
} STREAM_3_SYNCHRONIZATION;
typedef enum STREAM_4_SYNCHRONIZATION {
	STREAM_4_SYNCHRONIZATION_STEAM_NOT_STOPPED       = 0x0,
	STREAM_4_SYNCHRONIZATION_STEAM_STOPPED           = 0x1,
} STREAM_4_SYNCHRONIZATION;
typedef enum STREAM_5_SYNCHRONIZATION {
	STREAM_5_SYNCHRONIZATION_STEAM_NOT_STOPPED       = 0x0,
	STREAM_5_SYNCHRONIZATION_STEAM_STOPPED           = 0x1,
} STREAM_5_SYNCHRONIZATION;
typedef enum STREAM_6_SYNCHRONIZATION {
	STREAM_6_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_6_SYNCHRONIZATION_STEAM_STOPPED_RESERVED  = 0x1,
} STREAM_6_SYNCHRONIZATION;
typedef enum STREAM_7_SYNCHRONIZATION {
	STREAM_7_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_7_SYNCHRONIZATION_STEAM_STOPPED_RESERVED  = 0x1,
} STREAM_7_SYNCHRONIZATION;
typedef enum STREAM_8_SYNCHRONIZATION {
	STREAM_8_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_8_SYNCHRONIZATION_STEAM_STOPPED_RESERVED  = 0x1,
} STREAM_8_SYNCHRONIZATION;
typedef enum STREAM_9_SYNCHRONIZATION {
	STREAM_9_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_9_SYNCHRONIZATION_STEAM_STOPPED_RESERVED  = 0x1,
} STREAM_9_SYNCHRONIZATION;
typedef enum STREAM_10_SYNCHRONIZATION {
	STREAM_10_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_10_SYNCHRONIZATION_STEAM_STOPPED_RESERVED = 0x1,
} STREAM_10_SYNCHRONIZATION;
typedef enum STREAM_11_SYNCHRONIZATION {
	STREAM_11_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_11_SYNCHRONIZATION_STEAM_STOPPED_RESERVED = 0x1,
} STREAM_11_SYNCHRONIZATION;
typedef enum STREAM_12_SYNCHRONIZATION {
	STREAM_12_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_12_SYNCHRONIZATION_STEAM_STOPPED_RESERVED = 0x1,
} STREAM_12_SYNCHRONIZATION;
typedef enum STREAM_13_SYNCHRONIZATION {
	STREAM_13_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_13_SYNCHRONIZATION_STEAM_STOPPED_RESERVED = 0x1,
} STREAM_13_SYNCHRONIZATION;
typedef enum STREAM_14_SYNCHRONIZATION {
	STREAM_14_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_14_SYNCHRONIZATION_STEAM_STOPPED_RESERVED = 0x1,
} STREAM_14_SYNCHRONIZATION;
typedef enum STREAM_15_SYNCHRONIZATION {
	STREAM_15_SYNCHRONIZATION_STEAM_NOT_STOPPED_RESERVED= 0x0,
	STREAM_15_SYNCHRONIZATION_STEAM_STOPPED_RESERVED = 0x1,
} STREAM_15_SYNCHRONIZATION;
typedef enum CORB_READ_POINTER_RESET {
	CORB_READ_POINTER_RESET_CORB_DMA_IS_NOT_RESET    = 0x0,
	CORB_READ_POINTER_RESET_CORB_DMA_IS_RESET        = 0x1,
} CORB_READ_POINTER_RESET;
typedef enum AZ_CORB_SIZE {
	AZ_CORB_SIZE_2ENTRIES_RESERVED                   = 0x0,
	AZ_CORB_SIZE_16ENTRIES_RESERVED                  = 0x1,
	AZ_CORB_SIZE_256ENTRIES                          = 0x2,
	AZ_CORB_SIZE_RESERVED                            = 0x3,
} AZ_CORB_SIZE;
typedef enum AZ_RIRB_WRITE_POINTER_RESET {
	AZ_RIRB_WRITE_POINTER_NOT_RESET                  = 0x0,
	AZ_RIRB_WRITE_POINTER_DO_RESET                   = 0x1,
} AZ_RIRB_WRITE_POINTER_RESET;
typedef enum RIRB_CONTROL_RESPONSE_OVERRUN_INTERRUPT_CONTROL {
	RIRB_CONTROL_RESPONSE_OVERRUN_INTERRUPT_CONTROL_INTERRUPT_DISABLED= 0x0,
	RIRB_CONTROL_RESPONSE_OVERRUN_INTERRUPT_CONTROL_INTERRUPT_ENABLED= 0x1,
} RIRB_CONTROL_RESPONSE_OVERRUN_INTERRUPT_CONTROL;
typedef enum RIRB_CONTROL_RESPONSE_INTERRUPT_CONTROL {
	RIRB_CONTROL_RESPONSE_INTERRUPT_CONTROL_INTERRUPT_DISABLED= 0x0,
	RIRB_CONTROL_RESPONSE_INTERRUPT_CONTROL_INTERRUPT_ENABLED= 0x1,
} RIRB_CONTROL_RESPONSE_INTERRUPT_CONTROL;
typedef enum AZ_RIRB_SIZE {
	AZ_RIRB_SIZE_2ENTRIES_RESERVED                   = 0x0,
	AZ_RIRB_SIZE_16ENTRIES_RESERVED                  = 0x1,
	AZ_RIRB_SIZE_256ENTRIES                          = 0x2,
	AZ_RIRB_SIZE_UNDEFINED                           = 0x3,
} AZ_RIRB_SIZE;
typedef enum IMMEDIATE_COMMAND_STATUS_IMMEDIATE_RESULT_VALID {
	IMMEDIATE_COMMAND_STATUS_IMMEDIATE_RESULT_VALID_NO_IMMEDIATE_RESPONSE_VALID= 0x0,
	IMMEDIATE_COMMAND_STATUS_IMMEDIATE_RESULT_VALID_IMMEDIATE_RESPONSE_VALID= 0x1,
} IMMEDIATE_COMMAND_STATUS_IMMEDIATE_RESULT_VALID;
typedef enum IMMEDIATE_COMMAND_STATUS_IMMEDIATE_COMMAND_BUSY {
	IMMEDIATE_COMMAND_STATUS_IMMEDIATE_COMMAND_NOT_BUSY= 0x0,
	IMMEDIATE_COMMAND_STATUS_IMMEDIATE_COMMAND_IS_BUSY= 0x1,
} IMMEDIATE_COMMAND_STATUS_IMMEDIATE_COMMAND_BUSY;
typedef enum DMA_POSITION_LOWER_BASE_ADDRESS_BUFFER_ENABLE {
	DMA_POSITION_LOWER_BASE_ADDRESS_BUFFER_ENABLE_DMA_DISABLE= 0x0,
	DMA_POSITION_LOWER_BASE_ADDRESS_BUFFER_ENABLE_DMA_ENABLE= 0x1,
} DMA_POSITION_LOWER_BASE_ADDRESS_BUFFER_ENABLE;
typedef enum OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_DESCRIPTOR_ERROR {
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_DESCRIPTOR_ERROR_STATUS_NOT_SET= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_DESCRIPTOR_ERROR_STATUS_SET= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_DESCRIPTOR_ERROR;
typedef enum OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_FIFO_ERROR {
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_FIFO_ERROR_STATUS_NOT_SET= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_FIFO_ERROR_STATUS_SET= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_FIFO_ERROR;
typedef enum OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_BUFFER_COMPLETION_INTERRUPT_STATUS {
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_BUFFER_COMPLETION_INTERRUPT_STATUS_NOT_SET= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_BUFFER_COMPLETION_INTERRUPT_STATUS_SET= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_BUFFER_COMPLETION_INTERRUPT_STATUS;
typedef enum OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_TRAFFIC_PRIORITY {
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_NO_TRAFFIC_PRIORITY= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_YES_TRAFFIC_PRIORITY= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_TRAFFIC_PRIORITY;
typedef enum OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_DESCRIPTOR_ERROR_INTERRUPT_ENABLE {
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_DESCRIPTOR_ERROR_INTERRUPT_DISABLED= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_DESCRIPTOR_ERROR_INTERRUPT_ENABLED= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_DESCRIPTOR_ERROR_INTERRUPT_ENABLE;
typedef enum OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_FIFO_ERROR_INTERRUPT_ENABLE {
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_FIFO_ERROR_INTERRUPT_DISABLED= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_FIFO_ERROR_INTERRUPT_ENABLED= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_FIFO_ERROR_INTERRUPT_ENABLE;
typedef enum OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_INTERRUPT_ON_COMPLETION_ENABLE {
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_INTERRUPT_ON_COMPLETION_ENABLE_INTERRUPT_DISABLED= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_INTERRUPT_ON_COMPLETION_ENABLE_INTERRUPT_ENABLED= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_INTERRUPT_ON_COMPLETION_ENABLE;
typedef enum OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_STREAM_RUN {
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_STREAM_NOT_RUN= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_STREAM_DO_RUN= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_STREAM_RUN;
typedef enum OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_STREAM_RESET {
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_STREAM_NOT_RESET= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_STREAM_IS_RESET= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS_STREAM_RESET;
typedef enum OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_RATE {
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_RATE_48KHZ= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_RATE_44P1KHZ= 0x1,
} OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_RATE;
typedef enum OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_MULTIPLE {
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_MULTIPLE_BY1= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_MULTIPLE_BY2= 0x1,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_MULTIPLE_BY3_RESERVED= 0x2,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_MULTIPLE_BY4= 0x3,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_MULTIPLE_RESERVED= 0x4,
} OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_MULTIPLE;
typedef enum OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR {
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR_BY1= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR_BY2_RESERVED= 0x1,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR_BY3= 0x2,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR_BY4_RESERVED= 0x3,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR_BY5_RESERVED= 0x4,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR_BY6_RESERVED= 0x5,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR_BY7_RESERVED= 0x6,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR_BY8_RESERVED= 0x7,
} OUTPUT_STREAM_DESCRIPTOR_FORMAT_SAMPLE_BASE_DIVISOR;
typedef enum OUTPUT_STREAM_DESCRIPTOR_FORMAT_BITS_PER_SAMPLE {
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_BITS_PER_SAMPLE_8_RESERVED= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_BITS_PER_SAMPLE_16= 0x1,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_BITS_PER_SAMPLE_20= 0x2,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_BITS_PER_SAMPLE_24= 0x3,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_BITS_PER_SAMPLE_32_RESERVED= 0x4,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_BITS_PER_SAMPLE_RESERVED= 0x5,
} OUTPUT_STREAM_DESCRIPTOR_FORMAT_BITS_PER_SAMPLE;
typedef enum OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS {
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_1= 0x0,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_2= 0x1,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_3= 0x2,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_4= 0x3,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_5= 0x4,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_6= 0x5,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_7= 0x6,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_8= 0x7,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_9_RESERVED= 0x8,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_10_RESERVED= 0x9,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_11_RESERVED= 0xa,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_12_RESERVED= 0xb,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_13_RESERVED= 0xc,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_14_RESERVED= 0xd,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_15_RESERVED= 0xe,
	OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS_16_RESERVED= 0xf,
} OUTPUT_STREAM_DESCRIPTOR_FORMAT_NUMBER_OF_CHANNELS;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_STREAM_TYPE {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_STREAM_TYPE_PCM= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_STREAM_TYPE_NOT_PCM= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_STREAM_TYPE;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_RATE {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_RATE_48KHZ= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_RATE_44P1KHZ= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_RATE;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_BY1= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_BY2= 0x1,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_BY3_RESERVED= 0x2,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_BY4= 0x3,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_RESERVED= 0x4,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY1= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY2_RESERVED= 0x1,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY3= 0x2,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY4_RESERVED= 0x3,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY5_RESERVED= 0x4,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY6_RESERVED= 0x5,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY7_RESERVED= 0x6,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY8_RESERVED= 0x7,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_8_RESERVED= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_16= 0x1,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_20= 0x2,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_24= 0x3,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_32_RESERVED= 0x4,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_RESERVED= 0x5,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_1= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_2= 0x1,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_3= 0x2,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_4= 0x3,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_5= 0x4,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_6= 0x5,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_7= 0x6,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_8= 0x7,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_RESERVED= 0x8,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_L {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_L_BIT7_NOT_SET= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_L_BIT7_IS_SET= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_L;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_PRO {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_PRO_BIT_A_NOT_SET= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_PRO_BIT_A_IS_SET= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_PRO;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_NON_AUDIO {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_NON_AUDIO_BIT_B_NOT_SET= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_NON_AUDIO_BIT_B_IS_SET= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_NON_AUDIO;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_COPY {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_COPY_BIT_C_IS_SET= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_COPY_BIT_C_NOT_SET= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_COPY;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_PRE {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_PRE_LSB_OF_D_NOT_SET= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_PRE_LSB_OF_D_IS_SET= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_PRE;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_VCFG {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_VALIDITY_CFG_NOT_ON= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_VALIDITY_CFG_ON= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_VCFG;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_V {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_V_BIT28_IS_ZERO= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_V_BIT28_IS_ONE= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_V;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_DIGEN {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_DIGEN_DIGITAL_TRANSMISSION_DISABLED= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_DIGEN_DIGITAL_TRANSMISSION_ENABLED= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_DIGEN;
typedef enum AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_3_KEEPALIVE {
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_3_KEEPALIVE_SILENT_STREAM_NOT_ENABLE= 0x0,
	AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_3_KEEPALIVE_SILENT_STREAM_ENABLE= 0x1,
} AZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_3_KEEPALIVE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_WIDGET_CONTROL_OUT_ENABLE {
	AZALIA_F2_CODEC_PIN_CONTROL_WIDGET_CONTROL_OUT_ENABLE_PIN_SHUT_OFF= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_WIDGET_CONTROL_OUT_ENABLE_PIN_DRIVEN= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_WIDGET_CONTROL_OUT_ENABLE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_ENABLE {
	AZALIA_F2_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_DISABLED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_ENABLED= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_ENABLE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_DOWN_MIX_INFO_DOWN_MIX_INHIBIT {
	AZALIA_F2_CODEC_PIN_CONTROL_DOWN_MIX_NO_INFO_OR_PERMITTED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_DOWN_MIX_FORBIDDEN   = 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_DOWN_MIX_INFO_DOWN_MIX_INHIBIT;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL01_ENABLE_MULTICHANNEL01_MUTE {
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL01_ENABLE_MULTICHANNEL01_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL01_ENABLE_MULTICHANNEL01_MUTED= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL01_ENABLE_MULTICHANNEL01_MUTE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL23_ENABLE_MULTICHANNEL23_MUTE {
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL23_ENABLE_MULTICHANNEL23_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL23_ENABLE_MULTICHANNEL23_MUTED= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL23_ENABLE_MULTICHANNEL23_MUTE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL45_ENABLE_MULTICHANNEL45_MUTE {
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL45_ENABLE_MULTICHANNEL45_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL45_ENABLE_MULTICHANNEL45_MUTED= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL45_ENABLE_MULTICHANNEL45_MUTE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL67_ENABLE_MULTICHANNEL67_MUTE {
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL67_ENABLE_MULTICHANNEL67_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL67_ENABLE_MULTICHANNEL67_MUTED= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL67_ENABLE_MULTICHANNEL67_MUTE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL1_ENABLE_MULTICHANNEL1_MUTE {
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL1_ENABLE_MULTICHANNEL1_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL1_ENABLE_MULTICHANNEL1_MUTED= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL1_ENABLE_MULTICHANNEL1_MUTE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL3_ENABLE_MULTICHANNEL3_MUTE {
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL3_ENABLE_MULTICHANNEL3_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL3_ENABLE_MULTICHANNEL3_MUTED= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL3_ENABLE_MULTICHANNEL3_MUTE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL5_ENABLE_MULTICHANNEL5_MUTE {
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL5_ENABLE_MULTICHANNEL5_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL5_ENABLE_MULTICHANNEL5_MUTED= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL5_ENABLE_MULTICHANNEL5_MUTE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL7_ENABLE_MULTICHANNEL7_MUTE {
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL7_ENABLE_MULTICHANNEL7_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL7_ENABLE_MULTICHANNEL7_MUTED= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL7_ENABLE_MULTICHANNEL7_MUTE;
typedef enum AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL_MODE_MULTICHANNEL_MODE {
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL_MODE_MULTICHANNEL_PAIR_MODE= 0x0,
	AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL_MODE_MULTICHANNEL_SINGLE_MODE= 0x1,
} AZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL_MODE_MULTICHANNEL_MODE;
typedef enum AZ_LATENCY_COUNTER_CONTROL {
	AZ_LATENCY_COUNTER_NO_RESET                      = 0x0,
	AZ_LATENCY_COUNTER_RESET_DONE                    = 0x1,
} AZ_LATENCY_COUNTER_CONTROL;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_OUTPUT_CONVERTER_RESERVED= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_INPUT_CONVERTER_RESERVED= 0x1,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_MIXER_RESERVED= 0x2,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_SELECTOR_RESERVED= 0x3,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_PIN_RESERVED= 0x4,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_POWER_WIDGET_RESERVED= 0x5,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_VOLUME_KNOB_RESERVED= 0x6,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_BEEP_GENERATOR_RESERVED= 0x7,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_RESERVED_RESERVED= 0x8,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_VENDOR_DEFINED_RESERVED= 0x9,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_LR_SWAP {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_LR_SWAP_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_LR_SWAP_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_LR_SWAP;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_POWER_CONTROL {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_POWER_CONTROL_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_POWER_CONTROL_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_POWER_CONTROL;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_DIGITAL {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_IS_ANALOG= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_IS_DIGITAL= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_DIGITAL;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CONNECTION_LIST {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_CONNECTION_LIST= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_CONNECTION_LIST= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CONNECTION_LIST;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_UNSOLICITED_RESPONSE_CAPABILITY {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_UNSOLICITED_RESPONSE_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_UNSOLICITED_RESPONSE_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_UNSOLICITED_RESPONSE_CAPABILITY;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET_NO_PROCESSING_CAPABILITIES= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET_HAVE_PROCESSING_CAPABILITIES= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_STRIPE {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_SUPPORT_STRIPING= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_SUPPORT_STRIPING= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_STRIPE;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_FORMAT_OVERRIDE {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_FORMAT_OVERRIDE= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_SUPPORT_FORMAT_OVERRIDE= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_FORMAT_OVERRIDE;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AMPLIFIER_PARAMETER_OVERRIDE {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_AMPLIFIER_PARAMETER= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_AMPLIFIER_PARAMETER_OVERRIDE= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AMPLIFIER_PARAMETER_OVERRIDE;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_OUTPUT_AMPLIFIER_PRESENT {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_OUTPUT_AMPLIFIER= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_OUTPUT_AMPLIFIER= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_OUTPUT_AMPLIFIER_PRESENT;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_INPUT_AMPLIFIER_PRESENT {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_INPUT_AMPLIFIER= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_INPUT_AMPLIFIER= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_INPUT_AMPLIFIER_PRESENT;
typedef enum AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AUDIO_CHANNEL_CAPABILITIES {
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AUDIO_CHANNEL_CAPABILITIES_MONOPHONIC= 0x0,
	AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AUDIO_CHANNEL_CAPABILITIES_STEREO= 0x1,
} AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AUDIO_CHANNEL_CAPABILITIES;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_OUTPUT_CONVERTER_RESERVED= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_INPUT_CONVERTER_RESERVED= 0x1,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_MIXER_RESERVED= 0x2,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_SELECTOR_RESERVED= 0x3,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_PIN_RESERVED= 0x4,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_POWER_WIDGET_RESERVED= 0x5,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_VOLUME_KNOB_RESERVED= 0x6,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_BEEP_GENERATOR_RESERVED= 0x7,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_RESERVED_RESERVED= 0x8,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_VENDOR_DEFINED_RESERVED= 0x9,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_LR_SWAP {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_LR_SWAP_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_LR_SWAP_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_LR_SWAP;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_POWER_CONTROL {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_POWER_CONTROL_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_POWER_CONTROL_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_POWER_CONTROL;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_DIGITAL {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_IS_ANALOG= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_IS_DIGITAL= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_DIGITAL;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CONNECTION_LIST {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_CONNECTION_LIST= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_CONNECTION_LIST= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CONNECTION_LIST;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_UNSOLICITED_RESPONSE_CAPABILITY {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_UNSOLICITED_RESPONSE_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_UNSOLICITED_RESPONSE_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_UNSOLICITED_RESPONSE_CAPABILITY;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET_NO_PROCESSING_CAPABILITIES= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET_HAVE_PROCESSING_CAPABILITIES= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_STRIPE {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_SUPPORT_STRIPING= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_SUPPORT_STRIPING= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_STRIPE;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AMPLIFIER_PARAMETER_OVERRIDE {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_AMPLIFIER_PARAMETER= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_AMPLIFIER_PARAMETER_OVERRIDE= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AMPLIFIER_PARAMETER_OVERRIDE;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_OUTPUT_AMPLIFIER_PRESENT {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_OUTPUT_AMPLIFIER= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_OUTPUT_AMPLIFIER= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_OUTPUT_AMPLIFIER_PRESENT;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_INPUT_AMPLIFIER_PRESENT {
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_INPUT_AMPLIFIER_PRESENT= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_INPUT_AMPLIFIER= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_INPUT_AMPLIFIER_PRESENT;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_EAPD_CAPABLE {
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_NO_EAPD_PIN= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_HAVE_EAPD_PIN= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_EAPD_CAPABLE;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_BALANCED_I_O_PINS {
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_I_O_PINS_ARE_NOT_BALANCED= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_I_O_PINS_ARE_BALANCED= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_BALANCED_I_O_PINS;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_INPUT_CAPABLE {
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_NO_INPUT_PIN= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_HAVE_INPUT_PIN= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_INPUT_CAPABLE;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_OUTPUT_CAPABLE {
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_NO_OUTPUT_PIN= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_HAVE_OUTPUT_PIN= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_OUTPUT_CAPABLE;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_HEADPHONE_DRIVE_CAPABLE {
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_NO_HEADPHONE_DRIVE_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_HAVE_HEADPHONE_DRIVE_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_HEADPHONE_DRIVE_CAPABLE;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_JACK_DETECTION_CAPABILITY {
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_NO_JACK_DETECTION_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_HAVE_JACK_DETECTION_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_JACK_DETECTION_CAPABILITY;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_TRIGGER_REQUIRED {
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_NO_TRIGGER_REQUIRED_FOR_IMPEDANCE_MEASUREMENT= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_TRIGGER_REQUIRED_FOR_IMPEDANCE_MEASUREMENT= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_TRIGGER_REQUIRED;
typedef enum AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_IMPEDANCE_SENSE_CAPABLE {
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_NO_IMPEDANCE_SENSE_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_HAVE_IMPEDANCE_SENSE_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES_IMPEDANCE_SENSE_CAPABLE;
typedef enum AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE_MULTICHANNEL_MODE {
	AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE_MULTICHANNEL_PAIR_MODE= 0x0,
	AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE_MULTICHANNEL_SINGLE_MODE= 0x1,
} AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE_MULTICHANNEL_MODE;
typedef enum AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR_HBR_CAPABLE {
	AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR_NO_HBR_CAPABLILITY= 0x0,
	AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR_HAVE_HBR_CAPABLILITY= 0x1,
} AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR_HBR_CAPABLE;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_OUTPUT_CONVERTER_RESERVED= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_INPUT_CONVERTER_RESERVED= 0x1,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_MIXER_RESERVED= 0x2,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_SELECTOR_RESERVED= 0x3,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_PIN_RESERVED= 0x4,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_POWER_WIDGET_RESERVED= 0x5,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_VOLUME_KNOB_RESERVED= 0x6,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_BEEP_GENERATOR_RESERVED= 0x7,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_RESERVED= 0x8,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_VENDOR_DEFINED_RESERVED= 0x9,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_LR_SWAP {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_LR_SWAP_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_LR_SWAP_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_LR_SWAP;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_POWER_CONTROL {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_POWER_CONTROL_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_POWER_CONTROL_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_POWER_CONTROL;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_DIGITAL {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CODEC_CONVERTER0_IS_ANALOG= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CODEC_CONVERTER0_IS_DIGITAL= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_DIGITAL;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CONNECTION_LIST {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_CONNECTION_LIST= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_CONNECTION_LIST= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CONNECTION_LIST;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_UNSOLICITED_RESPONSE_CAPABILITY {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_UNSOLICITED_RESPONSE_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_UNSOLICITED_RESPONSE_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_UNSOLICITED_RESPONSE_CAPABILITY;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET_CODEC_CONVERTER0_HAVE_NO_PROCESSING_CAPABILITIES= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET_CODEC_CONVERTER0_HAVE_PROCESSING_CAPABILITIES= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_STRIPE {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NOT_SUPPORT_STRIPING= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_SUPPORT_STRIPING= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_STRIPE;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_FORMAT_OVERRIDE {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_FORMAT_OVERRIDE= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_FORMAT_OVERRIDE= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_FORMAT_OVERRIDE;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AMPLIFIER_PARAMETER_OVERRIDE {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_AMPLIFIER_PARAMETER= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_AMPLIFIER_PARAMETER= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AMPLIFIER_PARAMETER_OVERRIDE;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_OUTPUT_AMPLIFIER_PRESENT {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_OUTPUT_AMPLIFIER= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_OUTPUT_AMPLIFIER= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_OUTPUT_AMPLIFIER_PRESENT;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_INPUT_AMPLIFIER_PRESENT {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_INPUT_AMPLIFIER= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_INPUT_AMPLIFIER= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_INPUT_AMPLIFIER_PRESENT;
typedef enum AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AUDIO_CHANNEL_CAPABILITIES {
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AUDIO_CHANNEL_CAPABILITIES_MONOPHONIC= 0x0,
	AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AUDIO_CHANNEL_CAPABILITIES_STEREO= 0x1,
} AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AUDIO_CHANNEL_CAPABILITIES;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_OUTPUT_CONVERTER_RESERVED= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_INPUT_CONVERTER_RESERVED= 0x1,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_MIXER_RESERVED= 0x2,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_SELECTOR_RESERVED= 0x3,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_PIN_RESERVED= 0x4,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_POWER_WIDGET_RESERVED= 0x5,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_VOLUME_KNOB_RESERVED= 0x6,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_BEEP_GENERATOR_RESERVED= 0x7,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_RESERVED= 0x8,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE_VENDOR_DEFINED_RESERVED= 0x9,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_TYPE;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_LR_SWAP {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_LR_SWAP= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_LR_SWAP= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_LR_SWAP;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_POWER_CONTROL {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_POWER_CONTROL_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_POWER_CONTROL_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_POWER_CONTROL;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_DIGITAL {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_IS_ANALOG= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_IS_DIGITAL= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_DIGITAL;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CONNECTION_LIST {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_CONNECTION_LIST= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_CONNECTION_LIST= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_CONNECTION_LIST;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_UNSOLICITED_RESPONSE_CAPABILITY {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_UNSOLICITED_RESPONSE_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_UNSOLICITED_RESPONSE_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_UNSOLICITED_RESPONSE_CAPABILITY;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET_NO_PROCESING_CAPABILITIES= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET_HAVE_PROCESING_CAPABILITIES= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_PROCESSING_WIDGET;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_STRIPE {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_SUPPORT_STRIPING= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_SUPPORT_STRIPING= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_STRIPE;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AMPLIFIER_PARAMETER_OVERRIDE {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_AMPLIFIER_PARAMETER= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_AMPLIFIER_PARAMETER_OVERRIDE= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_AMPLIFIER_PARAMETER_OVERRIDE;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_OUTPUT_AMPLIFIER_PRESENT {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_OUTPUT_AMPLIFIER= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_OUTPUT_AMPLIFIER= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_OUTPUT_AMPLIFIER_PRESENT;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_INPUT_AMPLIFIER_PRESENT {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_NO_INPUT_AMPLIFIER= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_HAVE_INPUT_AMPLIFIER= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES_INPUT_AMPLIFIER_PRESENT;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_DP {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_DP_NOT_ENABLED= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_DP_ENABLED= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_DP;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_EAPD_CAPABLE {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_EAPD_CAPABLE_NO_EAPD_PIN= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_EAPD_CAPABLE_HAVE_EAPD_PIN= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_EAPD_CAPABLE;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HDMI {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HDMI_NOT_ENABLED= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HDMI_ENABLED= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HDMI;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_BALANCED_I_O_PINS {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_I_O_PINS_NOT_BALANCED= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_I_O_PINS_ARE_BALANCED= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_BALANCED_I_O_PINS;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_INPUT_CAPABLE {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_NO_INPUT_PIN= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HAVE_INPUT_PIN= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_INPUT_CAPABLE;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_OUTPUT_CAPABLE {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_NO_OUTPUT_PIN= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HAVE_OUTPUT_PIN= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_OUTPUT_CAPABLE;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HEADPHONE_DRIVE_CAPABLE {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_NO_HEADPHONE_DRIVE_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HAVE_HEADPHONE_DRIVE_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HEADPHONE_DRIVE_CAPABLE;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_JACK_DETECTION_CAPABILITY {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_NO_JACK_PRESENCE_DETECTION_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HAVE_JACK_PRESENCE_DETECTION_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_JACK_DETECTION_CAPABILITY;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_TRIGGER_REQUIRED {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_NO_TRIGGER_REQUIRED_FOR_IMPEDANCE_MEASUREMENT= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_TRIGGER_REQUIRED_FOR_IMPEDANCE_MEASUREMENT= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_TRIGGER_REQUIRED;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_IMPEDANCE_SENSE_CAPABLE {
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_NO_IMPEDANCE_SENSE_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_HAVE_IMPEDANCE_SENSE_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES_IMPEDANCE_SENSE_CAPABLE;
typedef enum AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR_HBR_CAPABLE {
	AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR_NO_HBR_CAPABILITY= 0x0,
	AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR_HAVE_HBR_CAPABILITY= 0x1,
} AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR_HBR_CAPABLE;
typedef enum AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_STREAM_TYPE {
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_STREAM_TYPE_PCM= 0x0,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_STREAM_TYPE_NOT_PCM= 0x1,
} AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_STREAM_TYPE;
typedef enum AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_RATE {
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_RATE_48KHZ= 0x0,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_RATE_44P1KHZ= 0x1,
} AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_RATE;
typedef enum AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE {
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_BY1= 0x0,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_BY2= 0x1,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_BY3_RESERVED= 0x2,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_BY4= 0x3,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE_RESERVED= 0x4,
} AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_MULTIPLE;
typedef enum AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR {
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY1= 0x0,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY2_RESERVED= 0x1,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY3= 0x2,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY4_RESERVED= 0x3,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY5_RESERVED= 0x4,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY6_RESERVED= 0x5,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY7_RESERVED= 0x6,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR_BY8_RESERVED= 0x7,
} AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_SAMPLE_BASE_DIVISOR;
typedef enum AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE {
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_8_RESERVED= 0x0,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_16= 0x1,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_20= 0x2,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_24= 0x3,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_32_RESERVED= 0x4,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE_RESERVED= 0x5,
} AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_BITS_PER_SAMPLE;
typedef enum AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS {
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_1= 0x0,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_2= 0x1,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_3= 0x2,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_4= 0x3,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_5= 0x4,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_6= 0x5,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_7= 0x6,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_8= 0x7,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS_RESERVED= 0x8,
} AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT_NUMBER_OF_CHANNELS;
typedef enum AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER_DIGEN {
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER_DIGEN_DIGITAL_TRANSMISSION_DISABLED= 0x0,
	AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER_DIGEN_DIGITAL_TRANSMISSION_ENABLED= 0x1,
} AZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER_DIGEN;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL_IN_ENABLE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL_IN_ENABLE_PIN_SHUT_OFF= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL_IN_ENABLE_PIN_DRIVEN= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL_IN_ENABLE;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_ENABLE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_DISABLED= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_ENABLED= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_ENABLE;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL0_ENABLE_MULTICHANNEL0_MUTE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL0_ENABLE_MULTICHANNEL0_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL0_ENABLE_MULTICHANNEL0_MUTED= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL0_ENABLE_MULTICHANNEL0_MUTE;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL1_ENABLE_MULTICHANNEL1_MUTE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL1_ENABLE_MULTICHANNEL1_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL1_ENABLE_MULTICHANNEL1_MUTED= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL1_ENABLE_MULTICHANNEL1_MUTE;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL2_ENABLE_MULTICHANNEL2_MUTE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL2_ENABLE_MULTICHANNEL2_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL2_ENABLE_MULTICHANNEL2_MUTED= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL2_ENABLE_MULTICHANNEL2_MUTE;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL3_ENABLE_MULTICHANNEL3_MUTE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL3_ENABLE_MULTICHANNEL3_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL3_ENABLE_MULTICHANNEL3_MUTED= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL3_ENABLE_MULTICHANNEL3_MUTE;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL4_ENABLE_MULTICHANNEL4_MUTE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL4_ENABLE_MULTICHANNEL4_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL4_ENABLE_MULTICHANNEL4_MUTED= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL4_ENABLE_MULTICHANNEL4_MUTE;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL5_ENABLE_MULTICHANNEL5_MUTE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL5_ENABLE_MULTICHANNEL5_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL5_ENABLE_MULTICHANNEL5_MUTED= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL5_ENABLE_MULTICHANNEL5_MUTE;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL6_ENABLE_MULTICHANNEL6_MUTE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL6_ENABLE_MULTICHANNEL6_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL6_ENABLE_MULTICHANNEL6_MUTED= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL6_ENABLE_MULTICHANNEL6_MUTE;
typedef enum AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL7_ENABLE_MULTICHANNEL7_MUTE {
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL7_ENABLE_MULTICHANNEL7_NOT_MUTED= 0x0,
	AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL7_ENABLE_MULTICHANNEL7_MUTED= 0x1,
} AZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL7_ENABLE_MULTICHANNEL7_MUTE;
typedef enum BLND_CONTROL_BLND_MODE {
	BLND_CONTROL_BLND_MODE_CURRENT_PIPE_ONLY         = 0x0,
	BLND_CONTROL_BLND_MODE_OTHER_PIPE_ONLY           = 0x1,
	BLND_CONTROL_BLND_MODE_ALPHA_BLENDING_MODE       = 0x2,
	BLND_CONTROL_BLND_MODE_OTHER_STEREO_TYPE         = 0x3,
} BLND_CONTROL_BLND_MODE;
typedef enum BLND_CONTROL_BLND_STEREO_TYPE {
	BLND_CONTROL_BLND_STEREO_TYPE_NON_SINGLE_PIPE_STEREO= 0x0,
	BLND_CONTROL_BLND_STEREO_TYPE_SIDE_BY_SIDE_SINGLE_PIPE_STEREO= 0x1,
	BLND_CONTROL_BLND_STEREO_TYPE_TOP_BOTTOM_SINGLE_PIPE_STEREO= 0x2,
	BLND_CONTROL_BLND_STEREO_TYPE_UNUSED             = 0x3,
} BLND_CONTROL_BLND_STEREO_TYPE;
typedef enum BLND_CONTROL_BLND_STEREO_POLARITY {
	BLND_CONTROL_BLND_STEREO_POLARITY_LOW            = 0x0,
	BLND_CONTROL_BLND_STEREO_POLARITY_HIGH           = 0x1,
} BLND_CONTROL_BLND_STEREO_POLARITY;
typedef enum BLND_CONTROL_BLND_FEEDTHROUGH_EN {
	BLND_CONTROL_BLND_FEEDTHROUGH_EN_FALSE           = 0x0,
	BLND_CONTROL_BLND_FEEDTHROUGH_EN_TRUE            = 0x1,
} BLND_CONTROL_BLND_FEEDTHROUGH_EN;
typedef enum BLND_CONTROL_BLND_ALPHA_MODE {
	BLND_CONTROL_BLND_ALPHA_MODE_CURRENT_PIXEL_ALPHA = 0x0,
	BLND_CONTROL_BLND_ALPHA_MODE_PIXEL_ALPHA_COMBINED_GLOBAL_GAIN= 0x1,
	BLND_CONTROL_BLND_ALPHA_MODE_GLOBAL_ALPHA_ONLY   = 0x2,
	BLND_CONTROL_BLND_ALPHA_MODE_UNUSED              = 0x3,
} BLND_CONTROL_BLND_ALPHA_MODE;
typedef enum BLND_CONTROL_BLND_ACTIVE_OVERLAP_ONLY {
	BLND_CONTROL_BLND_ACTIVE_OVERLAY_ONLY_FALSE      = 0x0,
	BLND_CONTROL_BLND_ACTIVE_OVERLAY_ONLY_TRUE       = 0x1,
} BLND_CONTROL_BLND_ACTIVE_OVERLAP_ONLY;
typedef enum BLND_CONTROL_BLND_MULTIPLIED_MODE {
	BLND_CONTROL_BLND_MULTIPLIED_MODE_FALSE          = 0x0,
	BLND_CONTROL_BLND_MULTIPLIED_MODE_TRUE           = 0x1,
} BLND_CONTROL_BLND_MULTIPLIED_MODE;
typedef enum BLND_SM_CONTROL2_SM_MODE {
	BLND_SM_CONTROL2_SM_MODE_SINGLE_PLANE            = 0x0,
	BLND_SM_CONTROL2_SM_MODE_ROW_SUBSAMPLING         = 0x2,
	BLND_SM_CONTROL2_SM_MODE_COLUMN_SUBSAMPLING      = 0x4,
	BLND_SM_CONTROL2_SM_MODE_CHECKERBOARD_SUBSAMPLING= 0x6,
} BLND_SM_CONTROL2_SM_MODE;
typedef enum BLND_SM_CONTROL2_SM_FRAME_ALTERNATE {
	BLND_SM_CONTROL2_SM_FRAME_ALTERNATE_FALSE        = 0x0,
	BLND_SM_CONTROL2_SM_FRAME_ALTERNATE_TRUE         = 0x1,
} BLND_SM_CONTROL2_SM_FRAME_ALTERNATE;
typedef enum BLND_SM_CONTROL2_SM_FIELD_ALTERNATE {
	BLND_SM_CONTROL2_SM_FIELD_ALTERNATE_FALSE        = 0x0,
	BLND_SM_CONTROL2_SM_FIELD_ALTERNATE_TRUE         = 0x1,
} BLND_SM_CONTROL2_SM_FIELD_ALTERNATE;
typedef enum BLND_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL {
	BLND_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL_NO_FORCE= 0x0,
	BLND_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL_RESERVED= 0x1,
	BLND_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL_FORCE_LOW= 0x2,
	BLND_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL_FORCE_HIGH= 0x3,
} BLND_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL;
typedef enum BLND_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL {
	BLND_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL_NO_FORCE  = 0x0,
	BLND_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL_RESERVED  = 0x1,
	BLND_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL_FORCE_LOW = 0x2,
	BLND_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL_FORCE_HIGH= 0x3,
} BLND_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL;
typedef enum BLND_CONTROL2_PTI_ENABLE {
	BLND_CONTROL2_PTI_ENABLE_FALSE                   = 0x0,
	BLND_CONTROL2_PTI_ENABLE_TRUE                    = 0x1,
} BLND_CONTROL2_PTI_ENABLE;
typedef enum BLND_CONTROL2_BLND_SUPERAA_DEGAMMA_EN {
	BLND_CONTROL2_BLND_SUPERAA_DEGAMMA_EN_FALSE      = 0x0,
	BLND_CONTROL2_BLND_SUPERAA_DEGAMMA_EN_TRUE       = 0x1,
} BLND_CONTROL2_BLND_SUPERAA_DEGAMMA_EN;
typedef enum BLND_CONTROL2_BLND_SUPERAA_REGAMMA_EN {
	BLND_CONTROL2_BLND_SUPERAA_REGAMMA_EN_FALSE      = 0x0,
	BLND_CONTROL2_BLND_SUPERAA_REGAMMA_EN_TRUE       = 0x1,
} BLND_CONTROL2_BLND_SUPERAA_REGAMMA_EN;
typedef enum BLND_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_ACK {
	BLND_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_ACK_FALSE= 0x0,
	BLND_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_ACK_TRUE= 0x1,
} BLND_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_ACK;
typedef enum BLND_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_MASK {
	BLND_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_MASK_FALSE= 0x0,
	BLND_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_MASK_TRUE= 0x1,
} BLND_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_MASK;
typedef enum BLND_V_UPDATE_LOCK_BLND_DCP_GRPH_V_UPDATE_LOCK {
	BLND_V_UPDATE_LOCK_BLND_DCP_GRPH_V_UPDATE_LOCK_FALSE= 0x0,
	BLND_V_UPDATE_LOCK_BLND_DCP_GRPH_V_UPDATE_LOCK_TRUE= 0x1,
} BLND_V_UPDATE_LOCK_BLND_DCP_GRPH_V_UPDATE_LOCK;
typedef enum BLND_V_UPDATE_LOCK_BLND_DCP_GRPH_SURF_V_UPDATE_LOCK {
	BLND_V_UPDATE_LOCK_BLND_DCP_GRPH_SURF_V_UPDATE_LOCK_FALSE= 0x0,
	BLND_V_UPDATE_LOCK_BLND_DCP_GRPH_SURF_V_UPDATE_LOCK_TRUE= 0x1,
} BLND_V_UPDATE_LOCK_BLND_DCP_GRPH_SURF_V_UPDATE_LOCK;
typedef enum BLND_V_UPDATE_LOCK_BLND_DCP_CUR_V_UPDATE_LOCK {
	BLND_V_UPDATE_LOCK_BLND_DCP_CUR_V_UPDATE_LOCK_FALSE= 0x0,
	BLND_V_UPDATE_LOCK_BLND_DCP_CUR_V_UPDATE_LOCK_TRUE= 0x1,
} BLND_V_UPDATE_LOCK_BLND_DCP_CUR_V_UPDATE_LOCK;
typedef enum BLND_V_UPDATE_LOCK_BLND_DCP_CUR2_V_UPDATE_LOCK {
	BLND_V_UPDATE_LOCK_BLND_DCP_CUR2_V_UPDATE_LOCK_FALSE= 0x0,
	BLND_V_UPDATE_LOCK_BLND_DCP_CUR2_V_UPDATE_LOCK_TRUE= 0x1,
} BLND_V_UPDATE_LOCK_BLND_DCP_CUR2_V_UPDATE_LOCK;
typedef enum BLND_V_UPDATE_LOCK_BLND_SCL_V_UPDATE_LOCK {
	BLND_V_UPDATE_LOCK_BLND_SCL_V_UPDATE_LOCK_FALSE  = 0x0,
	BLND_V_UPDATE_LOCK_BLND_SCL_V_UPDATE_LOCK_TRUE   = 0x1,
} BLND_V_UPDATE_LOCK_BLND_SCL_V_UPDATE_LOCK;
typedef enum BLND_V_UPDATE_LOCK_BLND_BLND_V_UPDATE_LOCK {
	BLND_V_UPDATE_LOCK_BLND_BLND_V_UPDATE_LOCK_FALSE = 0x0,
	BLND_V_UPDATE_LOCK_BLND_BLND_V_UPDATE_LOCK_TRUE  = 0x1,
} BLND_V_UPDATE_LOCK_BLND_BLND_V_UPDATE_LOCK;
typedef enum BLND_V_UPDATE_LOCK_BLND_V_UPDATE_LOCK_MODE {
	BLND_V_UPDATE_LOCK_BLND_V_UPDATE_LOCK_MODE_FALSE = 0x0,
	BLND_V_UPDATE_LOCK_BLND_V_UPDATE_LOCK_MODE_TRUE  = 0x1,
} BLND_V_UPDATE_LOCK_BLND_V_UPDATE_LOCK_MODE;
typedef enum BLND_DEBUG_BLND_CNV_MUX_SELECT {
	BLND_DEBUG_BLND_CNV_MUX_SELECT_LOW               = 0x0,
	BLND_DEBUG_BLND_CNV_MUX_SELECT_HIGH              = 0x1,
} BLND_DEBUG_BLND_CNV_MUX_SELECT;
typedef enum BLND_TEST_DEBUG_INDEX_BLND_TEST_DEBUG_WRITE_EN {
	BLND_TEST_DEBUG_INDEX_BLND_TEST_DEBUG_WRITE_EN_FALSE= 0x0,
	BLND_TEST_DEBUG_INDEX_BLND_TEST_DEBUG_WRITE_EN_TRUE= 0x1,
} BLND_TEST_DEBUG_INDEX_BLND_TEST_DEBUG_WRITE_EN;
typedef enum SurfaceEndian {
	ENDIAN_NONE                                      = 0x0,
	ENDIAN_8IN16                                     = 0x1,
	ENDIAN_8IN32                                     = 0x2,
	ENDIAN_8IN64                                     = 0x3,
} SurfaceEndian;
typedef enum ArrayMode {
	ARRAY_LINEAR_GENERAL                             = 0x0,
	ARRAY_LINEAR_ALIGNED                             = 0x1,
	ARRAY_1D_TILED_THIN1                             = 0x2,
	ARRAY_1D_TILED_THICK                             = 0x3,
	ARRAY_2D_TILED_THIN1                             = 0x4,
	ARRAY_PRT_TILED_THIN1                            = 0x5,
	ARRAY_PRT_2D_TILED_THIN1                         = 0x6,
	ARRAY_2D_TILED_THICK                             = 0x7,
	ARRAY_2D_TILED_XTHICK                            = 0x8,
	ARRAY_PRT_TILED_THICK                            = 0x9,
	ARRAY_PRT_2D_TILED_THICK                         = 0xa,
	ARRAY_PRT_3D_TILED_THIN1                         = 0xb,
	ARRAY_3D_TILED_THIN1                             = 0xc,
	ARRAY_3D_TILED_THICK                             = 0xd,
	ARRAY_3D_TILED_XTHICK                            = 0xe,
	ARRAY_PRT_3D_TILED_THICK                         = 0xf,
} ArrayMode;
typedef enum PipeTiling {
	CONFIG_1_PIPE                                    = 0x0,
	CONFIG_2_PIPE                                    = 0x1,
	CONFIG_4_PIPE                                    = 0x2,
	CONFIG_8_PIPE                                    = 0x3,
} PipeTiling;
typedef enum BankTiling {
	CONFIG_4_BANK                                    = 0x0,
	CONFIG_8_BANK                                    = 0x1,
} BankTiling;
typedef enum GroupInterleave {
	CONFIG_256B_GROUP                                = 0x0,
	CONFIG_512B_GROUP                                = 0x1,
} GroupInterleave;
typedef enum RowTiling {
	CONFIG_1KB_ROW                                   = 0x0,
	CONFIG_2KB_ROW                                   = 0x1,
	CONFIG_4KB_ROW                                   = 0x2,
	CONFIG_8KB_ROW                                   = 0x3,
	CONFIG_1KB_ROW_OPT                               = 0x4,
	CONFIG_2KB_ROW_OPT                               = 0x5,
	CONFIG_4KB_ROW_OPT                               = 0x6,
	CONFIG_8KB_ROW_OPT                               = 0x7,
} RowTiling;
typedef enum BankSwapBytes {
	CONFIG_128B_SWAPS                                = 0x0,
	CONFIG_256B_SWAPS                                = 0x1,
	CONFIG_512B_SWAPS                                = 0x2,
	CONFIG_1KB_SWAPS                                 = 0x3,
} BankSwapBytes;
typedef enum SampleSplitBytes {
	CONFIG_1KB_SPLIT                                 = 0x0,
	CONFIG_2KB_SPLIT                                 = 0x1,
	CONFIG_4KB_SPLIT                                 = 0x2,
	CONFIG_8KB_SPLIT                                 = 0x3,
} SampleSplitBytes;
typedef enum NumPipes {
	ADDR_CONFIG_1_PIPE                               = 0x0,
	ADDR_CONFIG_2_PIPE                               = 0x1,
	ADDR_CONFIG_4_PIPE                               = 0x2,
	ADDR_CONFIG_8_PIPE                               = 0x3,
} NumPipes;
typedef enum PipeInterleaveSize {
	ADDR_CONFIG_PIPE_INTERLEAVE_256B                 = 0x0,
	ADDR_CONFIG_PIPE_INTERLEAVE_512B                 = 0x1,
} PipeInterleaveSize;
typedef enum BankInterleaveSize {
	ADDR_CONFIG_BANK_INTERLEAVE_1                    = 0x0,
	ADDR_CONFIG_BANK_INTERLEAVE_2                    = 0x1,
	ADDR_CONFIG_BANK_INTERLEAVE_4                    = 0x2,
	ADDR_CONFIG_BANK_INTERLEAVE_8                    = 0x3,
} BankInterleaveSize;
typedef enum NumShaderEngines {
	ADDR_CONFIG_1_SHADER_ENGINE                      = 0x0,
	ADDR_CONFIG_2_SHADER_ENGINE                      = 0x1,
} NumShaderEngines;
typedef enum ShaderEngineTileSize {
	ADDR_CONFIG_SE_TILE_16                           = 0x0,
	ADDR_CONFIG_SE_TILE_32                           = 0x1,
} ShaderEngineTileSize;
typedef enum NumGPUs {
	ADDR_CONFIG_1_GPU                                = 0x0,
	ADDR_CONFIG_2_GPU                                = 0x1,
	ADDR_CONFIG_4_GPU                                = 0x2,
} NumGPUs;
typedef enum MultiGPUTileSize {
	ADDR_CONFIG_GPU_TILE_16                          = 0x0,
	ADDR_CONFIG_GPU_TILE_32                          = 0x1,
	ADDR_CONFIG_GPU_TILE_64                          = 0x2,
	ADDR_CONFIG_GPU_TILE_128                         = 0x3,
} MultiGPUTileSize;
typedef enum RowSize {
	ADDR_CONFIG_1KB_ROW                              = 0x0,
	ADDR_CONFIG_2KB_ROW                              = 0x1,
	ADDR_CONFIG_4KB_ROW                              = 0x2,
} RowSize;
typedef enum NumLowerPipes {
	ADDR_CONFIG_1_LOWER_PIPES                        = 0x0,
	ADDR_CONFIG_2_LOWER_PIPES                        = 0x1,
} NumLowerPipes;
typedef enum DebugBlockId {
	DBG_CLIENT_BLKID_RESERVED                        = 0x0,
	DBG_CLIENT_BLKID_dbg                             = 0x1,
	DBG_CLIENT_BLKID_scf2                            = 0x2,
	DBG_CLIENT_BLKID_mcd5                            = 0x3,
	DBG_CLIENT_BLKID_vmc                             = 0x4,
	DBG_CLIENT_BLKID_sx30                            = 0x5,
	DBG_CLIENT_BLKID_mcd2                            = 0x6,
	DBG_CLIENT_BLKID_bci1                            = 0x7,
	DBG_CLIENT_BLKID_xdma_dbg_client_wrapper         = 0x8,
	DBG_CLIENT_BLKID_mcc0                            = 0x9,
	DBG_CLIENT_BLKID_uvdf_2                          = 0xa,
	DBG_CLIENT_BLKID_uvdf_3                          = 0xb,
	DBG_CLIENT_BLKID_uvdt_0                          = 0xc,
	DBG_CLIENT_BLKID_uvdi_0                          = 0xd,
	DBG_CLIENT_BLKID_bci0                            = 0xe,
	DBG_CLIENT_BLKID_vceb0_1                         = 0xf,
	DBG_CLIENT_BLKID_cb100                           = 0x10,
	DBG_CLIENT_BLKID_cb001                           = 0x11,
	DBG_CLIENT_BLKID_mcd4                            = 0x12,
	DBG_CLIENT_BLKID_tmonw00                         = 0x13,
	DBG_CLIENT_BLKID_cb101                           = 0x14,
	DBG_CLIENT_BLKID_sx10                            = 0x15,
	DBG_CLIENT_BLKID_cb301                           = 0x16,
	DBG_CLIENT_BLKID_tmonw01                         = 0x17,
	DBG_CLIENT_BLKID_vcea0_0                         = 0x18,
	DBG_CLIENT_BLKID_vcea0_1                         = 0x19,
	DBG_CLIENT_BLKID_vcea0_2                         = 0x1a,
	DBG_CLIENT_BLKID_vcea0_3                         = 0x1b,
	DBG_CLIENT_BLKID_scf1                            = 0x1c,
	DBG_CLIENT_BLKID_sx20                            = 0x1d,
	DBG_CLIENT_BLKID_spim1                           = 0x1e,
	DBG_CLIENT_BLKID_pa10                            = 0x1f,
	DBG_CLIENT_BLKID_pa00                            = 0x20,
	DBG_CLIENT_BLKID_gmcon                           = 0x21,
	DBG_CLIENT_BLKID_mcb                             = 0x22,
	DBG_CLIENT_BLKID_vgt0                            = 0x23,
	DBG_CLIENT_BLKID_pc0                             = 0x24,
	DBG_CLIENT_BLKID_bci2                            = 0x25,
	DBG_CLIENT_BLKID_uvdb_0                          = 0x26,
	DBG_CLIENT_BLKID_spim3                           = 0x27,
	DBG_CLIENT_BLKID_cpc_0                           = 0x28,
	DBG_CLIENT_BLKID_cpc_1                           = 0x29,
	DBG_CLIENT_BLKID_uvdm_0                          = 0x2a,
	DBG_CLIENT_BLKID_uvdm_1                          = 0x2b,
	DBG_CLIENT_BLKID_uvdm_2                          = 0x2c,
	DBG_CLIENT_BLKID_uvdm_3                          = 0x2d,
	DBG_CLIENT_BLKID_cb000                           = 0x2e,
	DBG_CLIENT_BLKID_spim0                           = 0x2f,
	DBG_CLIENT_BLKID_mcc2                            = 0x30,
	DBG_CLIENT_BLKID_ds0                             = 0x31,
	DBG_CLIENT_BLKID_srbm                            = 0x32,
	DBG_CLIENT_BLKID_ih                              = 0x33,
	DBG_CLIENT_BLKID_sem                             = 0x34,
	DBG_CLIENT_BLKID_sdma_0                          = 0x35,
	DBG_CLIENT_BLKID_sdma_1                          = 0x36,
	DBG_CLIENT_BLKID_hdp                             = 0x37,
	DBG_CLIENT_BLKID_cb200                           = 0x38,
	DBG_CLIENT_BLKID_scf3                            = 0x39,
	DBG_CLIENT_BLKID_vceb1_0                         = 0x3a,
	DBG_CLIENT_BLKID_vcea1_0                         = 0x3b,
	DBG_CLIENT_BLKID_vcea1_1                         = 0x3c,
	DBG_CLIENT_BLKID_vcea1_2                         = 0x3d,
	DBG_CLIENT_BLKID_vcea1_3                         = 0x3e,
	DBG_CLIENT_BLKID_bci3                            = 0x3f,
	DBG_CLIENT_BLKID_mcd0                            = 0x40,
	DBG_CLIENT_BLKID_pa11                            = 0x41,
	DBG_CLIENT_BLKID_pa01                            = 0x42,
	DBG_CLIENT_BLKID_cb201                           = 0x43,
	DBG_CLIENT_BLKID_spim2                           = 0x44,
	DBG_CLIENT_BLKID_vgt2                            = 0x45,
	DBG_CLIENT_BLKID_pc2                             = 0x46,
	DBG_CLIENT_BLKID_smu_0                           = 0x47,
	DBG_CLIENT_BLKID_smu_1                           = 0x48,
	DBG_CLIENT_BLKID_smu_2                           = 0x49,
	DBG_CLIENT_BLKID_cb1                             = 0x4a,
	DBG_CLIENT_BLKID_ia0                             = 0x4b,
	DBG_CLIENT_BLKID_wd                              = 0x4c,
	DBG_CLIENT_BLKID_ia1                             = 0x4d,
	DBG_CLIENT_BLKID_vcec1_0                         = 0x4e,
	DBG_CLIENT_BLKID_scf0                            = 0x4f,
	DBG_CLIENT_BLKID_vgt1                            = 0x50,
	DBG_CLIENT_BLKID_pc1                             = 0x51,
	DBG_CLIENT_BLKID_cb0                             = 0x52,
	DBG_CLIENT_BLKID_gdc_one_0                       = 0x53,
	DBG_CLIENT_BLKID_gdc_one_1                       = 0x54,
	DBG_CLIENT_BLKID_gdc_one_2                       = 0x55,
	DBG_CLIENT_BLKID_gdc_one_3                       = 0x56,
	DBG_CLIENT_BLKID_gdc_one_4                       = 0x57,
	DBG_CLIENT_BLKID_gdc_one_5                       = 0x58,
	DBG_CLIENT_BLKID_gdc_one_6                       = 0x59,
	DBG_CLIENT_BLKID_gdc_one_7                       = 0x5a,
	DBG_CLIENT_BLKID_gdc_one_8                       = 0x5b,
	DBG_CLIENT_BLKID_gdc_one_9                       = 0x5c,
	DBG_CLIENT_BLKID_gdc_one_10                      = 0x5d,
	DBG_CLIENT_BLKID_gdc_one_11                      = 0x5e,
	DBG_CLIENT_BLKID_gdc_one_12                      = 0x5f,
	DBG_CLIENT_BLKID_gdc_one_13                      = 0x60,
	DBG_CLIENT_BLKID_gdc_one_14                      = 0x61,
	DBG_CLIENT_BLKID_gdc_one_15                      = 0x62,
	DBG_CLIENT_BLKID_gdc_one_16                      = 0x63,
	DBG_CLIENT_BLKID_gdc_one_17                      = 0x64,
	DBG_CLIENT_BLKID_gdc_one_18                      = 0x65,
	DBG_CLIENT_BLKID_gdc_one_19                      = 0x66,
	DBG_CLIENT_BLKID_gdc_one_20                      = 0x67,
	DBG_CLIENT_BLKID_gdc_one_21                      = 0x68,
	DBG_CLIENT_BLKID_gdc_one_22                      = 0x69,
	DBG_CLIENT_BLKID_gdc_one_23                      = 0x6a,
	DBG_CLIENT_BLKID_gdc_one_24                      = 0x6b,
	DBG_CLIENT_BLKID_gdc_one_25                      = 0x6c,
	DBG_CLIENT_BLKID_gdc_one_26                      = 0x6d,
	DBG_CLIENT_BLKID_gdc_one_27                      = 0x6e,
	DBG_CLIENT_BLKID_gdc_one_28                      = 0x6f,
	DBG_CLIENT_BLKID_gdc_one_29                      = 0x70,
	DBG_CLIENT_BLKID_gdc_one_30                      = 0x71,
	DBG_CLIENT_BLKID_gdc_one_31                      = 0x72,
	DBG_CLIENT_BLKID_gdc_one_32                      = 0x73,
	DBG_CLIENT_BLKID_gdc_one_33                      = 0x74,
	DBG_CLIENT_BLKID_gdc_one_34                      = 0x75,
	DBG_CLIENT_BLKID_gdc_one_35                      = 0x76,
	DBG_CLIENT_BLKID_vceb0_0                         = 0x77,
	DBG_CLIENT_BLKID_vgt3                            = 0x78,
	DBG_CLIENT_BLKID_pc3                             = 0x79,
	DBG_CLIENT_BLKID_mcd3                            = 0x7a,
	DBG_CLIENT_BLKID_uvdu_0                          = 0x7b,
	DBG_CLIENT_BLKID_uvdu_1                          = 0x7c,
	DBG_CLIENT_BLKID_uvdu_2                          = 0x7d,
	DBG_CLIENT_BLKID_uvdu_3                          = 0x7e,
	DBG_CLIENT_BLKID_uvdu_4                          = 0x7f,
	DBG_CLIENT_BLKID_uvdu_5                          = 0x80,
	DBG_CLIENT_BLKID_uvdu_6                          = 0x81,
	DBG_CLIENT_BLKID_cb300                           = 0x82,
	DBG_CLIENT_BLKID_mcd1                            = 0x83,
	DBG_CLIENT_BLKID_sx00                            = 0x84,
	DBG_CLIENT_BLKID_uvdf_0                          = 0x85,
	DBG_CLIENT_BLKID_uvdf_1                          = 0x86,
	DBG_CLIENT_BLKID_mcc3                            = 0x87,
	DBG_CLIENT_BLKID_cpg_0                           = 0x88,
	DBG_CLIENT_BLKID_cpg_1                           = 0x89,
	DBG_CLIENT_BLKID_gck                             = 0x8a,
	DBG_CLIENT_BLKID_mcc1                            = 0x8b,
	DBG_CLIENT_BLKID_cpf_0                           = 0x8c,
	DBG_CLIENT_BLKID_cpf_1                           = 0x8d,
	DBG_CLIENT_BLKID_rlc                             = 0x8e,
	DBG_CLIENT_BLKID_grbm                            = 0x8f,
	DBG_CLIENT_BLKID_sammsp                          = 0x90,
	DBG_CLIENT_BLKID_dci_pg                          = 0x91,
	DBG_CLIENT_BLKID_dci_0                           = 0x92,
	DBG_CLIENT_BLKID_dccg0_0                         = 0x93,
	DBG_CLIENT_BLKID_dccg0_1                         = 0x94,
	DBG_CLIENT_BLKID_dccg0_2                         = 0x95,
	DBG_CLIENT_BLKID_dccg0_3                         = 0x96,
	DBG_CLIENT_BLKID_dccg0_4                         = 0x97,
	DBG_CLIENT_BLKID_dccg0_5                         = 0x98,
	DBG_CLIENT_BLKID_dccg0_6                         = 0x99,
	DBG_CLIENT_BLKID_dccg0_7                         = 0x9a,
	DBG_CLIENT_BLKID_dccg0_8                         = 0x9b,
	DBG_CLIENT_BLKID_dcfe01_0                        = 0x9c,
	DBG_CLIENT_BLKID_dcfe02_0                        = 0x9d,
	DBG_CLIENT_BLKID_dcfe03_0                        = 0x9e,
	DBG_CLIENT_BLKID_dcfe04_0                        = 0x9f,
	DBG_CLIENT_BLKID_dcfe05_0                        = 0xa0,
	DBG_CLIENT_BLKID_dcfe06_0                        = 0xa1,
	DBG_CLIENT_BLKID_uvde_0                          = 0xa2,
	DBG_CLIENT_BLKID_RESERVED_LAST                   = 0xa3,
} DebugBlockId;
typedef enum DebugBlockId_OLD {
	DBG_BLOCK_ID_RESERVED                            = 0x0,
	DBG_BLOCK_ID_DBG                                 = 0x1,
	DBG_BLOCK_ID_VMC                                 = 0x2,
	DBG_BLOCK_ID_PDMA                                = 0x3,
	DBG_BLOCK_ID_CG                                  = 0x4,
	DBG_BLOCK_ID_SRBM                                = 0x5,
	DBG_BLOCK_ID_GRBM                                = 0x6,
	DBG_BLOCK_ID_RLC                                 = 0x7,
	DBG_BLOCK_ID_CSC                                 = 0x8,
	DBG_BLOCK_ID_SEM                                 = 0x9,
	DBG_BLOCK_ID_IH                                  = 0xa,
	DBG_BLOCK_ID_SC                                  = 0xb,
	DBG_BLOCK_ID_SQ                                  = 0xc,
	DBG_BLOCK_ID_AVP                                 = 0xd,
	DBG_BLOCK_ID_GMCON                               = 0xe,
	DBG_BLOCK_ID_SMU                                 = 0xf,
	DBG_BLOCK_ID_DMA0                                = 0x10,
	DBG_BLOCK_ID_DMA1                                = 0x11,
	DBG_BLOCK_ID_SPIM                                = 0x12,
	DBG_BLOCK_ID_GDS                                 = 0x13,
	DBG_BLOCK_ID_SPIS                                = 0x14,
	DBG_BLOCK_ID_UNUSED0                             = 0x15,
	DBG_BLOCK_ID_PA0                                 = 0x16,
	DBG_BLOCK_ID_PA1                                 = 0x17,
	DBG_BLOCK_ID_CP0                                 = 0x18,
	DBG_BLOCK_ID_CP1                                 = 0x19,
	DBG_BLOCK_ID_CP2                                 = 0x1a,
	DBG_BLOCK_ID_UNUSED1                             = 0x1b,
	DBG_BLOCK_ID_UVDU                                = 0x1c,
	DBG_BLOCK_ID_UVDM                                = 0x1d,
	DBG_BLOCK_ID_VCE                                 = 0x1e,
	DBG_BLOCK_ID_UNUSED2                             = 0x1f,
	DBG_BLOCK_ID_VGT0                                = 0x20,
	DBG_BLOCK_ID_VGT1                                = 0x21,
	DBG_BLOCK_ID_IA                                  = 0x22,
	DBG_BLOCK_ID_UNUSED3                             = 0x23,
	DBG_BLOCK_ID_SCT0                                = 0x24,
	DBG_BLOCK_ID_SCT1                                = 0x25,
	DBG_BLOCK_ID_SPM0                                = 0x26,
	DBG_BLOCK_ID_SPM1                                = 0x27,
	DBG_BLOCK_ID_TCAA                                = 0x28,
	DBG_BLOCK_ID_TCAB                                = 0x29,
	DBG_BLOCK_ID_TCCA                                = 0x2a,
	DBG_BLOCK_ID_TCCB                                = 0x2b,
	DBG_BLOCK_ID_MCC0                                = 0x2c,
	DBG_BLOCK_ID_MCC1                                = 0x2d,
	DBG_BLOCK_ID_MCC2                                = 0x2e,
	DBG_BLOCK_ID_MCC3                                = 0x2f,
	DBG_BLOCK_ID_SX0                                 = 0x30,
	DBG_BLOCK_ID_SX1                                 = 0x31,
	DBG_BLOCK_ID_SX2                                 = 0x32,
	DBG_BLOCK_ID_SX3                                 = 0x33,
	DBG_BLOCK_ID_UNUSED4                             = 0x34,
	DBG_BLOCK_ID_UNUSED5                             = 0x35,
	DBG_BLOCK_ID_UNUSED6                             = 0x36,
	DBG_BLOCK_ID_UNUSED7                             = 0x37,
	DBG_BLOCK_ID_PC0                                 = 0x38,
	DBG_BLOCK_ID_PC1                                 = 0x39,
	DBG_BLOCK_ID_UNUSED8                             = 0x3a,
	DBG_BLOCK_ID_UNUSED9                             = 0x3b,
	DBG_BLOCK_ID_UNUSED10                            = 0x3c,
	DBG_BLOCK_ID_UNUSED11                            = 0x3d,
	DBG_BLOCK_ID_MCB                                 = 0x3e,
	DBG_BLOCK_ID_UNUSED12                            = 0x3f,
	DBG_BLOCK_ID_SCB0                                = 0x40,
	DBG_BLOCK_ID_SCB1                                = 0x41,
	DBG_BLOCK_ID_UNUSED13                            = 0x42,
	DBG_BLOCK_ID_UNUSED14                            = 0x43,
	DBG_BLOCK_ID_SCF0                                = 0x44,
	DBG_BLOCK_ID_SCF1                                = 0x45,
	DBG_BLOCK_ID_UNUSED15                            = 0x46,
	DBG_BLOCK_ID_UNUSED16                            = 0x47,
	DBG_BLOCK_ID_BCI0                                = 0x48,
	DBG_BLOCK_ID_BCI1                                = 0x49,
	DBG_BLOCK_ID_BCI2                                = 0x4a,
	DBG_BLOCK_ID_BCI3                                = 0x4b,
	DBG_BLOCK_ID_UNUSED17                            = 0x4c,
	DBG_BLOCK_ID_UNUSED18                            = 0x4d,
	DBG_BLOCK_ID_UNUSED19                            = 0x4e,
	DBG_BLOCK_ID_UNUSED20                            = 0x4f,
	DBG_BLOCK_ID_CB00                                = 0x50,
	DBG_BLOCK_ID_CB01                                = 0x51,
	DBG_BLOCK_ID_CB02                                = 0x52,
	DBG_BLOCK_ID_CB03                                = 0x53,
	DBG_BLOCK_ID_CB04                                = 0x54,
	DBG_BLOCK_ID_UNUSED21                            = 0x55,
	DBG_BLOCK_ID_UNUSED22                            = 0x56,
	DBG_BLOCK_ID_UNUSED23                            = 0x57,
	DBG_BLOCK_ID_CB10                                = 0x58,
	DBG_BLOCK_ID_CB11                                = 0x59,
	DBG_BLOCK_ID_CB12                                = 0x5a,
	DBG_BLOCK_ID_CB13                                = 0x5b,
	DBG_BLOCK_ID_CB14                                = 0x5c,
	DBG_BLOCK_ID_UNUSED24                            = 0x5d,
	DBG_BLOCK_ID_UNUSED25                            = 0x5e,
	DBG_BLOCK_ID_UNUSED26                            = 0x5f,
	DBG_BLOCK_ID_TCP0                                = 0x60,
	DBG_BLOCK_ID_TCP1                                = 0x61,
	DBG_BLOCK_ID_TCP2                                = 0x62,
	DBG_BLOCK_ID_TCP3                                = 0x63,
	DBG_BLOCK_ID_TCP4                                = 0x64,
	DBG_BLOCK_ID_TCP5                                = 0x65,
	DBG_BLOCK_ID_TCP6                                = 0x66,
	DBG_BLOCK_ID_TCP7                                = 0x67,
	DBG_BLOCK_ID_TCP8                                = 0x68,
	DBG_BLOCK_ID_TCP9                                = 0x69,
	DBG_BLOCK_ID_TCP10                               = 0x6a,
	DBG_BLOCK_ID_TCP11                               = 0x6b,
	DBG_BLOCK_ID_TCP12                               = 0x6c,
	DBG_BLOCK_ID_TCP13                               = 0x6d,
	DBG_BLOCK_ID_TCP14                               = 0x6e,
	DBG_BLOCK_ID_TCP15                               = 0x6f,
	DBG_BLOCK_ID_TCP16                               = 0x70,
	DBG_BLOCK_ID_TCP17                               = 0x71,
	DBG_BLOCK_ID_TCP18                               = 0x72,
	DBG_BLOCK_ID_TCP19                               = 0x73,
	DBG_BLOCK_ID_TCP20                               = 0x74,
	DBG_BLOCK_ID_TCP21                               = 0x75,
	DBG_BLOCK_ID_TCP22                               = 0x76,
	DBG_BLOCK_ID_TCP23                               = 0x77,
	DBG_BLOCK_ID_TCP_RESERVED0                       = 0x78,
	DBG_BLOCK_ID_TCP_RESERVED1                       = 0x79,
	DBG_BLOCK_ID_TCP_RESERVED2                       = 0x7a,
	DBG_BLOCK_ID_TCP_RESERVED3                       = 0x7b,
	DBG_BLOCK_ID_TCP_RESERVED4                       = 0x7c,
	DBG_BLOCK_ID_TCP_RESERVED5                       = 0x7d,
	DBG_BLOCK_ID_TCP_RESERVED6                       = 0x7e,
	DBG_BLOCK_ID_TCP_RESERVED7                       = 0x7f,
	DBG_BLOCK_ID_DB00                                = 0x80,
	DBG_BLOCK_ID_DB01                                = 0x81,
	DBG_BLOCK_ID_DB02                                = 0x82,
	DBG_BLOCK_ID_DB03                                = 0x83,
	DBG_BLOCK_ID_DB04                                = 0x84,
	DBG_BLOCK_ID_UNUSED27                            = 0x85,
	DBG_BLOCK_ID_UNUSED28                            = 0x86,
	DBG_BLOCK_ID_UNUSED29                            = 0x87,
	DBG_BLOCK_ID_DB10                                = 0x88,
	DBG_BLOCK_ID_DB11                                = 0x89,
	DBG_BLOCK_ID_DB12                                = 0x8a,
	DBG_BLOCK_ID_DB13                                = 0x8b,
	DBG_BLOCK_ID_DB14                                = 0x8c,
	DBG_BLOCK_ID_UNUSED30                            = 0x8d,
	DBG_BLOCK_ID_UNUSED31                            = 0x8e,
	DBG_BLOCK_ID_UNUSED32                            = 0x8f,
	DBG_BLOCK_ID_TCC0                                = 0x90,
	DBG_BLOCK_ID_TCC1                                = 0x91,
	DBG_BLOCK_ID_TCC2                                = 0x92,
	DBG_BLOCK_ID_TCC3                                = 0x93,
	DBG_BLOCK_ID_TCC4                                = 0x94,
	DBG_BLOCK_ID_TCC5                                = 0x95,
	DBG_BLOCK_ID_TCC6                                = 0x96,
	DBG_BLOCK_ID_TCC7                                = 0x97,
	DBG_BLOCK_ID_SPS00                               = 0x98,
	DBG_BLOCK_ID_SPS01                               = 0x99,
	DBG_BLOCK_ID_SPS02                               = 0x9a,
	DBG_BLOCK_ID_SPS10                               = 0x9b,
	DBG_BLOCK_ID_SPS11                               = 0x9c,
	DBG_BLOCK_ID_SPS12                               = 0x9d,
	DBG_BLOCK_ID_UNUSED33                            = 0x9e,
	DBG_BLOCK_ID_UNUSED34                            = 0x9f,
	DBG_BLOCK_ID_TA00                                = 0xa0,
	DBG_BLOCK_ID_TA01                                = 0xa1,
	DBG_BLOCK_ID_TA02                                = 0xa2,
	DBG_BLOCK_ID_TA03                                = 0xa3,
	DBG_BLOCK_ID_TA04                                = 0xa4,
	DBG_BLOCK_ID_TA05                                = 0xa5,
	DBG_BLOCK_ID_TA06                                = 0xa6,
	DBG_BLOCK_ID_TA07                                = 0xa7,
	DBG_BLOCK_ID_TA08                                = 0xa8,
	DBG_BLOCK_ID_TA09                                = 0xa9,
	DBG_BLOCK_ID_TA0A                                = 0xaa,
	DBG_BLOCK_ID_TA0B                                = 0xab,
	DBG_BLOCK_ID_UNUSED35                            = 0xac,
	DBG_BLOCK_ID_UNUSED36                            = 0xad,
	DBG_BLOCK_ID_UNUSED37                            = 0xae,
	DBG_BLOCK_ID_UNUSED38                            = 0xaf,
	DBG_BLOCK_ID_TA10                                = 0xb0,
	DBG_BLOCK_ID_TA11                                = 0xb1,
	DBG_BLOCK_ID_TA12                                = 0xb2,
	DBG_BLOCK_ID_TA13                                = 0xb3,
	DBG_BLOCK_ID_TA14                                = 0xb4,
	DBG_BLOCK_ID_TA15                                = 0xb5,
	DBG_BLOCK_ID_TA16                                = 0xb6,
	DBG_BLOCK_ID_TA17                                = 0xb7,
	DBG_BLOCK_ID_TA18                                = 0xb8,
	DBG_BLOCK_ID_TA19                                = 0xb9,
	DBG_BLOCK_ID_TA1A                                = 0xba,
	DBG_BLOCK_ID_TA1B                                = 0xbb,
	DBG_BLOCK_ID_UNUSED39                            = 0xbc,
	DBG_BLOCK_ID_UNUSED40                            = 0xbd,
	DBG_BLOCK_ID_UNUSED41                            = 0xbe,
	DBG_BLOCK_ID_UNUSED42                            = 0xbf,
	DBG_BLOCK_ID_TD00                                = 0xc0,
	DBG_BLOCK_ID_TD01                                = 0xc1,
	DBG_BLOCK_ID_TD02                                = 0xc2,
	DBG_BLOCK_ID_TD03                                = 0xc3,
	DBG_BLOCK_ID_TD04                                = 0xc4,
	DBG_BLOCK_ID_TD05                                = 0xc5,
	DBG_BLOCK_ID_TD06                                = 0xc6,
	DBG_BLOCK_ID_TD07                                = 0xc7,
	DBG_BLOCK_ID_TD08                                = 0xc8,
	DBG_BLOCK_ID_TD09                                = 0xc9,
	DBG_BLOCK_ID_TD0A                                = 0xca,
	DBG_BLOCK_ID_TD0B                                = 0xcb,
	DBG_BLOCK_ID_UNUSED43                            = 0xcc,
	DBG_BLOCK_ID_UNUSED44                            = 0xcd,
	DBG_BLOCK_ID_UNUSED45                            = 0xce,
	DBG_BLOCK_ID_UNUSED46                            = 0xcf,
	DBG_BLOCK_ID_TD10                                = 0xd0,
	DBG_BLOCK_ID_TD11                                = 0xd1,
	DBG_BLOCK_ID_TD12                                = 0xd2,
	DBG_BLOCK_ID_TD13                                = 0xd3,
	DBG_BLOCK_ID_TD14                                = 0xd4,
	DBG_BLOCK_ID_TD15                                = 0xd5,
	DBG_BLOCK_ID_TD16                                = 0xd6,
	DBG_BLOCK_ID_TD17                                = 0xd7,
	DBG_BLOCK_ID_TD18                                = 0xd8,
	DBG_BLOCK_ID_TD19                                = 0xd9,
	DBG_BLOCK_ID_TD1A                                = 0xda,
	DBG_BLOCK_ID_TD1B                                = 0xdb,
	DBG_BLOCK_ID_UNUSED47                            = 0xdc,
	DBG_BLOCK_ID_UNUSED48                            = 0xdd,
	DBG_BLOCK_ID_UNUSED49                            = 0xde,
	DBG_BLOCK_ID_UNUSED50                            = 0xdf,
	DBG_BLOCK_ID_MCD0                                = 0xe0,
	DBG_BLOCK_ID_MCD1                                = 0xe1,
	DBG_BLOCK_ID_MCD2                                = 0xe2,
	DBG_BLOCK_ID_MCD3                                = 0xe3,
	DBG_BLOCK_ID_MCD4                                = 0xe4,
	DBG_BLOCK_ID_MCD5                                = 0xe5,
	DBG_BLOCK_ID_UNUSED51                            = 0xe6,
	DBG_BLOCK_ID_UNUSED52                            = 0xe7,
} DebugBlockId_OLD;
typedef enum DebugBlockId_BY2 {
	DBG_BLOCK_ID_RESERVED_BY2                        = 0x0,
	DBG_BLOCK_ID_VMC_BY2                             = 0x1,
	DBG_BLOCK_ID_CG_BY2                              = 0x2,
	DBG_BLOCK_ID_GRBM_BY2                            = 0x3,
	DBG_BLOCK_ID_CSC_BY2                             = 0x4,
	DBG_BLOCK_ID_IH_BY2                              = 0x5,
	DBG_BLOCK_ID_SQ_BY2                              = 0x6,
	DBG_BLOCK_ID_GMCON_BY2                           = 0x7,
	DBG_BLOCK_ID_DMA0_BY2                            = 0x8,
	DBG_BLOCK_ID_SPIM_BY2                            = 0x9,
	DBG_BLOCK_ID_SPIS_BY2                            = 0xa,
	DBG_BLOCK_ID_PA0_BY2                             = 0xb,
	DBG_BLOCK_ID_CP0_BY2                             = 0xc,
	DBG_BLOCK_ID_CP2_BY2                             = 0xd,
	DBG_BLOCK_ID_UVDU_BY2                            = 0xe,
	DBG_BLOCK_ID_VCE_BY2                             = 0xf,
	DBG_BLOCK_ID_VGT0_BY2                            = 0x10,
	DBG_BLOCK_ID_IA_BY2                              = 0x11,
	DBG_BLOCK_ID_SCT0_BY2                            = 0x12,
	DBG_BLOCK_ID_SPM0_BY2                            = 0x13,
	DBG_BLOCK_ID_TCAA_BY2                            = 0x14,
	DBG_BLOCK_ID_TCCA_BY2                            = 0x15,
	DBG_BLOCK_ID_MCC0_BY2                            = 0x16,
	DBG_BLOCK_ID_MCC2_BY2                            = 0x17,
	DBG_BLOCK_ID_SX0_BY2                             = 0x18,
	DBG_BLOCK_ID_SX2_BY2                             = 0x19,
	DBG_BLOCK_ID_UNUSED4_BY2                         = 0x1a,
	DBG_BLOCK_ID_UNUSED6_BY2                         = 0x1b,
	DBG_BLOCK_ID_PC0_BY2                             = 0x1c,
	DBG_BLOCK_ID_UNUSED8_BY2                         = 0x1d,
	DBG_BLOCK_ID_UNUSED10_BY2                        = 0x1e,
	DBG_BLOCK_ID_MCB_BY2                             = 0x1f,
	DBG_BLOCK_ID_SCB0_BY2                            = 0x20,
	DBG_BLOCK_ID_UNUSED13_BY2                        = 0x21,
	DBG_BLOCK_ID_SCF0_BY2                            = 0x22,
	DBG_BLOCK_ID_UNUSED15_BY2                        = 0x23,
	DBG_BLOCK_ID_BCI0_BY2                            = 0x24,
	DBG_BLOCK_ID_BCI2_BY2                            = 0x25,
	DBG_BLOCK_ID_UNUSED17_BY2                        = 0x26,
	DBG_BLOCK_ID_UNUSED19_BY2                        = 0x27,
	DBG_BLOCK_ID_CB00_BY2                            = 0x28,
	DBG_BLOCK_ID_CB02_BY2                            = 0x29,
	DBG_BLOCK_ID_CB04_BY2                            = 0x2a,
	DBG_BLOCK_ID_UNUSED22_BY2                        = 0x2b,
	DBG_BLOCK_ID_CB10_BY2                            = 0x2c,
	DBG_BLOCK_ID_CB12_BY2                            = 0x2d,
	DBG_BLOCK_ID_CB14_BY2                            = 0x2e,
	DBG_BLOCK_ID_UNUSED25_BY2                        = 0x2f,
	DBG_BLOCK_ID_TCP0_BY2                            = 0x30,
	DBG_BLOCK_ID_TCP2_BY2                            = 0x31,
	DBG_BLOCK_ID_TCP4_BY2                            = 0x32,
	DBG_BLOCK_ID_TCP6_BY2                            = 0x33,
	DBG_BLOCK_ID_TCP8_BY2                            = 0x34,
	DBG_BLOCK_ID_TCP10_BY2                           = 0x35,
	DBG_BLOCK_ID_TCP12_BY2                           = 0x36,
	DBG_BLOCK_ID_TCP14_BY2                           = 0x37,
	DBG_BLOCK_ID_TCP16_BY2                           = 0x38,
	DBG_BLOCK_ID_TCP18_BY2                           = 0x39,
	DBG_BLOCK_ID_TCP20_BY2                           = 0x3a,
	DBG_BLOCK_ID_TCP22_BY2                           = 0x3b,
	DBG_BLOCK_ID_TCP_RESERVED0_BY2                   = 0x3c,
	DBG_BLOCK_ID_TCP_RESERVED2_BY2                   = 0x3d,
	DBG_BLOCK_ID_TCP_RESERVED4_BY2                   = 0x3e,
	DBG_BLOCK_ID_TCP_RESERVED6_BY2                   = 0x3f,
	DBG_BLOCK_ID_DB00_BY2                            = 0x40,
	DBG_BLOCK_ID_DB02_BY2                            = 0x41,
	DBG_BLOCK_ID_DB04_BY2                            = 0x42,
	DBG_BLOCK_ID_UNUSED28_BY2                        = 0x43,
	DBG_BLOCK_ID_DB10_BY2                            = 0x44,
	DBG_BLOCK_ID_DB12_BY2                            = 0x45,
	DBG_BLOCK_ID_DB14_BY2                            = 0x46,
	DBG_BLOCK_ID_UNUSED31_BY2                        = 0x47,
	DBG_BLOCK_ID_TCC0_BY2                            = 0x48,
	DBG_BLOCK_ID_TCC2_BY2                            = 0x49,
	DBG_BLOCK_ID_TCC4_BY2                            = 0x4a,
	DBG_BLOCK_ID_TCC6_BY2                            = 0x4b,
	DBG_BLOCK_ID_SPS00_BY2                           = 0x4c,
	DBG_BLOCK_ID_SPS02_BY2                           = 0x4d,
	DBG_BLOCK_ID_SPS11_BY2                           = 0x4e,
	DBG_BLOCK_ID_UNUSED33_BY2                        = 0x4f,
	DBG_BLOCK_ID_TA00_BY2                            = 0x50,
	DBG_BLOCK_ID_TA02_BY2                            = 0x51,
	DBG_BLOCK_ID_TA04_BY2                            = 0x52,
	DBG_BLOCK_ID_TA06_BY2                            = 0x53,
	DBG_BLOCK_ID_TA08_BY2                            = 0x54,
	DBG_BLOCK_ID_TA0A_BY2                            = 0x55,
	DBG_BLOCK_ID_UNUSED35_BY2                        = 0x56,
	DBG_BLOCK_ID_UNUSED37_BY2                        = 0x57,
	DBG_BLOCK_ID_TA10_BY2                            = 0x58,
	DBG_BLOCK_ID_TA12_BY2                            = 0x59,
	DBG_BLOCK_ID_TA14_BY2                            = 0x5a,
	DBG_BLOCK_ID_TA16_BY2                            = 0x5b,
	DBG_BLOCK_ID_TA18_BY2                            = 0x5c,
	DBG_BLOCK_ID_TA1A_BY2                            = 0x5d,
	DBG_BLOCK_ID_UNUSED39_BY2                        = 0x5e,
	DBG_BLOCK_ID_UNUSED41_BY2                        = 0x5f,
	DBG_BLOCK_ID_TD00_BY2                            = 0x60,
	DBG_BLOCK_ID_TD02_BY2                            = 0x61,
	DBG_BLOCK_ID_TD04_BY2                            = 0x62,
	DBG_BLOCK_ID_TD06_BY2                            = 0x63,
	DBG_BLOCK_ID_TD08_BY2                            = 0x64,
	DBG_BLOCK_ID_TD0A_BY2                            = 0x65,
	DBG_BLOCK_ID_UNUSED43_BY2                        = 0x66,
	DBG_BLOCK_ID_UNUSED45_BY2                        = 0x67,
	DBG_BLOCK_ID_TD10_BY2                            = 0x68,
	DBG_BLOCK_ID_TD12_BY2                            = 0x69,
	DBG_BLOCK_ID_TD14_BY2                            = 0x6a,
	DBG_BLOCK_ID_TD16_BY2                            = 0x6b,
	DBG_BLOCK_ID_TD18_BY2                            = 0x6c,
	DBG_BLOCK_ID_TD1A_BY2                            = 0x6d,
	DBG_BLOCK_ID_UNUSED47_BY2                        = 0x6e,
	DBG_BLOCK_ID_UNUSED49_BY2                        = 0x6f,
	DBG_BLOCK_ID_MCD0_BY2                            = 0x70,
	DBG_BLOCK_ID_MCD2_BY2                            = 0x71,
	DBG_BLOCK_ID_MCD4_BY2                            = 0x72,
	DBG_BLOCK_ID_UNUSED51_BY2                        = 0x73,
} DebugBlockId_BY2;
typedef enum DebugBlockId_BY4 {
	DBG_BLOCK_ID_RESERVED_BY4                        = 0x0,
	DBG_BLOCK_ID_CG_BY4                              = 0x1,
	DBG_BLOCK_ID_CSC_BY4                             = 0x2,
	DBG_BLOCK_ID_SQ_BY4                              = 0x3,
	DBG_BLOCK_ID_DMA0_BY4                            = 0x4,
	DBG_BLOCK_ID_SPIS_BY4                            = 0x5,
	DBG_BLOCK_ID_CP0_BY4                             = 0x6,
	DBG_BLOCK_ID_UVDU_BY4                            = 0x7,
	DBG_BLOCK_ID_VGT0_BY4                            = 0x8,
	DBG_BLOCK_ID_SCT0_BY4                            = 0x9,
	DBG_BLOCK_ID_TCAA_BY4                            = 0xa,
	DBG_BLOCK_ID_MCC0_BY4                            = 0xb,
	DBG_BLOCK_ID_SX0_BY4                             = 0xc,
	DBG_BLOCK_ID_UNUSED4_BY4                         = 0xd,
	DBG_BLOCK_ID_PC0_BY4                             = 0xe,
	DBG_BLOCK_ID_UNUSED10_BY4                        = 0xf,
	DBG_BLOCK_ID_SCB0_BY4                            = 0x10,
	DBG_BLOCK_ID_SCF0_BY4                            = 0x11,
	DBG_BLOCK_ID_BCI0_BY4                            = 0x12,
	DBG_BLOCK_ID_UNUSED17_BY4                        = 0x13,
	DBG_BLOCK_ID_CB00_BY4                            = 0x14,
	DBG_BLOCK_ID_CB04_BY4                            = 0x15,
	DBG_BLOCK_ID_CB10_BY4                            = 0x16,
	DBG_BLOCK_ID_CB14_BY4                            = 0x17,
	DBG_BLOCK_ID_TCP0_BY4                            = 0x18,
	DBG_BLOCK_ID_TCP4_BY4                            = 0x19,
	DBG_BLOCK_ID_TCP8_BY4                            = 0x1a,
	DBG_BLOCK_ID_TCP12_BY4                           = 0x1b,
	DBG_BLOCK_ID_TCP16_BY4                           = 0x1c,
	DBG_BLOCK_ID_TCP20_BY4                           = 0x1d,
	DBG_BLOCK_ID_TCP_RESERVED0_BY4                   = 0x1e,
	DBG_BLOCK_ID_TCP_RESERVED4_BY4                   = 0x1f,
	DBG_BLOCK_ID_DB_BY4                              = 0x20,
	DBG_BLOCK_ID_DB04_BY4                            = 0x21,
	DBG_BLOCK_ID_DB10_BY4                            = 0x22,
	DBG_BLOCK_ID_DB14_BY4                            = 0x23,
	DBG_BLOCK_ID_TCC0_BY4                            = 0x24,
	DBG_BLOCK_ID_TCC4_BY4                            = 0x25,
	DBG_BLOCK_ID_SPS00_BY4                           = 0x26,
	DBG_BLOCK_ID_SPS11_BY4                           = 0x27,
	DBG_BLOCK_ID_TA00_BY4                            = 0x28,
	DBG_BLOCK_ID_TA04_BY4                            = 0x29,
	DBG_BLOCK_ID_TA08_BY4                            = 0x2a,
	DBG_BLOCK_ID_UNUSED35_BY4                        = 0x2b,
	DBG_BLOCK_ID_TA10_BY4                            = 0x2c,
	DBG_BLOCK_ID_TA14_BY4                            = 0x2d,
	DBG_BLOCK_ID_TA18_BY4                            = 0x2e,
	DBG_BLOCK_ID_UNUSED39_BY4                        = 0x2f,
	DBG_BLOCK_ID_TD00_BY4                            = 0x30,
	DBG_BLOCK_ID_TD04_BY4                            = 0x31,
	DBG_BLOCK_ID_TD08_BY4                            = 0x32,
	DBG_BLOCK_ID_UNUSED43_BY4                        = 0x33,
	DBG_BLOCK_ID_TD10_BY4                            = 0x34,
	DBG_BLOCK_ID_TD14_BY4                            = 0x35,
	DBG_BLOCK_ID_TD18_BY4                            = 0x36,
	DBG_BLOCK_ID_UNUSED47_BY4                        = 0x37,
	DBG_BLOCK_ID_MCD0_BY4                            = 0x38,
	DBG_BLOCK_ID_MCD4_BY4                            = 0x39,
} DebugBlockId_BY4;
typedef enum DebugBlockId_BY8 {
	DBG_BLOCK_ID_RESERVED_BY8                        = 0x0,
	DBG_BLOCK_ID_CSC_BY8                             = 0x1,
	DBG_BLOCK_ID_DMA0_BY8                            = 0x2,
	DBG_BLOCK_ID_CP0_BY8                             = 0x3,
	DBG_BLOCK_ID_VGT0_BY8                            = 0x4,
	DBG_BLOCK_ID_TCAA_BY8                            = 0x5,
	DBG_BLOCK_ID_SX0_BY8                             = 0x6,
	DBG_BLOCK_ID_PC0_BY8                             = 0x7,
	DBG_BLOCK_ID_SCB0_BY8                            = 0x8,
	DBG_BLOCK_ID_BCI0_BY8                            = 0x9,
	DBG_BLOCK_ID_CB00_BY8                            = 0xa,
	DBG_BLOCK_ID_CB10_BY8                            = 0xb,
	DBG_BLOCK_ID_TCP0_BY8                            = 0xc,
	DBG_BLOCK_ID_TCP8_BY8                            = 0xd,
	DBG_BLOCK_ID_TCP16_BY8                           = 0xe,
	DBG_BLOCK_ID_TCP_RESERVED0_BY8                   = 0xf,
	DBG_BLOCK_ID_DB00_BY8                            = 0x10,
	DBG_BLOCK_ID_DB10_BY8                            = 0x11,
	DBG_BLOCK_ID_TCC0_BY8                            = 0x12,
	DBG_BLOCK_ID_SPS00_BY8                           = 0x13,
	DBG_BLOCK_ID_TA00_BY8                            = 0x14,
	DBG_BLOCK_ID_TA08_BY8                            = 0x15,
	DBG_BLOCK_ID_TA10_BY8                            = 0x16,
	DBG_BLOCK_ID_TA18_BY8                            = 0x17,
	DBG_BLOCK_ID_TD00_BY8                            = 0x18,
	DBG_BLOCK_ID_TD08_BY8                            = 0x19,
	DBG_BLOCK_ID_TD10_BY8                            = 0x1a,
	DBG_BLOCK_ID_TD18_BY8                            = 0x1b,
	DBG_BLOCK_ID_MCD0_BY8                            = 0x1c,
} DebugBlockId_BY8;
typedef enum DebugBlockId_BY16 {
	DBG_BLOCK_ID_RESERVED_BY16                       = 0x0,
	DBG_BLOCK_ID_DMA0_BY16                           = 0x1,
	DBG_BLOCK_ID_VGT0_BY16                           = 0x2,
	DBG_BLOCK_ID_SX0_BY16                            = 0x3,
	DBG_BLOCK_ID_SCB0_BY16                           = 0x4,
	DBG_BLOCK_ID_CB00_BY16                           = 0x5,
	DBG_BLOCK_ID_TCP0_BY16                           = 0x6,
	DBG_BLOCK_ID_TCP16_BY16                          = 0x7,
	DBG_BLOCK_ID_DB00_BY16                           = 0x8,
	DBG_BLOCK_ID_TCC0_BY16                           = 0x9,
	DBG_BLOCK_ID_TA00_BY16                           = 0xa,
	DBG_BLOCK_ID_TA10_BY16                           = 0xb,
	DBG_BLOCK_ID_TD00_BY16                           = 0xc,
	DBG_BLOCK_ID_TD10_BY16                           = 0xd,
	DBG_BLOCK_ID_MCD0_BY16                           = 0xe,
} DebugBlockId_BY16;
typedef enum ColorTransform {
	DCC_CT_AUTO                                      = 0x0,
	DCC_CT_NONE                                      = 0x1,
	ABGR_TO_A_BG_G_RB                                = 0x2,
	BGRA_TO_BG_G_RB_A                                = 0x3,
} ColorTransform;
typedef enum CompareRef {
	REF_NEVER                                        = 0x0,
	REF_LESS                                         = 0x1,
	REF_EQUAL                                        = 0x2,
	REF_LEQUAL                                       = 0x3,
	REF_GREATER                                      = 0x4,
	REF_NOTEQUAL                                     = 0x5,
	REF_GEQUAL                                       = 0x6,
	REF_ALWAYS                                       = 0x7,
} CompareRef;
typedef enum ReadSize {
	READ_256_BITS                                    = 0x0,
	READ_512_BITS                                    = 0x1,
} ReadSize;
typedef enum DepthFormat {
	DEPTH_INVALID                                    = 0x0,
	DEPTH_16                                         = 0x1,
	DEPTH_X8_24                                      = 0x2,
	DEPTH_8_24                                       = 0x3,
	DEPTH_X8_24_FLOAT                                = 0x4,
	DEPTH_8_24_FLOAT                                 = 0x5,
	DEPTH_32_FLOAT                                   = 0x6,
	DEPTH_X24_8_32_FLOAT                             = 0x7,
} DepthFormat;
typedef enum ZFormat {
	Z_INVALID                                        = 0x0,
	Z_16                                             = 0x1,
	Z_24                                             = 0x2,
	Z_32_FLOAT                                       = 0x3,
} ZFormat;
typedef enum StencilFormat {
	STENCIL_INVALID                                  = 0x0,
	STENCIL_8                                        = 0x1,
} StencilFormat;
typedef enum CmaskMode {
	CMASK_CLEAR_NONE                                 = 0x0,
	CMASK_CLEAR_ONE                                  = 0x1,
	CMASK_CLEAR_ALL                                  = 0x2,
	CMASK_ANY_EXPANDED                               = 0x3,
	CMASK_ALPHA0_FRAG1                               = 0x4,
	CMASK_ALPHA0_FRAG2                               = 0x5,
	CMASK_ALPHA0_FRAG4                               = 0x6,
	CMASK_ALPHA0_FRAGS                               = 0x7,
	CMASK_ALPHA1_FRAG1                               = 0x8,
	CMASK_ALPHA1_FRAG2                               = 0x9,
	CMASK_ALPHA1_FRAG4                               = 0xa,
	CMASK_ALPHA1_FRAGS                               = 0xb,
	CMASK_ALPHAX_FRAG1                               = 0xc,
	CMASK_ALPHAX_FRAG2                               = 0xd,
	CMASK_ALPHAX_FRAG4                               = 0xe,
	CMASK_ALPHAX_FRAGS                               = 0xf,
} CmaskMode;
typedef enum QuadExportFormat {
	EXPORT_UNUSED                                    = 0x0,
	EXPORT_32_R                                      = 0x1,
	EXPORT_32_GR                                     = 0x2,
	EXPORT_32_AR                                     = 0x3,
	EXPORT_FP16_ABGR                                 = 0x4,
	EXPORT_UNSIGNED16_ABGR                           = 0x5,
	EXPORT_SIGNED16_ABGR                             = 0x6,
	EXPORT_32_ABGR                                   = 0x7,
} QuadExportFormat;
typedef enum QuadExportFormatOld {
	EXPORT_4P_32BPC_ABGR                             = 0x0,
	EXPORT_4P_16BPC_ABGR                             = 0x1,
	EXPORT_4P_32BPC_GR                               = 0x2,
	EXPORT_4P_32BPC_AR                               = 0x3,
	EXPORT_2P_32BPC_ABGR                             = 0x4,
	EXPORT_8P_32BPC_R                                = 0x5,
} QuadExportFormatOld;
typedef enum ColorFormat {
	COLOR_INVALID                                    = 0x0,
	COLOR_8                                          = 0x1,
	COLOR_16                                         = 0x2,
	COLOR_8_8                                        = 0x3,
	COLOR_32                                         = 0x4,
	COLOR_16_16                                      = 0x5,
	COLOR_10_11_11                                   = 0x6,
	COLOR_11_11_10                                   = 0x7,
	COLOR_10_10_10_2                                 = 0x8,
	COLOR_2_10_10_10                                 = 0x9,
	COLOR_8_8_8_8                                    = 0xa,
	COLOR_32_32                                      = 0xb,
	COLOR_16_16_16_16                                = 0xc,
	COLOR_RESERVED_13                                = 0xd,
	COLOR_32_32_32_32                                = 0xe,
	COLOR_RESERVED_15                                = 0xf,
	COLOR_5_6_5                                      = 0x10,
	COLOR_1_5_5_5                                    = 0x11,
	COLOR_5_5_5_1                                    = 0x12,
	COLOR_4_4_4_4                                    = 0x13,
	COLOR_8_24                                       = 0x14,
	COLOR_24_8                                       = 0x15,
	COLOR_X24_8_32_FLOAT                             = 0x16,
	COLOR_RESERVED_23                                = 0x17,
} ColorFormat;
typedef enum SurfaceFormat {
	FMT_INVALID                                      = 0x0,
	FMT_8                                            = 0x1,
	FMT_16                                           = 0x2,
	FMT_8_8                                          = 0x3,
	FMT_32                                           = 0x4,
	FMT_16_16                                        = 0x5,
	FMT_10_11_11                                     = 0x6,
	FMT_11_11_10                                     = 0x7,
	FMT_10_10_10_2                                   = 0x8,
	FMT_2_10_10_10                                   = 0x9,
	FMT_8_8_8_8                                      = 0xa,
	FMT_32_32                                        = 0xb,
	FMT_16_16_16_16                                  = 0xc,
	FMT_32_32_32                                     = 0xd,
	FMT_32_32_32_32                                  = 0xe,
	FMT_RESERVED_4                                   = 0xf,
	FMT_5_6_5                                        = 0x10,
	FMT_1_5_5_5                                      = 0x11,
	FMT_5_5_5_1                                      = 0x12,
	FMT_4_4_4_4                                      = 0x13,
	FMT_8_24                                         = 0x14,
	FMT_24_8                                         = 0x15,
	FMT_X24_8_32_FLOAT                               = 0x16,
	FMT_RESERVED_33                                  = 0x17,
	FMT_11_11_10_FLOAT                               = 0x18,
	FMT_16_FLOAT                                     = 0x19,
	FMT_32_FLOAT                                     = 0x1a,
	FMT_16_16_FLOAT                                  = 0x1b,
	FMT_8_24_FLOAT                                   = 0x1c,
	FMT_24_8_FLOAT                                   = 0x1d,
	FMT_32_32_FLOAT                                  = 0x1e,
	FMT_10_11_11_FLOAT                               = 0x1f,
	FMT_16_16_16_16_FLOAT                            = 0x20,
	FMT_3_3_2                                        = 0x21,
	FMT_6_5_5                                        = 0x22,
	FMT_32_32_32_32_FLOAT                            = 0x23,
	FMT_RESERVED_36                                  = 0x24,
	FMT_1                                            = 0x25,
	FMT_1_REVERSED                                   = 0x26,
	FMT_GB_GR                                        = 0x27,
	FMT_BG_RG                                        = 0x28,
	FMT_32_AS_8                                      = 0x29,
	FMT_32_AS_8_8                                    = 0x2a,
	FMT_5_9_9_9_SHAREDEXP                            = 0x2b,
	FMT_8_8_8                                        = 0x2c,
	FMT_16_16_16                                     = 0x2d,
	FMT_16_16_16_FLOAT                               = 0x2e,
	FMT_4_4                                          = 0x2f,
	FMT_32_32_32_FLOAT                               = 0x30,
	FMT_BC1                                          = 0x31,
	FMT_BC2                                          = 0x32,
	FMT_BC3                                          = 0x33,
	FMT_BC4                                          = 0x34,
	FMT_BC5                                          = 0x35,
	FMT_BC6                                          = 0x36,
	FMT_BC7                                          = 0x37,
	FMT_32_AS_32_32_32_32                            = 0x38,
	FMT_APC3                                         = 0x39,
	FMT_APC4                                         = 0x3a,
	FMT_APC5                                         = 0x3b,
	FMT_APC6                                         = 0x3c,
	FMT_APC7                                         = 0x3d,
	FMT_CTX1                                         = 0x3e,
	FMT_RESERVED_63                                  = 0x3f,
} SurfaceFormat;
typedef enum BUF_DATA_FORMAT {
	BUF_DATA_FORMAT_INVALID                          = 0x0,
	BUF_DATA_FORMAT_8                                = 0x1,
	BUF_DATA_FORMAT_16                               = 0x2,
	BUF_DATA_FORMAT_8_8                              = 0x3,
	BUF_DATA_FORMAT_32                               = 0x4,
	BUF_DATA_FORMAT_16_16                            = 0x5,
	BUF_DATA_FORMAT_10_11_11                         = 0x6,
	BUF_DATA_FORMAT_11_11_10                         = 0x7,
	BUF_DATA_FORMAT_10_10_10_2                       = 0x8,
	BUF_DATA_FORMAT_2_10_10_10                       = 0x9,
	BUF_DATA_FORMAT_8_8_8_8                          = 0xa,
	BUF_DATA_FORMAT_32_32                            = 0xb,
	BUF_DATA_FORMAT_16_16_16_16                      = 0xc,
	BUF_DATA_FORMAT_32_32_32                         = 0xd,
	BUF_DATA_FORMAT_32_32_32_32                      = 0xe,
	BUF_DATA_FORMAT_RESERVED_15                      = 0xf,
} BUF_DATA_FORMAT;
typedef enum IMG_DATA_FORMAT {
	IMG_DATA_FORMAT_INVALID                          = 0x0,
	IMG_DATA_FORMAT_8                                = 0x1,
	IMG_DATA_FORMAT_16                               = 0x2,
	IMG_DATA_FORMAT_8_8                              = 0x3,
	IMG_DATA_FORMAT_32                               = 0x4,
	IMG_DATA_FORMAT_16_16                            = 0x5,
	IMG_DATA_FORMAT_10_11_11                         = 0x6,
	IMG_DATA_FORMAT_11_11_10                         = 0x7,
	IMG_DATA_FORMAT_10_10_10_2                       = 0x8,
	IMG_DATA_FORMAT_2_10_10_10                       = 0x9,
	IMG_DATA_FORMAT_8_8_8_8                          = 0xa,
	IMG_DATA_FORMAT_32_32                            = 0xb,
	IMG_DATA_FORMAT_16_16_16_16                      = 0xc,
	IMG_DATA_FORMAT_32_32_32                         = 0xd,
	IMG_DATA_FORMAT_32_32_32_32                      = 0xe,
	IMG_DATA_FORMAT_RESERVED_15                      = 0xf,
	IMG_DATA_FORMAT_5_6_5                            = 0x10,
	IMG_DATA_FORMAT_1_5_5_5                          = 0x11,
	IMG_DATA_FORMAT_5_5_5_1                          = 0x12,
	IMG_DATA_FORMAT_4_4_4_4                          = 0x13,
	IMG_DATA_FORMAT_8_24                             = 0x14,
	IMG_DATA_FORMAT_24_8                             = 0x15,
	IMG_DATA_FORMAT_X24_8_32                         = 0x16,
	IMG_DATA_FORMAT_RESERVED_23                      = 0x17,
	IMG_DATA_FORMAT_RESERVED_24                      = 0x18,
	IMG_DATA_FORMAT_RESERVED_25                      = 0x19,
	IMG_DATA_FORMAT_RESERVED_26                      = 0x1a,
	IMG_DATA_FORMAT_RESERVED_27                      = 0x1b,
	IMG_DATA_FORMAT_RESERVED_28                      = 0x1c,
	IMG_DATA_FORMAT_RESERVED_29                      = 0x1d,
	IMG_DATA_FORMAT_RESERVED_30                      = 0x1e,
	IMG_DATA_FORMAT_RESERVED_31                      = 0x1f,
	IMG_DATA_FORMAT_GB_GR                            = 0x20,
	IMG_DATA_FORMAT_BG_RG                            = 0x21,
	IMG_DATA_FORMAT_5_9_9_9                          = 0x22,
	IMG_DATA_FORMAT_BC1                              = 0x23,
	IMG_DATA_FORMAT_BC2                              = 0x24,
	IMG_DATA_FORMAT_BC3                              = 0x25,
	IMG_DATA_FORMAT_BC4                              = 0x26,
	IMG_DATA_FORMAT_BC5                              = 0x27,
	IMG_DATA_FORMAT_BC6                              = 0x28,
	IMG_DATA_FORMAT_BC7                              = 0x29,
	IMG_DATA_FORMAT_RESERVED_42                      = 0x2a,
	IMG_DATA_FORMAT_RESERVED_43                      = 0x2b,
	IMG_DATA_FORMAT_FMASK8_S2_F1                     = 0x2c,
	IMG_DATA_FORMAT_FMASK8_S4_F1                     = 0x2d,
	IMG_DATA_FORMAT_FMASK8_S8_F1                     = 0x2e,
	IMG_DATA_FORMAT_FMASK8_S2_F2                     = 0x2f,
	IMG_DATA_FORMAT_FMASK8_S4_F2                     = 0x30,
	IMG_DATA_FORMAT_FMASK8_S4_F4                     = 0x31,
	IMG_DATA_FORMAT_FMASK16_S16_F1                   = 0x32,
	IMG_DATA_FORMAT_FMASK16_S8_F2                    = 0x33,
	IMG_DATA_FORMAT_FMASK32_S16_F2                   = 0x34,
	IMG_DATA_FORMAT_FMASK32_S8_F4                    = 0x35,
	IMG_DATA_FORMAT_FMASK32_S8_F8                    = 0x36,
	IMG_DATA_FORMAT_FMASK64_S16_F4                   = 0x37,
	IMG_DATA_FORMAT_FMASK64_S16_F8                   = 0x38,
	IMG_DATA_FORMAT_4_4                              = 0x39,
	IMG_DATA_FORMAT_6_5_5                            = 0x3a,
	IMG_DATA_FORMAT_1                                = 0x3b,
	IMG_DATA_FORMAT_1_REVERSED                       = 0x3c,
	IMG_DATA_FORMAT_32_AS_8                          = 0x3d,
	IMG_DATA_FORMAT_32_AS_8_8                        = 0x3e,
	IMG_DATA_FORMAT_32_AS_32_32_32_32                = 0x3f,
} IMG_DATA_FORMAT;
typedef enum BUF_NUM_FORMAT {
	BUF_NUM_FORMAT_UNORM                             = 0x0,
	BUF_NUM_FORMAT_SNORM                             = 0x1,
	BUF_NUM_FORMAT_USCALED                           = 0x2,
	BUF_NUM_FORMAT_SSCALED                           = 0x3,
	BUF_NUM_FORMAT_UINT                              = 0x4,
	BUF_NUM_FORMAT_SINT                              = 0x5,
	BUF_NUM_FORMAT_RESERVED_6                        = 0x6,
	BUF_NUM_FORMAT_FLOAT                             = 0x7,
} BUF_NUM_FORMAT;
typedef enum IMG_NUM_FORMAT {
	IMG_NUM_FORMAT_UNORM                             = 0x0,
	IMG_NUM_FORMAT_SNORM                             = 0x1,
	IMG_NUM_FORMAT_USCALED                           = 0x2,
	IMG_NUM_FORMAT_SSCALED                           = 0x3,
	IMG_NUM_FORMAT_UINT                              = 0x4,
	IMG_NUM_FORMAT_SINT                              = 0x5,
	IMG_NUM_FORMAT_RESERVED_6                        = 0x6,
	IMG_NUM_FORMAT_FLOAT                             = 0x7,
	IMG_NUM_FORMAT_RESERVED_8                        = 0x8,
	IMG_NUM_FORMAT_SRGB                              = 0x9,
	IMG_NUM_FORMAT_RESERVED_10                       = 0xa,
	IMG_NUM_FORMAT_RESERVED_11                       = 0xb,
	IMG_NUM_FORMAT_RESERVED_12                       = 0xc,
	IMG_NUM_FORMAT_RESERVED_13                       = 0xd,
	IMG_NUM_FORMAT_RESERVED_14                       = 0xe,
	IMG_NUM_FORMAT_RESERVED_15                       = 0xf,
} IMG_NUM_FORMAT;
typedef enum TileType {
	ARRAY_COLOR_TILE                                 = 0x0,
	ARRAY_DEPTH_TILE                                 = 0x1,
} TileType;
typedef enum NonDispTilingOrder {
	ADDR_SURF_MICRO_TILING_DISPLAY                   = 0x0,
	ADDR_SURF_MICRO_TILING_NON_DISPLAY               = 0x1,
} NonDispTilingOrder;
typedef enum MicroTileMode {
	ADDR_SURF_DISPLAY_MICRO_TILING                   = 0x0,
	ADDR_SURF_THIN_MICRO_TILING                      = 0x1,
	ADDR_SURF_DEPTH_MICRO_TILING                     = 0x2,
	ADDR_SURF_ROTATED_MICRO_TILING                   = 0x3,
	ADDR_SURF_THICK_MICRO_TILING                     = 0x4,
} MicroTileMode;
typedef enum TileSplit {
	ADDR_SURF_TILE_SPLIT_64B                         = 0x0,
	ADDR_SURF_TILE_SPLIT_128B                        = 0x1,
	ADDR_SURF_TILE_SPLIT_256B                        = 0x2,
	ADDR_SURF_TILE_SPLIT_512B                        = 0x3,
	ADDR_SURF_TILE_SPLIT_1KB                         = 0x4,
	ADDR_SURF_TILE_SPLIT_2KB                         = 0x5,
	ADDR_SURF_TILE_SPLIT_4KB                         = 0x6,
} TileSplit;
typedef enum SampleSplit {
	ADDR_SURF_SAMPLE_SPLIT_1                         = 0x0,
	ADDR_SURF_SAMPLE_SPLIT_2                         = 0x1,
	ADDR_SURF_SAMPLE_SPLIT_4                         = 0x2,
	ADDR_SURF_SAMPLE_SPLIT_8                         = 0x3,
} SampleSplit;
typedef enum PipeConfig {
	ADDR_SURF_P2                                     = 0x0,
	ADDR_SURF_P2_RESERVED0                           = 0x1,
	ADDR_SURF_P2_RESERVED1                           = 0x2,
	ADDR_SURF_P2_RESERVED2                           = 0x3,
	ADDR_SURF_P4_8x16                                = 0x4,
	ADDR_SURF_P4_16x16                               = 0x5,
	ADDR_SURF_P4_16x32                               = 0x6,
	ADDR_SURF_P4_32x32                               = 0x7,
	ADDR_SURF_P8_16x16_8x16                          = 0x8,
	ADDR_SURF_P8_16x32_8x16                          = 0x9,
	ADDR_SURF_P8_32x32_8x16                          = 0xa,
	ADDR_SURF_P8_16x32_16x16                         = 0xb,
	ADDR_SURF_P8_32x32_16x16                         = 0xc,
	ADDR_SURF_P8_32x32_16x32                         = 0xd,
	ADDR_SURF_P8_32x64_32x32                         = 0xe,
	ADDR_SURF_P8_RESERVED0                           = 0xf,
	ADDR_SURF_P16_32x32_8x16                         = 0x10,
	ADDR_SURF_P16_32x32_16x16                        = 0x11,
} PipeConfig;
typedef enum NumBanks {
	ADDR_SURF_2_BANK                                 = 0x0,
	ADDR_SURF_4_BANK                                 = 0x1,
	ADDR_SURF_8_BANK                                 = 0x2,
	ADDR_SURF_16_BANK                                = 0x3,
} NumBanks;
typedef enum BankWidth {
	ADDR_SURF_BANK_WIDTH_1                           = 0x0,
	ADDR_SURF_BANK_WIDTH_2                           = 0x1,
	ADDR_SURF_BANK_WIDTH_4                           = 0x2,
	ADDR_SURF_BANK_WIDTH_8                           = 0x3,
} BankWidth;
typedef enum BankHeight {
	ADDR_SURF_BANK_HEIGHT_1                          = 0x0,
	ADDR_SURF_BANK_HEIGHT_2                          = 0x1,
	ADDR_SURF_BANK_HEIGHT_4                          = 0x2,
	ADDR_SURF_BANK_HEIGHT_8                          = 0x3,
} BankHeight;
typedef enum BankWidthHeight {
	ADDR_SURF_BANK_WH_1                              = 0x0,
	ADDR_SURF_BANK_WH_2                              = 0x1,
	ADDR_SURF_BANK_WH_4                              = 0x2,
	ADDR_SURF_BANK_WH_8                              = 0x3,
} BankWidthHeight;
typedef enum MacroTileAspect {
	ADDR_SURF_MACRO_ASPECT_1                         = 0x0,
	ADDR_SURF_MACRO_ASPECT_2                         = 0x1,
	ADDR_SURF_MACRO_ASPECT_4                         = 0x2,
	ADDR_SURF_MACRO_ASPECT_8                         = 0x3,
} MacroTileAspect;
typedef enum GATCL1RequestType {
	GATCL1_TYPE_NORMAL                               = 0x0,
	GATCL1_TYPE_SHOOTDOWN                            = 0x1,
	GATCL1_TYPE_BYPASS                               = 0x2,
} GATCL1RequestType;
typedef enum TCC_CACHE_POLICIES {
	TCC_CACHE_POLICY_LRU                             = 0x0,
	TCC_CACHE_POLICY_STREAM                          = 0x1,
} TCC_CACHE_POLICIES;
typedef enum MTYPE {
	MTYPE_NC_NV                                      = 0x0,
	MTYPE_NC                                         = 0x1,
	MTYPE_CC                                         = 0x2,
	MTYPE_UC                                         = 0x3,
} MTYPE;
typedef enum PERFMON_COUNTER_MODE {
	PERFMON_COUNTER_MODE_ACCUM                       = 0x0,
	PERFMON_COUNTER_MODE_ACTIVE_CYCLES               = 0x1,
	PERFMON_COUNTER_MODE_MAX                         = 0x2,
	PERFMON_COUNTER_MODE_DIRTY                       = 0x3,
	PERFMON_COUNTER_MODE_SAMPLE                      = 0x4,
	PERFMON_COUNTER_MODE_CYCLES_SINCE_FIRST_EVENT    = 0x5,
	PERFMON_COUNTER_MODE_CYCLES_SINCE_LAST_EVENT     = 0x6,
	PERFMON_COUNTER_MODE_CYCLES_GE_HI                = 0x7,
	PERFMON_COUNTER_MODE_CYCLES_EQ_HI                = 0x8,
	PERFMON_COUNTER_MODE_INACTIVE_CYCLES             = 0x9,
	PERFMON_COUNTER_MODE_RESERVED                    = 0xf,
} PERFMON_COUNTER_MODE;
typedef enum PERFMON_SPM_MODE {
	PERFMON_SPM_MODE_OFF                             = 0x0,
	PERFMON_SPM_MODE_16BIT_CLAMP                     = 0x1,
	PERFMON_SPM_MODE_16BIT_NO_CLAMP                  = 0x2,
	PERFMON_SPM_MODE_32BIT_CLAMP                     = 0x3,
	PERFMON_SPM_MODE_32BIT_NO_CLAMP                  = 0x4,
	PERFMON_SPM_MODE_RESERVED_5                      = 0x5,
	PERFMON_SPM_MODE_RESERVED_6                      = 0x6,
	PERFMON_SPM_MODE_RESERVED_7                      = 0x7,
	PERFMON_SPM_MODE_TEST_MODE_0                     = 0x8,
	PERFMON_SPM_MODE_TEST_MODE_1                     = 0x9,
	PERFMON_SPM_MODE_TEST_MODE_2                     = 0xa,
} PERFMON_SPM_MODE;
typedef enum SurfaceTiling {
	ARRAY_LINEAR                                     = 0x0,
	ARRAY_TILED                                      = 0x1,
} SurfaceTiling;
typedef enum SurfaceArray {
	ARRAY_1D                                         = 0x0,
	ARRAY_2D                                         = 0x1,
	ARRAY_3D                                         = 0x2,
	ARRAY_3D_SLICE                                   = 0x3,
} SurfaceArray;
typedef enum ColorArray {
	ARRAY_2D_ALT_COLOR                               = 0x0,
	ARRAY_2D_COLOR                                   = 0x1,
	ARRAY_3D_SLICE_COLOR                             = 0x3,
} ColorArray;
typedef enum DepthArray {
	ARRAY_2D_ALT_DEPTH                               = 0x0,
	ARRAY_2D_DEPTH                                   = 0x1,
} DepthArray;
typedef enum ENUM_NUM_SIMD_PER_CU {
	NUM_SIMD_PER_CU                                  = 0x4,
} ENUM_NUM_SIMD_PER_CU;
typedef enum MEM_PWR_FORCE_CTRL {
	NO_FORCE_REQUEST                                 = 0x0,
	FORCE_LIGHT_SLEEP_REQUEST                        = 0x1,
	FORCE_DEEP_SLEEP_REQUEST                         = 0x2,
	FORCE_SHUT_DOWN_REQUEST                          = 0x3,
} MEM_PWR_FORCE_CTRL;
typedef enum MEM_PWR_FORCE_CTRL2 {
	NO_FORCE_REQ                                     = 0x0,
	FORCE_LIGHT_SLEEP_REQ                            = 0x1,
} MEM_PWR_FORCE_CTRL2;
typedef enum MEM_PWR_DIS_CTRL {
	ENABLE_MEM_PWR_CTRL                              = 0x0,
	DISABLE_MEM_PWR_CTRL                             = 0x1,
} MEM_PWR_DIS_CTRL;
typedef enum MEM_PWR_SEL_CTRL {
	DYNAMIC_SHUT_DOWN_ENABLE                         = 0x0,
	DYNAMIC_DEEP_SLEEP_ENABLE                        = 0x1,
	DYNAMIC_LIGHT_SLEEP_ENABLE                       = 0x2,
} MEM_PWR_SEL_CTRL;
typedef enum MEM_PWR_SEL_CTRL2 {
	DYNAMIC_DEEP_SLEEP_EN                            = 0x0,
	DYNAMIC_LIGHT_SLEEP_EN                           = 0x1,
} MEM_PWR_SEL_CTRL2;
typedef enum HPD_INT_CONTROL_ACK {
	HPD_INT_CONTROL_ACK_0                            = 0x0,
	HPD_INT_CONTROL_ACK_1                            = 0x1,
} HPD_INT_CONTROL_ACK;
typedef enum HPD_INT_CONTROL_POLARITY {
	HPD_INT_CONTROL_GEN_INT_ON_DISCON                = 0x0,
	HPD_INT_CONTROL_GEN_INT_ON_CON                   = 0x1,
} HPD_INT_CONTROL_POLARITY;
typedef enum HPD_INT_CONTROL_RX_INT_ACK {
	HPD_INT_CONTROL_RX_INT_ACK_0                     = 0x0,
	HPD_INT_CONTROL_RX_INT_ACK_1                     = 0x1,
} HPD_INT_CONTROL_RX_INT_ACK;
typedef enum DPDBG_EN {
	DPDBG_DISABLE                                    = 0x0,
	DPDBG_ENABLE                                     = 0x1,
} DPDBG_EN;
typedef enum DPDBG_INPUT_EN {
	DPDBG_INPUT_DISABLE                              = 0x0,
	DPDBG_INPUT_ENABLE                               = 0x1,
} DPDBG_INPUT_EN;
typedef enum DPDBG_ERROR_DETECTION_MODE {
	DPDBG_ERROR_DETECTION_MODE_CSC                   = 0x0,
	DPDBG_ERROR_DETECTION_MODE_RS_ENCODING           = 0x1,
} DPDBG_ERROR_DETECTION_MODE;
typedef enum DPDBG_FIFO_OVERFLOW_INTERRUPT_MASK {
	DPDBG_FIFO_OVERFLOW_INT_DISABLE                  = 0x0,
	DPDBG_FIFO_OVERFLOW_INT_ENABLE                   = 0x1,
} DPDBG_FIFO_OVERFLOW_INTERRUPT_MASK;
typedef enum DPDBG_FIFO_OVERFLOW_INTERRUPT_TYPE {
	DPDBG_FIFO_OVERFLOW_INT_LEVEL_BASED              = 0x0,
	DPDBG_FIFO_OVERFLOW_INT_PULSE_BASED              = 0x1,
} DPDBG_FIFO_OVERFLOW_INTERRUPT_TYPE;
typedef enum DPDBG_FIFO_OVERFLOW_INTERRUPT_ACK {
	DPDBG_FIFO_OVERFLOW_INT_NO_ACK                   = 0x0,
	DPDBG_FIFO_OVERFLOW_INT_CLEAR                    = 0x1,
} DPDBG_FIFO_OVERFLOW_INTERRUPT_ACK;
typedef enum PM_ASSERT_RESET {
	PM_ASSERT_RESET_0                                = 0x0,
	PM_ASSERT_RESET_1                                = 0x1,
} PM_ASSERT_RESET;
typedef enum DAC_MUX_SELECT {
	DAC_MUX_SELECT_DACA                              = 0x0,
	DAC_MUX_SELECT_DACB                              = 0x1,
} DAC_MUX_SELECT;
typedef enum TMDS_DVO_MUX_SELECT {
	TMDS_DVO_MUX_SELECT_B                            = 0x0,
	TMDS_DVO_MUX_SELECT_G                            = 0x1,
	TMDS_DVO_MUX_SELECT_R                            = 0x2,
	TMDS_DVO_MUX_SELECT_RESERVED                     = 0x3,
} TMDS_DVO_MUX_SELECT;
typedef enum DACA_SOFT_RESET {
	DACA_SOFT_RESET_0                                = 0x0,
	DACA_SOFT_RESET_1                                = 0x1,
} DACA_SOFT_RESET;
typedef enum I2S0_SPDIF0_SOFT_RESET {
	I2S0_SPDIF0_SOFT_RESET_0                         = 0x0,
	I2S0_SPDIF0_SOFT_RESET_1                         = 0x1,
} I2S0_SPDIF0_SOFT_RESET;
typedef enum I2S1_SOFT_RESET {
	I2S1_SOFT_RESET_0                                = 0x0,
	I2S1_SOFT_RESET_1                                = 0x1,
} I2S1_SOFT_RESET;
typedef enum SPDIF1_SOFT_RESET {
	SPDIF1_SOFT_RESET_0                              = 0x0,
	SPDIF1_SOFT_RESET_1                              = 0x1,
} SPDIF1_SOFT_RESET;
typedef enum DB_CLK_SOFT_RESET {
	DB_CLK_SOFT_RESET_0                              = 0x0,
	DB_CLK_SOFT_RESET_1                              = 0x1,
} DB_CLK_SOFT_RESET;
typedef enum FMT0_SOFT_RESET {
	FMT0_SOFT_RESET_0                                = 0x0,
	FMT0_SOFT_RESET_1                                = 0x1,
} FMT0_SOFT_RESET;
typedef enum FMT1_SOFT_RESET {
	FMT1_SOFT_RESET_0                                = 0x0,
	FMT1_SOFT_RESET_1                                = 0x1,
} FMT1_SOFT_RESET;
typedef enum FMT2_SOFT_RESET {
	FMT2_SOFT_RESET_0                                = 0x0,
	FMT2_SOFT_RESET_1                                = 0x1,
} FMT2_SOFT_RESET;
typedef enum FMT3_SOFT_RESET {
	FMT3_SOFT_RESET_0                                = 0x0,
	FMT3_SOFT_RESET_1                                = 0x1,
} FMT3_SOFT_RESET;
typedef enum FMT4_SOFT_RESET {
	FMT4_SOFT_RESET_0                                = 0x0,
	FMT4_SOFT_RESET_1                                = 0x1,
} FMT4_SOFT_RESET;
typedef enum FMT5_SOFT_RESET {
	FMT5_SOFT_RESET_0                                = 0x0,
	FMT5_SOFT_RESET_1                                = 0x1,
} FMT5_SOFT_RESET;
typedef enum MVP_SOFT_RESET {
	MVP_SOFT_RESET_0                                 = 0x0,
	MVP_SOFT_RESET_1                                 = 0x1,
} MVP_SOFT_RESET;
typedef enum ABM_SOFT_RESET {
	ABM_SOFT_RESET_0                                 = 0x0,
	ABM_SOFT_RESET_1                                 = 0x1,
} ABM_SOFT_RESET;
typedef enum DVO_SOFT_RESET {
	DVO_SOFT_RESET_0                                 = 0x0,
	DVO_SOFT_RESET_1                                 = 0x1,
} DVO_SOFT_RESET;
typedef enum DIGA_FE_SOFT_RESET {
	DIGA_FE_SOFT_RESET_0                             = 0x0,
	DIGA_FE_SOFT_RESET_1                             = 0x1,
} DIGA_FE_SOFT_RESET;
typedef enum DIGA_BE_SOFT_RESET {
	DIGA_BE_SOFT_RESET_0                             = 0x0,
	DIGA_BE_SOFT_RESET_1                             = 0x1,
} DIGA_BE_SOFT_RESET;
typedef enum DIGB_FE_SOFT_RESET {
	DIGB_FE_SOFT_RESET_0                             = 0x0,
	DIGB_FE_SOFT_RESET_1                             = 0x1,
} DIGB_FE_SOFT_RESET;
typedef enum DIGB_BE_SOFT_RESET {
	DIGB_BE_SOFT_RESET_0                             = 0x0,
	DIGB_BE_SOFT_RESET_1                             = 0x1,
} DIGB_BE_SOFT_RESET;
typedef enum DIGC_FE_SOFT_RESET {
	DIGC_FE_SOFT_RESET_0                             = 0x0,
	DIGC_FE_SOFT_RESET_1                             = 0x1,
} DIGC_FE_SOFT_RESET;
typedef enum DIGC_BE_SOFT_RESET {
	DIGC_BE_SOFT_RESET_0                             = 0x0,
	DIGC_BE_SOFT_RESET_1                             = 0x1,
} DIGC_BE_SOFT_RESET;
typedef enum DIGD_FE_SOFT_RESET {
	DIGD_FE_SOFT_RESET_0                             = 0x0,
	DIGD_FE_SOFT_RESET_1                             = 0x1,
} DIGD_FE_SOFT_RESET;
typedef enum DIGD_BE_SOFT_RESET {
	DIGD_BE_SOFT_RESET_0                             = 0x0,
	DIGD_BE_SOFT_RESET_1                             = 0x1,
} DIGD_BE_SOFT_RESET;
typedef enum DIGE_FE_SOFT_RESET {
	DIGE_FE_SOFT_RESET_0                             = 0x0,
	DIGE_FE_SOFT_RESET_1                             = 0x1,
} DIGE_FE_SOFT_RESET;
typedef enum DIGE_BE_SOFT_RESET {
	DIGE_BE_SOFT_RESET_0                             = 0x0,
	DIGE_BE_SOFT_RESET_1                             = 0x1,
} DIGE_BE_SOFT_RESET;
typedef enum DIGF_FE_SOFT_RESET {
	DIGF_FE_SOFT_RESET_0                             = 0x0,
	DIGF_FE_SOFT_RESET_1                             = 0x1,
} DIGF_FE_SOFT_RESET;
typedef enum DIGF_BE_SOFT_RESET {
	DIGF_BE_SOFT_RESET_0                             = 0x0,
	DIGF_BE_SOFT_RESET_1                             = 0x1,
} DIGF_BE_SOFT_RESET;
typedef enum DIGG_FE_SOFT_RESET {
	DIGG_FE_SOFT_RESET_0                             = 0x0,
	DIGG_FE_SOFT_RESET_1                             = 0x1,
} DIGG_FE_SOFT_RESET;
typedef enum DIGG_BE_SOFT_RESET {
	DIGG_BE_SOFT_RESET_0                             = 0x0,
	DIGG_BE_SOFT_RESET_1                             = 0x1,
} DIGG_BE_SOFT_RESET;
typedef enum DPDBG_SOFT_RESET {
	DPDBG_SOFT_RESET_0                               = 0x0,
	DPDBG_SOFT_RESET_1                               = 0x1,
} DPDBG_SOFT_RESET;
typedef enum DIGLPA_FE_SOFT_RESET {
	DIGLPA_FE_SOFT_RESET_0                           = 0x0,
	DIGLPA_FE_SOFT_RESET_1                           = 0x1,
} DIGLPA_FE_SOFT_RESET;
typedef enum DIGLPA_BE_SOFT_RESET {
	DIGLPA_BE_SOFT_RESET_0                           = 0x0,
	DIGLPA_BE_SOFT_RESET_1                           = 0x1,
} DIGLPA_BE_SOFT_RESET;
typedef enum DIGLPB_FE_SOFT_RESET {
	DIGLPB_FE_SOFT_RESET_0                           = 0x0,
	DIGLPB_FE_SOFT_RESET_1                           = 0x1,
} DIGLPB_FE_SOFT_RESET;
typedef enum DIGLPB_BE_SOFT_RESET {
	DIGLPB_BE_SOFT_RESET_0                           = 0x0,
	DIGLPB_BE_SOFT_RESET_1                           = 0x1,
} DIGLPB_BE_SOFT_RESET;
typedef enum GENERICA_STEREOSYNC_SEL {
	GENERICA_STEREOSYNC_SEL_D1                       = 0x0,
	GENERICA_STEREOSYNC_SEL_D2                       = 0x1,
	GENERICA_STEREOSYNC_SEL_D3                       = 0x2,
	GENERICA_STEREOSYNC_SEL_D4                       = 0x3,
	GENERICA_STEREOSYNC_SEL_D5                       = 0x4,
	GENERICA_STEREOSYNC_SEL_D6                       = 0x5,
	GENERICA_STEREOSYNC_SEL_RESERVED                 = 0x6,
} GENERICA_STEREOSYNC_SEL;
typedef enum GENERICB_STEREOSYNC_SEL {
	GENERICB_STEREOSYNC_SEL_D1                       = 0x0,
	GENERICB_STEREOSYNC_SEL_D2                       = 0x1,
	GENERICB_STEREOSYNC_SEL_D3                       = 0x2,
	GENERICB_STEREOSYNC_SEL_D4                       = 0x3,
	GENERICB_STEREOSYNC_SEL_D5                       = 0x4,
	GENERICB_STEREOSYNC_SEL_D6                       = 0x5,
	GENERICB_STEREOSYNC_SEL_RESERVED                 = 0x6,
} GENERICB_STEREOSYNC_SEL;
typedef enum DCO_DBG_BLOCK_SEL {
	DCO_DBG_BLOCK_SEL_DCO                            = 0x0,
	DCO_DBG_BLOCK_SEL_ABM                            = 0x1,
	DCO_DBG_BLOCK_SEL_DVO                            = 0x2,
	DCO_DBG_BLOCK_SEL_DAC                            = 0x3,
	DCO_DBG_BLOCK_SEL_MVP                            = 0x4,
	DCO_DBG_BLOCK_SEL_FMT0                           = 0x5,
	DCO_DBG_BLOCK_SEL_FMT1                           = 0x6,
	DCO_DBG_BLOCK_SEL_FMT2                           = 0x7,
	DCO_DBG_BLOCK_SEL_FMT3                           = 0x8,
	DCO_DBG_BLOCK_SEL_FMT4                           = 0x9,
	DCO_DBG_BLOCK_SEL_FMT5                           = 0xa,
	DCO_DBG_BLOCK_SEL_DIGFE_A                        = 0xb,
	DCO_DBG_BLOCK_SEL_DIGFE_B                        = 0xc,
	DCO_DBG_BLOCK_SEL_DIGFE_C                        = 0xd,
	DCO_DBG_BLOCK_SEL_DIGFE_D                        = 0xe,
	DCO_DBG_BLOCK_SEL_DIGFE_E                        = 0xf,
	DCO_DBG_BLOCK_SEL_DIGFE_F                        = 0x10,
	DCO_DBG_BLOCK_SEL_DIGFE_G                        = 0x11,
	DCO_DBG_BLOCK_SEL_DIGA                           = 0x12,
	DCO_DBG_BLOCK_SEL_DIGB                           = 0x13,
	DCO_DBG_BLOCK_SEL_DIGC                           = 0x14,
	DCO_DBG_BLOCK_SEL_DIGD                           = 0x15,
	DCO_DBG_BLOCK_SEL_DIGE                           = 0x16,
	DCO_DBG_BLOCK_SEL_DIGF                           = 0x17,
	DCO_DBG_BLOCK_SEL_DIGG                           = 0x18,
	DCO_DBG_BLOCK_SEL_DPFE_A                         = 0x19,
	DCO_DBG_BLOCK_SEL_DPFE_B                         = 0x1a,
	DCO_DBG_BLOCK_SEL_DPFE_C                         = 0x1b,
	DCO_DBG_BLOCK_SEL_DPFE_D                         = 0x1c,
	DCO_DBG_BLOCK_SEL_DPFE_E                         = 0x1d,
	DCO_DBG_BLOCK_SEL_DPFE_F                         = 0x1e,
	DCO_DBG_BLOCK_SEL_DPFE_G                         = 0x1f,
	DCO_DBG_BLOCK_SEL_DPA                            = 0x20,
	DCO_DBG_BLOCK_SEL_DPB                            = 0x21,
	DCO_DBG_BLOCK_SEL_DPC                            = 0x22,
	DCO_DBG_BLOCK_SEL_DPD                            = 0x23,
	DCO_DBG_BLOCK_SEL_DPE                            = 0x24,
	DCO_DBG_BLOCK_SEL_DPF                            = 0x25,
	DCO_DBG_BLOCK_SEL_DPG                            = 0x26,
	DCO_DBG_BLOCK_SEL_AUX0                           = 0x27,
	DCO_DBG_BLOCK_SEL_AUX1                           = 0x28,
	DCO_DBG_BLOCK_SEL_AUX2                           = 0x29,
	DCO_DBG_BLOCK_SEL_AUX3                           = 0x2a,
	DCO_DBG_BLOCK_SEL_AUX4                           = 0x2b,
	DCO_DBG_BLOCK_SEL_AUX5                           = 0x2c,
	DCO_DBG_BLOCK_SEL_PERFMON_DCO                    = 0x2d,
	DCO_DBG_BLOCK_SEL_AUDIO_OUT                      = 0x2e,
	DCO_DBG_BLOCK_SEL_DIGLPFEA                       = 0x2f,
	DCO_DBG_BLOCK_SEL_DIGLPFEB                       = 0x30,
	DCO_DBG_BLOCK_SEL_DIGLPA                         = 0x31,
	DCO_DBG_BLOCK_SEL_DIGLPB                         = 0x32,
	DCO_DBG_BLOCK_SEL_DPLPFEA                        = 0x33,
	DCO_DBG_BLOCK_SEL_DPLPFEB                        = 0x34,
	DCO_DBG_BLOCK_SEL_DPLPA                          = 0x35,
	DCO_DBG_BLOCK_SEL_DPLPB                          = 0x36,
} DCO_DBG_BLOCK_SEL;
typedef enum DCO_DBG_CLOCK_SEL {
	DCO_DBG_CLOCK_SEL_DISPCLK                        = 0x0,
	DCO_DBG_CLOCK_SEL_SCLK                           = 0x1,
	DCO_DBG_CLOCK_SEL_MVPCLK                         = 0x2,
	DCO_DBG_CLOCK_SEL_DVOCLK                         = 0x3,
	DCO_DBG_CLOCK_SEL_DACCLK                         = 0x4,
	DCO_DBG_CLOCK_SEL_REFCLK                         = 0x5,
	DCO_DBG_CLOCK_SEL_SYMCLKA                        = 0x6,
	DCO_DBG_CLOCK_SEL_SYMCLKB                        = 0x7,
	DCO_DBG_CLOCK_SEL_SYMCLKC                        = 0x8,
	DCO_DBG_CLOCK_SEL_SYMCLKD                        = 0x9,
	DCO_DBG_CLOCK_SEL_SYMCLKE                        = 0xa,
	DCO_DBG_CLOCK_SEL_SYMCLKF                        = 0xb,
	DCO_DBG_CLOCK_SEL_SYMCLKG                        = 0xc,
	DCO_DBG_CLOCK_SEL_RESERVED                       = 0xd,
	DCO_DBG_CLOCK_SEL_AM0CLK                         = 0xe,
	DCO_DBG_CLOCK_SEL_AM1CLK                         = 0xf,
	DCO_DBG_CLOCK_SEL_AM2CLK                         = 0x10,
	DCO_DBG_CLOCK_SEL_SYMCLKLPA                      = 0x11,
	DCO_DBG_CLOCK_SEL_SYMCLKLPB                      = 0x12,
} DCO_DBG_CLOCK_SEL;
typedef enum DCO_HDMI_RXSTATUS_TIMER_CONTROL_DCO_HDMI_RXSTATUS_TIMER_TYPE {
	DCO_HDMI_RXSTATUS_TIMER_TYPE_LEVEL               = 0x0,
	DCO_HDMI_RXSTATUS_TIMER_TYPE_PULSE               = 0x1,
} DCO_HDMI_RXSTATUS_TIMER_CONTROL_DCO_HDMI_RXSTATUS_TIMER_TYPE;
typedef enum FMT420_MEMORY_SOURCE_SEL {
	FMT420_MEMORY_SOURCE_SEL_FMT0                    = 0x0,
	FMT420_MEMORY_SOURCE_SEL_FMT1                    = 0x1,
	FMT420_MEMORY_SOURCE_SEL_FMT2                    = 0x2,
	FMT420_MEMORY_SOURCE_SEL_FMT3                    = 0x3,
	FMT420_MEMORY_SOURCE_SEL_FMT4                    = 0x4,
	FMT420_MEMORY_SOURCE_SEL_FMT5                    = 0x5,
	FMT420_MEMORY_SOURCE_SEL_FMT_RESERVED            = 0x6,
} FMT420_MEMORY_SOURCE_SEL;
typedef enum DOUT_I2C_CONTROL_GO {
	DOUT_I2C_CONTROL_STOP_TRANSFER                   = 0x0,
	DOUT_I2C_CONTROL_START_TRANSFER                  = 0x1,
} DOUT_I2C_CONTROL_GO;
typedef enum DOUT_I2C_CONTROL_SOFT_RESET {
	DOUT_I2C_CONTROL_NOT_RESET_I2C_CONTROLLER        = 0x0,
	DOUT_I2C_CONTROL_RESET_I2C_CONTROLLER            = 0x1,
} DOUT_I2C_CONTROL_SOFT_RESET;
typedef enum DOUT_I2C_CONTROL_SEND_RESET {
	DOUT_I2C_CONTROL__NOT_SEND_RESET                 = 0x0,
	DOUT_I2C_CONTROL__SEND_RESET                     = 0x1,
} DOUT_I2C_CONTROL_SEND_RESET;
typedef enum DOUT_I2C_CONTROL_SW_STATUS_RESET {
	DOUT_I2C_CONTROL_NOT_RESET_SW_STATUS             = 0x0,
	DOUT_I2C_CONTROL_RESET_SW_STATUS                 = 0x1,
} DOUT_I2C_CONTROL_SW_STATUS_RESET;
typedef enum DOUT_I2C_CONTROL_DDC_SELECT {
	DOUT_I2C_CONTROL_SELECT_DDC1                     = 0x0,
	DOUT_I2C_CONTROL_SELECT_DDC2                     = 0x1,
	DOUT_I2C_CONTROL_SELECT_DDC3                     = 0x2,
	DOUT_I2C_CONTROL_SELECT_DDC4                     = 0x3,
	DOUT_I2C_CONTROL_SELECT_DDC5                     = 0x4,
	DOUT_I2C_CONTROL_SELECT_DDC6                     = 0x5,
	DOUT_I2C_CONTROL_SELECT_DDCVGA                   = 0x6,
} DOUT_I2C_CONTROL_DDC_SELECT;
typedef enum DOUT_I2C_CONTROL_TRANSACTION_COUNT {
	DOUT_I2C_CONTROL_TRANS0                          = 0x0,
	DOUT_I2C_CONTROL_TRANS0_TRANS1                   = 0x1,
	DOUT_I2C_CONTROL_TRANS0_TRANS1_TRANS2            = 0x2,
	DOUT_I2C_CONTROL_TRANS0_TRANS1_TRANS2_TRANS3     = 0x3,
} DOUT_I2C_CONTROL_TRANSACTION_COUNT;
typedef enum DOUT_I2C_CONTROL_DBG_REF_SEL {
	DOUT_I2C_CONTROL_NORMAL_DEBUG                    = 0x0,
	DOUT_I2C_CONTROL_FAST_REFERENCE_DEBUG            = 0x1,
} DOUT_I2C_CONTROL_DBG_REF_SEL;
typedef enum DOUT_I2C_ARBITRATION_SW_PRIORITY {
	DOUT_I2C_ARBITRATION_SW_PRIORITY_NORMAL          = 0x0,
	DOUT_I2C_ARBITRATION_SW_PRIORITY_HIGH            = 0x1,
	DOUT_I2C_ARBITRATION_SW_PRIORITY_0_RESERVED      = 0x2,
	DOUT_I2C_ARBITRATION_SW_PRIORITY_1_RESERVED      = 0x3,
} DOUT_I2C_ARBITRATION_SW_PRIORITY;
typedef enum DOUT_I2C_ARBITRATION_NO_QUEUED_SW_GO {
	DOUT_I2C_ARBITRATION_SW_QUEUE_ENABLED            = 0x0,
	DOUT_I2C_ARBITRATION_SW_QUEUE_DISABLED           = 0x1,
} DOUT_I2C_ARBITRATION_NO_QUEUED_SW_GO;
typedef enum DOUT_I2C_ARBITRATION_ABORT_XFER {
	DOUT_I2C_ARBITRATION_NOT_ABORT_CURRENT_TRANSFER  = 0x0,
	DOUT_I2C_ARBITRATION_ABORT_CURRENT_TRANSFER      = 0x1,
} DOUT_I2C_ARBITRATION_ABORT_XFER;
typedef enum DOUT_I2C_ARBITRATION_USE_I2C_REG_REQ {
	DOUT_I2C_ARBITRATION__NOT_USE_I2C_REG_REQ        = 0x0,
	DOUT_I2C_ARBITRATION__USE_I2C_REG_REQ            = 0x1,
} DOUT_I2C_ARBITRATION_USE_I2C_REG_REQ;
typedef enum DOUT_I2C_ARBITRATION_DONE_USING_I2C_REG {
	DOUT_I2C_ARBITRATION_DONE__NOT_USING_I2C_REG     = 0x0,
	DOUT_I2C_ARBITRATION_DONE__USING_I2C_REG         = 0x1,
} DOUT_I2C_ARBITRATION_DONE_USING_I2C_REG;
typedef enum DOUT_I2C_ACK {
	DOUT_I2C_NO_ACK                                  = 0x0,
	DOUT_I2C_ACK_TO_CLEAN                            = 0x1,
} DOUT_I2C_ACK;
typedef enum DOUT_I2C_DDC_SPEED_THRESHOLD {
	DOUT_I2C_DDC_SPEED_THRESHOLD_BIG_THAN_ZERO       = 0x0,
	DOUT_I2C_DDC_SPEED_THRESHOLD_QUATER_OF_TOTAL_SAMPLE= 0x1,
	DOUT_I2C_DDC_SPEED_THRESHOLD_HALF_OF_TOTAL_SAMPLE= 0x2,
	DOUT_I2C_DDC_SPEED_THRESHOLD_THREE_QUATERS_OF_TOTAL_SAMPLE= 0x3,
} DOUT_I2C_DDC_SPEED_THRESHOLD;
typedef enum DOUT_I2C_DDC_SETUP_DATA_DRIVE_EN {
	DOUT_I2C_DDC_SETUP_DATA_DRIVE_BY_EXTERNAL_RESISTOR= 0x0,
	DOUT_I2C_DDC_SETUP_I2C_PAD_DRIVE_SDA             = 0x1,
} DOUT_I2C_DDC_SETUP_DATA_DRIVE_EN;
typedef enum DOUT_I2C_DDC_SETUP_DATA_DRIVE_SEL {
	DOUT_I2C_DDC_SETUP_DATA_DRIVE_FOR_10MCLKS        = 0x0,
	DOUT_I2C_DDC_SETUP_DATA_DRIVE_FOR_20MCLKS        = 0x1,
} DOUT_I2C_DDC_SETUP_DATA_DRIVE_SEL;
typedef enum DOUT_I2C_DDC_SETUP_EDID_DETECT_MODE {
	DOUT_I2C_DDC_SETUP_EDID_DETECT_CONNECT           = 0x0,
	DOUT_I2C_DDC_SETUP_EDID_DETECT_DISCONNECT        = 0x1,
} DOUT_I2C_DDC_SETUP_EDID_DETECT_MODE;
typedef enum DOUT_I2C_DDC_SETUP_CLK_DRIVE_EN {
	DOUT_I2C_DDC_SETUP_CLK_DRIVE_BY_EXTERNAL_RESISTOR= 0x0,
	DOUT_I2C_DDC_SETUP_I2C_PAD_DRIVE_SCL             = 0x1,
} DOUT_I2C_DDC_SETUP_CLK_DRIVE_EN;
typedef enum DOUT_I2C_TRANSACTION_STOP_ON_NACK {
	DOUT_I2C_TRANSACTION_STOP_CURRENT_TRANS          = 0x0,
	DOUT_I2C_TRANSACTION_STOP_ALL_TRANS              = 0x1,
} DOUT_I2C_TRANSACTION_STOP_ON_NACK;
typedef enum DOUT_I2C_DATA_INDEX_WRITE {
	DOUT_I2C_DATA__NOT_INDEX_WRITE                   = 0x0,
	DOUT_I2C_DATA__INDEX_WRITE                       = 0x1,
} DOUT_I2C_DATA_INDEX_WRITE;
typedef enum DOUT_I2C_EDID_DETECT_CTRL_SEND_RESET {
	DOUT_I2C_EDID_NOT_SEND_RESET_BEFORE_EDID_READ_TRACTION= 0x0,
	DOUT_I2C_EDID_SEND_RESET_BEFORE_EDID_READ_TRACTION= 0x1,
} DOUT_I2C_EDID_DETECT_CTRL_SEND_RESET;
typedef enum DOUT_I2C_READ_REQUEST_INTERRUPT_TYPE {
	DOUT_I2C_READ_REQUEST_INTERRUPT_TYPE__LEVEL      = 0x0,
	DOUT_I2C_READ_REQUEST_INTERRUPT_TYPE__PULSE      = 0x1,
} DOUT_I2C_READ_REQUEST_INTERRUPT_TYPE;
typedef enum BLNDV_CONTROL_BLND_MODE {
	BLNDV_CONTROL_BLND_MODE_CURRENT_PIPE_ONLY        = 0x0,
	BLNDV_CONTROL_BLND_MODE_OTHER_PIPE_ONLY          = 0x1,
	BLNDV_CONTROL_BLND_MODE_ALPHA_BLENDING_MODE      = 0x2,
	BLNDV_CONTROL_BLND_MODE_OTHER_STEREO_TYPE        = 0x3,
} BLNDV_CONTROL_BLND_MODE;
typedef enum BLNDV_CONTROL_BLND_STEREO_TYPE {
	BLNDV_CONTROL_BLND_STEREO_TYPE_NON_SINGLE_PIPE_STEREO= 0x0,
	BLNDV_CONTROL_BLND_STEREO_TYPE_SIDE_BY_SIDE_SINGLE_PIPE_STEREO= 0x1,
	BLNDV_CONTROL_BLND_STEREO_TYPE_TOP_BOTTOM_SINGLE_PIPE_STEREO= 0x2,
	BLNDV_CONTROL_BLND_STEREO_TYPE_UNUSED            = 0x3,
} BLNDV_CONTROL_BLND_STEREO_TYPE;
typedef enum BLNDV_CONTROL_BLND_STEREO_POLARITY {
	BLNDV_CONTROL_BLND_STEREO_POLARITY_LOW           = 0x0,
	BLNDV_CONTROL_BLND_STEREO_POLARITY_HIGH          = 0x1,
} BLNDV_CONTROL_BLND_STEREO_POLARITY;
typedef enum BLNDV_CONTROL_BLND_FEEDTHROUGH_EN {
	BLNDV_CONTROL_BLND_FEEDTHROUGH_EN_FALSE          = 0x0,
	BLNDV_CONTROL_BLND_FEEDTHROUGH_EN_TRUE           = 0x1,
} BLNDV_CONTROL_BLND_FEEDTHROUGH_EN;
typedef enum BLNDV_CONTROL_BLND_ALPHA_MODE {
	BLNDV_CONTROL_BLND_ALPHA_MODE_CURRENT_PIXEL_ALPHA= 0x0,
	BLNDV_CONTROL_BLND_ALPHA_MODE_PIXEL_ALPHA_COMBINED_GLOBAL_GAIN= 0x1,
	BLNDV_CONTROL_BLND_ALPHA_MODE_GLOBAL_ALPHA_ONLY  = 0x2,
	BLNDV_CONTROL_BLND_ALPHA_MODE_UNUSED             = 0x3,
} BLNDV_CONTROL_BLND_ALPHA_MODE;
typedef enum BLNDV_CONTROL_BLND_ACTIVE_OVERLAP_ONLY {
	BLNDV_CONTROL_BLND_ACTIVE_OVERLAP_ONLY_FALSE     = 0x0,
	BLNDV_CONTROL_BLND_ACTIVE_OVERLAP_ONLY_TRUE      = 0x1,
} BLNDV_CONTROL_BLND_ACTIVE_OVERLAP_ONLY;
typedef enum BLNDV_CONTROL_BLND_MULTIPLIED_MODE {
	BLNDV_CONTROL_BLND_MULTIPLIED_MODE_FALSE         = 0x0,
	BLNDV_CONTROL_BLND_MULTIPLIED_MODE_TRUE          = 0x1,
} BLNDV_CONTROL_BLND_MULTIPLIED_MODE;
typedef enum BLNDV_SM_CONTROL2_SM_MODE {
	BLNDV_SM_CONTROL2_SM_MODE_SINGLE_PLANE           = 0x0,
	BLNDV_SM_CONTROL2_SM_MODE_ROW_SUBSAMPLING        = 0x2,
	BLNDV_SM_CONTROL2_SM_MODE_COLUMN_SUBSAMPLING     = 0x4,
	BLNDV_SM_CONTROL2_SM_MODE_CHECKERBOARD_SUBSAMPLING= 0x6,
} BLNDV_SM_CONTROL2_SM_MODE;
typedef enum BLNDV_SM_CONTROL2_SM_FRAME_ALTERNATE {
	BLNDV_SM_CONTROL2_SM_FRAME_ALTERNATE_FALSE       = 0x0,
	BLNDV_SM_CONTROL2_SM_FRAME_ALTERNATE_TRUE        = 0x1,
} BLNDV_SM_CONTROL2_SM_FRAME_ALTERNATE;
typedef enum BLNDV_SM_CONTROL2_SM_FIELD_ALTERNATE {
	BLNDV_SM_CONTROL2_SM_FIELD_ALTERNATE_FALSE       = 0x0,
	BLNDV_SM_CONTROL2_SM_FIELD_ALTERNATE_TRUE        = 0x1,
} BLNDV_SM_CONTROL2_SM_FIELD_ALTERNATE;
typedef enum BLNDV_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL {
	BLNDV_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL_NO_FORCE= 0x0,
	BLNDV_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL_RESERVED= 0x1,
	BLNDV_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL_FORCE_LOW= 0x2,
	BLNDV_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL_FORCE_HIGH= 0x3,
} BLNDV_SM_CONTROL2_SM_FORCE_NEXT_FRAME_POL;
typedef enum BLNDV_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL {
	BLNDV_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL_NO_FORCE = 0x0,
	BLNDV_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL_RESERVED = 0x1,
	BLNDV_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL_FORCE_LOW= 0x2,
	BLNDV_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL_FORCE_HIGH= 0x3,
} BLNDV_SM_CONTROL2_SM_FORCE_NEXT_TOP_POL;
typedef enum BLNDV_CONTROL2_PTI_ENABLE {
	BLNDV_CONTROL2_PTI_ENABLE_FALSE                  = 0x0,
	BLNDV_CONTROL2_PTI_ENABLE_TRUE                   = 0x1,
} BLNDV_CONTROL2_PTI_ENABLE;
typedef enum BLNDV_CONTROL2_BLND_SUPERAA_DEGAMMA_EN {
	BLNDV_CONTROL2_BLND_SUPERAA_DEGAMMA_EN_FALSE     = 0x0,
	BLNDV_CONTROL2_BLND_SUPERAA_DEGAMMA_EN_TRUE      = 0x1,
} BLNDV_CONTROL2_BLND_SUPERAA_DEGAMMA_EN;
typedef enum BLNDV_CONTROL2_BLND_SUPERAA_REGAMMA_EN {
	BLNDV_CONTROL2_BLND_SUPERAA_REGAMMA_EN_FALSE     = 0x0,
	BLNDV_CONTROL2_BLND_SUPERAA_REGAMMA_EN_TRUE      = 0x1,
} BLNDV_CONTROL2_BLND_SUPERAA_REGAMMA_EN;
typedef enum BLNDV_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_ACK {
	BLNDV_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_ACK_FALSE= 0x0,
	BLNDV_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_ACK_TRUE= 0x1,
} BLNDV_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_ACK;
typedef enum BLNDV_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_MASK {
	BLNDV_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_MASK_FALSE= 0x0,
	BLNDV_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_MASK_TRUE= 0x1,
} BLNDV_UNDERFLOW_INTERRUPT_BLND_UNDERFLOW_INT_MASK;
typedef enum BLNDV_V_UPDATE_LOCK_BLND_DCP_GRPH_V_UPDATE_LOCK {
	BLNDV_V_UPDATE_LOCK_BLND_DCP_GRPH_V_UPDATE_LOCK_FALSE= 0x0,
	BLNDV_V_UPDATE_LOCK_BLND_DCP_GRPH_V_UPDATE_LOCK_TRUE= 0x1,
} BLNDV_V_UPDATE_LOCK_BLND_DCP_GRPH_V_UPDATE_LOCK;
typedef enum BLNDV_V_UPDATE_LOCK_BLND_DCP_GRPH_SURF_V_UPDATE_LOCK {
	BLNDV_V_UPDATE_LOCK_BLND_DCP_GRPH_SURF_V_UPDATE_LOCK_FALSE= 0x0,
	BLNDV_V_UPDATE_LOCK_BLND_DCP_GRPH_SURF_V_UPDATE_LOCK_TRUE= 0x1,
} BLNDV_V_UPDATE_LOCK_BLND_DCP_GRPH_SURF_V_UPDATE_LOCK;
typedef enum BLNDV_V_UPDATE_LOCK_BLND_DCP_CUR_V_UPDATE_LOCK {
	BLNDV_V_UPDATE_LOCK_BLND_DCP_CUR_V_UPDATE_LOCK_FALSE= 0x0,
	BLNDV_V_UPDATE_LOCK_BLND_DCP_CUR_V_UPDATE_LOCK_TRUE= 0x1,
} BLNDV_V_UPDATE_LOCK_BLND_DCP_CUR_V_UPDATE_LOCK;
typedef enum BLNDV_V_UPDATE_LOCK_BLND_DCP_CUR2_V_UPDATE_LOCK {
	BLNDV_V_UPDATE_LOCK_BLND_DCP_CUR2_V_UPDATE_LOCK_FALSE= 0x0,
	BLNDV_V_UPDATE_LOCK_BLND_DCP_CUR2_V_UPDATE_LOCK_TRUE= 0x1,
} BLNDV_V_UPDATE_LOCK_BLND_DCP_CUR2_V_UPDATE_LOCK;
typedef enum BLNDV_V_UPDATE_LOCK_BLND_SCL_V_UPDATE_LOCK {
	BLNDV_V_UPDATE_LOCK_BLND_SCL_V_UPDATE_LOCK_FALSE = 0x0,
	BLNDV_V_UPDATE_LOCK_BLND_SCL_V_UPDATE_LOCK_TRUE  = 0x1,
} BLNDV_V_UPDATE_LOCK_BLND_SCL_V_UPDATE_LOCK;
typedef enum BLNDV_V_UPDATE_LOCK_BLND_BLND_V_UPDATE_LOCK {
	BLNDV_V_UPDATE_LOCK_BLND_BLND_V_UPDATE_LOCK_FALSE= 0x0,
	BLNDV_V_UPDATE_LOCK_BLND_BLND_V_UPDATE_LOCK_TRUE = 0x1,
} BLNDV_V_UPDATE_LOCK_BLND_BLND_V_UPDATE_LOCK;
typedef enum BLNDV_V_UPDATE_LOCK_BLND_V_UPDATE_LOCK_MODE {
	BLNDV_V_UPDATE_LOCK_BLND_V_UPDATE_LOCK_MODE_FALSE= 0x0,
	BLNDV_V_UPDATE_LOCK_BLND_V_UPDATE_LOCK_MODE_TRUE = 0x1,
} BLNDV_V_UPDATE_LOCK_BLND_V_UPDATE_LOCK_MODE;
typedef enum BLNDV_DEBUG_BLND_CNV_MUX_SELECT {
	BLNDV_DEBUG_BLND_CNV_MUX_SELECT_LOW              = 0x0,
	BLNDV_DEBUG_BLND_CNV_MUX_SELECT_HIGH             = 0x1,
} BLNDV_DEBUG_BLND_CNV_MUX_SELECT;
typedef enum BLNDV_TEST_DEBUG_INDEX_BLND_TEST_DEBUG_WRITE_EN {
	BLNDV_TEST_DEBUG_INDEX_BLND_TEST_DEBUG_WRITE_EN_FALSE= 0x0,
	BLNDV_TEST_DEBUG_INDEX_BLND_TEST_DEBUG_WRITE_EN_TRUE= 0x1,
} BLNDV_TEST_DEBUG_INDEX_BLND_TEST_DEBUG_WRITE_EN;
typedef enum DPCSTX_DBG_CFGCLK_SEL {
	DPCSTX_DBG_CFGCLK_SEL_DC_DPCS_INF                = 0x0,
	DPCSTX_DBG_CFGCLK_SEL_DPCS_BPHY_INF              = 0x1,
	DPCSTX_DBG_CFGCLK_SEL_CBUS_SLAVE                 = 0x2,
	DPCSTX_DBG_CFGCLK_SEL_CBUS_MASTER                = 0x3,
} DPCSTX_DBG_CFGCLK_SEL;
typedef enum DPCSTX_TX_SYMCLK_SEL {
	DPCSTX_DBG_TX_SYMCLK_SEL_IN0                     = 0x0,
	DPCSTX_DBG_TX_SYMCLK_SEL_IN1                     = 0x1,
	DPCSTX_DBG_TX_SYMCLK_SEL_FIFO_WR                 = 0x2,
} DPCSTX_TX_SYMCLK_SEL;
typedef enum DPCSTX_TX_SYMCLK_DIV2_SEL {
	DPCSTX_DBG_TX_SYMCLK_DIV2_SEL_OUT0               = 0x0,
	DPCSTX_DBG_TX_SYMCLK_DIV2_SEL_OUT1               = 0x1,
	DPCSTX_DBG_TX_SYMCLK_DIV2_SEL_OUT2               = 0x2,
	DPCSTX_DBG_TX_SYMCLK_DIV2_SEL_OUT3               = 0x3,
	DPCSTX_DBG_TX_SYMCLK_DIV2_SEL_FIFO_RD            = 0x4,
	DPCSTX_DBG_TX_SYMCLK_DIV2_SEL_INT                = 0x5,
} DPCSTX_TX_SYMCLK_DIV2_SEL;
typedef enum DPCSTX_DBG_CLOCK_SEL {
	DPCSTX_DBG_CLOCK_SEL_DC_CFGCLK                   = 0x0,
	DPCSTX_DBG_CLOCK_SEL_PHY_CFGCLK                  = 0x1,
	DPCSTX_DBG_CLOCK_SEL_TXSYMCLK                    = 0x2,
} DPCSTX_DBG_CLOCK_SEL;
typedef enum DPCSTX_DVI_LINK_MODE {
	DPCSTX_DVI_LINK_MODE_NORMAL                      = 0x0,
	DPCSTX_DVI_LINK_MODE_DUAL_LINK_MASTER            = 0x1,
	DPCSTX_DVI_LINK_MODE_DUAL_LINK_SLAVER            = 0x2,
} DPCSTX_DVI_LINK_MODE;

#endif /* DCE_11_2_ENUM_H */
