% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_perform_request}
\alias{whapi_perform_request}
\title{Perform an HTTP request to Whapi.Cloud}
\usage{
whapi_perform_request(
  endpoint,
  payload = NULL,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE,
  method = c("POST", "GET", "PUT")
)
}
\arguments{
\item{endpoint}{Character(1). Endpoint path (e.g. \code{"messages/text"}).
Full URL is constructed as \code{"https://gate.whapi.cloud/{endpoint}"}.}

\item{payload}{List. Request body (for POST/PUT) or query (for GET). Default: \code{NULL}.}

\item{token}{Character(1). Bearer token. Defaults to env var \code{WHAPI_TOKEN}.}

\item{timeout}{Numeric. Timeout in seconds. Default \code{30}.}

\item{verbose}{Logical. Print progress via cli? Default \code{TRUE}.}

\item{method}{Character(1). HTTP method (\code{"GET"}, \code{"POST"}, \code{"PUT"}). Default \code{"POST"}.}
}
\value{
Parsed JSON response as a list.
}
\description{
Generic helper wrapping httr2 to call Whapi endpoints.
Supports methods: \code{"GET"}, \code{"POST"}, \code{"PUT"}.
Handles JSON encoding, retries, errors, and CLI logging.
}
