% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{taxonomy}
\alias{taxonomy}
\title{The category taxonomy used by walmart.com to categorize items}
\usage{
taxonomy(key = auth_cache$KEY, list_output = FALSE)
}
\arguments{
\item{key}{Your API access key.}

\item{list_output}{Indicator for list output.}
}
\value{
A tibble with 15 columns in base response format.
}
\description{
This function returns the top level of categories only, for further levels
run function with \code{list_output = FALSE} for nested list.
}
\details{
\code{\link{taxonomy}} gives returns the category taxonomy used by
walmart.com to categorize items.

An API key will be required to run this function and can be acquired by
creating an account on the following website
\url{https://developer.walmartlabs.com/member}.

For more information refer to the original documentation
\url{https://developer.walmartlabs.com/docs/read/Taxonomy_API}.
}
\examples{
\dontrun{
key <- "************************"

taxonomy(key = key)

taxonomy(key = key, list_output = TRUE)
}
}
