% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{lookup}
\alias{lookup}
\title{Looks up product information}
\usage{
lookup(key = auth_cache$KEY, lsPublisherId = NULL, id = NULL,
  upc = NULL, list_output = FALSE)
}
\arguments{
\item{key}{Your API access key.}

\item{lsPublisherId}{Your LinkShare Publisher Id.}

\item{id}{vector of item ids.}

\item{upc}{upc of the item.}

\item{list_output}{Indicator for list output.}
}
\value{
A tibble with 15 columns in base response format.
}
\description{
\code{\link{lookup}} gives access to item price and availability in real-time.
}
\details{
An API key will be required to run this function and can be acquired by
creating an account on the following website
\url{https://developer.walmartlabs.com/member}.

For more information refer to the original documentation
\url{https://developer.walmartlabs.com/docs/read/Home}.

Response formats are described at the url
\url{https://developer.walmartlabs.com/docs/read/Item_Field_Description}.
}
\examples{
\dontrun{
key <- "************************"

## Up to 20 ids can be called at once.
lookup(id = c(12417882:12417937), key = key)

lookup(id = 12417832, key = key)

lookup(upc = 10001137891, key = key)

## First argument will be used with conflicting arguments.
lookup(id = 12417837, upc = 10001137891, key = key)

lookup(id = 12417832, key = key, list_output = TRUE)
}
}
