% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linreg.R
\name{glr}
\alias{glr}
\alias{plr}
\alias{poplr}
\title{Global and pointwise linear regression analyses}
\usage{
glr(g, testSlope = 0)

plr(vf, testSlope = 0)

poplr(vf, testSlope = 0, nperm = factorial(7), trunc = 1)
}
\arguments{
\item{g}{a data.frame with date on the first column and the value of the
global index on the second column}

\item{testSlope}{slope, or slopes, to test as null hypothesis. Default is 0.
if a single value, then the same null hypothesis is used for all locations.
If a vector of values, then (for \code{plr} and \code{poplr}) each
location of the visual field will have a different null hypothesis. The length of
testSlope must be 1 or equal to the number of locations to be used in the PLR or
PoPLR analysis}

\item{vf}{visual fields sensitivity data}

\item{nperm}{number of permutations. If the number of visits is 7 or less, then
\code{nperm = factorial(nrow(vf))}. For series greater than 8 visits, default is
factorial(7). For series up to 7 visits, it is the factorial of the number of visits
(with less than 7 visits, the number of possible permutations is small and results
can be unreliable. For instance, for 5 visits, the number of possible permutations is
only 120.)}

\item{trunc}{truncation value for the Truncated Product Method (see reference)}
}
\value{
\itemize{
  \item{\code{glr} and \code{plr} return a list with the following
    \itemize{
      \item\code{id} patient ID
      \item\code{eye} patient eye
      \item\code{testSlope} slope for \code{glr} or list of slopes for \code{plr}
        to test as null hypotheses
      \item\code{nvisits} number of visits
      \item\code{years} years from baseline. Used for the pointwise linear
        regression analysis
      \item\code{data} data analyzed. For \code{glr}, it is the values of the
        global indes analyzed. For \code{plr}, each column is a location of the
        visual field used for the analysis. Each row is a visit (as many as years)
      \item\code{pred} predicted values. Each column is a location of the visual
        field used for the analysis. Each row is a visit (as many as years)
      \item\code{sl} slopes estimated at each location for pointwise (simple)
        linear regression
      \item\code{int} intercept estimated at each location for pointwise (simple)
        linear regression
      \item\code{tval} t-values obtained for the left-tailed-t-tests for the slopes
        obtained in the pointwise (simple) linear regression at each location
      \item\code{pval} p-values obtained for the left-tailed t-tests for the slopes
        obtained
    }
  }
  \item{\code{poplr} returns a list with the following additional fields
    \itemize{
      \item\code{csl} the modified Fisher's S-statistic for the left-tailed permutation test
      \item\code{cslp} the p-value for the left-tailed permutation test
      \item\code{csr} the modifed Fisher's S-statistic for the right-tailed permutation test
      \item\code{csrp} the p-value for the right-tailed permutation test
      \item\code{pstats} a list with the poinwise slopes (`\code{sl}`), intercepts
        (`\code{int}`), standard errors (`\code{se}`), and p-values (`\code{pval}`) obtained
        for the series at each location analyzed and for all \code{nperm} permutations
        (in `\code{permutations}`)
      \item\code{cstats} a list with all combined stats:
        \itemize{
          \item\code{csl, csr} the combined Fisher S-statistics for the left- and right-tailed
            permutation tests respectively
          \item\code{cslp, csrp} the corresponding p-values for the permutation tests
          \item\code{cslall, csrall} the combined Fisher S-statistics for all permutations
        }
    }
  }
}
}
\description{
Functions that compute global and pointwise linear regression analyses:
\itemize{
  \item\code{glr} performs global linear regression analysis
  \item\code{plr} performs pointwise linear regression (PLR) analysis
  \item\code{poplr} performs PoPLR analysis as in O'Leary et al (see reference)
}
}
\details{
\itemize{
  \item\code{poplr} there is a small difference between this implementation of
    PoPLR and that proposed by O'Leary et al. The combined S statistic in the
    paper used a natural logarithm. Here we not only use a logarithm of base 10
    but we also divide by the number of locations. This way the S statistic has
    a more direct interpretation as the average number of leading zeros in the
    p-values for pointwise (simple) linear regression. That is, if S = 2, then
    the p-values have on average 2 leading zeros, if S = 3, then 3 leading zeros,
    and so on
}
}
\examples{
vf <- vffilter(vfpwgRetest24d2, id == 1) # select one patient
res <- glr(getgl(vf)[,c("date", "tmd")]) # linear regression with mean deviation (MD)
res <- plr(gettd(vf))   # pointwise linear regression (PLR) with TD values
res <- poplr(gettd(vf)) # Permutation of PLR with TD values
}
\references{
N. O'Leary, B. C. Chauhan, and P. H. Artes. \emph{Visual field progression in
glaucoma: estimating the overall significance of deterioration with permutation
analyses of pointwise linear regression (PoPLR)}. Investigative Ophthalmology
and Visual Science, 53, 2012
}
