% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fvYearAnnuityCompMonthly.R
\name{fvYearlyAnnuityCompMonthly}
\alias{fvYearlyAnnuityCompMonthly}
\title{Calculates Future Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Monthly.}
\usage{
fvYearlyAnnuityCompMonthly(r, n, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to four arguments \code{r} , \code{n} , \code{pmt} and \code{bgn}.
}
\description{
Calculates Future Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Monthly.
}
\details{
According to \insertCite{humm;textual}{tvmComp} Annuity is a series of equal payments, made at periodic intervals. The length of time between the successive payments is called the payment interval or payment period. The length of time from the beginning of the first payment interval to the end of the last payment interval is called the term of an annuity. The amount of each of the regular payments is called the periodic payment or periodic rent.
The method \code{fvYearlyAnnuityCompMonthly()}is developed to calculate Future Value of Yearly-Paid Ordinary Annuity or Annuity Due that is Compounded Monthly.The method gives Future Value when values are passed to its four arguments. Here \code{r} is annual rate, \code{n} is number of years, \code{pmt} is amount of one annuity and \code{bgn} is the computational mode. (Enter 1 when annuity payment occurs at the beginning of the period; 0 for end of period payments)
}
\examples{
fvYearlyAnnuityCompMonthly(0.11,4,-300,0)
fvYearlyAnnuityCompMonthly(0.11,4,-300,1)
fvYearlyAnnuityCompMonthly(0.11,4,300,0)
fvYearlyAnnuityCompMonthly(0.11,4,300,1)
}
\references{
\insertRef{humm}{tvmComp}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
