% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_embedding_2d.R
\name{textplot_embedding_2d}
\alias{textplot_embedding_2d}
\alias{textplot_embedding_2d.default}
\title{Plot word embeddings in 2D}
\usage{
textplot_embedding_2d(x, ...)

\method{textplot_embedding_2d}{default}(
  x,
  title = "Embedding plot in 2D",
  subtitle = list(),
  encircle = FALSE,
  points = FALSE,
  alpha = 0.4,
  ...
)
}
\arguments{
\item{x}{a data.frame with columns 'x', 'y', 'term' and optionally 'group' (color by group), 'weight' (size of the text / point shown), 'type' (pch used for the type of point)}

\item{...}{not used yet}

\item{title}{character string with the title to use in the plot}

\item{subtitle}{character string with the subtitle to use in the plot}

\item{encircle}{logical indicating to encircle all the points belonging to a group using \code{geom_encircle} from the ggalt package}

\item{points}{logical indicating to add points. Defaults to \code{FALSE}.}

\item{alpha}{transparancy level passed on to \code{geom_encircle} from the ggalt package in case \code{encircle} is set to \code{TRUE}}
}
\value{
an object of class ggplot
}
\description{
This plot displays words in 2 dimensions, optionally grouped by cluster.\cr
This allows to visualise embeddings which are reduced by dimensionality reduction techniques like UMAP, t-SNE, PCA or similar techniques.
It allows to highlight the words by groups and is a good way to visualise a small sets of word or topic embeddings.
}
\examples{
\dontshow{
if(require(ggplot2) && require(ggrepel) && require(ggalt))
\{
}
library(ggplot2)
library(ggrepel)
library(ggalt)
##
## Generate some fake embeddings
##   probably you want to use word2vec::word2vec(...) + uwot::umap(...)
embeddings <- matrix(runif(26 * 2), nrow = 26, ncol = 2, dimnames = list(letters))
x <- data.frame(term = rownames(embeddings), x = embeddings[, 1], y = embeddings[, 2])

## 2D plot
textplot_embedding_2d(x)

## 2D plot with groups
x$group <- sample(c("clustera", "clusterb", "clusterc"), size = 26, replace = TRUE)
textplot_embedding_2d(x)

## 2D plot with groups and weights for each word
x$weight <- runif(nrow(x))
textplot_embedding_2d(x)
textplot_embedding_2d(x, points = TRUE)

## 2D plot with groups and weights for each word and different types of points
x$type <- sample(c("word", "center"), size = 26, replace = TRUE)
x$type <- factor(x$type, levels = c("word", "center"))
textplot_embedding_2d(x, points = TRUE)
textplot_embedding_2d(x, title = "Embedding plot in 2D", subtitle = "example")

## Encircle the words belonging to each group
textplot_embedding_2d(x, title = "Embedding plot in 2D", subtitle = "example",
                      encircle = TRUE, alpha = 0.2)
\dontshow{
\}
# End of main if statement running only if the required packages are installed
}
}
