% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma.R
\name{sigma.msel}
\alias{sigma.msel}
\title{Extract Residual Standard Deviation 'Sigma'}
\usage{
\method{sigma}{msel}(object, use.fallback = TRUE, ..., regime = NULL, eq2 = NULL)
}
\arguments{
\item{object}{object of class "msel".}

\item{use.fallback}{logical, passed to \code{nobs} (currently ignored).}

\item{...}{further arguments (currently ignored).}

\item{regime}{regime of continuous equation}

\item{eq2}{index of continuous equation}
}
\value{
Returns estimates of the standard deviations 
of \eqn{\varepsilon_{i}}. 
If \code{eq2 = k} then estimates only for \eqn{k}-th continuous equation are 
returned. If in addition \code{regime = r} then estimate of 
\eqn{\sqrt{Var(\varepsilon_{ri})}} is returned. 
Herewith if \code{regime} is not \code{NULL} and \code{eq2} is \code{NULL} 
it is assumed that \code{eq2 = 1}.
}
\description{
Extract standard deviations of random errors of continuous
equations of \code{\link[switchSelection]{msel}} function.
}
\details{
Available only if \code{estimator = "ml"} or all \code{degrees}
values are equal to \code{1}.
}
