% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv2sample-ver003.R
\name{rmstaug}
\alias{rmstaug}
\title{Adjusted difference/ratio of restricted mean survival times}
\usage{
rmstaug(y, delta, x, arm, tau, type="difference", conf.int=0.95)
}
\arguments{
\item{y}{The follow-up time.}

\item{delta}{The censoring indicator, 1=event, and 0=censoring.}

\item{x}{The covariate matrix. The group indicator, arm (below) should not be included in this matrix.}

\item{arm}{The group indicator, 1/0.}

\item{tau}{The value indicates the restricted time point on the follow-up time to calculate the restricted mean survival time.}

\item{type}{The type of the between-group contrast measure: "difference"(default), "ratio" or "lossratio".}

\item{conf.int}{The level for computation of the confidence intervals. The default is 0.95.}
}
\description{
Compares restricted mean survival time between two groups, adjusting for imbalance of baseline factors.
}
\examples{
D=pbc.sample()
rmstaug(D$time, D$status, D$covariates, D$group, tau=8, type="difference")
}
\references{
Tian L, Zhao L, Wei LJ. Predicting the restricted mean event time with the subject's baseline covariates in survival analysis. Biostatistics 2014, 15, 222-233.
}
\author{
Lu Tian
}
