% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgs_deps.R
\name{pkgs_deps}
\alias{pkgs_deps}
\title{computes the dependencies of some (source) packages}
\usage{
pkgs_deps(
  pkgids,
  src_pkgs = get_srcpkgs(),
  source = TRUE,
  installed = TRUE,
  imports = TRUE,
  depends = TRUE,
  suggests = TRUE,
  reverse = FALSE
)
}
\arguments{
\item{pkgids}{a list of package ids (names, paths or object), or a
srcpkgs object. Also accept a singleton package object}

\item{src_pkgs}{a collection of source packages as a \code{srckgs} object.}

\item{source}{whether to report source packages}

\item{installed}{whether to report installed (non-source) packages}

\item{imports}{whether to only consider \code{imports} dependencies}

\item{depends}{whether to only consider \code{depends} dependencies}

\item{suggests}{whether to only consider \code{suggests} dependencies}

\item{reverse}{whether to compute reverse dependencies instead}
}
\value{
the dependencies, as a character vector, topologically sorted
}
\description{
computes the dependencies of some (source) packages
}
\examples{
pkg <- setup_and_get_dummy_srcpkg()
deps_src <- pkgs_deps(pkg, installed = FALSE)
deps_inst <- pkgs_deps(pkg, source = FALSE)
print(get_srcpkgs())
deps_rev <- pkgs_deps(pkg, reverse = TRUE, suggests = FALSE)
}
