#' SELECT * statement.
#'
#' This class represents a SQL SELECT * statement. It can be used to select
#' all fields from a table, with optional `distinct` keyword to remove duplicate
#' results.
#'
#' @examples
#' # Create a SELECT * statement:
#' select_all <- StmtSelectAll$new()
#'
#' # Use the created SELECT * statement inside a SELECT query:
#' query <- QuerySelect$new(select = select_all,
#'                          from = StmtFrom$new("books"))
#'
#' # Create a SELECT DISTINCT * statement:
#' select_distinct_all <- StmtSelectAll$new(distinct = TRUE)
#'
#' @import R6
#' @include StmtSelect.R
#' @export
StmtSelectAll <- R6::R6Class("StmtSelectAll",
  inherit = StmtSelect,
  public = list(

    #' @description
    #' Initializer
    #' @param distinct Set to TRUE enable `distinct` keyword and remove
    #'                 duplicate results.
    #' @return Nothing.
    initialize = function(distinct = FALSE) {
      super$initialize(distinct = distinct)
      return(invisible(NULL))
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      tokens <- list(.select, .spc)
      if (private$distinct) {
        tokens <- c(tokens, .distinct, .spc)
      }
      tokens <- c(tokens, .asterisk)
      return(tokens)
    }
  )
)
