% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{connect}
\alias{connect}
\title{(Re-)Establish connections to databases}
\usage{
connect(config_filename = NA, exclusive = FALSE)
}
\arguments{
\item{config_filename}{String. The full name and path of a configuration
file, or "site", or "user", or "example", or \code{NA} (the default). Cannot be
\code{NA} if \code{exclusive = TRUE}.}

\item{exclusive}{Logical. If \code{TRUE}, the file named by \code{config_filename} is
treated as the only config file. Site and user level files are not read.
This parameter is ignored if \code{config_filename} is missing.}
}
\value{
\code{NULL}, invisibly
}
\description{
Closes any open connections, reads config files as directed by
\code{config_filename} and \code{exclusive}, and creates new connections from the
descriptions in those files.
}
\details{
If \code{exclusive=FALSE} (the default), configuration files will be sought in the
directory returned by \code{\link[rappdirs:site_data_dir]{rappdirs::site_config_dir()}}, the directory returned
by \code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}, and finally a file named by
\code{config_filename} (if not \code{NA}). If elements of those files conflict, later
files overwrite the elements of earlier files.

If \code{exclusive=TRUE}, only 1 file, indicated by the
\code{config_filename} parameter,  will be read.
\itemize{
\item If \code{config_filename = "site"}, a config file called
\code{sqlhelper_db_conf.yml} will be sought in the directory returned by
\code{\link[rappdirs:site_data_dir]{rappdirs::site_config_dir()}}
\item If \code{config_filename = "user"}, a config file called
\code{sqlhelper_db_conf.yml} will be sought in the directory returned by
\code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}
\item If \code{config_filename} is not \code{NULL} (but not "site" or "user"), it is
assumed to name a file.
}

A warning is raised if no valid configurations are found (e.g. \code{connect()} is
called without arguments and no site- or user-wide files are present, or the
connections in those files are invalid)

\code{vignette("connections")} explains how to write a
config file and how to access the created connections.
}
\examples{
library(sqlhelper)

example_filename <- system.file("examples",
                                "sqlhelper_db_conf.yml",
                                package = "sqlhelper")

# Search for config files in rappdirs::site_config_dir(),
# rappdirs::user_config_dir(), and read from example_filename
connect(example_filename)

# Read only the named example file
connect(example_filename, exclusive=TRUE)

}
