% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fns.R
\name{cholsolve}
\alias{cholsolve}
\title{Solve the equation Qx = y}
\usage{
cholsolve(Q = NULL, y = NULL, perm = FALSE, cholQ = NULL,
  cholQp = NULL, P = NULL)
}
\arguments{
\item{Q}{matrix (if of class \code{Matrix} needs to be column-compressed, i.e., \code{dgCMatrix} or \code{dsCMatrix})), the Cholesky factor of which needs to be found}

\item{y}{matrix with the same number of rows as Q}

\item{perm}{if FLASE no permutation is carried out, if TRUE permuted Cholesky factors are used}

\item{cholQ}{the lower Cholesky factor of Q (if known already)}

\item{cholQp}{the lower Cholesky factor of a permuted Q (if known already)}

\item{P}{the permutation matrix (if known already)}
}
\value{
x solution to Qx = y
}
\description{
This function is similar to \code{solve(Q,y)} but with the added benefit that it allows for permuted matrices. This function does the job in order to minimise
user error when attempting to re-permute the matrices prior or after solving. The user also has an option for the permuted Cholesky factorisation of Q to be carried out
internally.
}
\examples{
require(Matrix)
Q = sparseMatrix(i = c(1, 1, 2, 2),
                 j = c(1, 2, 1, 2),
                 x = c(0.1, 0.2, 0.2, 1))
y = matrix(c(1, 2), 2, 1)
cholsolve(Q, y)
}
\references{
Havard Rue and Leonhard Held (2005). Gaussian Markov Random Fields: Theory and Applications. Chapman & Hall/CRC Press
}
\keyword{Cholesky}
\keyword{factor,}
\keyword{linear}
\keyword{solve}
