% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/author_info.R
\name{author_info}
\alias{author_info}
\title{Authors' Information}
\usage{
author_info(authors, citations, sep, top = 10, only_first_author = F)
}
\arguments{
\item{authors}{A character vector containing author names}

\item{citations}{A numeric vector containing citations}

\item{sep}{A character pattern separating author names}

\item{top}{The number of top authors}

\item{only_first_author}{Logical. If to find the author list by the first authors}
}
\value{
A list consisting of author names, total instances, total citations, h index, g index, i10 index, max citation
}
\description{
It finds top author names and their different performance indicators
}
\examples{
authors<-c("Wolf W.R., Lele S.K.",
"Shin D., Yeh X., Khatib O.",
"Aukes D., Heyneman B., Duchaine V., Cutkosky M.R.")
author_info(authors,c(3,4,1),',')
}
\seealso{
\code{\link[=g_index]{g index}} \code{\link[=h_index]{h index}}
}

