% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectFunctions.R
\name{obj.border}
\alias{obj.border}
\title{Borders of raster objects}
\usage{
obj.border(group, ngbList, silent = FALSE)
}
\arguments{
\item{group}{named list, each element represents a raster object composed of
several raster cells. If there are NA values on the raster surface, raster
cells must be identified by attribute table row indices (each corresponding
to a raster cell) (see \code{\link{attTbl}}).}

\item{ngbList}{list, the list of neighborhoods returned by the function
\code{\link{ngbList}}. The list of neighborhoods has to be computed setting
the argument \code{rNumb=TRUE}.}

\item{silent}{logic, progress bar is not printed on the console.}
}
\value{
The function returns a named list of object borders. List names
identify the objects; list element values identify the raster cells
comprising the borders.
}
\description{
Identify the borders of raster objects.
}
\note{
\itemize{ \item Note that \code{group} has to be a \strong{named} list whose
names correspond to raster object IDs.

\item If there are NA values on the raster surface, raster cells must be
identified by attribute table row indices (each corresponding to a raster
cell). Row indices can be converted into raster cells using the \code{Cell}
column of the attribute table (e.g. \code{attTbl$Cell[indices]}) (see
\code{\link{attTbl}}).}
}
\examples{
# DUMMY DATA
######################################################################################
# LOAD LIBRARIES
library(scapesClassification)
library(terra)

# LOAD THE DUMMY RASTER
r <- list.files(system.file("extdata", package = "scapesClassification"),
                pattern = "dummy_raster\\\\.tif", full.names = TRUE)
r <- terra::rast(r)

# ADD NA-VALUE
r[11] <- NA

# COMPUTE THE ATTRIBUTE TABLE
at <- attTbl(r, "dummy_var")

# COMPUTE THE LIST OF NEIGBORHOODS
nbs <- ngbList(r, rNumb=TRUE, attTbl=at) # rnumb MUST be true to use obj.border

################################################################################
# COMPUTE RASTER OBJECTS
################################################################################
at$cv <- anchor.seed(at, nbs, silent=TRUE, class = NULL, rNumb=TRUE,
                     cond.filter = "dummy_var > 1",
                     cond.seed   = "dummy_var==max(dummy_var)",
                     cond.growth = "dummy_var<dummy_var[]",
                     lag.growth  = 0)

# Raster objects
RO <- split(1:NROW(at), at$cv)

print(RO) # values are attribute table row indices

################################################################################
# COMPUTE BORDERS
################################################################################
RO_bd <- obj.border(RO, nbs, silent = TRUE)

RO_bd1 <- at$Cell[RO_bd[["1"]]] # Convert row numbers to cell numbers
RO_bd2 <- at$Cell[RO_bd[["2"]]] # Convert row numbers to cell numbers

print(RO_bd)  # attribute table row indices
print(RO_bd1) # cell numbers
print(RO_bd2) # cell numbers

################################################################################
# PLOT BORDERS
################################################################################
plot(cv.2.rast(r,at$cv), type="classes", col=c("#E6E600","#00A600"),
     main="Borders")
points(terra::xyFromCell(r, RO_bd1), pch=20, col="blue")
points(terra::xyFromCell(r, RO_bd2), pch=20, col="red")
text(xyFromCell(r, 11), "NA\nvalue")
}
\seealso{
\code{\link[=attTbl]{attTbl()}}, \code{\link[=ngbList]{ngbList()}}, \code{\link[=obj.nbs]{obj.nbs()}}
}
