% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngb8.R
\name{ngb8}
\alias{ngb8}
\title{Eight neighbors}
\usage{
ngb8(n_row, n_col)
}
\arguments{
\item{n_row}{Integer. The number of rows of a Raster or object.}

\item{n_col}{Integer. The number of columns of a Raster object.}
}
\value{
Named list, the \code{nth} element of the list corresponds to the 8
adjacent cell numbers of the \code{nth} cell on the \code{Raster*} object.
}
\description{
Return the 8 neighbors, as cell numbers, of each cell on a raster.
}
\details{
A cell with coordinates \code{(x, y)} has 8 neighbors with
coordinates: \code{(x±1, y)},  \code{(x, y±1)} and \code{(x±1, y±1)}. Cells
on the edge of a raster have less than 8 neighbors. The function identifies
the neighbors of a cell as cell numbers.
}
\examples{
## Matrix m mocking a raster of 3 rows and 4 columns
m <- matrix(1:12, nrow = 3, ncol = 4, byrow = TRUE)
m

nbs <- ngb8(3, 4)
nbs
}
\seealso{
\code{\link[=ngbList]{ngbList()}}
}
