% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyModule.R
\name{reactlog_module_ui}
\alias{reactlog_module_ui}
\alias{reactlog_module_server}
\title{Reactlog Shiny Module}
\usage{
reactlog_module_ui(include_refresh = TRUE, id = "reactlog_module")

reactlog_module_server(
  id = "reactlog_module",
  width = "100\%",
  height = 600,
  ...
)
}
\arguments{
\item{include_refresh}{should the iframe refresh button be included?}

\item{id}{\pkg{shiny} module id to use}

\item{width, height}{HTML attributes to be applied to the reactlog iframe}

\item{...}{parameters passed to \code{\link[shiny:actionButton]{shiny::actionButton()}}}
}
\description{
Displays an iframe of the reactlog in the given application.
}
\details{
State will not be preserved between refreshes.
To open the reactlog at a particular step, be sure to mark your time points
with \code{Cmd+Shift+F3} (Windows: \code{Ctrl+Shift+F3})
}
\examples{
if (!require("shiny")) {
  message("`shiny` required to run example")
  return()
}

library(shiny)
# Enable reactlog
reactlog_enable()

# Define UI for app that draws a histogram ----
ui <- fluidPage(
  tags$h1("Pythagorean theorem"),
  numericInput("a", "A", 3),
  numericInput("b", "B", 4),
  "C:", verbatimTextOutput("c"),
### start ui module
  reactlog_module_ui()
### end ui module
)

server <- function(input, output, session) {
  a2 <- reactive({a <- input$a; req(a); a * a}, label = "a^2")
  b2 <- reactive({b <- input$b; req(b); b * b}, label = "b^2")
  c2 <- reactive({a2() + b2()}, label = "c^2")
  c_val <- reactive({sqrt(c2())}, label = "c")

  output$c <- renderText({
    c_val()
  })

### start server module
  reactlog_module_server()
### end server module

}

if (interactive()) {
  shinyApp(ui = ui, server = server)
}
}
\seealso{
\code{\link[shiny:moduleServer]{shiny::moduleServer()}}
}
