% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactCheckbox.R
\name{reactCheckboxesInput}
\alias{reactCheckboxesInput}
\title{Checkbox group input}
\usage{
reactCheckboxesInput(
  inputId,
  checkboxes,
  headLabel = "Check all",
  headClass = "",
  styles = NULL,
  theme = "material"
)
}
\arguments{
\item{inputId}{the id that will be used to get the values in Shiny}

\item{checkboxes}{a list of checkboxes defined with the
\code{\link{checkbox}} function}

\item{headLabel}{the label for the head checkbox}

\item{headClass}{a CSS class for the head checkbox}

\item{styles}{a named list of styles created with the
\code{\link{checkboxStyle}} function; the names denote the CSS classes}

\item{theme}{the theme, \code{"bootstrap"}, \code{"fancy"}, or
\code{"material"}}
}
\value{
A \code{shiny.tag.list} object to be included in a Shiny UI.
}
\description{
Create a checkbox group input for usage in Shiny.
}
\examples{
library(shiny)
library(htmltools)
library(reactCheckbox)

ui <- fluidPage(
  reactCheckboxesInput(
    "iris",
    list(
      checkbox("Sepal length", FALSE),
      checkbox("Sepal width", FALSE),
      checkbox("Petal length", FALSE),
      checkbox("Petal width", FALSE)
    ),
    headLabel = tags$span(
      "Make a choice", style = "font-size: 1.8rem; font-style: italic;"
    ),
    headClass = "custom",
    theme = "material",
    styles = list(
      "custom" = checkboxStyle(
        checked = css(
          background.color = "darkred"
        ),
        checked_hover = css(
          background.color = "maroon"
        ),
        unchecked = css(
          background.color = "darkorange"
        ),
        unchecked_hover = css(
          background.color = "orange"
        ),
        indeterminate = css(
          background.color = "gold"
        ),
        indeterminate_hover = css(
          background.color = "yellow"
        )
      )
    )
  )
)

server <- function(input, output, session) {
  observe({
    print(input[["iris"]])
  })
}

if(interactive()) {
  shinyApp(ui, server)
}
}
