% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radvs.R
\name{radvs}
\alias{radvs}
\title{Vital Signs Analysis Dataset (ADVS)}
\usage{
radvs(
  adsl,
  param = c("Diastolic Blood Pressure", "Pulse Rate", "Respiratory Rate",
    "Systolic Blood Pressure", "Temperature", "Weight"),
  paramcd = c("DIABP", "PULSE", "RESP", "SYSBP", "TEMP", "WEIGHT"),
  paramu = c("Pa", "beats/min", "breaths/min", "Pa", "C", "Kg"),
  visit_format = "WEEK",
  n_assessments = 5L,
  n_days = 5L,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(CHG2 = c(1235, 0.1), PCHG2 = c(1235, 0.1), CHG = c(1234, 0.1), PCHG =
    c(1234, 0.1), AVAL = c(123, 0.1), AVALU = c(123, 0.1)),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{param}{(\verb{character vector})\cr Parameter values.}

\item{paramcd}{(\verb{character vector})\cr Parameter code values.}

\item{paramu}{(\verb{character vector})\cr Parameter unit values.}

\item{visit_format}{(\code{character})\cr Type of visit. Options are "WEEK" and "CYCLE".}

\item{n_assessments}{(\code{integer})\cr Number of weeks or cycles.}

\item{n_days}{(\code{integer})\cr Number of days in each cycle (only used if \code{visit_format} is "CYCLE").}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADVS data \code{cadvs} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radvs} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating a random Vital Signs Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per subject per parameter per analysis visit per analysis date.

Keys: \code{STUDYID}, \code{USUBJID}, \code{PARAMCD}, \code{BASETYPE}, \code{AVISITN}, \code{ATPTN}, \code{DTYPE}, \code{ADTM}, \code{VSSEQ}, \code{ASPID}
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)

advs <- radvs(adsl, visit_format = "WEEK", n_assessments = 7L, seed = 2)
advs

advs <- radvs(adsl, visit_format = "CYCLE", n_assessments = 3L, seed = 2)
advs
}
\author{
npaszty
}
