% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radsl.R
\name{radsl}
\alias{radsl}
\title{Subject-Level Analysis Dataset (ADSL)}
\usage{
radsl(
  N = 400,
  study_duration = 2,
  seed = NULL,
  with_trt02 = TRUE,
  na_percentage = 0,
  na_vars = list(AGE = NA, SEX = NA, RACE = NA, STRATA1 = NA, STRATA2 = NA, BMRKR1 =
    c(seed = 1234, percentage = 0.1), BMRKR2 = c(1234, 0.1), BEP01FL = NA),
  ae_withdrawal_prob = 0.05,
  cached = FALSE
)
}
\arguments{
\item{N}{(\code{numeric})\cr Number of patients.}

\item{study_duration}{(\code{numeric})\cr Duration of study in years.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{with_trt02}{(\code{logical})\cr Should period 2 be added.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{ae_withdrawal_prob}{(\code{proportion})\cr Probability that there is at least one
Adverse Event leading to the withdrawal of a study drug.}

\item{cached}{boolean whether the cached ADSL data \code{cadsl} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radsl} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The Subject-Level Analysis Dataset (ADSL) is used to provide the variables
that describe attributes of a subject. ADSL is a source for subject-level
variables used in other analysis data sets, such as population flags and
treatment variables. There is only one ADSL per study. ADSL and its related
metadata are required in a CDISC-based submission of data from a clinical
trial even if no other analysis data sets are submitted.
}
\details{
One record per subject.

Keys: \code{STUDYID}, \code{USUBJID}
}
\examples{
adsl <- radsl(N = 10, study_duration = 2, seed = 1)
adsl

adsl <- radsl(
  N = 10, seed = 1,
  na_percentage = 0.1,
  na_vars = list(
    DTHDT = c(seed = 1234, percentage = 0.1),
    LSTALVDT = c(seed = 1234, percentage = 0.1)
  )
)
adsl

adsl <- radsl(N = 10, seed = 1, na_percentage = .1)
adsl
}
