% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.R
\name{plot_lm}
\alias{plot_lm}
\title{Plot Linear Regression Estimates with Confidence Intervals}
\usage{
plot_lm(
  data,
  outcome,
  predictors,
  label_vjust = -0.8,
  label_hjust = 0.4,
  label_size = 3.5,
  label_color = "black",
  point_color = c("steelblue", "firebrick"),
  point_shape = 15,
  ref = TRUE
)
}
\arguments{
\item{data}{A data frame containing the outcome and predictor variables.}

\item{outcome}{A string specifying the outcome (dependent) variable.}

\item{predictors}{A character vector of predictor (independent) variables.}

\item{label_vjust}{Vertical adjustment for text labels. Default is -0.8.}

\item{label_hjust}{Horizontal adjustment for text labels. Default is 0.4.}

\item{label_size}{Size of text labels. Default is 3.5.}

\item{label_color}{Color of text labels. Default is "black".}

\item{point_color}{Vector of colors for the points. Default is c("steelblue", "firebrick").}

\item{point_shape}{Shape of the points. Default is 15.}

\item{ref}{Logical; if TRUE, adds reference levels for factor variables. Default is TRUE.}
}
\value{
A \code{ggplot} object showing regression estimates with 95\% confidence intervals
for both univariate and multivariate models.
@import broom
}
\description{
This function fits univariate and multivariate linear regression models
for a given outcome and a set of predictors. It returns a ggplot showing
point estimates and 95\% confidence intervals for each predictor. Reference
levels of factors can optionally be added, and univariate and multivariate
results are plotted side by side.
}
\examples{
mtcars2 <- dplyr::mutate(
  mtcars,
  cyl = factor(cyl),
  am = factor(am, labels = c("Automatic", "Manual")),
  gear = factor(gear)
)

plot_lm(
  data = mtcars2,
  outcome = "mpg",
  predictors = c("cyl", "hp", "wt", "am", "gear"),
  point_shape = 18
)

plot_lm(
  data = mtcars2,
  outcome = "mpg",
  predictors = c("cyl", "hp", "wt", "am", "gear"),
  point_shape = 18
)
}
