% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_outlets}
\alias{search_outlets}
\title{Search for outlets using text}
\usage{
search_outlets(
  search_term,
  latitude = NULL,
  longitude = NULL,
  max_distance = NULL,
  route_types = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{search_term}{Character. Term used to perform search.}

\item{latitude}{Numeric. Latitude in decimal degrees. For example, Flinders
Street Station is at approximately -37.8183 latitude.}

\item{longitude}{Numeric. Longitude in decimal degrees. For example, Flinders
Street Station is at approximately 144.9671 longitude.}

\item{max_distance}{Integer. Optionally filter by maximum distance from the
given location, in metres.}

\item{route_types}{Integer or character vector. Optionally filter by a vector
of route types. A route type can be provided either as a non-negative
integer code, or as a character: "Tram", "Train", "Bus", "Vline" or "Night
Bus". Character inputs are not case-sensitive. Use the
\code{\link{route_types}} function to extract a vector of all route types.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble with the following columns: \itemize{
\item {\code{outlet_slid_spid}}
\item {\code{outlet_name}}
\item {\code{outlet_business}}
\item {\code{outlet_latitude}}
\item {\code{outlet_longitude}}
\item {\code{outlet_suburb}}
\item {\code{outlet_postcode}}
\item {\code{outlet_business_hour_mon}}
\item {\code{outlet_business_hour_tue}}
\item {\code{outlet_business_hour_wed}}
\item {\code{outlet_business_hour_thu}}
\item {\code{outlet_business_hour_fri}}
\item {\code{outlet_business_hour_sat}}
\item {\code{outlet_business_hour_sun}}
\item {\code{outlet_notes}}
}
}
\description{
This function will search outlets in which the search term can be found in
either the outlet name, outlet business or outlet suburb. The search is
case-insensitive. The search term must contain at least 3 characters, and
cannot be numeric.
}
\examples{
\dontrun{
search_outlets("St Kilda")
search_outlets("St Kilda", route_types = c("Train", "Tram"))
search_outlets("St Kilda", route_types = 1)

search_outlets(
  "St Kilda",
  latitude = -37.867647,
  longitude = 144.976809
)
search_outlets(
  "St Kilda",
  latitude = -37.867647,
  longitude = 144.976809,
  max_distance = 100
)
}
}
