% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision.R
\name{precision_risk_difference}
\alias{precision_risk_difference}
\alias{precision_risk_ratio}
\alias{precision_rate_difference}
\alias{precision_rate_ratio}
\alias{precision_odds_ratio}
\title{Estimate precision of a measure based on sample size}
\usage{
precision_risk_difference(
  n_exposed,
  exposed,
  unexposed,
  group_ratio,
  ci = 0.95
)

precision_risk_ratio(n_exposed, exposed, unexposed, group_ratio, ci = 0.95)

precision_rate_difference(
  n_exposed,
  exposed,
  unexposed,
  group_ratio,
  ci = 0.95
)

precision_rate_ratio(n_exposed, exposed, unexposed, group_ratio, ci = 0.95)

precision_odds_ratio(
  n_cases,
  exposed_cases,
  exposed_controls,
  group_ratio,
  ci = 0.95
)
}
\arguments{
\item{n_exposed, n_cases}{In cohort studies, the number of exposed
participants. In case-control studies, the number of cases.}

\item{exposed}{The risk or rate among the exposed cohort.}

\item{unexposed}{The risk or rate among the unexposed cohort.}

\item{group_ratio}{In cohort studies, the ratio of the unexposed to the
exposed. In case-control studies, the ratio of the controls to the cases.}

\item{ci}{The confidence interval as a probability or percent. Default is
.95.}

\item{exposed_cases}{The proportion of exposed cases.}

\item{exposed_controls}{The proportion of exposed controls.}
}
\value{
a tibble with precision, effect measure, and sample size
}
\description{
These functions calculate the precision of an estimate given a certain sample
size. For ratio measures, like the risk ratio, rate ratio, and odds ratio,
this is the ratio of the upper to lower limit of the confidence interval. For
difference measures, like the risk difference or rate difference, this is the
absolute width of the confidence interval.
}
\examples{

# From Rothman and Greenland 2018

precision_odds_ratio(
  n_cases = 500,
  exposed_cases = .6,
  exposed_controls = .4,
  group_ratio = 2
)

}
\references{
Rothman, K.J. and Greenland, S. 2018.
\href{https://pubmed.ncbi.nlm.nih.gov/29912015/}{Planning Study Size Based on Precision Rather Than Power}. 29(5):599-603.
}
