% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size.R
\name{n_risk_difference}
\alias{n_risk_difference}
\alias{n_risk_ratio}
\alias{n_rate_difference}
\alias{n_rate_ratio}
\alias{n_odds_ratio}
\title{Estimate sample size based on precision of a measure}
\usage{
n_risk_difference(precision, exposed, unexposed, group_ratio, ci = 0.95)

n_risk_ratio(precision, exposed, unexposed, group_ratio, ci = 0.95)

n_rate_difference(precision, exposed, unexposed, group_ratio, ci = 0.95)

n_rate_ratio(precision, exposed, unexposed, group_ratio, ci = 0.95)

n_odds_ratio(
  precision,
  exposed_cases,
  exposed_controls,
  group_ratio,
  ci = 0.95
)
}
\arguments{
\item{precision}{For differences, the width of the CI. For ratios, the ratio
of the upper to lower CI.}

\item{exposed}{The risk or rate among the exposed cohort.}

\item{unexposed}{The risk or rate among the unexposed cohort.}

\item{group_ratio}{In cohort studies, the ratio of the unexposed to the
exposed. In case-control studies, the ratio of the controls to the cases.}

\item{ci}{The confidence interval as a probability or percent. Default is
.95.}

\item{exposed_cases}{The proportion of exposed cases.}

\item{exposed_controls}{The proportion of exposed controls.}
}
\value{
a tibble with sample size, effect measure, and precision
}
\description{
These functions calculate the sample size needed to estimate a measure with a
certain precision. For ratio measures, like the risk ratio, rate ratio, and
odds ratio, this is the ratio of the upper to lower limit of the confidence
interval. For difference measures, like the risk difference or rate
difference, this is the absolute width of the confidence interval.
}
\examples{

# From Rothman and Greenland 2018

n_risk_difference(
  precision = .08,
  exposed = .4,
  unexposed = .3,
  group_ratio = 3,
  ci = .90
)

n_risk_ratio(
  precision = 2,
  exposed = .4,
  unexposed = .3,
  group_ratio = 3
)

}
\references{
Rothman, K.J. and Greenland, S. 2018.
\href{https://pubmed.ncbi.nlm.nih.gov/29912015/}{Planning Study Size Based on Precision Rather Than Power}. 29(5):599-603.
}
