% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvTarald.R
\name{pvTarald}
\alias{pvTarald}
\title{Compute the p-value for exact correlation significance test
using Taraldsen's exact methods.}
\usage{
pvTarald(n, rho = 0, obsr)
}
\arguments{
\item{n}{{number of observations, n-1 is degrees of freedom}}

\item{rho}{{True unknown population correlation coefficient
in the r-interval [-1, 1], default=0}}

\item{obsr}{{observed r or  correlation coefficient}}
}
\value{
ans is the p-value or probability from sampling distribution of observing a
correlation as extreme or more extreme than the input obsr or observed r.
}
\description{
Compute the p-value for exact correlation significance test
using Taraldsen's exact methods.
}
\note{
needs function hypergeo from the package of that name.
}
\references{
Taraldsen, G. "The Confidence Density for Correlation"
Sankhya: The Indian Journal of Statistics
2023, Volume 85-A, Part 1, pp. 600-616.
}
\seealso{
See Also as \code{\link{qTarald}},
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
